/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools.domains;

import AIspace.cspTools.dialogs.VariableDialog;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DomainChooser
extends JPanel
implements ActionListener {
    private static final String[] DOMAIN_NAMES = new String[]{"DomainInteger", "DomainString", "DomainBoolean"};
    private static final String DOMAIN_PATH = "AIspace.cspTools.domains.";
    private static Class[] DOMAIN_CLASSES;
    private ButtonGroup domainChooser;
    private DomainDiscrete current;
    private VariableDialog varDialog;
    private ArrayList<JRadioButton> domainButtons;
    private JPanel buttonPanel;
    private BasicDialog parent;

    public DomainChooser(DomainDiscrete current) {
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel("Domain Type:       "));
        this.current = current;
        this.domainChooser = new ButtonGroup();
        this.domainButtons = new ArrayList();
        DomainChooser.loadClasses();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        int i = 0;
        while (i < DOMAIN_CLASSES.length) {
            DomainDiscrete cur = DomainChooser.newObject(i);
            String s = cur == null ? "" : cur.getTypeString();
            JRadioButton button = new JRadioButton(s);
            button.setActionCommand(s);
            button.addActionListener(this);
            if (DOMAIN_CLASSES[i].isInstance(current)) {
                button.setSelected(true);
            }
            this.domainChooser.add(button);
            this.domainButtons.add(i, button);
            this.buttonPanel.add(button);
            ++i;
        }
        this.add(this.buttonPanel);
    }

    public static final void loadClasses() {
        if (DOMAIN_CLASSES != null) {
            return;
        }
        DOMAIN_CLASSES = new Class[DOMAIN_NAMES.length];
        int i = 0;
        while (i < DOMAIN_CLASSES.length) {
            try {
                DomainChooser.DOMAIN_CLASSES[i] = Class.forName(DOMAIN_PATH + DOMAIN_NAMES[i]);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Class Not Found: " + DOMAIN_NAMES[i] + " exiting");
                System.exit(0);
            }
            ++i;
        }
    }

    public static final DomainDiscrete newObject(int i) {
        if (DOMAIN_CLASSES == null) {
            DomainChooser.loadClasses();
        }
        if (i >= DOMAIN_CLASSES.length) {
            return null;
        }
        try {
            Object o = DOMAIN_CLASSES[i].newInstance();
            if (o instanceof DomainDiscrete) {
                return (DomainDiscrete)o;
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("Error requested class could not be created due to instantiation or access error");
            return null;
        }
    }

    public static final DomainDiscrete newObject(String s) {
        if (DOMAIN_CLASSES == null) {
            DomainChooser.loadClasses();
        }
        int i = 0;
        while (i < DOMAIN_CLASSES.length) {
            try {
                Object o = DOMAIN_CLASSES[i].newInstance();
                if (o instanceof DomainDiscrete && ((DomainDiscrete)o).getTypeString().toUpperCase().equals(s.toUpperCase())) {
                    return (DomainDiscrete)o;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    public void setVarDialog(VariableDialog varDialog) {
        this.varDialog = varDialog;
    }

    public void setParent(BasicDialog parent) {
        this.parent = parent;
    }

    public void actionPerformed(ActionEvent e) {
        int i = 0;
        while (i < this.domainChooser.getButtonCount()) {
            if (this.domainButtons.get(i).isSelected()) {
                Class newDomainType = DOMAIN_CLASSES[i];
                if (newDomainType.isInstance(this.current)) {
                    return;
                }
                this.current = DomainChooser.newObject(i);
                this.current.panel.changeText(this.domainButtons.get(i).getText());
                this.repaint();
            }
            ++i;
        }
        if (this.varDialog != null) {
            this.varDialog.setDomain(this.current);
        }
        if (this.parent != null) {
            e.setSource(this);
            this.parent.actionPerformed(e);
        }
    }

    public DomainDiscrete getCurrent() {
        return this.current;
    }
}

