/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools.elements;

import AIspace.cspTools.CSP;
import AIspace.cspTools.dialogs.AffirmPanel;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.elements.Constraint;
import AIspace.cspTools.elements.ConstraintEdge;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.HistogramNode;
import AIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSPVariable
extends HistogramNode {
    private String originalname;
    protected DomainDiscrete domain;
    protected String name;
    protected int index;
    protected boolean edit = true;
    protected boolean solve;
    private boolean newvar = true;

    public CSPVariable(DomainDiscrete domain, Graph graph, Point point, String name) {
        super(graph, String.valueOf(name) + ":\n" + domain.getRep(), point, Color.black, 1110);
        this.domain = domain;
        this.name = name;
        this.clearHistogram();
    }

    public boolean setDomain(DomainDiscrete domain) {
        this.domain = domain;
        return true;
    }

    public int index() {
        return this.index;
    }

    public boolean getEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public void setLabel() {
        this.label[0] = CSP.trim(String.valueOf(this.name) + ":");
        this.label[1] = this.solve ? CSP.trim("{" + this.domain.getSplitRep() + "}") : CSP.trim("{" + this.domain.getRep() + "}");
        this.updateSize();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNewVar() {
        return this.newvar;
    }

    public void setNewVar(boolean b) {
        this.newvar = b;
        this.originalname = this.name;
    }

    public String getOriginalName() {
        return this.originalname;
    }

    public DomainDiscrete getDomain() {
        return this.domain;
    }

    public ArrayList<Constraint> getConstraints() {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        ArrayList edges = new ArrayList(this.edgesIn);
        edges.addAll(this.edgesOut);
        for (Edge e : edges) {
            if (!(e instanceof ConstraintEdge)) continue;
            constraints.add(((ConstraintEdge)e).getConstraint());
        }
        return constraints;
    }

    public void reset() {
        this.domain.resetSplit();
    }

    public AffirmPanel getPanel(CSP csp) {
        return new VariablePanel(this, csp);
    }

    public void setMode(boolean solve) {
        this.solve = solve;
    }

    @Override
    protected int getWidth() {
        int width1 = this.graph.canvas.getFontMetrics().stringWidth(this.label[0]) + this.wPad;
        int width2 = this.graph.canvas.getFontMetrics().stringWidth(this.label[1]) + this.wPad;
        return Math.max(width1, width2);
    }

    @Override
    protected int getHeight() {
        return (this.graph.canvas.getFontMetrics().getHeight() + this.hPad) * 2;
    }

    @Override
    protected void drawLabel(Graphics offscreen) {
        int width1 = this.graph.canvas.getFontMetrics().stringWidth(this.label[0]) + this.wPad;
        int width2 = this.graph.canvas.getFontMetrics().stringWidth(this.label[1]) + this.wPad;
        if (this.isBold) {
            offscreen.setColor(Color.white);
        } else {
            offscreen.setColor(Color.black);
        }
        offscreen.drawString(this.label[0], (int)this.pos.x - (width1 - this.wPad) / 2, (int)this.pos.y - (this.height - this.hPad) / 4);
        offscreen.drawString(this.label[1], (int)this.pos.x - (width2 - this.wPad) / 2, (int)this.pos.y + (this.height - this.hPad) / 4);
    }

    public String toXML(String indent, boolean current) {
        StringBuffer rep = new StringBuffer(indent);
        rep.append("<").append("VARIABLE").append(" ").append("TYPE").append("=\"").append(this.domain.getTypeString()).append("\">\n");
        rep.append(indent).append("\t<").append("NAME").append(">").append(this.name).append("</").append("NAME").append(">\n");
        if (!current) {
            int i = 0;
            while (i < this.domain.getSize()) {
                rep.append(indent).append("\t<").append("VALUE").append(">").append(this.domain.getElementString(i)).append("</").append("VALUE").append(">\n");
                ++i;
            }
        } else {
            int[] split = this.domain.getSplitElements();
            int i = 0;
            while (i < split.length) {
                rep.append(indent).append("\t<").append("VALUE").append(">").append(this.domain.getElementString(split[i])).append("</").append("VALUE").append(">\n");
                ++i;
            }
        }
        rep.append(indent).append("\t<").append("PROPERTY").append(">").append("position = (").append(this.pos.x).append(", ").append(this.pos.y).append(")").append("</").append("PROPERTY").append(">\n");
        rep.append(indent).append("</").append("VARIABLE").append(">\n");
        return rep.toString();
    }

    class VariablePanel
    extends AffirmPanel
    implements ActionListener {
        private CSPVariable variable;
        private JTextField value;
        private JLabel name;
        private CSP csp;

        VariablePanel(CSPVariable variable, CSP csp) {
            this.variable = variable;
            this.csp = csp;
            this.setLayout(new BoxLayout(this, 0));
            this.add(new JLabel("Variable Name:     "));
            this.value = new JTextField(variable.getName(), 10);
            this.add(this.value);
            this.name = new JLabel(variable.getName());
        }

        public void actionPerformed(ActionEvent e) {
            if ((e.getActionCommand() == "Change name" || e.getSource().equals(this.value)) && this.csp.nameOK(this.value.getText().trim())) {
                this.name.setText(this.value.getText().trim());
                this.value.setText("");
            }
        }

        public boolean ok() {
            if (this.csp.nameOK(this.value.getText().trim())) {
                this.name.setText(this.value.getText().trim());
                this.value.setText("");
                this.variable.setName(this.name.getText().trim());
                return true;
            }
            return false;
        }

        public boolean okNoCheck() {
            this.name.setText(this.value.getText().trim());
            this.value.setText("");
            this.variable.setName(this.name.getText().trim());
            return true;
        }

        public void cancel() {
        }

        public String returnText() {
            return this.value.getText().trim();
        }
    }
}

