/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools.relations;

import AIspace.cspTools.Domain;
import AIspace.cspTools.Relation;
import AIspace.cspTools.dialogs.RelationDialog;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RelationChooser
extends JPanel
implements ActionListener {
    private static final String[] RELATION_NAMES = new String[]{"RelationFactor", "RelationAnd", "RelationOr", "RelationImply", "RelationXOr", "RelationEquals", "RelationLessThan", "RelationGreaterThan", "RelationFalse", "RelationTrivial", "RelationCrossword", "RelationQueens"};
    private static final String RELATION_PATH = "AIspace.cspTools.relations.";
    private static Class[] RELATION_CLASSES;
    private ArrayList<Class> currentClasses;
    private JComboBox relationChooser;
    private Relation current;
    private RelationDialog cnsDialog;
    private Constraint cns;
    private Domain[] domains;
    private JLabel constraintType;
    private int currentIndex;
    private int[] indices;

    public RelationChooser(Relation current, Constraint cns, boolean editable) {
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel("Constraint Type:     "));
        this.current = current;
        this.currentClasses = new ArrayList();
        this.relationChooser = new JComboBox();
        this.relationChooser.setEnabled(editable);
        this.relationChooser.addActionListener(this);
        RelationChooser.loadClasses();
        this.domains = null;
        this.cns = cns;
        ArrayList<CSPVariable> vars = cns.getVariables();
        if (vars != null && vars.size() > 0) {
            this.domains = new Domain[vars.size()];
            int i = 0;
            while (i < vars.size()) {
                this.domains[i] = vars.get(i).getDomain();
                ++i;
            }
        }
        this.constraintType = new JLabel("");
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int i = 0;
        while (i < RELATION_CLASSES.length) {
            Relation cur = RelationChooser.newObject(i);
            if (cur == null) {
                return;
            }
            String s = cur.getTypeString();
            if ((this.domains == null || this.domains.length > 1 || s.equals("True") || s.equals("False") || s.equals("Custom")) && (this.domains == null || this.domains.length <= 2 || !s.equals("Queens"))) {
                if (this.domains == null) {
                    this.currentClasses.add(RELATION_CLASSES[i]);
                    this.relationChooser.addItem(s);
                } else if (cur.testDomains(this.domains)) {
                    indices.add(new Integer(i));
                    this.currentClasses.add(RELATION_CLASSES[i]);
                    this.relationChooser.addItem(s);
                    this.constraintType.setText(cur.getTypeString());
                }
                if (RELATION_CLASSES[i].isInstance(current)) {
                    this.relationChooser.setSelectedIndex(this.relationChooser.getItemCount() - 1);
                    this.currentIndex = this.relationChooser.getSelectedIndex();
                }
            }
            ++i;
        }
        this.add(this.relationChooser);
        this.indices = new int[indices.size()];
        i = 0;
        while (i < this.indices.length) {
            this.indices[i] = (Integer)indices.get(i);
            ++i;
        }
        if (vars == null || vars.size() == 0) {
            this.relationChooser.setEnabled(false);
        }
    }

    public static final void loadClasses() {
        if (RELATION_CLASSES != null) {
            return;
        }
        RELATION_CLASSES = new Class[RELATION_NAMES.length];
        int i = 0;
        while (i < RELATION_CLASSES.length) {
            try {
                RelationChooser.RELATION_CLASSES[i] = Class.forName(RELATION_PATH + RELATION_NAMES[i]);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Class Not Found: " + RELATION_NAMES[i] + " exiting");
                System.exit(0);
            }
            ++i;
        }
    }

    private static final Relation newObject(int i) {
        Relation r;
        block5: {
            if (RELATION_CLASSES == null) {
                RelationChooser.loadClasses();
            }
            if (i >= RELATION_CLASSES.length) {
                return null;
            }
            try {
                Object o = RELATION_CLASSES[i].newInstance();
                if (o instanceof Relation) {
                    r = (Relation)o;
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                System.err.println("Error requested class could not be created due to instantiation or access error");
                return null;
            }
        }
        return r;
    }

    private static final Relation newObject(int i, Constraint cns, int[] indices) {
        Relation r = RelationChooser.newObject(indices[i]);
        r.init(cns);
        return r;
    }

    public static final Relation newObject(String s, Constraint cns) {
        if (RELATION_CLASSES == null) {
            RelationChooser.loadClasses();
        }
        int i = 0;
        while (i < RELATION_CLASSES.length) {
            try {
                Object o = RELATION_CLASSES[i].newInstance();
                if (o instanceof Relation && ((Relation)o).getTypeString().toUpperCase().equals(s.toUpperCase())) {
                    Relation r = (Relation)o;
                    r.init(cns);
                    return r;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    public static final Relation newObject(int i, Constraint cns) {
        return RelationChooser.newObject(0, cns, new int[]{i});
    }

    public void setCnsDialog(RelationDialog cnsDialog) {
        this.cnsDialog = cnsDialog;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.relationChooser)) {
            if (this.relationChooser.getSelectedIndex() == this.currentIndex) {
                return;
            }
            if (this.indices == null) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                int i = 0;
                while (i < RELATION_CLASSES.length) {
                    indices.add(new Integer(i));
                    ++i;
                }
                this.indices = new int[indices.size()];
                i = 0;
                while (i < this.indices.length) {
                    this.indices[i] = (Integer)indices.get(i);
                    ++i;
                }
            }
            this.current = RelationChooser.newObject(this.relationChooser.getSelectedIndex(), this.cns, this.indices);
            this.currentIndex = this.relationChooser.getSelectedIndex();
            if (this.cnsDialog != null) {
                this.cnsDialog.setRelation(this.current);
            }
        }
    }
}

