/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools.relations;

import AIspace.cspTools.Domain;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.domains.DomainInteger;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.relations.RelationArg;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationQueens
extends RelationArg {
    @Override
    protected void resetRows() {
        this.rows = new int[1];
    }

    @Override
    protected boolean testFunction(int[] args, DomainDiscrete[] domains) {
        if (args.length < 2) {
            return true;
        }
        int[] vals = new int[args.length];
        int i = 0;
        while (i < args.length) {
            vals[i] = (Integer)domains[i].getObject(args[i]);
            ++i;
        }
        i = 0;
        while (i < vals.length) {
            int j = i + 1;
            while (j < vals.length) {
                if (!this.testTwoQueens(vals[i], vals[j], this.rows[0] * (j - i))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean testTwoQueens(int pos1, int pos2, int sep) {
        if (pos1 == pos2) {
            return false;
        }
        if (sep == 0) {
            return false;
        }
        if (pos2 - sep == pos1) {
            return false;
        }
        return pos2 + sep != pos1;
    }

    @Override
    public boolean testDomains(Domain[] domains) {
        int i = 0;
        while (i < domains.length) {
            if (!(domains[i] instanceof DomainInteger)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean testVar(CSPVariable var) {
        return var.getDomain() instanceof DomainInteger;
    }

    @Override
    public String getTypeString() {
        return "Queens";
    }

    @Override
    public String getType() {
        return "Queens";
    }

    @Override
    public String getDescription(ArrayList<CSPVariable> variables) {
        return "Queens " + this.rows[0];
    }
}

