/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit.dialogs;

import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.dialogs.BasicDialog;
import CIspace.graphToolKit.elements.Edge;
import CIspace.graphToolKit.elements.Node;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EdgeDialog
extends BasicDialog {
    private JComboBox colors;
    private JComboBox types;
    private GraphCanvas parent;
    private Node start;
    private Node end;
    private JTextField label;
    private boolean creating;
    private Edge edge;

    public EdgeDialog(GraphCanvas parent) {
        super((JFrame)parent.parent, "Edge Options", true);
        this.parent = parent;
        this.creating = true;
        this.colors = new JComboBox();
        this.colors.addItem("Black");
        this.colors.addItem("Red");
        this.colors.addItem("Blue");
        this.colors.addItem("Green");
        this.types = new JComboBox();
        this.types.addItem("Directional");
        this.types.addItem("Bi-directional");
        this.types.addItem("Non-directional");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridLayout(3, 1));
        JPanel panel = new JPanel();
        panel.add(new JLabel("Label"));
        this.label = new JTextField("", 10);
        this.label.addActionListener(this);
        panel.add(this.label);
        contentPane.add(panel);
        panel = new JPanel();
        panel.add(this.colors);
        panel.add(this.types);
        contentPane.add(panel);
        panel = new JPanel();
        JButton button = new JButton("OK");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        panel.add(button);
        button = new JButton("Cancel");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        panel.add(button);
        contentPane.add(panel);
    }

    public void open(Node start, Node end) {
        this.creating = true;
        this.centerWindow();
        this.start = start;
        this.end = end;
        this.setSize(265, 150);
        this.setVisible(true);
    }

    public void open(Edge e) {
        this.creating = false;
        this.edge = e;
        this.start = e.start;
        this.end = e.end;
        this.label.setText(e.label[0]);
        if (e.color == Color.black) {
            this.colors.setSelectedItem("Black");
        } else if (e.color == Color.red) {
            this.colors.setSelectedItem("Red");
        } else if (e.color == Color.blue) {
            this.colors.setSelectedItem("Blue");
        } else {
            this.colors.setSelectedItem("Green");
        }
        if (e.type == 5551) {
            this.types.setSelectedItem("Directional");
        } else if (e.type == 5552) {
            this.types.setSelectedItem("Bi-directional");
        } else {
            this.types.setSelectedItem("Non-directional");
        }
        this.centerWindow();
        this.setVisible(true);
    }

    protected boolean actionOK() {
        this.parseDialog();
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }

    private void parseDialog() {
        Color color = this.colors.getSelectedItem() == "Black" ? Color.black : (this.colors.getSelectedItem() == "Red" ? Color.red : (this.colors.getSelectedItem() == "Blue" ? Color.blue : Color.green));
        int type = this.types.getSelectedItem().equals("Directional") ? 5551 : (this.types.getSelectedItem().equals("Bi-directional") ? 5552 : 5550);
        if (this.creating) {
            Edge e = new Edge(this.parent.graph, this.label.getText(), this.start, this.end, color, type);
            this.parent.graph.addEdge(e);
        } else {
            this.parent.graph.modifyEdge(this.edge, this.label.getText(), this.start, this.end, color, type);
        }
    }
}

