/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit.dialogs;

import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.dialogs.BasicFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;

public abstract class TextFrame
extends BasicFrame {
    private JPopupMenu pop;
    protected JTextArea display;
    protected GraphCanvas canvas;
    protected JButton updateButton;

    public TextFrame(GraphCanvas canvas, String textRep, String title) {
        super(title);
        super.setOKString("Update");
        this.setLocation(50, 50);
        this.canvas = canvas;
        JPanel p = new JPanel();
        this.updateButton = new JButton("Update");
        this.updateButton.addActionListener(this);
        this.updateButton.setActionCommand(this.updateButton.getText());
        this.getRootPane().setDefaultButton(this.updateButton);
        p.add(this.updateButton);
        JButton button = new JButton("Cancel");
        button.addActionListener(this);
        button.setActionCommand(button.getText());
        p.add(button);
        this.display = new JTextArea(40, 80);
        this.display.setFont(new Font("Monospaced", 0, 12));
        this.display.setText(textRep);
        this.display.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 4) {
                    Point screenp = new Point(e.getX() - ((JTextArea)e.getSource()).getTopLevelAncestor().getLocation().x, e.getY() - ((JTextArea)e.getSource()).getTopLevelAncestor().getLocation().y);
                    SwingUtilities.convertPointToScreen(screenp, TextFrame.this.display);
                    TextFrame.this.popupEdit(screenp.x, screenp.y);
                }
            }
        });
        JScrollPane displaypane = new JScrollPane(this.display, 20, 30);
        this.pop = new JPopupMenu();
        JPanel statusPane = new JPanel(new BorderLayout());
        CaretListenerLabel caretListenerLabel = new CaretListenerLabel("1 : 1");
        statusPane.add((Component)caretListenerLabel, "East");
        this.display.addCaretListener(caretListenerLabel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)p, "Center");
        bottomPanel.add((Component)statusPane, "South");
        this.getContentPane().add("Center", displaypane);
        this.getContentPane().add("South", bottomPanel);
    }

    protected void open() {
        this.display.setCaretPosition(0);
        this.packCenterOpen();
    }

    protected final void popupEdit(int x, int y) {
        this.pop.removeAll();
        JMenuItem mItem = new JMenuItem("Cut");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Copy");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Paste");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.addSeparator();
        mItem = new JMenuItem("Select All");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected final boolean actionOK() {
        return this.updateAction();
    }

    protected final boolean actionCancel() {
        return true;
    }

    protected abstract boolean updateAction();

    public final void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String arg = e.getActionCommand();
        if (arg.equals("Cut")) {
            this.display.cut();
        } else if (arg.equals("Copy")) {
            this.display.copy();
        } else if (arg.equals("Paste")) {
            this.display.paste();
        } else if (arg.equals("Select All")) {
            this.display.selectAll();
        }
    }

    protected class CaretListenerLabel
    extends JLabel
    implements CaretListener {
        private static final long serialVersionUID = 1L;

        public CaretListenerLabel(String label) {
            super(label);
        }

        public void caretUpdate(CaretEvent e) {
            this.displaySelectionInfo(e.getDot(), e.getMark());
        }

        protected void displaySelectionInfo(final int dot, int mark) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        CaretListenerLabel.this.setText(String.valueOf(((CaretListenerLabel)CaretListenerLabel.this).TextFrame.this.display.getLineOfOffset(dot) + 1) + " : " + (1 + dot - ((CaretListenerLabel)CaretListenerLabel.this).TextFrame.this.display.getLineStartOffset(((CaretListenerLabel)CaretListenerLabel.this).TextFrame.this.display.getLineOfOffset(dot))) + "\n");
                    }
                    catch (BadLocationException ble) {
                        CaretListenerLabel.this.setText("text position: " + dot + "\n");
                    }
                }
            });
        }
    }
}

