/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit.elements;

import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.elements.Edge;
import CIspace.graphToolKit.elements.Entity;
import CIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
extends Entity {
    public Point pos;
    public int width;
    public int height;
    public int shape;
    protected ArrayList<Edge> edgesIn;
    protected ArrayList<Edge> edgesOut;
    public int index;
    protected int wPad;
    protected int hPad;
    protected int printWidth;
    protected int printHeight;
    protected boolean isHeavy;
    protected int heavyWidth = 2;
    protected Color internalColor = Color.WHITE;

    public Node(Graph graph) {
        super(graph);
        this.pos = new Point();
        this.shape = 0;
        this.edgesIn = new ArrayList();
        this.edgesOut = new ArrayList();
        this.index = -1;
        this.updateSize();
        this.wPad = 20;
        this.hPad = 20;
    }

    public Node(Graph graph, String label, Point pos, Color color, int shape) {
        super(graph);
        this.label[0] = label;
        this.pos = pos;
        this.isSelected = false;
        this.isBold = false;
        this.color = color;
        this.shape = shape;
        this.edgesIn = new ArrayList();
        this.edgesOut = new ArrayList();
        this.type = 7770;
        this.wPad = 20;
        this.hPad = 20;
        this.updateSize();
    }

    public void updateSize() {
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    public void updateSize(int printWidth, int printHeight) {
        this.width = printWidth;
        this.height = printHeight;
    }

    protected int getWidth() {
        return this.graph.canvas.getFontMetrics().stringWidth(this.label[0]) + this.wPad;
    }

    protected int getHeight() {
        return this.graph.canvas.getFontMetrics().getHeight() + this.hPad;
    }

    public final Point getPos() {
        return this.pos;
    }

    public final void setPos(Point pos) {
        this.pos = pos;
    }

    public final float getXPos() {
        return this.pos.x;
    }

    public final float getYPos() {
        return this.pos.y;
    }

    public void set(String l, Point p, Color c, int s) {
        this.label[0] = l;
        this.pos = p;
        this.color = c;
        this.shape = s;
    }

    public final void setHeavy(boolean heavy) {
        this.isHeavy = heavy;
    }

    public final boolean isHeavy() {
        return this.isHeavy;
    }

    public final void setShape(int shape) {
        this.shape = shape != 1112 && shape != 1111 && shape != 1110 && shape != 1113 ? 1111 : shape;
    }

    public final int getShape() {
        return this.shape;
    }

    @Override
    public void draw(Graphics graphics, boolean moving) {
        float lineWidth = this.graph.getLineWidth() + this.xw;
        if (this.isHeavy) {
            lineWidth += (float)this.heavyWidth;
        }
        Point nw = new Point(this.pos);
        nw.translate(-this.width / 2, -this.height / 2);
        graphics.setColor(this.color);
        switch (this.shape) {
            case 1111: {
                graphics.fillRect((int)(nw.x - lineWidth), (int)(nw.y - lineWidth), (int)((float)this.width + lineWidth * 2.0f), (int)((float)this.height + lineWidth * 2.0f));
                if (this.isBold) break;
                graphics.setColor(this.internalColor);
                graphics.fillRect((int)nw.x, (int)nw.y, this.width, this.height);
                break;
            }
            case 1113: {
                if (this.width < 20) {
                    this.width = 20;
                    nw = new Point(this.pos);
                    nw.translate(-this.width / 2, -this.height / 2);
                }
                graphics.fillRoundRect((int)(nw.x - lineWidth), (int)(nw.y - lineWidth), (int)((float)this.width + lineWidth * 2.0f), (int)((float)this.height + lineWidth * 2.0f), 30, 30);
                if (this.isBold) break;
                graphics.setColor(this.internalColor);
                graphics.fillRoundRect((int)nw.x, (int)nw.y, this.width, this.height, 30, 30);
                break;
            }
            case 1112: {
                int[] xVals = new int[4];
                xVals[0] = xVals[2] = (int)this.pos.x;
                xVals[1] = (int)((double)this.pos.x + (double)this.width / 1.5 + (double)lineWidth);
                xVals[3] = (int)((double)this.pos.x - (double)this.width / 1.5 - (double)lineWidth);
                int[] yVals = new int[4];
                yVals[0] = (int)((double)this.pos.y - (double)this.height / 1.5 - (double)lineWidth);
                yVals[1] = yVals[3] = (int)this.pos.y;
                yVals[2] = (int)((double)this.pos.y + (double)this.height / 1.5 + (double)lineWidth);
                graphics.fillPolygon(xVals, yVals, 4);
                if (this.isBold) break;
                if (((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON) {
                    xVals[1] = (int)((float)xVals[1] - 2.0f * lineWidth);
                    xVals[3] = (int)((float)xVals[3] + 2.0f * lineWidth);
                } else if (this.width < 55) {
                    xVals[1] = (int)((double)xVals[1] - 1.6 * (double)lineWidth);
                    xVals[3] = (int)((float)xVals[3] + 2.0f * lineWidth);
                } else {
                    xVals[1] = (int)((float)xVals[1] - (float)(this.width / 25) * lineWidth);
                    xVals[3] = (int)((float)xVals[3] + (float)(this.width / 25) * lineWidth);
                }
                yVals[0] = (int)((float)yVals[0] + lineWidth);
                yVals[2] = (int)((float)yVals[2] - lineWidth);
                graphics.setColor(this.internalColor);
                graphics.fillPolygon(xVals, yVals, 4);
                break;
            }
            default: {
                graphics.fillOval((int)(nw.x - lineWidth), (int)(nw.y - lineWidth), (int)((float)this.width + lineWidth * 2.0f), (int)((float)this.height + lineWidth * 2.0f));
                if (this.isBold) break;
                graphics.setColor(this.internalColor);
                graphics.fillOval((int)nw.x, (int)nw.y, this.width, this.height);
            }
        }
        this.drawLabel(graphics);
        if ((!moving || this.graph.canvas.getSubmode() == 3335) && this.isSelected && this.graph.canvas.getMode() != 2221) {
            graphics.setColor(Color.magenta);
            graphics.fillRect((int)((double)this.pos.x - (double)this.width / 1.5) - 2, (int)((double)this.pos.y - (double)this.height / 1.5) - 2, 4, 4);
            graphics.fillRect((int)((double)this.pos.x - (double)this.width / 1.5) - 2, (int)((double)this.pos.y + (double)this.height / 1.5) - 2, 4, 4);
            graphics.fillRect((int)((double)this.pos.x + (double)this.width / 1.5) - 2, (int)((double)this.pos.y + (double)this.height / 1.5) - 2, 4, 4);
            graphics.fillRect((int)((double)this.pos.x + (double)this.width / 1.5) - 2, (int)((double)this.pos.y - (double)this.height / 1.5) - 2, 4, 4);
        }
    }

    protected void drawLabel(Graphics offscreen) {
        if (this.isBold && (this.color == Color.blue || this.color == Color.black)) {
            offscreen.setColor(Color.white);
        } else {
            offscreen.setColor(Color.black);
        }
        offscreen.drawString(this.label[0], (int)this.pos.x - this.graph.canvas.getFontMetrics().stringWidth(this.label[0]) / 2, (int)this.pos.y + this.graph.canvas.getFontMetrics().getAscent() / 2);
    }

    @Override
    public void drawStructure(Graphics g, boolean moving) {
        this.width /= 2;
        this.height /= 2;
        this.draw(g, moving);
        this.width *= 2;
        this.height *= 2;
    }

    public void addEdgesIn(Edge edge) {
        this.edgesIn.add(edge);
    }

    public void addEdgesOut(Edge edge) {
        this.edgesOut.add(edge);
    }

    public void removeEdgesIn(Edge e) {
        this.edgesIn.remove(e);
    }

    public void removeEdgesOut(Edge e) {
        this.edgesOut.remove(e);
    }

    public ArrayList<Edge>[] getAllEdges() {
        ArrayList[] tmp = new ArrayList[]{this.edgesIn, this.edgesOut};
        return tmp;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void setLabel(String name) {
        this.label[0] = name.equals("") ? "Node " + this.getIndex() : name;
    }

    @Override
    public boolean contains(Point p) {
        if (this.width == 0 || this.height == 0) {
            return false;
        }
        int dx = (int)Math.abs(this.pos.x - p.x);
        int dy = (int)Math.abs(this.pos.y - p.y);
        if (this.shape == 1110) {
            double radX2 = (double)this.width / 2.0 * ((double)this.width / 2.0);
            double radY2 = (double)this.height / 2.0 * ((double)this.height / 2.0);
            return (double)((p.x - this.pos.x) * (p.x - this.pos.x)) / radX2 + (double)((p.y - this.pos.y) * (p.y - this.pos.y)) / radY2 <= 1.0;
        }
        if (this.shape == 1111 || this.shape == 1113) {
            return (double)(4 * dx * dx / (this.width * this.width) + 4 * dy * dy / (this.height * this.height)) <= 0.5;
        }
        Point p1 = new Point(this.pos.x, this.pos.y - (float)this.height / 1.5f);
        Point p2 = new Point(this.pos.x + (float)this.width / 1.5f, this.pos.y);
        Point p3 = new Point(this.pos.x, this.pos.y + (float)this.height / 1.5f);
        Point p4 = new Point(this.pos.x - (float)this.width / 1.5f, this.pos.y);
        return p.leftOf(p1, p4) < 0.0f && p.leftOf(p4, p3) < 0.0f && p.leftOf(p3, p2) < 0.0f && p.leftOf(p2, p1) < 0.0f;
    }

    @Override
    public boolean isInRect(Point a, Point b) {
        Point upperLeft = new Point(this.pos.x - (float)(this.width / 2), this.pos.y - (float)(this.height / 2));
        Point lowerRight = new Point(this.pos.x + (float)(this.width / 2), this.pos.y + (float)(this.height / 2));
        if (this.shape == 1112) {
            upperLeft.x = this.pos.x - (float)this.width / 1.5f;
            upperLeft.y = this.pos.y - (float)this.height / 1.5f;
            lowerRight.x = this.pos.x + (float)this.width / 1.5f;
            lowerRight.y = this.pos.y + (float)this.height / 1.5f;
        }
        return upperLeft.x > a.x && lowerRight.x < b.x && upperLeft.y > a.y && lowerRight.y < b.y;
    }

    @Override
    public void translate(float dx, float dy) {
        this.pos.translate(dx, dy);
        int i = 0;
        while (i < this.edgesIn.size()) {
            this.edgesIn.get(i).updateLength();
            ++i;
        }
        i = 0;
        while (i < this.edgesOut.size()) {
            this.edgesOut.get(i).updateLength();
            ++i;
        }
    }

    @Override
    public void move(Point p) {
        this.pos.move(p);
        int i = 0;
        while (i < this.edgesIn.size()) {
            this.edgesIn.get(i).updateLength();
            ++i;
        }
        i = 0;
        while (i < this.edgesOut.size()) {
            this.edgesOut.get(i).updateLength();
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Point findBorder(Node start) {
        float tmp2;
        if (this.shape == 1110 || this.shape == 1113) {
            float dx = this.pos.x - start.pos.x;
            float dy = this.pos.y - start.pos.y;
            float t = (float)(0.5 / Math.sqrt(dx * dx / (float)(this.width * this.width) + dy * dy / (float)(this.height * this.height)));
            return new Point(this.pos.x - dx * t, this.pos.y - dy * t);
        }
        Point a = new Point(this.pos);
        Point b = new Point(start.pos.x, start.pos.y);
        Point c = new Point(0.0f, 0.0f);
        Point d = new Point(0.0f, 0.0f);
        Point p1 = new Point(0.0f, 0.0f);
        Point p2 = new Point(0.0f, 0.0f);
        Point p3 = new Point(0.0f, 0.0f);
        Point p4 = new Point(0.0f, 0.0f);
        if (this.shape == 1111) {
            p1.move(this.pos.x - (float)(this.width / 2), this.pos.y - (float)(this.height / 2));
            p2.move(p1.x, this.pos.y + (float)(this.height / 2));
            p3.move(this.pos.x + (float)(this.width / 2), p2.y);
            p4.move(p3.x, p1.y);
        } else {
            p1.move(this.pos.x, this.pos.y - (float)this.height / 1.5f);
            p2.move(this.pos.x - (float)this.width / 1.5f, this.pos.y);
            p3.move(this.pos.x, this.pos.y + (float)this.height / 1.5f);
            p4.move(this.pos.x + (float)this.width / 1.5f, this.pos.y);
        }
        float tmp1 = b.leftOf(p3, p1);
        if (tmp1 < 0.0f) {
            tmp2 = b.leftOf(p4, p2);
            if (tmp2 < 0.0f) {
                c.move(p2);
                d.move(p3);
            } else {
                if (!(tmp2 > 0.0f)) return p2;
                c.move(p1);
                d.move(p2);
            }
        } else if (tmp1 > 0.0f) {
            tmp2 = b.leftOf(p2, p4);
            if (tmp2 < 0.0f) {
                c.move(p4);
                d.move(p1);
            } else {
                if (!(tmp2 > 0.0f)) return p4;
                c.move(p3);
                d.move(p4);
            }
        } else {
            float tmp22 = b.leftOf(p2, p4);
            if (tmp22 < 0.0f) {
                return p1;
            }
            if (!(tmp22 > 0.0f)) return a;
            return p3;
        }
        float[][] A = new float[2][2];
        A[0][0] = b.y - a.y;
        A[0][1] = a.x - b.x;
        A[1][0] = d.y - c.y;
        A[1][1] = c.x - d.x;
        float[] B = new float[]{a.x * b.y - b.x * a.y, c.x * d.y - d.x * c.y};
        float denominator = A[0][0] * A[1][1] - A[0][1] * A[1][0];
        float[][] invA = new float[2][2];
        invA[0][0] = A[1][1] / denominator;
        invA[0][1] = -A[0][1] / denominator;
        invA[1][0] = -A[1][0] / denominator;
        invA[1][1] = A[0][0] / denominator;
        return new Point(invA[0][0] * B[0] + invA[0][1] * B[1], invA[1][0] * B[0] + invA[1][1] * B[1]);
    }

    @Override
    public boolean equals(Entity ent) {
        if (ent.type == 7770) {
            return ((Node)ent).index == this.index && this.pos.equals(((Node)ent).pos);
        }
        return false;
    }

    public ArrayList<Node> getNeighbours() {
        ArrayList<Node> tmp = new ArrayList<Node>(this.edgesOut.size());
        int i = 0;
        while (i < this.edgesOut.size()) {
            tmp.add(this.edgesOut.get(i).otherNode(this));
            ++i;
        }
        return tmp;
    }

    public boolean isConnected() {
        return this.edgesIn.size() > 0 || this.edgesOut.size() > 0;
    }

    @Override
    public String toString() {
        return this.label[0];
    }

    public Color getInternalColor() {
        return this.internalColor;
    }

    public void setInternalColor(Color internalColor) {
        this.internalColor = internalColor;
    }
}

