/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.InlineApplet;
import CIspace.search.InlineCanvas;
import CIspace.search.SearchGraph;
import CIspace.search.searchTypes.Search;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class InlineSearchApplet
extends InlineApplet {
    public JTextPane algorithmPane;
    private static final long serialVersionUID = 1L;
    private int searchAlgorithm = 201;
    public JTextArea pathTextArea;
    public JToggleButton fakeButton;
    public JToggleButton quizButton;
    public JToggleButton inspectNodeButton;
    public JToggleButton selectButton;
    public JToggleButton resetButton;
    public JToggleButton stopButton;
    public JToggleButton autoSearchButton;
    public JToggleButton stepButton;
    public JToggleButton fineStepButton;
    private boolean fineStepButtonOn = false;
    private boolean stepButtonOn = false;
    private boolean autoSearchButtonOn = false;
    private boolean stopButtonOn = false;
    private boolean resetButtonOn = false;
    private boolean selectButtonOn = false;
    private boolean inspectNodeButtonOn = false;
    private boolean quizButtonOn = false;
    public boolean fineStepPopupOn = false;
    public boolean stepPopupOn = false;
    public boolean autoSearchPopupOn = false;
    public boolean stopPopupOn = false;
    public boolean resetPopupOn = false;
    public boolean quizPopupOn = false;
    public boolean pruningPopupOn = false;
    public boolean algorithmPopupOn = false;
    private boolean showNodeHeuristics = false;
    private boolean showEdgeCosts = false;
    private boolean showQuizResults = false;
    private boolean showPathInfo = false;
    private boolean showAlgorithm = false;
    private boolean quizMode = false;

    public void init() {
        super.init();
        this.makeCanvas();
        this.loadParams();
        if (this.incorrectParameter) {
            return;
        }
        ((InlineCanvas)this.canvas).initializePopup();
        this.createToolBar();
        this.addComponent(this.messageCanvas, this.canvasPanel, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.canvas, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        this.canvas.setMinimumSize(new Dimension(10, 100));
        if (!this.showMessagePanel) {
            this.messageCanvas.setVisible(false);
        } else {
            this.messageCanvas.setMinimumSize(new Dimension(10, 50));
            this.setPromptLabel("Click Fine Step, Step, or Auto Search to watch the algorithm run.");
        }
        this.pathTextArea = new JTextArea();
        this.pathTextArea.setEditable(false);
        this.pathTextArea.setBackground(Color.white);
        this.pathTextArea.setForeground(GraphConsts.fg);
        this.pathTextArea.setRows(2);
        this.pathTextArea.setText("CURRENT PATH:\n");
        JScrollPane taPanel = new JScrollPane(this.pathTextArea, 20, 31);
        this.algorithmPane = new JTextPane();
        this.algorithmPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.algorithmPane.setEditable(false);
        this.algorithmPane.setMinimumSize(new Dimension(100, 17));
        this.updateAlgorithm();
        if (this.incorrectParameter) {
            return;
        }
        StyledDocument doc = this.algorithmPane.getStyledDocument();
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 1);
        StyleConstants.setFontFamily(standard, "arial");
        StyleConstants.setBold(standard, true);
        doc.setParagraphAttributes(0, 0, standard, true);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)taPanel, "Center");
        bottomPanel.add((Component)this.algorithmPane, "South");
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(this.canvasPanel);
        this.canvasPanel.addComponentListener(this);
        splitPane.setBottomComponent(bottomPanel);
        if (!this.showPathInfo) {
            taPanel.setVisible(false);
            splitPane.setDividerSize(0);
            splitPane.setResizeWeight(1.0);
            splitPane.setEnabled(false);
        } else {
            splitPane.setOneTouchExpandable(true);
            splitPane.setResizeWeight(0.85);
        }
        if (!this.showAlgorithm) {
            this.algorithmPane.setVisible(false);
        }
        if (this.showButtons) {
            splitPane.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 75));
        } else {
            splitPane.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 10));
            this.toolBarPanel.setVisible(false);
        }
        this.algorithmPane.setBorder(null);
        if (this.showBorder) {
            this.canvas.setBorder(BorderFactory.createLineBorder(Color.black));
            splitPane.setBorder(BorderFactory.createLineBorder(Color.black));
            taPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        } else {
            this.canvas.setBorder(null);
            splitPane.setBorder(null);
            taPanel.setBorder(null);
        }
        this.mainPanel.add((Component)splitPane, "Center");
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.setBorder(null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        ((SearchGraph)this.returnCanvas().graph).createFrontierInfo();
        if (this.quizMode) {
            this.startQuiz();
        }
    }

    protected void makeCanvas() {
        this.canvas = new InlineCanvas(this);
        this.canvas.WIDTH = this.getSize().width;
        this.canvas.HEIGHT = this.getSize().height;
        this.canvas.setPreferredSize(new Dimension(this.canvas.WIDTH, this.canvas.HEIGHT));
        this.canvas.setMode(2221);
    }

    public InlineCanvas returnCanvas() {
        return (InlineCanvas)this.canvas;
    }

    protected void loadParams() {
        super.loadParams();
        String param = this.getParameter("fineStepButton");
        if (param != null) {
            if (param.equals("on")) {
                this.fineStepButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("fineStepButton", param);
            }
        }
        if ((param = this.getParameter("stepButton")) != null) {
            if (param.equals("on")) {
                this.stepButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepButton", param);
            }
        }
        if ((param = this.getParameter("autoSearchButton")) != null) {
            if (param.equals("on")) {
                this.autoSearchButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoSearchButton", param);
            }
        }
        if ((param = this.getParameter("stopButton")) != null) {
            if (param.equals("on")) {
                this.stopButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopButton", param);
            }
        }
        if ((param = this.getParameter("resetButton")) != null) {
            if (param.equals("on")) {
                this.resetButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("resetButton", param);
            }
        }
        if ((param = this.getParameter("selectButton")) != null) {
            if (param.equals("on")) {
                this.selectButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("selectButton", param);
            }
        }
        if ((param = this.getParameter("inspectNodeButton")) != null) {
            if (param.equals("on")) {
                this.inspectNodeButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("inspectNodeButton", param);
            }
        }
        if ((param = this.getParameter("quizButton")) != null) {
            if (param.equals("on")) {
                this.quizButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("quizButton", param);
            }
        }
        if ((param = this.getParameter("pathInfo")) != null) {
            if (param.equals("on")) {
                this.showPathInfo = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("pathInfo", param);
            }
        }
        if ((param = this.getParameter("showAlgorithm")) != null) {
            if (param.equals("on")) {
                this.showAlgorithm = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showAlgorithm", param);
            }
        }
        if ((param = this.getParameter("fineStepPopup")) != null) {
            if (param.equals("on")) {
                this.fineStepPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("fineStepPopup", param);
            }
        }
        if ((param = this.getParameter("stepPopup")) != null) {
            if (param.equals("on")) {
                this.stepPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepPopup", param);
            }
        }
        if ((param = this.getParameter("autoSearchPopup")) != null) {
            if (param.equals("on")) {
                this.autoSearchPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoSearchPopup", param);
            }
        }
        if ((param = this.getParameter("stopPopup")) != null) {
            if (param.equals("on")) {
                this.stopPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopPopup", param);
            }
        }
        if ((param = this.getParameter("resetPopup")) != null) {
            if (param.equals("on")) {
                this.resetPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("resetPopup", param);
            }
        }
        if ((param = this.getParameter("quizPopup")) != null) {
            if (param.equals("on")) {
                this.quizPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("quizPopup", param);
            }
        }
        if ((param = this.getParameter("showNodeHeuristics")) != null) {
            if (param.equals("on")) {
                this.showNodeHeuristics = true;
                this.returnCanvas().setDisplayHeuristics(true);
            } else if (param.equals("off")) {
                this.returnCanvas().setDisplayHeuristics(false);
            } else {
                this.incorrectParameter("showNodeHeuristics", param);
            }
        } else {
            this.returnCanvas().setDisplayHeuristics(false);
        }
        param = this.getParameter("showEdgeCosts");
        if (param != null) {
            if (param.equals("on")) {
                this.returnCanvas().setDisplayCost(true);
                this.showEdgeCosts = true;
            } else if (param.equals("off")) {
                this.returnCanvas().setDisplayCost(false);
            } else {
                this.incorrectParameter("showEdgeCosts", param);
            }
        } else {
            this.returnCanvas().setDisplayCost(false);
        }
        param = this.getParameter("showQuizResults");
        if (param != null && param.equals("on")) {
            this.showQuizResults = true;
            Search searchObject = this.returnCanvas().getSearchObject();
            if (searchObject != null) {
                searchObject.setShowAnswers(!searchObject.getShowAnswers());
                if (((SearchGraph)this.returnCanvas().graph).getSearchRate() == 104) {
                    if (searchObject.getShowAnswers()) {
                        ((SearchGraph)this.returnCanvas().graph).getFrontierInfo().displayQuizFrontier();
                    } else {
                        this.setFrontierPathArea(" ");
                    }
                }
            }
        } else if (param != null && !param.equals("off")) {
            this.incorrectParameter("showQuizResults", param);
        }
        if ((param = this.getParameter("pruningPopup")) != null) {
            if (param.equals("on")) {
                this.pruningPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("pruningPopup", param);
            }
        }
        if ((param = this.getParameter("algorithmPopup")) != null) {
            if (param.equals("on")) {
                this.algorithmPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("algorithmPopup", param);
            }
        }
        if ((param = this.getParameter("quizMode")) != null) {
            if (param.equals("on")) {
                this.quizMode = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("quizMode", param);
            }
        }
        if ((param = this.getParameter("speed")) != null) {
            if (param.equals("veryFast")) {
                Search.animationSpeed = 0;
            } else if (param.equals("fast")) {
                Search.animationSpeed = 100;
            } else if (param.equals("medium")) {
                Search.animationSpeed = 500;
            } else if (param.equals("slow")) {
                Search.animationSpeed = 1000;
            } else {
                this.incorrectParameter("speed", param);
            }
        } else {
            Search.animationSpeed = 100;
        }
    }

    public void createToolBar() {
        this.toolBarPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttons = new JToggleButton[9];
        int index = 0;
        this.setSolveButtonsWithText(index, " Fine Step ", InlineSearchApplet.createImageIcon("images/finestep.png"), "Fine Step");
        this.fineStepButton = this.buttons[index++];
        if (!this.fineStepButtonOn) {
            this.fineStepButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Step    ", InlineSearchApplet.createImageIcon("images/step.png"), "Step");
        this.stepButton = this.buttons[index++];
        if (!this.stepButtonOn) {
            this.stepButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Auto Search", InlineSearchApplet.createImageIcon("images/gear.png"), "Auto Search");
        this.autoSearchButton = this.buttons[index++];
        if (!this.autoSearchButtonOn) {
            this.autoSearchButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Stop Search", InlineSearchApplet.createImageIcon("images/stop.gif"), "Stop Search");
        this.stopButton = this.buttons[index++];
        this.stopButton.setEnabled(false);
        if (!this.stopButtonOn) {
            this.stopButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Reset Search", InlineSearchApplet.createImageIcon("images/Reset.gif"), "Reset Search");
        this.resetButton = this.buttons[index++];
        if (!this.resetButtonOn) {
            this.resetButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "   Select   ", InlineSearchApplet.createImageIcon("images/select.png"), "Select");
        this.selectButton = this.buttons[index++];
        this.selectButton.setSelected(true);
        if (!this.selectButtonOn) {
            this.selectButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Inspect Node Paths", InlineSearchApplet.createImageIcon("images/viewNodeInfo.png"), "Inspect Node Paths");
        this.inspectNodeButton = this.buttons[index++];
        if (!this.inspectNodeButtonOn) {
            this.inspectNodeButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Quiz    ", InlineSearchApplet.createImageIcon("images/quiz.gif"), "Quiz");
        this.quizButton = this.buttons[index++];
        if (!this.quizButtonOn) {
            this.quizButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Fake", InlineSearchApplet.createImageIcon("images/finestep.png"), "Fake");
        this.fakeButton = this.buttons[index++];
        ButtonGroup buttonGroup2 = new ButtonGroup();
        Font toolFont = new Font("arial", 0, 10);
        int i = 0;
        while (i < index) {
            if (this.buttons[i] != this.selectButton && this.buttons[i] != this.inspectNodeButton) {
                buttonGroup.add(this.buttons[i]);
                toolBar.add(this.buttons[i]);
                this.buttons[i].setFont(toolFont);
            } else {
                buttonGroup2.add(this.buttons[i]);
                toolBar.add(this.buttons[i]);
                this.buttons[i].setFont(toolFont);
            }
            ++i;
        }
        this.buttons[index - 1].setVisible(false);
        this.toolBarPanel.add((Component)toolBar, "Center");
        this.mainPanel.add((Component)this.toolBarPanel, "North");
    }

    public int getAlgorithm() {
        return this.searchAlgorithm;
    }

    public void load(String filename) {
        try {
            String line;
            StringBuffer all = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL(filename).openStream()));
            while ((line = in.readLine()) != null) {
                all.append(line).append("\n");
            }
            in.close();
            ((InlineCanvas)this.canvas).resetSearch();
            ((InlineCanvas)this.canvas).parseXML(all.toString());
            ((InlineCanvas)this.canvas).greenify();
            if (this.searchAlgorithm == 209) {
                ((InlineCanvas)this.canvas).doSearch(209, 102);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (this.canvas.pause) {
            return;
        }
        if (arg.equals("Step")) {
            ((InlineCanvas)this.canvas).doSearch(this.getAlgorithm(), 102);
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Fine Step")) {
            ((InlineCanvas)this.canvas).doSearch(this.getAlgorithm(), 103);
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Auto Search")) {
            this.setIsAutoSearchingOptions(true);
            ((InlineCanvas)this.canvas).doSearch(this.getAlgorithm(), 101);
        } else if (arg.equals("Stop Search")) {
            this.stopSearch();
        } else if (arg.equals("Reset Search")) {
            this.resetSearch();
            if (this.quizMode) {
                this.startQuiz();
            }
        } else if (arg.equals("Select")) {
            ((InlineCanvas)this.canvas).setSubmode(3332);
        } else if (arg.equals("Inspect Node Paths")) {
            ((InlineCanvas)this.canvas).setSubmode(32465);
        } else if (arg.equals("Quiz")) {
            this.startQuiz();
        } else if (arg.equals("Autoscale")) {
            this.canvas.autoscale();
        } else if (arg.equals("Reset Labels")) {
            this.canvas.resetLabels();
        } else if (arg.equals("Show Frontier Info")) {
            ((SearchGraph)this.canvas.graph).createFrontierInfo();
        } else if (arg.equals("Depth First") || arg.equals("Breadth First") || arg.equals("Lowest Cost First") || arg.equals("Best First") || arg.equals("Heuristic Depth First") || arg.equals("A*") || arg.equals("User Defined")) {
            this.setAlgorithm(arg);
        } else if (arg.equals("Multiple-Path Pruning")) {
            ((SearchGraph)this.returnCanvas().graph).setPruning(301);
            this.returnCanvas().resetSearch();
            this.setAlgorithm(this.getAlgorithmName());
        } else if (arg.equals("Loop Detection")) {
            ((SearchGraph)this.returnCanvas().graph).setPruning(302);
            this.returnCanvas().resetSearch();
            this.setAlgorithm(this.getAlgorithmName());
        } else if (arg.equals("None")) {
            ((SearchGraph)this.returnCanvas().graph).setPruning(303);
            this.returnCanvas().resetSearch();
            this.setAlgorithm(this.getAlgorithmName());
        } else if (arg.equals("View Prolog Code")) {
            this.returnCanvas().prologRep();
        } else if (arg.equals("View Text Representation")) {
            this.returnCanvas().textRep(false);
        } else if (arg.equals("View XML Representation")) {
            this.returnCanvas().XMLRep(false);
        }
    }

    public void setIsAutoSearchingOptions(boolean isEnabled) {
        this.stepButton.setEnabled(!isEnabled);
        this.fineStepButton.setEnabled(!isEnabled);
        this.stopButton.setEnabled(isEnabled);
        this.selectButton.setEnabled(!isEnabled);
        this.inspectNodeButton.setEnabled(!isEnabled);
        this.quizButton.setEnabled(!isEnabled);
        this.returnCanvas().step.setEnabled(!isEnabled);
        this.returnCanvas().fineStep.setEnabled(!isEnabled);
        this.returnCanvas().stop.setEnabled(isEnabled);
        this.returnCanvas().quiz.setEnabled(!isEnabled);
        if (!isEnabled) {
            this.fakeButton.setSelected(true);
        }
    }

    public void resetSearch() {
        if (!this.resetButton.isEnabled()) {
            return;
        }
        ((InlineCanvas)this.canvas).resetSearch();
        ((InlineCanvas)this.canvas).greenify();
        if (this.searchAlgorithm == 209) {
            ((InlineCanvas)this.canvas).doSearch(209, 102);
        }
        this.setPromptLabel("Click Fine Step, Step or Auto Search to watch the algorithm run.");
        this.fakeButton.setSelected(true);
        if (this.searchAlgorithm != 209) {
            this.stepButton.setEnabled(true);
            this.fineStepButton.setEnabled(true);
            this.autoSearchButton.setEnabled(true);
            this.stopButton.setEnabled(false);
            this.selectButton.setEnabled(true);
            this.inspectNodeButton.setEnabled(true);
            this.quizButton.setEnabled(true);
            this.returnCanvas().step.setEnabled(true);
            this.returnCanvas().fineStep.setEnabled(true);
            this.returnCanvas().autoSearch.setEnabled(true);
            this.returnCanvas().stop.setEnabled(false);
            this.returnCanvas().quiz.setEnabled(true);
        }
    }

    public void startQuiz() {
        this.selectButton.doClick();
        this.stepButton.setEnabled(false);
        this.fineStepButton.setEnabled(false);
        this.autoSearchButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.selectButton.setEnabled(false);
        this.inspectNodeButton.setEnabled(false);
        this.quizButton.setEnabled(false);
        if (((SearchGraph)this.returnCanvas().graph).getSearchObject() != null) {
            ((SearchGraph)this.returnCanvas().graph).getSearchObject().updateForQuiz();
        }
        this.returnCanvas().doSearch(this.getAlgorithm(), 104);
        this.returnCanvas().step.setEnabled(false);
        this.returnCanvas().fineStep.setEnabled(false);
        this.returnCanvas().autoSearch.setEnabled(false);
        this.returnCanvas().stop.setEnabled(false);
        this.returnCanvas().reset.setEnabled(true);
    }

    public void setFrontierPathArea(String info) {
        if (info.length() > 0) {
            if (((SearchGraph)this.canvas.graph).search != null) {
                this.setPathArea(String.valueOf(((SearchGraph)this.canvas.graph).search.getPathString()) + "\n");
            }
            this.pathTextArea.append(info);
        }
    }

    public void clearPathArea() {
        this.pathTextArea.setText("");
    }

    public void setPathArea(String path) {
        Search sTemp = ((SearchGraph)this.returnCanvas().graph).getSearchObject();
        if (path.equals("") || path.equals("\n")) {
            if (sTemp == null || sTemp.isPathCurrent()) {
                this.pathTextArea.setText("CURRENT PATH: \n   None\n");
            } else {
                this.pathTextArea.setText("PREVIOUS PATH: \n   None\n");
            }
        } else if (sTemp == null || sTemp.isPathCurrent()) {
            this.pathTextArea.setText("CURRENT PATH: \n   " + path);
        } else {
            this.pathTextArea.setText("PREVIOUS PATH: \n   " + path);
        }
    }

    public boolean isShowingAnswers() {
        return this.showQuizResults;
    }

    public void stopSearch() {
        if (!this.stopButton.isEnabled()) {
            return;
        }
        ((SearchGraph)this.returnCanvas().graph).stopAutoSearch();
        this.fineStepButton.setEnabled(true);
        this.stepButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.selectButton.setEnabled(true);
        this.inspectNodeButton.setEnabled(true);
        this.quizButton.setEnabled(true);
        this.fakeButton.setSelected(true);
        this.returnCanvas().step.setEnabled(true);
        this.returnCanvas().fineStep.setEnabled(true);
        this.returnCanvas().stop.setEnabled(false);
        this.returnCanvas().quiz.setEnabled(true);
    }

    public void setAutoSearch() {
        this.stopButton.setEnabled(false);
        this.returnCanvas().stop.setEnabled(false);
    }

    private void updateAlgorithm() {
        String param = this.getParameter("algorithm");
        if (param != null) {
            if (param.equals("depthFirst") || param.equals("breadthFirst") || param.equals("lowestCostFirst") || param.equals("bestFirst") || param.equals("heuristicDepthFirst") || param.equals("A*") || param.equals("userDefined")) {
                this.setAlgorithm(param);
            } else {
                this.incorrectParameter("algorithm", param);
            }
        } else {
            this.setAlgorithm("Depth First");
        }
        param = this.getParameter("pruning");
        if (param != null) {
            if (param.equals("multiplePath")) {
                ((SearchGraph)this.returnCanvas().graph).setPruning(301);
                this.returnCanvas().resetSearch();
                this.setAlgorithm(this.getAlgorithmName());
            } else if (param.equals("loopDetection")) {
                ((SearchGraph)this.returnCanvas().graph).setPruning(302);
                this.returnCanvas().resetSearch();
                this.setAlgorithm(this.getAlgorithmName());
            } else if (!param.equals("off")) {
                this.incorrectParameter("pruning", param);
            }
        }
    }

    private String getAlgorithmName() {
        if (this.searchAlgorithm == 201) {
            return "Depth First";
        }
        if (this.searchAlgorithm == 202) {
            return "Breadth First";
        }
        if (this.searchAlgorithm == 203) {
            return "Lowest Cost First";
        }
        if (this.searchAlgorithm == 204) {
            return "Best First";
        }
        if (this.searchAlgorithm == 205) {
            return "Heuristic Depth First";
        }
        if (this.searchAlgorithm == 206) {
            return "A*";
        }
        if (this.searchAlgorithm == 209) {
            return "User Defined";
        }
        return "No Algorithm Selected";
    }

    public void setAlgorithm(String algorithm) {
        if (algorithm.equals("Depth First") || algorithm.equals("depthFirst")) {
            this.algorithmPane.setText("Algorithm Selected: Depth First");
            this.returnCanvas().searchMethod = 201;
            this.searchAlgorithm = 201;
        } else if (algorithm.equals("Breadth First") || algorithm.equals("breadthFirst")) {
            this.algorithmPane.setText("Algorithm Selected: Breadth First");
            this.returnCanvas().searchMethod = 202;
            this.searchAlgorithm = 202;
        } else if (algorithm.equals("Lowest Cost First") || algorithm.equals("lowestCostFirst")) {
            this.algorithmPane.setText(" Algorithm Selected:  Lowest Cost First  ");
            this.returnCanvas().searchMethod = 203;
            this.searchAlgorithm = 203;
        } else if (algorithm.equals("Best First") || algorithm.equals("bestFirst")) {
            this.algorithmPane.setText(" Algorithm Selected: Best First ");
            this.returnCanvas().searchMethod = 204;
            this.searchAlgorithm = 204;
        } else if (algorithm.equals("Heuristic Depth First") || algorithm.equals("heuristicDepthFirst")) {
            this.algorithmPane.setText(" Algorithm Selected: Heuristic Depth First");
            this.returnCanvas().searchMethod = 205;
            this.searchAlgorithm = 205;
        } else if (algorithm.equals("A*")) {
            this.algorithmPane.setText("Algorithm Selected:  A*");
            this.returnCanvas().searchMethod = 206;
            this.searchAlgorithm = 206;
        } else if (algorithm.equals("User Defined") || algorithm.equals("userDefined")) {
            this.algorithmPane.setText("Algorithm Selected: User Defined");
            this.returnCanvas().searchMethod = 209;
            this.searchAlgorithm = 209;
        }
        this.returnCanvas().resetSearch();
        if (this.returnCanvas().getMode() == 2221) {
            ((InlineCanvas)this.canvas).greenify();
            if (algorithm.equals("User Defined")) {
                this.startUserDefinedSearch();
            }
        }
        this.returnCanvas().setDisplayCost(this.showEdgeCosts);
        this.returnCanvas().setDisplayHeuristics(this.showNodeHeuristics);
        this.returnCanvas().updateGraph();
    }

    private void startUserDefinedSearch() {
        this.returnCanvas().doSearch(this.getAlgorithm(), 102);
        this.stepButton.setEnabled(false);
        this.fineStepButton.setEnabled(false);
        this.autoSearchButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.selectButton.setEnabled(false);
        this.inspectNodeButton.setEnabled(false);
        this.quizButton.setEnabled(false);
        this.returnCanvas().step.setEnabled(false);
        this.returnCanvas().fineStep.setEnabled(false);
        this.returnCanvas().autoSearch.setEnabled(false);
        this.returnCanvas().stop.setEnabled(false);
        this.returnCanvas().quiz.setEnabled(false);
    }

    public void fineStep() {
        if (this.fineStepButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.fineStepButton, 0, "Fine Step"));
        }
    }

    public void step() {
        if (this.stepButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.stepButton, 0, "Step"));
        }
    }

    public void autoSearch() {
        if (this.autoSearchButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.autoSearchButton, 0, "Auto Search"));
        }
    }

    public void quiz() {
        if (this.quizButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.quizButton, 0, "Quiz"));
        }
    }

    public void autoscale() {
        this.actionPerformed(new ActionEvent(this.fakeButton, 0, "Autoscale"));
    }

    public void resetEdgeLabels() {
        this.actionPerformed(new ActionEvent(this.fakeButton, 0, "Reset Edge Labels"));
    }
}

