/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search;

import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.elements.Edge;
import CIspace.graphToolKit.elements.EdgeLabel;
import CIspace.graphToolKit.elements.Entity;
import CIspace.graphToolKit.elements.Point;
import CIspace.search.FrontierInfo;
import CIspace.search.InlineCanvas;
import CIspace.search.InlineSearchApplet;
import CIspace.search.SearchGraph;
import CIspace.search.SearchWindow;
import CIspace.search.dialogs.CostsHeuristicsDialog;
import CIspace.search.dialogs.EdgeDialog;
import CIspace.search.dialogs.NodeDialog;
import CIspace.search.dialogs.NodePathDialog;
import CIspace.search.dialogs.SearchTextFrame;
import CIspace.search.elements.SearchEdge;
import CIspace.search.elements.SearchNode;
import CIspace.search.searchTypes.Search;
import CIspace.search.searchTypes.SearchObject;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public class SearchCanvas
extends GraphCanvas {
    public static final int S_INSPECT_PATHS = 32465;
    public JMenuItem autoSearch;
    public JMenuItem fineStep;
    public JMenuItem invert;
    public JMenuItem quiz;
    public JMenuItem reset;
    public JMenuItem step;
    public JMenuItem stop;
    private EdgeDialog eDialog;
    private NodeDialog nDialog;
    private CostsHeuristicsDialog rDialog;
    private int lastStepSize;
    public int searchMethod;
    private boolean isQuizAnimating;
    private boolean isDisplayingHeuristics = false;
    private boolean isDisplayingCost = false;

    public SearchCanvas(Container parent, boolean inline) {
        super(parent, inline);
        this.graph = new SearchGraph(this, parent);
        this.lastStepSize = 102;
        this.solvePopUp();
        this.isQuizAnimating = false;
    }

    public void aPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Set as Start Node")) {
            this.setStartNode((SearchNode)this.entClicked);
            return;
        }
        if (arg.equals("Set as Goal Node")) {
            this.setGoalNode((SearchNode)this.entClicked);
            return;
        }
        if (arg.equals("Set as Regular Node")) {
            this.setRegularNode((SearchNode)this.entClicked);
            return;
        }
        if (arg.equals("Send to Back")) {
            ((SearchGraph)this.graph).sendToBack((SearchEdge)this.entClicked);
            return;
        }
        super.aPerformed(e);
    }

    public Search getSearchObject() {
        return ((SearchGraph)this.graph).getSearchObject();
    }

    public void setQuizAnimating(boolean isAnimating) {
        this.isQuizAnimating = isAnimating;
    }

    public boolean isQuizAnimating() {
        return this.isQuizAnimating;
    }

    public void setDisplayHeuristics(boolean display) {
        this.isDisplayingHeuristics = display;
    }

    public boolean isDisplayingHeuristics() {
        return this.isDisplayingHeuristics;
    }

    public void setDisplayCost(boolean display) {
        this.isDisplayingCost = display;
        Iterator<Edge> itr = this.graph.edges.iterator();
        while (itr.hasNext()) {
            ((SearchEdge)itr.next()).setDisplayCost(display);
        }
    }

    public boolean isDisplayingCost() {
        return this.isDisplayingCost;
    }

    public void changeFont(int size) {
        super.changeFont(size);
        ((SearchWindow)this.parent).setFontSize(this.font.getSize());
    }

    protected void createEdge(Entity ent, Point p) {
        if (this.makingEdge == 1) {
            if (ent == null || ent.type != 7770) {
                this.makingEdge = 0;
            } else if (ent.type == 7770) {
                this.to = (SearchNode)ent;
                SearchEdge edge = new SearchEdge((SearchGraph)this.graph, this.from, this.to);
                edge.updateLength();
                this.makingEdge = 2;
                this.pause();
                if (this.eDialog == null) {
                    this.eDialog = new EdgeDialog((JFrame)this.parent);
                }
                this.eDialog.open(edge);
                if (!this.eDialog.isCancelled()) {
                    this.graph.addEdge(edge);
                }
                this.unpause();
                this.makingEdge = 0;
            }
            if (this.tmpMode != -1) {
                this.submode = this.tmpMode;
            }
            this.tmpMode = -1;
        } else if (ent != null && ent.type == 7770) {
            this.from = (SearchNode)ent;
            this.makingEdge = 1;
            this.mMovedPos.move(p);
        }
    }

    protected void createNode(Entity ent, Point p) {
        if (ent == null || ent.type != 7770) {
            SearchNode node = new SearchNode((SearchGraph)this.graph);
            node.pos = p;
            this.pause();
            java.awt.Point screenp = new java.awt.Point((int)p.x, (int)p.y);
            SwingUtilities.convertPointToScreen(screenp, this);
            if (this.nDialog == null) {
                this.nDialog = new NodeDialog((JFrame)this.parent, (SearchGraph)this.graph);
            }
            this.nDialog.open(node, new Point(screenp.x, screenp.y));
            if (!this.nDialog.isCancelled) {
                this.graph.addNode(node);
            }
            this.unpause();
        }
    }

    protected void deleteEnt(Entity ent) {
        ((SearchWindow)this.parent).saveUndo();
        if (ent.type == 7770) {
            ArrayList graphnodes = ((SearchGraph)this.graph).nodes;
            int pos = graphnodes.indexOf(ent) + 1;
            if (!((SearchGraph)this.graph).goalNodes.remove(ent)) {
                ((SearchGraph)this.graph).startNodes.remove(ent);
            }
            int numnodes = graphnodes.size();
            int i = pos;
            while (i < numnodes) {
                SearchNode node = (SearchNode)graphnodes.get(i);
                node.setIndex(node.getIndex() - 1);
                node.getChildren().remove(node);
                ++i;
            }
        }
        super.deleteEnt(ent);
    }

    public void disposeWindows() {
        super.disposeWindows();
        if (this.nDialog != null) {
            this.nDialog.dispose();
        }
        if (this.eDialog != null) {
            this.eDialog.dispose();
        }
    }

    public void doSearch(int searchAlgorithm, int rate) {
        this.lastStepSize = rate;
        this.searchMethod = searchAlgorithm;
        ((SearchGraph)this.graph).doSearch(searchAlgorithm, rate);
        this.repaint();
    }

    public void greenify() {
        ArrayList<SearchNode> startNodes = ((SearchGraph)this.graph).getStartNodes();
        FrontierInfo fif = ((SearchGraph)this.graph).getFrontierInfo();
        if (fif != null) {
            fif.clear();
        }
        int i = 0;
        while (i < startNodes.size()) {
            SearchNode node = startNodes.get(i);
            node.setNodeAppearance(4);
            node.setNodeSearchType(4);
            ++i;
        }
        if (fif != null) {
            fif.showInitFrontier();
        }
        ((SearchGraph)this.graph).stepInit = true;
    }

    public void keyPressed(KeyEvent e) {
        int arg = e.getKeyCode();
        if ((arg == 32 || arg == 10 || arg == 83) && this.mode == 2221) {
            this.doSearch(this.searchMethod, this.lastStepSize);
        } else if (arg == 127) {
            ((SearchGraph)this.graph).deleteSelectedEntities();
            return;
        }
        super.keyPressed(e);
    }

    public void mouseDragged(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        this.mDraggedPos.move(p);
        Entity entClicked = this.graph.searchEntities(p);
        if (this.mode == 2220) {
            super.mouseDragged(e);
        } else if (this.mode == 2221) {
            if (e.getModifiers() == 4) {
                super.mouseDragged(e);
            } else if (this.submode == 3335 && entClicked == this.tempEnt) {
                this.mDraggedSelect();
            } else if (this.submode == 3335 && entClicked != this.tempEnt) {
                this.submode = this.tempMode;
            } else if (this.submode == 3332) {
                this.mDraggedSelect();
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        if (this.mode == 2220) {
            if (ent == null || ent.type != 7770) {
                return;
            }
        } else if (this.mode == 2221) {
            Search tmpSearch = ((SearchGraph)this.graph).getSearchObject();
            if (!(tmpSearch == null || this.isQuizAnimating() || this.searchMethod != 209 && ((SearchGraph)this.graph).getSearchRate() != 104)) {
                if (ent == null || ent.type != 7770) {
                    return;
                }
                this.repaint();
                tmpSearch.setSelectedNode((SearchNode)ent);
                tmpSearch.step();
            } else if (this.submode == 3332 && e.getModifiers() != 4) {
                this.mPressedSelect(ent, e.isControlDown() || e.isShiftDown());
            } else if (ent != null && ent instanceof SearchNode && this.submode == 32465) {
                ArrayList<SearchObject> paths = new ArrayList<SearchObject>(5);
                Search curSearch = ((SearchGraph)this.graph).getSearchObject();
                int selectedNodeIndex = ((SearchNode)ent).getIndex();
                if (curSearch != null) {
                    for (SearchObject curObject : curSearch.getFrontier(((SearchNode)ent).getNodeSearchType() != 6)) {
                        if (!curObject.checkNodeOnPath(selectedNodeIndex)) continue;
                        paths.add(curObject);
                    }
                } else if (((SearchNode)ent).getNodeType() == 1) {
                    paths.add(new SearchObject(-1, selectedNodeIndex, new ArrayList<Integer[]>(), (SearchGraph)this.graph));
                }
                new NodePathDialog(this.parent, ((SearchNode)ent).getLabel(), paths);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (e.getModifiers() == 4) {
            return;
        }
        if (this.mode == 2220) {
            if (((SearchGraph)this.graph).getUseNodeDistance() && this.isDisplayingHeuristics()) {
                this.repaint();
            }
        } else if (this.mode == 2221 && ((SearchGraph)this.graph).getSearchObject() != null) {
            this.repaint();
        }
    }

    public String parse(String str) {
        this.resetSearch();
        String errMsg = ((SearchGraph)this.graph).parse(str);
        if (errMsg.equals("OK")) {
            this.repaint();
        }
        return errMsg;
    }

    public String parseXML(String str) {
        this.resetSearch();
        String errMsg = ((SearchGraph)this.graph).updateGraphFromXML(str);
        if (errMsg.equals("OK")) {
            this.repaint();
        }
        return errMsg;
    }

    public void pause() {
        super.pause();
        Search search = ((SearchGraph)this.graph).getSearchObject();
        if (search != null) {
            search.pauseAuto(true);
        }
    }

    protected void popupCanvas(int x, int y) {
        JRadioButtonMenuItem pan;
        JRadioButtonMenuItem zoom;
        JMenuItem mItem;
        this.pop.removeAll();
        if (this.mode == 2220) {
            this.pop.setBorder(BorderFactory.createTitledBorder("Create Options"));
            mItem = new JMenuItem("Create Node");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.invert = new JMenuItem("Invert Graph");
            this.invert.addActionListener((SearchWindow)this.parent);
            this.pop.add(this.invert);
        } else {
            this.pop.setBorder(BorderFactory.createTitledBorder("Solve Options"));
            if (this.inline) {
                ((InlineCanvas)this).addMenuItems();
            }
            this.pop.add(this.fineStep);
            this.pop.add(this.step);
            this.pop.add(this.autoSearch);
            this.pop.add(this.stop);
            this.pop.add(this.reset);
            this.pop.add(this.quiz);
        }
        this.pop.addSeparator();
        this.pop.add(new JLabel("View Options"));
        mItem = new JMenuItem("Autoscale");
        mItem.addActionListener(this);
        this.pop.add(mItem);
        JMenu zp = new JMenu("Pan/Zoom");
        ButtonGroup zpGroup = new ButtonGroup();
        if (this.getRMode() == 4441) {
            zoom = new JRadioButtonMenuItem("Zoom", true);
            pan = new JRadioButtonMenuItem("Pan", false);
        } else {
            zoom = new JRadioButtonMenuItem("Zoom", false);
            pan = new JRadioButtonMenuItem("Pan", true);
        }
        zoom.setToolTipText("Zoom into certain area of graph");
        zoom.addActionListener(this);
        zpGroup.add(zoom);
        zp.add(zoom);
        pan.setToolTipText("Pan the graph to a different area on the canvas");
        pan.addActionListener(this);
        zp.add(pan);
        zpGroup.add(pan);
        this.pop.add(zp);
        if (this.isDisplayingCost()) {
            mItem = new JMenuItem("Reset Edge Labels");
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        if (this.inline && ((InlineSearchApplet)this.parent).textRepresentationPopupOn) {
            this.pop.addSeparator();
            JMenuItem repItem = new JMenuItem("View Prolog Code");
            repItem.setActionCommand(repItem.getText());
            repItem.addActionListener((InlineSearchApplet)this.parent);
            this.pop.add(repItem);
            repItem = new JMenuItem("View Text Representation");
            repItem.setActionCommand(repItem.getText());
            repItem.addActionListener((InlineSearchApplet)this.parent);
            this.pop.add(repItem);
            repItem = new JMenuItem("View XML Representation");
            repItem.setActionCommand(repItem.getText());
            repItem.addActionListener((InlineSearchApplet)this.parent);
            this.pop.add(repItem);
        }
        this.pop.show(this, x, y);
    }

    protected void popupEdge(int x, int y) {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Edge Options"));
        if (this.mode == 2220) {
            JMenuItem mItem = new JMenuItem("Set Properties of Edge");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Send to Back");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            if (this.isDisplayingCost()) {
                mItem = new JMenuItem("Reset Edge Label");
                mItem.addActionListener(this);
                this.pop.add(mItem);
            }
            mItem = new JMenuItem("Delete Edge");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.show(this, x, y);
        } else {
            this.graph.deselectAll();
        }
    }

    protected void popupNode(int x, int y) {
        this.pop.setBorder(BorderFactory.createTitledBorder("Node Options"));
        this.pop.removeAll();
        if (this.mode == 2220) {
            JMenuItem mItem = new JMenuItem("Create Edge");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Set Properties of Node");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Delete Node");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.addSeparator();
            mItem = new JMenuItem("Set as Start Node");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Set as Goal Node");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Set as Regular Node");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.show(this, x, y);
        } else {
            this.graph.deselectAll();
        }
    }

    public void reset() {
        ((SearchGraph)this.graph).goalNodes = new ArrayList(5);
        ((SearchGraph)this.graph).startNodes = new ArrayList(5);
        this.graph.nodes = new ArrayList();
        this.graph.edges = new ArrayList();
        this.resetSearch();
    }

    public void resetCosts() {
        this.pause();
        if (this.rDialog == null) {
            this.rDialog = new CostsHeuristicsDialog((JFrame)this.parent, (SearchGraph)this.graph);
        } else {
            this.rDialog.open();
        }
        if (!this.rDialog.isCancelled()) {
            this.setHeuristics(this.rDialog);
            this.setCosts(this.rDialog);
        }
        this.unpause();
    }

    public void resetSearch() {
        ((SearchGraph)this.graph).resetSearch();
        this.repaint();
    }

    public void setCosts(CostsHeuristicsDialog rDialog) {
        if (rDialog.getCostState()) {
            Iterator<Edge> itr = this.graph.getEdges();
            double value = Double.parseDouble(rDialog.getValue());
            while (itr.hasNext()) {
                SearchEdge tmpEdge = (SearchEdge)itr.next();
                if (rDialog.getAddState()) {
                    tmpEdge.setCost(tmpEdge.getCost() + value);
                    continue;
                }
                tmpEdge.setCost(tmpEdge.getCost() * value);
            }
        }
    }

    public void setEnabled() {
        this.pop.getComponent(0).setFocusable(false);
        this.pop.getComponent(1).setEnabled(false);
        this.pop.getComponent(3).setEnabled(true);
        this.pop.getComponent(5).setEnabled(false);
        this.pop.getComponent(6).setEnabled(false);
    }

    protected void setEntProperties(Entity ent) {
        this.pause();
        switch (ent.type) {
            case 7770: {
                java.awt.Point screenp = new java.awt.Point((int)((SearchNode)ent).pos.x, (int)((SearchNode)ent).pos.y);
                SwingUtilities.convertPointToScreen(screenp, this);
                if (this.nDialog == null) {
                    this.nDialog = new NodeDialog((JFrame)this.parent, (SearchGraph)this.graph);
                }
                this.nDialog.open((SearchNode)ent, new Point(screenp.x, screenp.y));
                break;
            }
            case 7771: {
                if (this.eDialog == null) {
                    this.eDialog = new EdgeDialog((JFrame)this.parent);
                }
                this.eDialog.open((SearchEdge)ent);
                break;
            }
            case 7772: {
                ent = ((EdgeLabel)ent).parent;
                if (this.eDialog == null) {
                    this.eDialog = new EdgeDialog((JFrame)this.parent);
                }
                this.eDialog.open((SearchEdge)ent);
            }
        }
        this.unpause();
    }

    private void setHeuristics(CostsHeuristicsDialog rDialog) {
        double value = Double.parseDouble(rDialog.getValue());
        if (!rDialog.getHeuristicsState()) {
            return;
        }
        int i = 0;
        while (i < this.graph.numNodes()) {
            SearchNode curr = (SearchNode)this.graph.nodeAt(i);
            if (curr != null) {
                if (rDialog.getAddState()) {
                    curr.setHeuristics(curr.getNodeHeuristics() + value);
                } else {
                    curr.setHeuristics(curr.getNodeHeuristics() * value);
                }
                curr.updateSize();
            }
            ++i;
        }
    }

    public void setMode(int newMode) {
        this.mode = newMode;
        this.clearMouse();
        this.graph.deselectAll();
        this.resetSearch();
        this.repaint();
    }

    public void setPathArea(String s) {
        if (!this.inline) {
            ((SearchWindow)this.parent).setPathArea(s);
        } else {
            ((InlineSearchApplet)this.parent).setPathArea(s);
        }
    }

    public void setIsAutoSearchingOptions(boolean isEnabled) {
        if (!this.inline) {
            ((SearchWindow)this.parent).setIsAutoSearchingOptions(isEnabled);
        } else {
            ((InlineSearchApplet)this.parent).setIsAutoSearchingOptions(isEnabled);
        }
    }

    protected void setRegularNode(SearchNode node) {
        ((SearchGraph)this.graph).setAsRegularNode(node);
        this.graph.updateNodeSize(node);
    }

    protected void setStartNode(SearchNode node) {
        ((SearchGraph)this.graph).setAsStartNode(node);
        this.graph.updateNodeSize(node);
    }

    protected void setGoalNode(SearchNode node) {
        ((SearchGraph)this.graph).setAsGoalNode(node);
        this.graph.updateNodeSize(node);
    }

    public void solvePopUp() {
        this.step = new JMenuItem("Step");
        this.step.addActionListener((SearchWindow)this.parent);
        this.fineStep = new JMenuItem("Fine Step");
        this.fineStep.addActionListener((SearchWindow)this.parent);
        this.autoSearch = new JMenuItem("Auto Search");
        this.autoSearch.addActionListener((SearchWindow)this.parent);
        this.stop = new JMenuItem("Stop Search");
        this.stop.addActionListener((SearchWindow)this.parent);
        this.stop.setEnabled(false);
        this.quiz = new JMenuItem("Quiz");
        this.quiz.addActionListener((SearchWindow)this.parent);
        this.reset = new JMenuItem("Reset Search");
        this.reset.addActionListener((SearchWindow)this.parent);
    }

    public void textRep(boolean modify) {
        new SearchTextFrame(this, ((SearchGraph)this.graph).generateTextRep(), "Text Representation of the Graph", 9830, modify);
    }

    public void prologRep() {
        new SearchTextFrame(this, ((SearchGraph)this.graph).generatePrologTextRep(), "Prolog Code for the Graph", 9831, false);
    }

    public void XMLRep(boolean modify) {
        new SearchTextFrame(this, ((SearchGraph)this.graph).generateXMLTextRep(), "XML Text Representation of the Graph", 9832, modify);
    }

    public void unpause() {
        super.unpause();
        Search search = ((SearchGraph)this.graph).getSearchObject();
        if (search != null) {
            search.pauseAuto(false);
        }
    }

    public boolean updateGraphFromText(String allText, boolean isXML) {
        ((SearchWindow)this.parent).saveUndo();
        this.setDisplayCost(this.searchMethod == 206 || this.searchMethod == 203);
        this.setDisplayHeuristics(this.searchMethod == 204 || this.searchMethod == 206 || this.searchMethod == 205);
        String errMessage = isXML ? ((SearchGraph)this.graph).updateGraphFromXML(allText) : ((SearchGraph)this.graph).updateGraphFromText(allText);
        if (errMessage.equals("OK")) {
            this.repaint();
            return true;
        }
        this.showMessage("Error", errMessage);
        ((SearchWindow)this.parent).loadUndo();
        return false;
    }
}

