/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search.dialogs;

import CIspace.graphToolKit.dialogs.BasicDialog;
import CIspace.graphToolKit.elements.Edge;
import CIspace.search.SearchGraph;
import CIspace.search.elements.SearchEdge;
import CIspace.search.elements.SearchNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CostsHeuristicsDialog
extends BasicDialog {
    private JLabel labelError;
    private SearchGraph graph;
    private JCheckBox heuristics;
    private JCheckBox cost;
    private JRadioButton add;
    private JRadioButton multiply;
    private JTextField amountField;
    private String value;
    private boolean isCancelled = true;

    public CostsHeuristicsDialog(JFrame parent, SearchGraph graph) {
        super(parent, "Set Costs and Heuristics", true);
        this.graph = graph;
        this.amountField = new JTextField(7);
        this.labelError = new JLabel("");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(5, 2));
        panel.add(new JLabel("Choose to set: "));
        JPanel choosePanel = new JPanel(new BorderLayout());
        this.heuristics = new JCheckBox("Heuristics");
        choosePanel.add((Component)this.heuristics, "West");
        this.cost = new JCheckBox("Edge Costs");
        choosePanel.add((Component)this.cost, "East");
        panel.add(choosePanel);
        panel.add(new JLabel("Choose operation: "));
        JPanel operationPanel = new JPanel(new BorderLayout());
        ButtonGroup operationGroup = new ButtonGroup();
        this.multiply = new JRadioButton("Multiply", false);
        operationPanel.add((Component)this.multiply, "West");
        operationGroup.add(this.multiply);
        this.add = new JRadioButton("Add ", true);
        operationPanel.add((Component)this.add, "East");
        operationGroup.add(this.add);
        panel.add(operationPanel);
        panel.add(new JLabel("Value: "));
        panel.add(this.amountField);
        panel.add(new JLabel("*/+ to current heuristics/edges. "));
        panel.add(new JLabel("Example: -2.6 or 10.0"));
        JButton button = new JButton("OK");
        button.addActionListener(this);
        button.setActionCommand(button.getText());
        this.getRootPane().setDefaultButton(button);
        panel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(this);
        button.setActionCommand(button.getText());
        panel.add(button);
        this.getContentPane().add(panel);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    public void open() {
        this.isCancelled = true;
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    public boolean getHeuristicsState() {
        return this.heuristics.isSelected();
    }

    public boolean getCostState() {
        return this.cost.isSelected();
    }

    public boolean getAddState() {
        return this.add.isSelected();
    }

    public boolean getMultiplyState() {
        return this.multiply.isSelected();
    }

    public String getValue() {
        return this.value;
    }

    public boolean setProperties() {
        block3: {
            try {
                if (!(this.checkValidHeuristics() & this.checkValidEdge())) break block3;
                return true;
            }
            catch (NumberFormatException e) {
                this.labelError.setText("Error: Invalid Heuristics value! (Non-numeric or sets value to < 0)");
                return false;
            }
        }
        JOptionPane.showMessageDialog(this.getParent(), "This value modifies a heuristics or edge value to less than 0");
        return false;
    }

    public boolean checkValidEdge() {
        this.value = this.amountField.getText();
        if (this.getCostState()) {
            double value = Double.parseDouble(this.getValue());
            Iterator<Edge> itr = this.graph.getEdges();
            while (itr.hasNext()) {
                SearchEdge tmpEdge = (SearchEdge)itr.next();
                if (!(this.getAddState() ? tmpEdge.getCost() + value < 0.0 : tmpEdge.getCost() * value < 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkValidHeuristics() {
        double value = Double.parseDouble(this.amountField.getText());
        this.value = this.amountField.getText();
        if (this.getHeuristicsState()) {
            int i = 0;
            while (i < this.graph.numNodes()) {
                SearchNode curr = (SearchNode)this.graph.nodeAt(i);
                if (curr != null && (this.getAddState() ? curr.getNodeHeuristics() + value < 0.0 : curr.getNodeHeuristics() * value < 0.0)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    protected boolean actionOK() {
        if (this.setProperties()) {
            this.isCancelled = false;
            return true;
        }
        return false;
    }

    protected boolean actionCancel() {
        return true;
    }
}

