/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search.dialogs;

import CIspace.graphToolKit.dialogs.BasicDialog;
import CIspace.search.SearchWindow;
import CIspace.search.elements.SearchEdge;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EdgeDialog
extends BasicDialog
implements TextListener {
    private JTextField textEdgeCost = new JTextField("", 20);
    private JLabel labelError;
    private SearchEdge edge;
    private boolean isCancelled;

    public EdgeDialog(JFrame parent) {
        super(parent, "Edge Properties", true);
        this.textEdgeCost.addActionListener(this);
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(this);
        this.getRootPane().setDefaultButton(buttonOk);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(this);
        this.labelError = new JLabel("");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        panel.add(new JLabel("Edge cost:"));
        panel.add(this.textEdgeCost);
        panel.add(buttonOk);
        panel.add(buttonCancel);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.labelError, "South");
        this.pack();
    }

    public void open(SearchEdge e) {
        this.isCancelled = true;
        this.edge = e;
        this.textEdgeCost.setText(String.valueOf(this.edge.getCost()));
        this.centerWindow();
        this.setVisible(true);
    }

    public boolean setProperties() {
        try {
            ((SearchWindow)this.getParent()).saveUndo();
            this.edge.updateProperties(Double.parseDouble(this.textEdgeCost.getText()));
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Invalid real number format!");
            return false;
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    protected boolean actionOK() {
        if (this.setProperties()) {
            this.isCancelled = false;
            return true;
        }
        return false;
    }

    protected boolean actionCancel() {
        return true;
    }

    public void textValueChanged(TextEvent e) {
        if (e.getSource().equals(this.textEdgeCost)) {
            this.labelError.setText("");
        }
    }
}

