/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search.dialogs;

import CIspace.graphToolKit.GraphWindow;
import CIspace.graphToolKit.dialogs.BasicDialog;
import CIspace.search.FrontierInfo;
import CIspace.search.InlineSearchApplet;
import CIspace.search.SearchWindow;
import CIspace.search.searchTypes.SearchObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSearchPathSelectDialog
extends BasicDialog {
    protected JList pathList;
    protected Font font;

    public UserSearchPathSelectDialog(Container parent, ArrayList<SearchObject> pathObjects) {
        this(parent, "Select Path to Extend", pathObjects);
    }

    public UserSearchPathSelectDialog(Container parent, String title, ArrayList<SearchObject> pathObjects) {
        super((JFrame)null, title, true);
        if (parent instanceof SearchWindow) {
            this.font = new Font("arial", 1, ((GraphWindow)parent).returnCanvas().getFontSize());
        }
        JButton ok_button = new JButton("OK");
        ok_button.setActionCommand(ok_button.getText());
        ok_button.setFont(this.font);
        ok_button.addActionListener(this);
        this.getRootPane().setDefaultButton(ok_button);
        DefaultListModel<String> pathListModel = new DefaultListModel<String>();
        pathListModel.setSize(pathObjects.size());
        this.pathList = new JList(pathListModel);
        this.pathList.setSelectionMode(0);
        this.pathList.setCellRenderer(new ListRenderer());
        pathListModel.removeAllElements();
        if (pathObjects == null || pathObjects.size() == 0) {
            pathListModel.addElement("No paths for this node.");
        } else {
            Iterator<SearchObject> itr = pathObjects.iterator();
            FrontierInfo pathInfo = parent instanceof SearchWindow ? new FrontierInfo((SearchWindow)parent) : new FrontierInfo((InlineSearchApplet)parent);
            while (itr.hasNext()) {
                pathListModel.addElement(pathInfo.getPathString(itr.next().getPath()));
            }
        }
        this.pathList.setSelectedIndex(0);
        this.getContentPane().add((Component)this.pathList, "Center");
        this.getContentPane().add((Component)ok_button, "South");
    }

    public void open() {
        this.pack();
        if (this.getWidth() < 200) {
            this.setSize(200, this.getHeight());
        }
        this.centerWindow();
        this.setVisible(true);
    }

    public int getSelectedPathIndex() {
        return this.pathList.getSelectedIndex();
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    protected boolean actionOK() {
        return true;
    }

    protected class ListRenderer
    extends JLabel
    implements ListCellRenderer {
        public ListRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.setFont(UserSearchPathSelectDialog.this.font);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }
}

