/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search.searchTypes;

import CIspace.search.SearchGraph;
import CIspace.search.elements.SearchNode;
import CIspace.search.searchTypes.Search;
import CIspace.search.searchTypes.SearchObject;
import java.util.ArrayList;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AStar
extends Search {
    public AStar() {
    }

    public AStar(SearchGraph sg) {
        super(sg);
    }

    @Override
    protected void mergeWithFrontier(ArrayList<SearchObject> ch) {
        TreeMap<Integer, SearchObject> nodeMap = new TreeMap<Integer, SearchObject>();
        int i = 0;
        while (i < ch.size()) {
            SearchObject nextObject = ch.get(i);
            SearchNode nextNode = (SearchNode)this.graph.nodeFromIndex(nextObject.getToNode());
            int position = this.frontier.size() - 1;
            while (position >= 0) {
                SearchObject curObject = (SearchObject)this.frontier.get(position);
                SearchNode tmpNode = (SearchNode)this.graph.nodeFromIndex(curObject.getToNode());
                if (nextNode.getHeuristics() + nextObject.getPathCost() >= tmpNode.getHeuristics() + curObject.getPathCost()) break;
                --position;
            }
            nodeMap.put(new Integer(position + 1), nextObject);
            this.frontier.add(position + 1, nextObject);
            ++i;
        }
        this.fillAnimateFrontier(nodeMap);
    }

    @Override
    protected int getStartIndex() {
        int currIndex = -1;
        double smallestHeur = 9.99999999E8;
        int i = 0;
        while (i < this.startNodeIndex.size()) {
            double currHeur = ((SearchNode)this.startNodeIndex.get(i)).getHeuristics();
            if (currHeur < smallestHeur) {
                smallestHeur = currHeur;
                currIndex = ((SearchNode)this.startNodeIndex.get(i)).getIndex();
            }
            ++i;
        }
        return currIndex;
    }
}

