/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search.searchTypes;

import CIspace.graphToolKit.elements.Edge;
import CIspace.search.InlineSearchApplet;
import CIspace.search.SearchCanvas;
import CIspace.search.SearchGraph;
import CIspace.search.SearchQuizAnimator;
import CIspace.search.SearchWindow;
import CIspace.search.elements.SearchEdge;
import CIspace.search.elements.SearchNode;
import CIspace.search.searchTypes.AutoSearch;
import CIspace.search.searchTypes.SearchObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Search {
    public static final int SEARCH_AUTO = 101;
    public static final int SEARCH_STEP = 102;
    public static final int SEARCH_FINE = 103;
    public static final int SEARCH_QUIZ = 104;
    public static final int DEPTH_FIRST = 201;
    public static final int BREADTH_FIRST = 202;
    public static final int LOWEST_COST_FIRST = 203;
    public static final int BEST_FIRST = 204;
    public static final int HEURISTIC_DEPTH_FIRST = 205;
    public static final int A_STAR = 206;
    public static final int USER_DEFINED = 209;
    public static final int MULT_PATH_PRUNING = 301;
    public static final int LOOP_DETECTION = 302;
    public static final int NO_PRUNING = 303;
    protected SearchGraph graph;
    protected ArrayList<SearchObject> frontier;
    protected ArrayList<SearchObject> quizResultFrontier;
    protected ArrayList<SearchObject> quizAnimateFrontier;
    protected ArrayList<Integer> shorterFrontier;
    protected ArrayList<SearchObject> neighbours;
    protected ArrayList<SearchNode> startNodeIndex;
    protected ArrayList<SearchNode> goalNodeIndex;
    protected int searchRate;
    protected SearchObject currObject;
    protected SearchObject previousObject;
    protected int currentStep;
    protected int nodeCount;
    protected boolean showAnswers;
    protected boolean quizzed;
    protected boolean firstAnswerCorrect;
    protected String pathString;
    protected int pruning;
    protected ArrayList<Integer> nodesVisited;
    protected int previousIndex;
    protected SearchNode selectedNode;
    protected boolean goalReached;
    protected AutoSearch auto;
    public static int animationSpeed = 100;
    protected ArrayList<SearchObject> backup;
    protected ArrayList<SearchObject> oldFrontier;
    protected ArrayList<SearchObject> oldNeighbours;
    protected SearchObject oldCurrObject;
    protected SearchQuizAnimator quizAnimate;

    public Search() {
        this.graph = null;
        this.frontier = new ArrayList(5);
        this.shorterFrontier = new ArrayList(5);
        this.neighbours = new ArrayList(5);
        this.startNodeIndex = new ArrayList(5);
        this.goalNodeIndex = new ArrayList(5);
        this.currObject = null;
        this.currentStep = 0;
        this.quizzed = false;
        this.firstAnswerCorrect = false;
        this.previousObject = null;
        this.nodeCount = 1;
        this.pathString = new String("");
        this.nodesVisited = new ArrayList(5);
        this.previousIndex = -1;
        this.goalReached = false;
        this.showAnswers = false;
    }

    public Search(SearchGraph sg) {
        this.graph = sg;
        this.frontier = new ArrayList(5);
        this.shorterFrontier = new ArrayList(5);
        this.neighbours = new ArrayList(5);
        this.nodesVisited = new ArrayList(5);
        this.startNodeIndex = new ArrayList<SearchNode>(sg.getStartNodes());
        this.goalNodeIndex = new ArrayList<SearchNode>(sg.getGoalNodes());
        this.currObject = null;
        this.previousObject = null;
        this.searchRate = sg.getSearchRate();
        this.pruning = sg.getPruning();
        this.currentStep = 0;
        this.showAnswers = false;
        this.goalReached = false;
        this.firstAnswerCorrect = false;
        this.quizzed = false;
        this.nodeCount = 1;
        this.pathString = new String("");
        this.previousIndex = -1;
        this.quizAnimateFrontier = new ArrayList();
        this.stepInit();
    }

    public void setSelectedNode(SearchNode node) {
        this.selectedNode = node;
    }

    public void repaint() {
        this.graph.repaint();
    }

    protected void stepInit() {
        if (this.startNodeIndex.size() > 0) {
            int currIndex = this.getStartIndex();
            SearchNode currNode = (SearchNode)this.graph.nodeFromIndex(currIndex);
            currNode.setSearchOrder(1);
            currNode.setSearchOrderDisplayed(true);
            currNode.setPathFound(true);
            this.nodesVisited.add(new Integer(currIndex));
            if (this.searchRate == 102 || this.searchRate == 103 || this.searchRate == 101) {
                currNode.setNodeAppearance(3);
            } else if (this.searchRate == 104) {
                currNode.setNodeAppearance(4);
            }
            ArrayList<SearchObject> startNodes = new ArrayList<SearchObject>(5);
            int i = 0;
            while (i < this.startNodeIndex.size()) {
                int nextStart = this.graph.nodes.indexOf(this.startNodeIndex.get(i));
                this.shorterFrontier.add(new Integer(nextStart));
                boolean condition = false;
                if (this.pruning == 303) {
                    condition = true;
                } else if (this.pruning == 301) {
                    condition = true;
                } else if (!(this.pruning != 302 || this.currObject != null && this.currObject.checkNodeOnPath(nextStart))) {
                    condition = true;
                }
                if (condition) {
                    startNodes.add(new SearchObject(-1, nextStart, null, this.graph));
                }
                ++i;
            }
            this.mergeWithFrontier(startNodes);
            this.paintNodes(this.frontier, 4);
            ArrayList<SearchNode> children = new ArrayList<SearchNode>(((SearchNode)this.graph.nodeFromIndex(currIndex)).getChildren());
            int numNeigh = children.size();
            int i2 = 0;
            while (i2 < numNeigh) {
                int nextNeigh = children.get(0).getIndex();
                boolean condition = false;
                if (this.pruning == 303) {
                    condition = true;
                } else if (this.pruning == 301) {
                    condition = true;
                } else if (!(this.pruning != 302 || this.currObject != null && this.currObject.checkNodeOnPath(nextNeigh))) {
                    condition = true;
                }
                if (condition) {
                    this.neighbours.add(new SearchObject(currNode.getIndex(), nextNeigh, null, this.graph));
                }
                children.remove(0);
                ++i2;
            }
            if (this.searchRate == 104) {
                this.graph.setPromptColor(Color.green);
                this.graph.setPromptLabel(" Click on the first node on the frontier (the frontier nodes are green)");
            } else {
                this.stepOne();
                if (this.searchRate == 102) {
                    this.doSearchFine();
                    this.doSearchFine();
                }
            }
            String tmpLabel = currNode.getPredicateLabel();
            if (tmpLabel.equals("")) {
                tmpLabel = new String("Node " + currNode.getIndex());
            }
            this.graph.setPathArea(tmpLabel);
        }
    }

    public void step() {
        switch (this.searchRate) {
            case 102: {
                this.doSearchStep();
                break;
            }
            case 103: {
                this.doSearchFine();
                break;
            }
            case 101: {
                this.startAutoSearch();
                break;
            }
            case 104: {
                this.doSearchQuiz();
                break;
            }
            default: {
                System.out.println("Error in Search " + this.searchRate);
            }
        }
    }

    public boolean isPathCurrent() {
        return this.currentStep != 1;
    }

    public void showPath(SearchObject currObj) {
        if (currObj != null) {
            String tmpLabel;
            SearchNode tmpNode;
            ArrayList<Integer[]> path = currObj.getPath();
            this.pathString = "";
            int i = 0;
            while (i < path.size()) {
                if (path.get(i)[0] != -1) {
                    tmpNode = (SearchNode)this.graph.nodeFromIndex(path.get(i)[0]);
                    tmpLabel = tmpNode.getPredicateLabel();
                    if (tmpLabel.equals("")) {
                        tmpLabel = new String("Node " + tmpNode.index);
                    }
                    this.pathString = String.valueOf(this.pathString) + tmpLabel + " --> ";
                }
                ++i;
            }
            tmpNode = (SearchNode)this.graph.nodeFromIndex(path.get(path.size() - 1)[1]);
            tmpLabel = tmpNode.getPredicateLabel();
            if (tmpLabel.equals("")) {
                tmpLabel = new String("Node " + tmpNode.getIndex());
            }
            if (this.goalNodeIndex.contains(tmpNode)) {
                tmpLabel = String.valueOf(tmpLabel) + " (Goal)";
            }
            this.pathString = String.valueOf(this.pathString) + tmpLabel;
            this.graph.setPathArea(this.pathString);
        }
    }

    public String getPathString() {
        return this.pathString;
    }

    public SearchGraph getGraph() {
        return this.graph;
    }

    public String getPathString(SearchObject o) {
        String p = new String("");
        if (o != null) {
            String tmpLabel;
            SearchNode tmpNode;
            ArrayList<Integer[]> path = o.getPath();
            p = "";
            int i = 0;
            while (i < path.size()) {
                if (path.get(i)[0] != -1) {
                    tmpNode = (SearchNode)this.graph.nodeFromIndex(path.get(i)[0]);
                    tmpLabel = tmpNode.getPredicateLabel();
                    if (tmpLabel.equals("")) {
                        tmpLabel = new String("Node " + tmpNode.index);
                    }
                    p = String.valueOf(p) + tmpLabel + " --> ";
                }
                ++i;
            }
            tmpNode = (SearchNode)this.graph.nodeFromIndex(path.get(path.size() - 1)[1]);
            tmpLabel = tmpNode.getPredicateLabel();
            if (tmpLabel.equals("")) {
                tmpLabel = new String("Node " + tmpNode.getIndex());
            }
            if (this.goalNodeIndex.contains(tmpNode)) {
                tmpLabel = String.valueOf(tmpLabel) + " (Goal)";
            }
            p = String.valueOf(p) + tmpLabel;
        }
        return p;
    }

    public void setShowAnswers(boolean show) {
        this.showAnswers = show;
    }

    public boolean getShowAnswers() {
        return this.showAnswers;
    }

    protected void doSearchStep() {
        if (this.previousObject != null) {
            this.currObject = this.previousObject.clone();
        }
        this.doSearchFine();
        while (this.currentStep != 1) {
            this.doSearchFine();
        }
    }

    protected void doSearchFine() {
        switch (this.currentStep) {
            case 0: {
                if (this.neighbours.size() > 0) {
                    this.paintNodes(this.neighbours, 5);
                    String s = "Path " + this.pathString + " extended by one step.\nNeighbours of " + ((SearchNode)this.graph.nodes.get(this.currObject.getToNode())).getLabel() + ":  ";
                    int numneighbours = this.neighbours.size();
                    int i = 0;
                    while (i < numneighbours) {
                        s = i + 1 < numneighbours ? String.valueOf(s) + ((SearchNode)this.graph.nodes.get(this.neighbours.get(i).getToNode())).getLabel() + ", " : String.valueOf(s) + ((SearchNode)this.graph.nodes.get(this.neighbours.get(i).getToNode())).getLabel();
                        ++i;
                    }
                    this.graph.setPromptLabel(s);
                }
                this.backup = new ArrayList<SearchObject>(this.frontier);
                this.currentStep = 3;
                break;
            }
            case 1: {
                this.resetPrevious(this.currObject);
                this.resetEdges();
                this.stepOne();
                this.currentStep = 2;
                break;
            }
            case 2: {
                this.stepTwo();
                this.currentStep = 3;
                break;
            }
            case 3: {
                this.stepThree();
                this.currentStep = 1;
                break;
            }
            default: {
                System.out.println("error");
            }
        }
    }

    public void reset() {
        this.resetAutoSearch();
        this.resetNodes(true);
        this.resetEdges();
    }

    private void resetAutoSearch() {
        this.stopAutoSearch();
        this.auto = null;
    }

    public void startAutoSearch() {
        this.auto = new AutoSearch(this, animationSpeed);
        this.auto.start();
    }

    public void stopAutoSearch() {
        if (this.auto == null) {
            return;
        }
        if (this.auto.isAlive()) {
            this.auto.quit();
        }
    }

    public void pauseAuto(boolean pause) {
        if (this.auto == null) {
            return;
        }
        this.auto.isPaused = pause;
    }

    public boolean autoSearchContinue(int count) {
        if (count == 0) {
            return true;
        }
        if (this.frontier.size() <= 0 && this.currObject == null) {
            return false;
        }
        if (count >= this.graph.getMaxNumSteps()) {
            this.graph.showMessage("Search Incomplete", "Auto Search incomplete after " + this.graph.getMaxNumSteps() + " steps.");
            return false;
        }
        return !this.graph.getStopAtGoal() || !this.goalReached;
    }

    public void autoSearchStep() {
        if (this.previousObject != null) {
            this.currObject = this.previousObject.clone();
        }
        this.doSearchFine();
        if (this.graph.getFrontierInfo() != null) {
            this.graph.getFrontierInfo().setFrontier(false);
        }
    }

    public void autoSearchEnd() {
        this.goalReached = false;
        this.stopAutoSearch();
        if (this.graph.canvas.inline) {
            ((InlineSearchApplet)this.graph.getWindow()).stopSearch();
        } else {
            ((SearchWindow)this.graph.getWindow()).stopSearch();
        }
    }

    protected void doSearchQuiz() {
        if (this.frontier.size() == 0 && this.currObject == null && this.firstAnswerCorrect) {
            this.resetPrevious(this.currObject);
            this.resetEdges();
            this.graph.setPromptLabel("Search completed.\nClick on the Reset Search button to reset the graph.");
            return;
        }
        this.quizzed = true;
        this.currentStep = 2;
        this.oldFrontier = new ArrayList<SearchObject>(this.frontier);
        this.oldNeighbours = new ArrayList<SearchObject>(this.neighbours);
        this.oldCurrObject = null;
        if (this.currObject != null) {
            this.oldCurrObject = this.currObject.clone();
        }
        if (this.selectedNode != null) {
            int selectedIndex = this.selectedNode.getIndex();
            if (this.firstAnswerCorrect) {
                this.stepTwo();
                this.oldFrontier = new ArrayList<SearchObject>(this.frontier);
                this.oldNeighbours = new ArrayList<SearchObject>(this.neighbours);
                this.oldCurrObject = null;
                if (this.currObject != null) {
                    this.oldCurrObject = this.currObject.clone();
                    this.previousObject = this.currObject.clone();
                }
            }
            if (this.currObject == null) {
                if (selectedIndex == this.graph.nodes.indexOf(this.startNodeIndex.get(0))) {
                    SearchNode node = (SearchNode)this.graph.nodeFromIndex(selectedIndex);
                    node.setNodeAppearance(3);
                    node.setSearchOrder(this.nodeCount);
                    node.setSearchOrderDisplayed(true);
                    ++this.nodeCount;
                    this.firstAnswerCorrect = true;
                    this.stepOne();
                    this.stepTwo();
                    this.stepThree();
                    this.quizResultFrontier = new ArrayList<SearchObject>(this.frontier);
                    if (this.showAnswers) {
                        this.graph.getFrontierInfo().setFrontier(false);
                    }
                    SearchObject previousObject = this.currObject;
                    this.stepOne();
                    this.quizAnimate = new SearchQuizAnimator(this, (SearchCanvas)this.graph.canvas, this.quizResultFrontier, animationSpeed);
                    this.quizAnimate.start();
                    this.paintNode(previousObject, 3);
                    this.graph.setPromptColor(Color.GREEN);
                    this.graph.setPromptLabel("Correct.  Click on the next node on the frontier.");
                } else {
                    this.graph.setPromptColor(Color.RED);
                    this.graph.setPromptLabel("Incorrect.  Click on the first node on the frontier.");
                }
                return;
            }
            if (this.currObject.getToNode() == selectedIndex) {
                this.firstAnswerCorrect = true;
                if (this.previousObject != null) {
                    this.resetPrevious(this.previousObject);
                }
                this.selectedNode.setSearchOrder(this.nodeCount);
                this.selectedNode.setSearchOrderDisplayed(true);
                ++this.nodeCount;
                this.resetNodes(false);
                this.resetEdges();
                this.paintPath(this.currObject, true);
                this.checkGoal(selectedIndex);
                this.showPath(this.currObject);
                this.stepTwo();
                this.stepThree();
                this.quizResultFrontier = new ArrayList<SearchObject>(this.frontier);
                if (this.showAnswers) {
                    this.graph.getFrontierInfo().setFrontier(false);
                }
                this.stepOne();
                this.quizAnimate = new SearchQuizAnimator(this, (SearchCanvas)this.graph.canvas, this.quizAnimateFrontier, animationSpeed);
                this.quizAnimate.start();
                this.selectedNode.setNodeAppearance(3);
                this.graph.setPromptColor(Color.GREEN);
                if (this.frontier.size() == 0 && this.currObject == null && this.firstAnswerCorrect) {
                    this.resetPrevious(this.currObject);
                    this.resetEdges();
                    this.graph.setPromptLabel("Search completed.\nClick on the Reset Search button to reset the graph.");
                    return;
                }
                if (this.goalNodeIndex.contains((SearchNode)this.graph.nodeFromIndex(selectedIndex))) {
                    this.graph.setPromptLabel("Click on the next node on the frontier or click the Reset Search button.");
                } else {
                    this.graph.setPromptLabel("Correct.  Click on the next node on the frontier.");
                }
            } else {
                if (((SearchNode)this.graph.nodeFromIndex(selectedIndex)).getColor() == Color.GREEN) {
                    this.graph.setPromptColor(Color.RED);
                    this.graph.setPromptLabel("Incorrect.  Try another node on the frontier.");
                } else if (((SearchNode)this.graph.nodeFromIndex(selectedIndex)).getColor() == Color.BLACK) {
                    this.graph.setPromptColor(Color.RED);
                    this.graph.setPromptLabel("Incorrect.  That node is not on the frontier.");
                } else if (((SearchNode)this.graph.nodeFromIndex(selectedIndex)).getColor() == Color.RED) {
                    this.graph.setPromptColor(Color.RED);
                    this.graph.setPromptLabel("Incorrect.  That is the current node.");
                } else if (((SearchNode)this.graph.nodeFromIndex(selectedIndex)).getColor() == Color.GRAY) {
                    this.graph.setPromptColor(Color.RED);
                    this.graph.setPromptLabel("Incorrect.  That node has already been visited.");
                }
                this.firstAnswerCorrect = false;
                this.frontier = new ArrayList<SearchObject>(this.oldFrontier);
                this.neighbours = new ArrayList<SearchObject>(this.oldNeighbours);
                this.currObject = null;
                if (this.oldCurrObject != null) {
                    this.currObject = this.oldCurrObject.clone();
                }
                this.paintNodes(this.neighbours, 6);
            }
        }
        this.selectedNode = null;
    }

    public void updateForQuiz() {
        while (this.currentStep != 1) {
            this.doSearchFine();
        }
        SearchObject previousObject = this.currObject;
        this.quizResultFrontier = new ArrayList<SearchObject>(this.frontier);
        if (this.showAnswers) {
            this.graph.getFrontierInfo().setFrontier(false);
        }
        this.stepOne();
        this.firstAnswerCorrect = true;
        this.paintPath(this.currObject, false);
        this.paintNode(previousObject, 3);
        this.paintNodes(this.neighbours, 4);
    }

    public void setSearchRate(int rate) {
        this.searchRate = rate;
    }

    public int getSearchRate() {
        return this.searchRate;
    }

    public int getPruning() {
        return this.pruning;
    }

    public void setPruning(int p) {
        this.pruning = p;
    }

    private void sortNeighbours() {
        ArrayList<SearchObject> newOrder = new ArrayList<SearchObject>();
        int count = 0;
        while (count < this.neighbours.size()) {
            SearchObject object1 = this.neighbours.get(count);
            boolean leftmostNode = true;
            for (SearchObject object2 : this.neighbours) {
                if (!(this.graph.nodeFromIndex((int)object1.getToNode()).getPos().x > this.graph.nodeFromIndex((int)object2.getToNode()).getPos().x)) continue;
                leftmostNode = false;
            }
            if (leftmostNode) {
                newOrder.add(object1);
                this.neighbours.remove(object1);
                count = -1;
            }
            ++count;
        }
        this.neighbours.addAll(newOrder);
    }

    protected void stepThree() {
        if (this.currObject == null) {
            return;
        }
        if (this.backup != null) {
            this.frontier = this.backup;
        }
        StringBuffer paths = new StringBuffer("Paths added to frontier: ");
        if (this.neighbours != null && this.neighbours.size() > 0) {
            int i = 0;
            while (i < this.neighbours.size()) {
                Integer toNodeIndex = new Integer(this.neighbours.get(i).getToNode());
                if (this.shorterFrontier.contains(toNodeIndex)) {
                    ((SearchNode)this.graph.nodeFromIndex(toNodeIndex)).setDrawnShadowed(true);
                }
                this.shorterFrontier.add(toNodeIndex);
                ++i;
            }
            int n = this.neighbours.size();
            int i2 = 0;
            while (i2 < n) {
                if (i2 == 0) {
                    paths.append("\n").append(this.getPathString(this.neighbours.get(i2)));
                } else {
                    paths.append(this.getPathString(this.neighbours.get(i2)));
                }
                if (i2 != n - 1) {
                    paths.append(", ");
                }
                ++i2;
            }
            this.sortNeighbours();
            this.mergeWithFrontier(this.neighbours);
            if (!this.quizzed) {
                this.paintNodes(this.frontier, 4);
                if (this.searchRate == 102) {
                    this.paintNodes(this.neighbours, 5);
                    ((SearchNode)this.graph.nodeFromIndex(this.currObject.getToNode())).setNodeAppearance(3);
                }
            } else {
                this.paintNodes(this.neighbours, 6);
            }
            this.pruneNodes();
        } else {
            this.quizAnimateFrontier.clear();
            this.pruneNodes();
            paths.append(" no paths added.");
            if (this.searchRate == 102) {
                this.paintNodes(this.frontier, 4);
                ((SearchNode)this.graph.nodeFromIndex(this.currObject.getToNode())).setNodeAppearance(3);
            }
        }
        this.graph.setPromptLabel(paths.toString());
        if (this.searchRate != 102) {
            this.paintPath(this.currObject, false);
            this.paintNode(this.currObject, 6);
            ((SearchNode)this.graph.nodeFromIndex(this.currObject.getToNode())).setNodeSearchType(6);
        }
        this.resetPrevious(this.previousObject);
    }

    protected void stepOne() {
        if (this.frontier.size() > 0) {
            this.currObject = this.frontier.get(0).clone();
            int curIndex = this.currObject.getToNode();
            SearchNode node = (SearchNode)this.graph.nodeFromIndex(curIndex);
            node.setPathFound(true);
            if (this.searchRate != 104) {
                node.setNodeAppearance(3);
                node.setSearchOrder(this.nodeCount++ + 1);
                node.setSearchOrderDisplayed(true);
                this.paintPath(this.currObject, true);
                this.checkGoal(curIndex);
                this.showPath(this.currObject);
            }
            if (!this.goalReached) {
                this.graph.setPromptLabel("Path " + this.pathString + "\nselected and removed from frontier.");
            }
            Integer curIntIndex = new Integer(curIndex);
            this.nodesVisited.add(curIntIndex);
            this.frontier.remove(0);
            this.shorterFrontier.remove(curIntIndex);
            if (this.countOccurances(this.shorterFrontier, curIntIndex) <= 1) {
                ((SearchNode)this.graph.nodeFromIndex(curIntIndex)).setDrawnShadowed(false);
            }
        } else {
            this.completed();
            this.graph.showMessage("Search Done", "No more nodes on the frontier to search");
        }
    }

    protected void stepTwo() {
        this.neighbours = new ArrayList(5);
        if (this.currObject != null) {
            int currIndex = this.currObject.getToNode();
            ArrayList<SearchNode> children = new ArrayList<SearchNode>(((SearchNode)this.graph.nodeFromIndex(currIndex)).getChildren());
            int numNeigh = children != null ? children.size() : 0;
            int i = 0;
            while (i < numNeigh) {
                int nextNeigh = children.get(0).getIndex();
                boolean condition = false;
                if (this.pruning == 303 || this.pruning == 301) {
                    condition = true;
                } else if (this.pruning == 302 && this.currObject == null || !this.currObject.checkNodeOnPath(nextNeigh)) {
                    condition = true;
                }
                if (condition) {
                    this.neighbours.add(new SearchObject(currIndex, nextNeigh, this.currObject.getPath(), this.graph));
                }
                children.remove(0);
                ++i;
            }
            StringBuffer path = new StringBuffer("Path ").append(this.pathString).append(" expanded.\nNeighbours of ");
            path.append(((SearchNode)this.graph.nodes.get(this.currObject.getToNode())).getLabel()).append(":  ");
            if (this.neighbours.size() > 0) {
                this.paintNodes(this.neighbours, 5);
                Iterator<SearchObject> itr = this.neighbours.iterator();
                while (itr.hasNext()) {
                    path.append(((SearchNode)this.graph.nodes.get(itr.next().getToNode())).getLabel()).append(", ");
                    if (!itr.hasNext()) continue;
                    path.append(", ");
                }
            } else {
                path.append("no neighbours.");
            }
            this.graph.setPromptLabel(path.toString());
        }
        this.backup = new ArrayList<SearchObject>(this.frontier);
    }

    protected int countOccurances(ArrayList<Integer> vector, Integer item) {
        int occurances = 0;
        Iterator<Integer> itr = vector.iterator();
        while (itr.hasNext()) {
            if (itr.next().intValue() != item.intValue()) continue;
            ++occurances;
        }
        return occurances;
    }

    protected void checkGoal(int currIndex) {
        if (this.goalNodeIndex.contains(this.graph.nodes.get(currIndex))) {
            this.goalReached = true;
            this.showPath(this.currObject);
            this.graph.repaint();
            String saveLabel = this.graph.getPromptLabel();
            this.graph.setPromptLabel(" Goal Node reached! (" + this.pathString + ")");
            this.graph.showMessage("Goal Node Reached", "Path found: " + this.pathString);
            this.graph.setPromptLabel(saveLabel);
            if (this.graph.canvas.inline) {
                ((InlineSearchApplet)this.graph.getWindow()).setAutoSearch();
            } else {
                ((SearchWindow)this.graph.getWindow()).setAutoSearch();
            }
        }
    }

    protected void completed() {
        if (this.currObject != null) {
            this.paintPath(this.currObject, false);
            this.currObject = null;
        }
        int i = 0;
        while (i < this.graph.numNodes()) {
            SearchNode tmpNode = (SearchNode)this.graph.nodeAt(i);
            tmpNode.setNodeAppearance(6);
            this.graph.setPromptLabel(" Search Completed.\nClick on the Reset Search button to reset the graph.");
            ++i;
        }
    }

    public void paintNodes(ArrayList f, int type) {
        int i = 0;
        while (i < f.size()) {
            ((SearchNode)this.graph.nodes.get(((SearchObject)f.get(i)).getToNode())).setNodeAppearance(type);
            ++i;
        }
    }

    public void paintNode(SearchObject nodeObject, int type) {
        ArrayList<SearchObject> sTemp = new ArrayList<SearchObject>();
        sTemp.add(nodeObject);
        this.paintNodes(sTemp, type);
    }

    protected void paintPath(SearchObject so, boolean currPath) {
        if (so == null) {
            return;
        }
        ArrayList path = (ArrayList)so.getPath().clone();
        int max = path.size();
        int i = 0;
        while (i < max) {
            SearchEdge edge;
            Integer[] edgeNode = (Integer[])path.get(0);
            path.remove(0);
            if (edgeNode[0] != -1 && (edge = (SearchEdge)this.graph.getEdge(edgeNode[0], edgeNode[1])) != null) {
                if (currPath) {
                    edge.setAppearance(1);
                } else {
                    edge.setAppearance(0);
                }
            }
            ++i;
        }
    }

    protected void resetPrevious(SearchObject tmpcurrObject) {
        if (tmpcurrObject != null) {
            int currIndex = tmpcurrObject.getToNode();
            if (this.shorterFrontier.contains(new Integer(currIndex))) {
                ((SearchNode)this.graph.nodeFromIndex(currIndex)).setNodeAppearance(4);
                return;
            }
            ((SearchNode)this.graph.nodeFromIndex(currIndex)).setNodeAppearance(6);
        }
    }

    private void resetEdges() {
        Iterator<Edge> itr = this.graph.getEdges();
        while (itr.hasNext()) {
            ((SearchEdge)itr.next()).setAppearance(0);
        }
    }

    private void resetNodes(boolean resetFrontierNodes) {
        int i = 0;
        while (i < this.graph.numNodes()) {
            SearchNode tmpNode = (SearchNode)this.graph.nodeAt(i);
            tmpNode.setDrawnShadowed(false);
            if (resetFrontierNodes || tmpNode.getNodeAppearance() != 4) {
                tmpNode.setNodeAppearance(6);
            }
            ++i;
        }
    }

    protected void clearOrdering() {
        for (SearchNode curNode : this.graph.nodes) {
            if (!curNode.isSearchOrderDisplayed()) continue;
            curNode.resetSearchOrder();
        }
    }

    protected void pruneNodes() {
        if (this.pruning == 301) {
            SearchNode node;
            int i = 0;
            while (i < this.frontier.size()) {
                SearchObject so = this.frontier.get(i);
                if (this.nodesVisited.contains(new Integer(so.getToNode()))) {
                    SearchNode tmpNode = (SearchNode)this.graph.nodeFromIndex(so.getToNode());
                    tmpNode.setNodeAppearance(6);
                    this.frontier.remove(i);
                    this.shorterFrontier.remove(new Integer(so.getToNode()));
                    continue;
                }
                ++i;
            }
            if (this.previousIndex != -1 && (node = (SearchNode)this.graph.nodeFromIndex(this.previousIndex)) != null) {
                node.setNodeAppearance(6);
            }
        }
    }

    public ArrayList<SearchObject> getFrontier(boolean isCurrObjectIncluded) {
        if (isCurrObjectIncluded && !this.frontier.contains(this.currObject)) {
            ArrayList<SearchObject> bigFrontier = new ArrayList<SearchObject>(this.frontier);
            bigFrontier.add(this.currObject);
            return bigFrontier;
        }
        return this.frontier;
    }

    public ArrayList<SearchObject> getQuizFrontier() {
        return this.quizResultFrontier;
    }

    public ArrayList<SearchObject> getNeighbours() {
        return this.neighbours;
    }

    public boolean getFirstAnswerCorrect() {
        return this.firstAnswerCorrect;
    }

    public void fillAnimateFrontier(TreeMap<Integer, SearchObject> nodeMap) {
        this.quizAnimateFrontier.clear();
        while (nodeMap.size() > 0) {
            this.quizAnimateFrontier.add(nodeMap.get(nodeMap.firstKey()));
            nodeMap.remove(nodeMap.firstKey());
        }
    }

    protected void insertAdvance(int position, SearchObject next, TreeMap<Integer, SearchObject> nodeMap) {
        int pos = position;
        Integer key = new Integer(pos);
        SearchObject value = null;
        SearchObject value2 = null;
        while (nodeMap.containsKey(key)) {
            value = nodeMap.get(key);
            nodeMap.put(key, value2);
            value2 = value;
            key = new Integer(++pos);
        }
        if (value2 != null) {
            key = new Integer(++pos);
            nodeMap.put(key, value2);
        }
        nodeMap.put(new Integer(position), next);
    }

    protected abstract void mergeWithFrontier(ArrayList<SearchObject> var1);

    protected abstract int getStartIndex();
}

