/*
 * Decompiled with CFR 0.152.
 */
package CIspace.search.searchTypes;

import CIspace.search.SearchGraph;
import CIspace.search.elements.SearchEdge;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchObject
implements Cloneable {
    protected SearchGraph graph;
    protected Integer[] edgeNodes;
    protected ArrayList<Integer[]> path;
    protected double pathCost;

    public SearchObject() {
        this.graph = null;
        this.edgeNodes = new Integer[2];
        this.edgeNodes[0] = new Integer(-1);
        this.edgeNodes[1] = new Integer(-1);
        this.path = new ArrayList(5);
        this.pathCost = 0.0;
    }

    public SearchObject(int from, int to, ArrayList<Integer[]> prev, SearchGraph g) {
        this.graph = g;
        this.edgeNodes = new Integer[2];
        this.edgeNodes[0] = new Integer(from);
        this.edgeNodes[1] = new Integer(to);
        SearchEdge currEdge = (SearchEdge)this.graph.getEdge(from, to);
        this.pathCost = currEdge != null ? currEdge.getCost() : 0.0;
        if (prev != null) {
            this.path = new ArrayList<Integer[]>(prev);
            this.path.add(this.edgeNodes);
            int i = 0;
            while (i < prev.size()) {
                currEdge = (SearchEdge)this.graph.getEdge(prev.get(i)[0], prev.get(i)[1]);
                if (currEdge != null) {
                    this.pathCost += currEdge.getCost();
                }
                ++i;
            }
        } else {
            this.path = new ArrayList(5);
            this.path.add(this.edgeNodes);
        }
    }

    public int getFromNode() {
        return this.edgeNodes[0];
    }

    public void setFromNode(int from) {
        this.edgeNodes[0] = new Integer(from);
    }

    public int getToNode() {
        return this.edgeNodes[1];
    }

    public void setToNode(int to) {
        this.edgeNodes[1] = new Integer(to);
    }

    public ArrayList<Integer[]> getPath() {
        return this.path;
    }

    public double getPathCost() {
        return this.pathCost;
    }

    public boolean checkNodeOnPath(int next) {
        int tempIndex;
        int i = 0;
        while (i < this.path.size()) {
            tempIndex = this.path.get(i)[0];
            if (tempIndex == next) {
                return true;
            }
            ++i;
        }
        tempIndex = this.path.get(this.path.size() - 1)[1];
        return tempIndex == next;
    }

    public SearchObject clone() {
        SearchObject copy = new SearchObject();
        copy.edgeNodes[0] = this.edgeNodes[0];
        copy.edgeNodes[1] = this.edgeNodes[1];
        copy.path = new ArrayList<Integer[]>(this.path);
        return copy;
    }

    public String toString() {
        StringBuffer string = new StringBuffer("From Node: ");
        string.append(this.graph.nodeFromIndex(this.edgeNodes[0]));
        string.append("\nTo Node: ").append(this.graph.nodeFromIndex(this.edgeNodes[1]));
        return string.append("\n").toString();
    }
}

