/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree;

import CIspace.dTree.InlineDTreeApplet;
import CIspace.dTree.dTreeCanvas;
import CIspace.dTree.elements.dTreeNode;
import java.awt.Color;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class InlineCanvas
extends dTreeCanvas {
    private static final long serialVersionUID = 1L;

    public InlineCanvas(Container parent) {
        super(parent, true);
        this.setSize(parent.getSize());
        this.WIDTH = this.getSize().width;
        this.HEIGHT = this.getSize().height;
        this.mode = 2221;
    }

    public void initializePopup() {
        if (!((InlineDTreeApplet)this.parent).isPopupMenuOn()) {
            this.pop.setPopupSize(0, 0);
        }
    }

    public boolean isAntiAliasingEnabled() {
        return true;
    }

    protected JPopupMenu addNodeItems(JPopupMenu pop, dTreeNode node) {
        pop.removeAll();
        pop.setBorder(BorderFactory.createTitledBorder("Node Options"));
        boolean enabled = false;
        if (((InlineDTreeApplet)this.parent).viewNodeInfoPopupOn) {
            pop.add(this.newMenuItem("View Node Information of Node", "View Node Information", this));
            enabled = true;
        }
        if (((InlineDTreeApplet)this.parent).viewMappedExamplesPopupOn) {
            pop.add(this.newMenuItem("View Mapped Examples of Node", "View Mapped Examples", this));
            enabled = true;
        }
        if (((InlineDTreeApplet)this.parent).toggleHistogramPopupOn) {
            pop.add(this.newMenuItem("Toggle Histogram of Node", "Toggle Histogram", this));
            enabled = true;
        }
        if (((InlineDTreeApplet)this.parent).splitNodePopupOn) {
            if (node.color == Color.blue) {
                pop.add(this.newMenuItem("Split Node", this));
            }
            enabled = true;
        }
        if (!enabled) {
            pop.setBorder(null);
        }
        return pop;
    }

    protected JPopupMenu addTestCanvasItems(JPopupMenu pop) {
        JRadioButtonMenuItem pan;
        JRadioButtonMenuItem zoom;
        pop.removeAll();
        if (((InlineDTreeApplet)this.parent).examplesPopupOn) {
            pop.add(this.newMenuItem("View/Edit Examples", (InlineDTreeApplet)this.parent));
        }
        if (((InlineDTreeApplet)this.parent).stepPopupOn) {
            pop.add(this.newMenuItem("Step", (InlineDTreeApplet)this.parent));
        }
        JMenuItem mItemAuto = this.newMenuItem("Auto Create", (InlineDTreeApplet)this.parent);
        JMenuItem mItemStop = this.newMenuItem("Stop", (InlineDTreeApplet)this.parent);
        boolean isAutoCreateRunning = ((InlineDTreeApplet)this.parent).autoCreate != null && ((InlineDTreeApplet)this.parent).autoCreate.isRunning();
        mItemAuto.setEnabled(!isAutoCreateRunning);
        mItemStop.setEnabled(isAutoCreateRunning);
        if (((InlineDTreeApplet)this.parent).autoCreatePopupOn) {
            pop.add(mItemAuto);
        }
        if (((InlineDTreeApplet)this.parent).stopPopupOn) {
            pop.add(mItemStop);
        }
        if (((InlineDTreeApplet)this.parent).resetGraphPopupOn) {
            pop.add(this.newMenuItem("Reset Graph", (InlineDTreeApplet)this.parent));
        }
        if (((InlineDTreeApplet)this.parent).showPlotPopupOn) {
            pop.add(this.newMenuItem("Show Plot", (InlineDTreeApplet)this.parent));
        }
        if (((InlineDTreeApplet)this.parent).testPopupOn) {
            pop.add(this.newMenuItem("Test", (InlineDTreeApplet)this.parent));
        }
        if (((InlineDTreeApplet)this.parent).testNewExamplePopupOn) {
            pop.add(this.newMenuItem("Test New Example", (InlineDTreeApplet)this.parent));
        }
        pop.addSeparator();
        pop.add(new JLabel("View Options"));
        pop.add(this.newMenuItem("Autoscale", this));
        JMenu zp = new JMenu("Pan/Zoom");
        ButtonGroup zpGroup = new ButtonGroup();
        if (this.getRMode() == 4441) {
            zoom = new JRadioButtonMenuItem("Zoom", true);
            pan = new JRadioButtonMenuItem("Pan", false);
        } else {
            zoom = new JRadioButtonMenuItem("Zoom", false);
            pan = new JRadioButtonMenuItem("Pan", true);
        }
        zoom.setToolTipText("Zoom into certain area of graph");
        zoom.addActionListener(this);
        zpGroup.add(zoom);
        zp.add(zoom);
        pan.setToolTipText("Pan the graph to a different area on the canvas");
        pan.addActionListener(this);
        zp.add(pan);
        zpGroup.add(pan);
        pop.add(zp);
        if (((InlineDTreeApplet)this.parent).textRepresentationPopupOn) {
            pop.addSeparator();
            JMenuItem repItem = new JMenuItem("View Text Representation");
            repItem.setActionCommand(repItem.getText());
            repItem.addActionListener((InlineDTreeApplet)this.parent);
            pop.add(repItem);
            repItem = new JMenuItem("View XML Representation");
            repItem.setActionCommand(repItem.getText());
            repItem.addActionListener((InlineDTreeApplet)this.parent);
            pop.add(repItem);
        }
        return pop;
    }
}

