/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree;

import CIspace.dTree.PlotFrame;
import CIspace.dTree.intList.IntList;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PlotCanvas
extends JPanel
implements MouseListener {
    protected DecimalFormat numFormat;
    private Font font;
    private FontMetrics fm;
    private int width;
    private int height;
    private float xStep;
    private float yStep;
    private IntList xVals;
    private IntList yVals;
    private IntList xTestVals;
    private IntList yTestVals;
    private int maxTestX;
    private int maxY;
    private int maxX;
    private int skipX;
    private int skipY;
    private static final int LEFT_PAD = 100;
    private static final int RIGHT_PAD = 100;
    private static final int TOP_PAD = 50;
    private static final int BOTTOM_PAD = 50;
    private boolean useLogScale = false;
    private int mouseX;
    private int mouseY;
    private String mouseStr;
    private int redX;
    private int redY;
    private PlotFrame parent;
    private int plotType;

    public PlotCanvas(PlotFrame parent) {
        this.parent = parent;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.numFormat = new DecimalFormat("0.00;0.00");
        this.font = new Font("SansSerif", 0, 12);
        this.fm = this.getFontMetrics(this.font);
        this.xVals = new IntList();
        this.yVals = new IntList();
        this.xTestVals = new IntList();
        this.yTestVals = new IntList();
        this.maxTestX = 1;
        this.xStep = 5.0f;
        this.maxX = 1;
        this.mouseX = -100;
        this.mouseY = -100;
        this.mouseStr = "";
        this.redX = -100;
        this.redY = -100;
    }

    public PlotCanvas(PlotFrame parent, int plotType) {
        this.parent = parent;
        this.plotType = plotType;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.numFormat = new DecimalFormat("0.00;0.00");
        this.font = new Font("SansSerif", 0, 12);
        this.fm = this.getFontMetrics(this.font);
        this.xVals = new IntList();
        this.yVals = new IntList();
        this.xTestVals = new IntList();
        this.yTestVals = new IntList();
        this.maxTestX = 1;
        this.xStep = 5.0f;
        this.maxX = 1;
        this.mouseX = -100;
        this.mouseY = -100;
        this.mouseStr = "";
        this.redX = -100;
        this.redY = -100;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void resetSteps(int maxY) {
        this.updateSize();
        this.maxY = maxY;
        if (maxY <= 0) {
            maxY = 1;
            this.yStep = 50.0f;
        } else {
            this.yStep = (float)this.height / (float)maxY;
        }
        this.skipX = this.round(50.0 / (double)this.xStep);
        this.skipY = this.round(20.0 / (double)this.yStep);
    }

    public void resetSteps() {
        this.resetSteps(this.maxY);
    }

    private int round(double d) {
        int mult;
        int digits = 0;
        double tmp = d;
        while (tmp >= 1.0) {
            tmp /= 10.0;
            ++digits;
        }
        if (digits <= 0) {
            digits = 1;
        }
        if (d / (double)(mult = (int)Math.pow(10.0, digits)) < 0.1) {
            return (int)(0.1 * (double)mult);
        }
        if (d / (double)mult < 0.25) {
            return (int)(0.25 * (double)mult);
        }
        if (d / (double)mult < 0.5) {
            return (int)(0.5 * (double)mult);
        }
        return mult;
    }

    public void updateSize() {
        this.width = Math.abs(this.getWidth() - 100 - 100);
        this.height = Math.abs(this.getHeight() - 50 - 50);
    }

    public void clear() {
        this.xVals = null;
        this.yVals = null;
        this.xTestVals = null;
        this.yTestVals = null;
        this.maxY = 1;
        this.repaint();
    }

    public void useLogScale(boolean bool) {
        this.useLogScale = bool;
        this.repaint();
    }

    public void redraw(IntList[] vals, IntList[] testVals) {
        if (vals == null || testVals == null) {
            return;
        }
        this.xVals = vals[0];
        this.yVals = vals[1];
        this.xTestVals = testVals[0];
        this.yTestVals = testVals[1];
        if (this.xVals.first() == -1) {
            return;
        }
        this.maxX = this.xVals.last();
        this.xStep = (float)this.width / (float)this.maxX;
        this.maxY = this.yVals.first();
        int tmp = this.yVals.next();
        while (tmp != -1) {
            if (tmp > this.maxY) {
                this.maxY = tmp;
            }
            tmp = this.yVals.next();
        }
        if (this.xTestVals.first() == -1) {
            return;
        }
        this.maxTestX = this.xTestVals.last();
        this.xStep = (float)this.width / (float)this.maxTestX;
        this.yTestVals.first();
        tmp = this.yTestVals.next();
        while (tmp != -1) {
            if (tmp > this.maxY) {
                this.maxY = tmp;
            }
            tmp = this.yTestVals.next();
        }
        this.resetSteps();
        this.repaint();
    }

    public void paintComponent(IntList[] vals, IntList[] testVals) {
        if (vals == null) {
            return;
        }
        if (testVals == null) {
            return;
        }
        this.xTestVals = testVals[0];
        this.yTestVals = testVals[1];
        this.xVals = vals[0];
        this.yVals = vals[1];
        this.maxX = this.xVals.last();
        if (this.maxX == -1) {
            this.maxX = 1;
        }
        this.xStep = (float)this.width / (float)this.maxX;
        if (this.maxX == 1 && this.yVals.first() > this.maxY) {
            this.maxY = this.yVals.first();
        }
        if (this.yVals.last() > this.maxY) {
            this.maxY = this.yVals.last();
        }
        this.maxTestX = this.xTestVals.last();
        if (this.maxTestX == -1) {
            this.maxTestX = 1;
        }
        this.xStep = (float)this.width / (float)this.maxTestX;
        if (this.maxTestX == 1 && this.yTestVals.first() > this.maxY) {
            this.maxY = this.yTestVals.first();
        }
        if (this.yTestVals.last() > this.maxY) {
            this.maxY = this.yTestVals.last();
        }
        this.resetSteps();
        this.repaint();
    }

    public void update(Graphics g) {
        this.paintComponent(g);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawGrid(g);
        this.drawPoints(g);
        this.drawLabels(g);
        g.setColor(Color.red);
        g.drawOval((int)((float)this.redX * this.xStep) + 100 - 1, this.getHeight() - 50 - (int)((float)this.redY * this.yStep), 2, 2);
        g.setColor(Color.white);
        g.fillRect(this.mouseX, this.mouseY - this.fm.getAscent(), this.fm.stringWidth(this.mouseStr), this.fm.getHeight());
        g.setColor(Color.black);
        g.drawString(this.mouseStr, this.mouseX, this.mouseY);
    }

    private void drawGrid(Graphics graphics) {
        this.updateSize();
        graphics.setColor(Color.black);
        int xStart = 100;
        if (xStart < 0) {
            xStart = 0;
        }
        int xEnd = this.getWidth() - 100;
        graphics.drawLine(xStart, this.getHeight() - 50, xEnd, this.getHeight() - 50);
        graphics.drawLine(100, this.getHeight() - 50, 100, 50);
        graphics.setColor(Color.lightGray);
        int i = 0;
        this.xStep = (float)this.width / (float)this.maxX;
        float x = 100.0f + this.xStep * (float)this.skipX;
        while (x <= (float)(100 + this.width + 1)) {
            i += this.skipX;
            float x2 = x - 100.0f;
            if (this.useLogScale) {
                float percent = x2 / (float)this.width;
                x2 *= percent * percent;
            }
            x2 += 100.0f;
            if (x >= 0.0f) {
                graphics.drawLine((int)x2, 50, (int)x2, this.getHeight() - 50);
                graphics.drawString(String.valueOf(i), (int)x2 - this.fm.stringWidth(String.valueOf(i)) / 2, this.getHeight() - 50 + this.fm.getHeight());
            }
            x += this.xStep * (float)this.skipX;
        }
        i = 0;
        float y = (float)(this.getHeight() - 50) - this.yStep * (float)this.skipY;
        while (y >= 50.0f) {
            xStart = 100;
            graphics.drawLine(xStart, (int)y, this.getWidth() - 100, (int)y);
            String yStr = PlotCanvas.doubleToString((double)(i += this.skipY) / 100.0);
            xStart = xStart == 0 ? this.getWidth() - 100 + this.fm.stringWidth(" ") : (xStart -= this.fm.stringWidth(String.valueOf(yStr) + " "));
            graphics.drawString(yStr, xStart, (int)y + this.fm.getHeight() / 2);
            y -= this.yStep * (float)this.skipY;
        }
    }

    private void drawPoints(Graphics graphics) {
        if (this.xVals == null || this.yVals == null) {
            return;
        }
        int x = this.xVals.first();
        int y = this.yVals.first();
        int xPrev = -1;
        int yPrev = -1;
        int r = 1;
        int xStart = 100;
        int yStart = this.getHeight() - 50;
        float percent = 1.0f;
        graphics.setColor(Color.blue);
        while (x != -1 && y != -1) {
            if (this.useLogScale) {
                percent = this.percent(x);
                x = (int)((float)x * this.xStep * percent * percent);
            } else {
                x = (int)((float)x * this.xStep);
            }
            y = (int)((float)y * this.yStep);
            y = yStart - y;
            graphics.drawRect((x += xStart) - r, y - r, r * 2, r * 2);
            if (xPrev != -1 && yPrev != -1) {
                graphics.drawLine(xPrev, yPrev, x, y);
            }
            xPrev = x;
            yPrev = y;
            x = this.xVals.next();
            y = this.yVals.next();
        }
        if (this.xTestVals == null || this.yTestVals == null) {
            return;
        }
        int xTest = this.xTestVals.first();
        int yTest = this.yTestVals.first();
        int xTestPrev = -1;
        int yTestPrev = -1;
        int rTest = 1;
        int xTestStart = 100;
        int yTestStart = this.getHeight() - 50;
        float testPercent = 1.0f;
        graphics.setColor(Color.orange);
        while (xTest != -1 && yTest != -1) {
            if (this.useLogScale) {
                testPercent = this.percent(xTest);
                xTest = (int)((float)xTest * this.xStep * testPercent * testPercent);
            } else {
                xTest = (int)((float)xTest * this.xStep);
            }
            yTest = (int)((float)yTest * this.yStep);
            yTest = yTestStart - yTest;
            graphics.drawRect((xTest += xTestStart) - rTest, yTest - rTest, rTest * 2, rTest * 2);
            if (xTestPrev != -1 && yTestPrev != -1) {
                graphics.drawLine(xTestPrev, yTestPrev, xTest, yTest);
            }
            xTestPrev = xTest;
            yTestPrev = yTest;
            xTest = this.xTestVals.next();
            yTest = this.yTestVals.next();
        }
    }

    private void drawLabels(Graphics graphics) {
        String err;
        int y;
        String xName = "Split Count";
        String yNameLine1 = "";
        String yNameLine2 = "";
        String yNameLine3 = "";
        if (this.plotType == 101) {
            yNameLine1 = "Sum of";
            yNameLine2 = "Absolute";
            yNameLine3 = "Values";
        } else if (this.plotType == 102) {
            yNameLine1 = "Sum of";
            yNameLine2 = "Squares of";
            yNameLine3 = "Abs. Vals";
        }
        graphics.setColor(Color.black);
        graphics.drawString(xName, this.getWidth() / 2 - this.fm.stringWidth(xName) / 2, this.getHeight() - this.fm.getHeight());
        int xStart = (100 - this.fm.stringWidth("0.00")) / 2;
        int yNameWidthLine1 = this.fm.stringWidth(yNameLine1);
        int yNameWidthLine2 = this.fm.stringWidth(yNameLine2);
        int yNameWidthLine3 = this.fm.stringWidth(yNameLine3);
        if (xStart + yNameWidthLine1 < 0) {
            return;
        }
        graphics.drawString(yNameLine1, xStart - yNameWidthLine1 / 2, this.getHeight() / 2 - this.fm.getHeight() / 2 - this.fm.getHeight() - 3);
        graphics.drawString(yNameLine2, xStart - yNameWidthLine2 / 2, this.getHeight() / 2 - this.fm.getHeight() / 2);
        graphics.drawString(yNameLine3, xStart - yNameWidthLine3 / 2, this.getHeight() / 2 - this.fm.getHeight() / 2 + this.fm.getHeight() + 3);
        xStart = this.getWidth() - 100 + 5;
        if (this.yVals != null && this.yVals.last() != -1) {
            graphics.setColor(Color.orange);
            graphics.drawLine(xStart, this.getHeight() / 3 - this.fm.getHeight() / 2, xStart + 55, this.getHeight() / 3 - this.fm.getHeight() / 2);
            graphics.drawRect(xStart + 27, this.getHeight() / 3 - this.fm.getHeight() / 2 - 2, 4, 4);
            y = 2 * this.getHeight() / 3 - this.fm.getHeight();
            graphics.setColor(Color.black);
            err = PlotCanvas.doubleToString((double)this.yVals.last() / 100.0);
            graphics.drawString(String.valueOf(err) + " Train", xStart, y);
        }
        if (this.yTestVals != null && this.yTestVals.last() != -1) {
            graphics.setColor(Color.blue);
            graphics.drawLine(xStart, 2 * this.getHeight() / 3 - this.fm.getHeight() / 2, xStart + 55, 2 * this.getHeight() / 3 - this.fm.getHeight() / 2);
            graphics.drawRect(xStart + 27, 2 * this.getHeight() / 3 - this.fm.getHeight() / 2 - 2, 4, 4);
            y = this.getHeight() / 3 - this.fm.getHeight();
            err = PlotCanvas.doubleToString((double)this.yTestVals.last() / 100.0);
            graphics.setColor(Color.black);
            graphics.drawString(String.valueOf(err) + " Test", xStart, y);
        }
    }

    private float percent(int x) {
        if (this.maxX == 0) {
            return 0.0f;
        }
        return (float)x / (float)this.xVals.last();
    }

    public static String doubleToString(double d) {
        DecimalFormat decFor = new DecimalFormat("0.##");
        return decFor.format(d);
    }

    public void setErrorType(int errorType) {
        this.plotType = errorType;
        if (this.plotType == 100) {
            this.parent.setTitle("Proportion Incorrect Error Plot");
        } else if (this.plotType == 101) {
            this.parent.setTitle("Average Sum of Absolute Values of Differences Error Plot");
        } else if (this.plotType == 102) {
            this.parent.setTitle("Average Sum of Squares of Absolute Values of Differences Error Plot");
        }
    }

    public void print(JFrame parent) {
        PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob(parent, "Title", null);
        if (pj == null) {
            System.out.println("The print request was cancelled");
            return;
        }
        Graphics g = pj.getGraphics();
        Image im = this.createImage(this.getWidth(), this.getHeight());
        Graphics graphics = im.getGraphics();
        this.drawGrid(graphics);
        this.drawPoints(graphics);
        this.drawLabels(graphics);
        g.drawImage(im, 0, 0, this);
        g.dispose();
        pj.end();
    }

    public void mousePressed(MouseEvent e) {
        if (this.xVals == null) {
            return;
        }
        if (this.useLogScale) {
            return;
        }
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        float clickedX = (float)(this.mouseX - 100) / this.xStep;
        int x = this.xVals.first();
        int y = this.yVals.first();
        int prevX = x;
        int prevY = y;
        while ((float)x < clickedX && x != -1) {
            prevX = x;
            prevY = y;
            x = this.xVals.next();
            y = this.yVals.next();
        }
        if (Math.abs(clickedX - (float)x) > Math.abs(clickedX - (float)prevX)) {
            x = prevX;
            y = prevY;
        }
        if (x == -1) {
            this.mouseX = -100;
            this.mouseY = -100;
            this.mouseStr = "";
            this.redX = -100;
            this.redY = -100;
            return;
        }
        this.redX = x;
        this.redY = y;
        this.mouseStr = "(" + x + ", " + PlotCanvas.doubleToString((double)y / 100.0) + ")";
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseX = -100;
        this.mouseY = -100;
        this.mouseStr = "";
        this.redX = -100;
        this.redY = -100;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

