/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree;

import CIspace.dTree.InlineDTreeApplet;
import CIspace.dTree.PlotCanvas;
import CIspace.dTree.dTreeGraph;
import CIspace.dTree.dTreeWindow;
import CIspace.graphToolKit.LabelCanvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlotFrame
extends JFrame
implements ActionListener,
ChangeListener {
    private JTabbedPane tabbedPane;
    private PlotCanvas absValue;
    private PlotCanvas squareDifference;
    private LabelCanvas messageCanvas;
    private JRadioButton modeValueError;
    private JRadioButton probabilisticError;
    private boolean probabilityModeDifference = true;
    private boolean probabilityModeAbs = true;
    private dTreeGraph graph;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    private JCheckBox log;
    private JButton step;
    private JButton auto;
    private JButton stop;
    private JButton resetGraph;
    private int absMaxY;
    private int differenceMaxY;

    public PlotFrame(dTreeGraph graph) {
        super("Error Plot");
        this.setSize(600, 450);
        this.graph = graph;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.absValue = new PlotCanvas(this, 101);
        this.squareDifference = new PlotCanvas(this, 102);
        this.tabbedPane.add((Component)this.squareDifference, "Sum of Squares of Differences");
        this.tabbedPane.add((Component)this.absValue, "Sum of Absolute Values of Differences");
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        if (graph.canvas.inline) {
            this.step = new JButton("Step");
            this.step.addActionListener((InlineDTreeApplet)graph.window);
            this.auto = new JButton("Auto Create");
            this.auto.addActionListener((InlineDTreeApplet)graph.window);
            this.stop = new JButton("Stop");
            this.stop.addActionListener((InlineDTreeApplet)graph.window);
            this.stop.setEnabled(false);
            this.resetGraph = new JButton("Reset Graph");
            this.resetGraph.addActionListener((InlineDTreeApplet)graph.window);
        } else {
            this.step = new JButton("Step");
            this.step.addActionListener((dTreeWindow)graph.window);
            this.auto = new JButton("Auto Create");
            this.auto.addActionListener((dTreeWindow)graph.window);
            this.stop = new JButton("Stop");
            this.stop.addActionListener((dTreeWindow)graph.window);
            this.stop.setEnabled(false);
            this.resetGraph = new JButton("Reset Graph");
            this.resetGraph.addActionListener((dTreeWindow)graph.window);
        }
        JPanel middle = new JPanel();
        middle.add(this.step);
        middle.add(this.auto);
        middle.add(this.stop);
        middle.add(this.resetGraph);
        JPanel chooseMode = new JPanel();
        ButtonGroup modeGroup = new ButtonGroup();
        JLabel valueErrorLabel = new JLabel("Prediction at Leaf:");
        this.modeValueError = new JRadioButton("Mode", false);
        this.probabilisticError = new JRadioButton("Probability", true);
        this.modeValueError.addActionListener(this);
        this.probabilisticError.addActionListener(this);
        modeGroup.add(this.probabilisticError);
        modeGroup.add(this.modeValueError);
        chooseMode.add(valueErrorLabel);
        chooseMode.add(this.probabilisticError);
        chooseMode.add(this.modeValueError);
        this.log = new JCheckBox("Logarithmic Scale");
        this.log.addActionListener(this);
        JButton close = new JButton("Close");
        close.addActionListener(this);
        JButton print = new JButton("Print");
        print.addActionListener(this);
        JPanel bottom = new JPanel();
        bottom.add(this.log);
        bottom.add(print);
        bottom.add(new JLabel("     "));
        bottom.add(close);
        this.messageCanvas = new LabelCanvas();
        this.messageCanvas.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.messageCanvas.setText("You can change the type of error plot in plot options menu");
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout(this.gbl);
        this.addComponent(this.tabbedPane, tempPanel, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(middle, tempPanel, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(chooseMode, tempPanel, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(bottom, tempPanel, 3, 0, 1, 1, 0.0, 0.0);
        this.getContentPane().add("Center", tempPanel);
    }

    private void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    public void setMaxY() {
        this.absValue.paintComponent(this.graph.getPlotValsAbs(), this.graph.getTestPlotValsAbs());
        this.squareDifference.paintComponent(this.graph.getPlotValsDifference(), this.graph.getTestPlotValsDifference());
        this.absMaxY = this.absValue.getMaxY();
        this.differenceMaxY = this.squareDifference.getMaxY();
        this.absValue.resetSteps(Math.max(this.differenceMaxY, this.absMaxY));
        this.squareDifference.resetSteps(Math.max(this.differenceMaxY, this.absMaxY));
    }

    public void open() {
        this.setVisible(true);
        this.repaint();
    }

    public void setPromptLabel(String message) {
        this.messageCanvas.setText(message);
    }

    public void clear() {
        this.graph.clearPlotPts();
    }

    public String getPlotErrorString() {
        return "You must reset the graph and recreate your decision tree to see the new error plot.";
    }

    public void setGraph(dTreeGraph newGraph) {
        this.graph = newGraph;
    }

    public void repaint() {
        super.repaint();
        if (this.probabilityModeDifference) {
            this.squareDifference.paintComponent(this.graph.getPlotValsDifference(), this.graph.getTestPlotValsDifference());
        } else {
            this.squareDifference.paintComponent(this.graph.getPlotValsMode(), this.graph.getTestPlotValsMode());
        }
        if (this.probabilityModeAbs) {
            this.absValue.paintComponent(this.graph.getPlotValsAbs(), this.graph.getTestPlotValsAbs());
        } else {
            this.absValue.paintComponent(this.graph.getPlotValsMode(), this.graph.getTestPlotValsMode());
        }
    }

    public boolean getMode() {
        return this.modeValueError.isSelected();
    }

    public void setAutoCreateOn(boolean isOn) {
        this.stop.setEnabled(isOn);
        this.auto.setEnabled(!isOn);
        this.resetGraph.setEnabled(!isOn);
        this.step.setEnabled(!isOn);
    }

    public void actionPerformed(ActionEvent e) {
        block18: {
            String arg = e.getActionCommand();
            if (arg.equals("Logarithmic Scale")) {
                this.absValue.useLogScale(this.log.isSelected());
                this.squareDifference.useLogScale(this.log.isSelected());
                this.repaint();
            } else if (arg.equals("Close")) {
                this.setVisible(false);
            } else if (arg.equals("Clear")) {
                this.clear();
            } else if (arg.equals("Print")) {
                try {
                    if (this.tabbedPane.getSelectedIndex() == 0) {
                        this.squareDifference.print(this);
                        break block18;
                    }
                    this.absValue.print(this);
                }
                catch (Exception exception) {}
            } else if (arg.equals("Mode")) {
                if (this.tabbedPane.getSelectedIndex() == 1) {
                    this.probabilityModeAbs = false;
                } else {
                    this.probabilityModeDifference = false;
                }
                this.repaint();
            } else if (arg.equals("Probability")) {
                if (this.tabbedPane.getSelectedIndex() == 1) {
                    this.probabilityModeAbs = true;
                } else {
                    this.probabilityModeDifference = true;
                }
                this.repaint();
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.probabilisticError != null || this.modeValueError != null) {
            if (this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex()).equals("Sum of Squares of Differences")) {
                this.probabilityModeDifference = this.probabilityModeAbs;
            } else {
                this.probabilityModeAbs = this.probabilityModeDifference;
            }
            this.repaint();
        }
    }
}

