/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree;

import CIspace.dTree.ExampleList;
import CIspace.dTree.InlineDTreeApplet;
import CIspace.dTree.dTreeGraph;
import CIspace.dTree.dTreeWindow;
import CIspace.dTree.dialogs.ExampleDisplayDialog;
import CIspace.dTree.dialogs.NodeInformationDialog;
import CIspace.dTree.dialogs.SplitDialog;
import CIspace.dTree.elements.dTreeNode;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.elements.Entity;
import CIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class dTreeCanvas
extends GraphCanvas {
    public static final int C_MOVE_SUBTREE = 3338;
    private ExampleDisplayDialog testLeafDisplay;
    private ExampleDisplayDialog mappedExampleDisplay;

    public dTreeCanvas(Container parent, boolean inline) {
        super(parent, inline);
        this.graph = inline ? new dTreeGraph(this, ((InlineDTreeApplet)parent).exampleList) : new dTreeGraph(this, ((dTreeWindow)parent).exampleList);
        this.setMode(2220);
    }

    protected void popupEdge(int x, int y) {
        this.popupCanvas(x, y);
    }

    protected void popupCanvas(int x, int y) {
        if (this.mode == 2221) {
            this.pop.setBorder(BorderFactory.createTitledBorder("Test Options"));
            this.pop = this.addTestCanvasItems(this.pop);
            this.pop.show(this, x, y);
        }
    }

    protected void popupNode(int x, int y) {
        this.pop = this.addNodeItems(this.pop, (dTreeNode)this.graph.searchEntities(new Point(x, y)));
        this.pop.show(this, x, y);
    }

    protected JPopupMenu addTestNodeItems(JPopupMenu pop) {
        pop.add(this.newMenuItem("View Node Information", this));
        pop.add(this.newMenuItem("View Mapped Test Examples", this));
        return pop;
    }

    protected JPopupMenu addNodeItems(JPopupMenu pop, dTreeNode node) {
        pop.removeAll();
        pop.setBorder(BorderFactory.createTitledBorder("Node Options"));
        pop.add(this.newMenuItem("View Node Information of Node", "View Node Information", this));
        pop.add(this.newMenuItem("View Mapped Examples of Node", "View Mapped Examples", this));
        pop.add(this.newMenuItem("Toggle Histogram of Node", "Toggle Histogram", this));
        if (node.color == Color.blue) {
            pop.add(this.newMenuItem("Split Node", this));
        }
        return pop;
    }

    protected JPopupMenu addTestCanvasItems(JPopupMenu pop) {
        JRadioButtonMenuItem pan;
        JRadioButtonMenuItem zoom;
        pop.removeAll();
        pop.add(this.newMenuItem("View/Edit Examples", (dTreeWindow)this.parent));
        pop.add(this.newMenuItem("Step", (dTreeWindow)this.parent));
        JMenuItem mItemAuto = this.newMenuItem("Auto Create", (dTreeWindow)this.parent);
        JMenuItem mItemStop = this.newMenuItem("Stop", (dTreeWindow)this.parent);
        boolean isAutoCreateRunning = ((dTreeWindow)this.parent).autoCreate != null && ((dTreeWindow)this.parent).autoCreate.isRunning();
        mItemAuto.setEnabled(!isAutoCreateRunning);
        mItemStop.setEnabled(isAutoCreateRunning);
        pop.add(mItemAuto);
        pop.add(mItemStop);
        pop.add(this.newMenuItem("Reset Graph", (dTreeWindow)this.parent));
        pop.add(this.newMenuItem("Show Plot", (dTreeWindow)this.parent));
        pop.add(this.newMenuItem("Test", (dTreeWindow)this.parent));
        pop.add(this.newMenuItem("Test New Example", (dTreeWindow)this.parent));
        pop.addSeparator();
        pop.add(new JLabel("View Options"));
        pop.add(this.newMenuItem("Autoscale", (dTreeWindow)this.parent));
        JMenu zp = new JMenu("Pan/Zoom");
        ButtonGroup zpGroup = new ButtonGroup();
        if (this.getRMode() == 4441) {
            zoom = new JRadioButtonMenuItem("Zoom", true);
            pan = new JRadioButtonMenuItem("Pan", false);
        } else {
            zoom = new JRadioButtonMenuItem("Zoom", false);
            pan = new JRadioButtonMenuItem("Pan", true);
        }
        zoom.setToolTipText("Zoom into certain area of graph");
        zoom.addActionListener((dTreeWindow)this.parent);
        zpGroup.add(zoom);
        zp.add(zoom);
        pan.setToolTipText("Pan the graph to a different area on the canvas");
        pan.addActionListener((dTreeWindow)this.parent);
        zp.add(pan);
        zpGroup.add(pan);
        pop.add(zp);
        return pop;
    }

    protected JMenuItem newMenuItem(String label, String actionCommand, ActionListener listener) {
        JMenuItem mItem = new JMenuItem(label);
        mItem.setActionCommand(actionCommand);
        mItem.addActionListener(listener);
        return mItem;
    }

    protected JMenuItem newMenuItem(String label, ActionListener listener) {
        return this.newMenuItem(label, label, listener);
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        Point min = this.graph.getBound()[0];
        Point max = this.graph.getBound()[1];
        float midX = Math.abs(max.x - min.x) / 2.0f + min.x;
        float midY = Math.abs(max.y - min.y) / 2.0f + min.y;
        float graphScale = this.graph.getScale();
        this.zoomForPrinting();
        this.drawPrint((Graphics2D)g);
        this.graph.setScale(graphScale);
        this.moveGraphToPoint(new Point(midX, midY));
        return 0;
    }

    public void reset() {
        boolean minExampleStoppingCondition = ((dTreeGraph)this.graph).isMinExampleCountEnabled();
        boolean minInfoGainStoppingCondition = ((dTreeGraph)this.graph).isMinInfoGainEnabled();
        boolean maxDepthStoppingCondition = ((dTreeGraph)this.graph).isMaxDepthEnabled();
        int minExample = ((dTreeGraph)this.graph).getMinExampleCount();
        double minInfoGain = ((dTreeGraph)this.graph).getMinInfoGain();
        int maxDepth = ((dTreeGraph)this.graph).getMaxDepth();
        super.reset();
        this.graph = !this.inline ? new dTreeGraph(this, ((dTreeWindow)this.parent).exampleList) : new dTreeGraph(this, ((InlineDTreeApplet)this.parent).exampleList);
        ((dTreeGraph)this.graph).setLineWidth(((dTreeGraph)this.graph).getLineWidth());
        ((dTreeGraph)this.graph).setMinExampleCountEnabled(minExampleStoppingCondition);
        ((dTreeGraph)this.graph).setMinInfoGainEnabled(minInfoGainStoppingCondition);
        ((dTreeGraph)this.graph).setMaxDepthEnabled(maxDepthStoppingCondition);
        ((dTreeGraph)this.graph).setMinExampleCount(minExample);
        ((dTreeGraph)this.graph).setMinInfoGain(minInfoGain);
        ((dTreeGraph)this.graph).setMaxDepth(maxDepth);
        if (this.inline) {
            if (((InlineDTreeApplet)this.parent).plotWindow != null) {
                ((InlineDTreeApplet)this.parent).plotWindow.clear();
                ((dTreeGraph)this.graph).clearPlotPts();
                ((InlineDTreeApplet)this.parent).plotWindow.setGraph((dTreeGraph)this.graph);
                ((dTreeGraph)this.graph).updatePlot();
            }
        } else if (((dTreeWindow)this.parent).plotWindow != null) {
            ((dTreeWindow)this.parent).plotWindow.clear();
            ((dTreeGraph)this.graph).clearPlotPts();
            ((dTreeWindow)this.parent).plotWindow.setGraph((dTreeGraph)this.graph);
            ((dTreeGraph)this.graph).updatePlot();
        }
        this.repaint();
    }

    protected void aPerformed(ActionEvent e) {
        super.aPerformed(e);
        String arg = e.getActionCommand();
        System.out.println(arg);
        ExampleList eList = this.inline ? ((InlineDTreeApplet)this.parent).exampleList : ((dTreeWindow)this.parent).exampleList;
        dTreeNode N = (dTreeNode)this.entClicked;
        int i = 0;
        while (i < N.getInIndices().size()) {
            int j = N.getInIndices().get(i);
            if (arg.equals(eList.parameters[j])) {
                ((dTreeGraph)this.graph).split(N, j);
                break;
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("View Mapped Training Examples")) {
            this.showMapped((dTreeNode)this.entClicked);
        } else if (arg.equals("View Mapped Test Examples")) {
            this.showTestLeafExamples((dTreeNode)this.entClicked);
        } else if (arg.equals("View Node Information")) {
            if (this.inline) {
                new NodeInformationDialog(null, (dTreeNode)this.entClicked);
            } else {
                new NodeInformationDialog((dTreeWindow)this.parent, (dTreeNode)this.entClicked);
            }
        } else if (arg.equals("Split Node")) {
            if (this.inline) {
                new SplitDialog((InlineDTreeApplet)this.parent, (dTreeNode)this.entClicked, "Split Node");
            } else {
                new SplitDialog((Container)((dTreeWindow)this.parent), (dTreeNode)this.entClicked, "Split Node");
            }
        } else if (arg.equals("View Node Information")) {
            this.nodeAction(11, this.entClicked);
        } else if (arg.equals("View Mapped Examples")) {
            this.nodeAction(12, this.entClicked);
        } else if (arg.equals("Split Node")) {
            this.nodeAction(13, this.entClicked);
        } else if (arg.equals("Toggle Histogram")) {
            this.nodeAction(15, this.entClicked);
        } else {
            super.aPerformed(e);
        }
    }

    protected void showTestLeafExamples(dTreeNode N) {
        ((dTreeGraph)this.graph).mapAllTestExamples();
        this.testLeafDisplay = new ExampleDisplayDialog(this.parent, "Inspect Mapped Examples");
        this.testLeafDisplay.loadMappedExamples(N.getExampleIndices());
        this.testLeafDisplay.loadCorrectExamples(N.getCorrectTestIndices());
        this.testLeafDisplay.loadNoPredictionExamples(N.getNoPredictionTestIndices());
        this.testLeafDisplay.loadIncorrectExamples(N.getIncorrectTestIndices());
        this.testLeafDisplay.open();
    }

    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        Entity ent = this.graph.searchEntities(new Point(e.getX(), e.getY()));
        if (ent != null && ent.type == 7770 && e.getModifiers() != 4) {
            this.pause();
            dTreeNode clickedNode = (dTreeNode)ent;
            switch (((dTreeGraph)this.graph).getSolveGraphMode()) {
                case 10: {
                    break;
                }
                case 11: {
                    if (this.inline) {
                        new NodeInformationDialog(null, (dTreeNode)ent);
                        break;
                    }
                    new NodeInformationDialog((dTreeWindow)this.parent, (dTreeNode)ent);
                    break;
                }
                case 12: {
                    this.showTestLeafExamples(clickedNode);
                    break;
                }
                case 13: {
                    if (((dTreeNode)ent).getType() != "SPLIT") break;
                    if (this.inline) {
                        new SplitDialog((InlineDTreeApplet)this.parent, (dTreeNode)ent, "Split Node");
                        break;
                    }
                    new SplitDialog((Container)((dTreeWindow)this.parent), (dTreeNode)ent, "Split Node");
                    break;
                }
                case 15: {
                    ((dTreeNode)ent).toggleHistogramView();
                }
            }
            this.unpause();
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        Entity ent = this.graph.searchEntities(new Point(e.getX(), e.getY()));
        if (e.getModifiers() == 4) {
            return;
        }
        if (ent == null || ent.type != 7770) {
            return;
        }
        if (this.mode == 2221 && this.submode == 3338) {
            this.isSelected = this.graph.deselectAll();
            this.isSelected = this.graph.select(ent);
            ArrayList<dTreeNode> descendents = ((dTreeNode)ent).getAllDescendents();
            int i = 0;
            while (i < descendents.size()) {
                this.graph.select(descendents.get(i));
                ++i;
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (this.mode == 2221 && this.submode == 3338 && this.hover != null && this.hover instanceof dTreeNode) {
            ArrayList<dTreeNode> descendents = ((dTreeNode)this.hover).getAllDescendents();
            int i = 0;
            while (i < descendents.size()) {
                descendents.get(i).updatePosition();
                ++i;
            }
        }
    }

    public Entity nodeAction(int tempMode, Entity ent) {
        block14: {
            block16: {
                block15: {
                    if (ent == null || ent.type != 7770) break block14;
                    this.pause();
                    if (this.getMode() != 2220) break block15;
                    switch (tempMode) {
                        case 10: {
                            break;
                        }
                        case 11: {
                            new NodeInformationDialog((dTreeWindow)this.parent, (dTreeNode)ent);
                            break;
                        }
                        case 12: {
                            this.showMapped((dTreeNode)ent);
                            break;
                        }
                        case 13: {
                            if (((dTreeNode)ent).getType().equals("SPLIT")) {
                                new SplitDialog((Container)((dTreeWindow)this.parent), (dTreeNode)ent, "Split Node");
                                break;
                            }
                            break block16;
                        }
                        case 15: {
                            ((dTreeNode)ent).toggleHistogramView();
                        }
                    }
                    break block16;
                }
                switch (tempMode) {
                    case 10: {
                        break;
                    }
                    case 11: {
                        new NodeInformationDialog((dTreeWindow)this.parent, (dTreeNode)ent);
                        break;
                    }
                    case 12: {
                        this.showTestLeafExamples((dTreeNode)ent);
                        break;
                    }
                    case 15: {
                        ((dTreeNode)ent).toggleHistogramView();
                    }
                }
            }
            this.unpause();
        }
        return ent;
    }

    protected void showMapped(dTreeNode clickedNode) {
        this.mappedExampleDisplay = new ExampleDisplayDialog((Container)((dTreeWindow)this.parent), "Examples Mapped to Selected Node");
        this.mappedExampleDisplay.loadMappedExamples(clickedNode.getExampleIndices());
        this.mappedExampleDisplay.open();
    }

    public void disposeWindows() {
        super.disposeWindows();
        if (this.mappedExampleDisplay != null) {
            this.mappedExampleDisplay.dispose();
        }
        if (this.testLeafDisplay != null) {
            this.testLeafDisplay.dispose();
        }
    }

    public boolean updateGraphFromText(String allText) {
        ((dTreeWindow)this.parent).load(new BufferedReader(new StringReader(allText)));
        this.autoscale();
        return true;
    }
}

