/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree;

import CIspace.dTree.ExampleList;
import CIspace.dTree.InlineDTreeApplet;
import CIspace.dTree.PlotFrame;
import CIspace.dTree.dTreeCanvas;
import CIspace.dTree.dTreeWindow;
import CIspace.dTree.elements.dTreeEdge;
import CIspace.dTree.elements.dTreeNode;
import CIspace.dTree.intList.IntList;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dTreeGraph
extends Graph {
    public static final int RANDOM = 1;
    public static final int INFO_GAIN = 2;
    public static final int GAIN_RATIO = 3;
    public static final int GINI = 4;
    public static final int ABS_ERR = 5;
    public static final int DIFF_ERR = 6;
    public static final int MOVE_NODE = 10;
    public static final int VIEW_NODE = 11;
    public static final int VIEW_MAPPED = 12;
    public static final int SPLIT_NODE = 13;
    public static final int SET_LEAF = 14;
    public static final int TOGGLE_HISTOGRAM = 15;
    public static final int CORRECT = 30;
    public static final int NO_PREDICTION = 31;
    public static final int INCORRECT = 32;
    public static final int PROPORTION_INCORRECT_ERROR = 100;
    public static final int SUM_ABS_VALUES_ERROR = 101;
    public static final int SUM_SQUARES_ABS_VALUES_ERROR = 102;
    public static final int PROBABILISTIC_LEAF_ERROR = 200;
    public static final int MODE_VALUE_LEAF_ERROR = 201;
    private int leafErrorType = 200;
    public static ExampleList exampleList;
    protected ArrayList<dTreeNode> nodesToSplit;
    protected static int solveGraphMode;
    protected static int splitMode;
    protected IntList xValsAbs;
    protected IntList yValsTrainingAbs;
    protected IntList yValsTestAbs;
    protected IntList xValsDifference;
    protected IntList yValsTrainingDifference;
    protected IntList yValsTestDifference;
    protected IntList xValsMode;
    protected IntList yValsTrainingMode;
    protected IntList yValsTestMode;
    protected Container window;
    protected int splitCount = 0;
    protected boolean minInfoGainEnabled = false;
    protected boolean minExampleCountEnabled = false;
    protected boolean maxDepthEnabled = false;
    protected double minInfoGain = 0.1;
    protected int minExampleCount = 3;
    private int maxDepth = 3;

    static {
        solveGraphMode = 11;
        splitMode = 2;
    }

    public dTreeGraph(dTreeCanvas canvas, ExampleList eList) {
        super(canvas);
        this.setLineWidth(1);
        exampleList = eList;
        this.window = canvas.parent;
        this.xValsAbs = new IntList();
        this.yValsTrainingAbs = new IntList();
        this.yValsTestAbs = new IntList();
        this.xValsDifference = new IntList();
        this.yValsTrainingDifference = new IntList();
        this.yValsTestDifference = new IntList();
        this.xValsMode = new IntList();
        this.yValsTrainingMode = new IntList();
        this.yValsTestMode = new IntList();
        if (eList.indices != null) {
            dTreeNode N = new dTreeNode(this, "SPLIT");
            N.pos = new Point(0.0f, -200.0f);
            N.color = Color.blue;
            int i = 0;
            while (i < eList.indices.length - 1) {
                N.addInIndex(i);
                ++i;
            }
            i = 0;
            while (i < eList.trainingData.size()) {
                N.addExample(i);
                ++i;
            }
            N.setOutValues();
            N.setOriginalOutsAndProbs();
            N.refreshHistogram();
            N.setType("SPLIT");
            if (!canvas.inline) {
                if (((dTreeWindow)canvas.parent).getShowHistograms()) {
                    N.toggleHistogramView();
                }
            } else if (((InlineDTreeApplet)canvas.parent).getShowHistograms()) {
                N.toggleHistogramView();
            }
            this.addNode(N);
            this.nodesToSplit = new ArrayList();
            this.nodesToSplit.add(N);
            N.updateSize();
        }
    }

    protected int getSplitIndex(dTreeNode node) {
        int index = -1;
        switch (splitMode) {
            case 1: {
                int i = (int)((double)node.getInIndices().size() * Math.random());
                index = node.getInIndices().get(i);
                break;
            }
            case 2: {
                double gain0 = 0.0;
                int ind = 0;
                int i = 0;
                while (i < node.getInIndices().size()) {
                    int j = node.getInIndices().get(i);
                    double gain = node.getEntropy() - this.getEntropy(node, j);
                    if (gain > gain0) {
                        gain0 = gain;
                        ind = i;
                    }
                    ++i;
                }
                index = node.getInIndices().get(ind);
                break;
            }
            case 3: {
                double gain0 = 0.0;
                int ind = 0;
                int i = 0;
                while (i < node.getInIndices().size()) {
                    int j = node.getInIndices().get(i);
                    double gain = (node.getEntropy() - this.getEntropy(node, j)) / (double)node.numInValues(j);
                    if (gain > gain0) {
                        gain0 = gain;
                        ind = i;
                    }
                    ++i;
                }
                index = node.getInIndices().get(ind);
                break;
            }
            case 4: {
                double gain0 = 0.0;
                int ind = 0;
                int i = 0;
                while (i < node.getInIndices().size()) {
                    int j = node.getInIndices().get(i);
                    double gain = (node.getGini() - this.getGini(node, j)) / (double)node.numInValues(j);
                    if (gain > gain0) {
                        gain0 = gain;
                        ind = i;
                    }
                    ++i;
                }
                index = node.getInIndices().get(ind);
            }
        }
        return index;
    }

    public double getGini(dTreeNode N, int ind) {
        double ent = 0.0;
        if (N.getOutValues().size() != 1) {
            int n = N.numInValues(ind);
            ArrayList<Integer> new_examples = new ArrayList<Integer>(N.getExampleIndices());
            int i = 0;
            while (i < n) {
                dTreeNode newNode = new dTreeNode(this);
                int j = new_examples.get(0);
                String v = exampleList.inValue(j, ind);
                int k = 0;
                while (k < new_examples.size()) {
                    j = new_examples.get(k);
                    if (v.equals(exampleList.inValue(j, ind))) {
                        newNode.getExampleIndices().add(new Integer(j));
                        new_examples.remove(k);
                        --k;
                    }
                    ++k;
                }
                newNode.setOutValues();
                ent += newNode.getGini() * (double)newNode.getNumExamples() / (double)N.getNumExamples();
                ++i;
            }
        }
        return ent;
    }

    public double getEntropy(dTreeNode N, int ind) {
        double ent = 0.0;
        if (N.getOutValues().size() != 1) {
            int n = N.numInValues(ind);
            ArrayList<Integer> new_examples = new ArrayList<Integer>(N.getExampleIndices());
            int i = 0;
            while (i < n) {
                dTreeNode newNode = new dTreeNode(this);
                int j = new_examples.get(0);
                String v = exampleList.inValue(j, ind);
                int k = 0;
                while (k < new_examples.size()) {
                    j = new_examples.get(k);
                    String s = exampleList.inValue(j, ind);
                    if (v.equals(s)) {
                        newNode.addExample(j);
                        new_examples.remove(k);
                        --k;
                    }
                    ++k;
                }
                newNode.setOutValues();
                ent += newNode.getEntropy() * (double)newNode.getNumExamples() / (double)N.getNumExamples();
                ++i;
            }
        }
        return ent;
    }

    public void step() {
        boolean stoppingConditionReached = false;
        if (this.nodesToSplit != null && this.nodesToSplit.size() > 0) {
            double infoGain;
            dTreeNode node = this.nodesToSplit.get(0);
            int splitParamIndex = this.getSplitIndex(node);
            if (this.isMinExampleCountEnabled() && !stoppingConditionReached && node.getNumExamples() < this.minExampleCount) {
                node.setAsLeaf();
                this.nodesToSplit.remove(node);
                stoppingConditionReached = true;
            }
            if (this.isMinInfoGainEnabled() && !stoppingConditionReached && (infoGain = node.getEntropy() - this.getEntropy(node, splitParamIndex)) < this.minInfoGain) {
                node.setAsLeaf();
                this.nodesToSplit.remove(node);
                stoppingConditionReached = true;
            }
            if (this.isMaxDepthEnabled() && !stoppingConditionReached && node.getDepth() >= this.maxDepth) {
                node.setAsLeaf();
                this.nodesToSplit.remove(node);
                stoppingConditionReached = true;
            }
            if (!stoppingConditionReached) {
                this.split(node, splitParamIndex);
                this.canvas.centerOverNode(node);
            }
        } else if (this.nodesToSplit != null && this.nodesToSplit.size() == 0) {
            this.showMessage("Tree Expansion Finished", "There are no more nodes to expand.");
        }
        this.canvas.repaint();
        try {
            ((dTreeWindow)this.window).setPromptLabel(((dTreeGraph)this.canvas.graph).getGraphStatsLabel());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String search(String[] values) {
        dTreeNode N = (dTreeNode)this.nodes.get(0);
        boolean found = true;
        block0: while (N.getType() == "NON_LEAF" && found) {
            int ind = -1;
            int i = 0;
            while (i < dTreeGraph.exampleList.parameters.length) {
                if (dTreeGraph.exampleList.parameters[i].equals(N.label[0])) {
                    ind = i;
                    break;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.edges.size()) {
                dTreeEdge E = (dTreeEdge)this.edges.get(i2);
                if (E.start == N && E.label[0].equals(values[ind])) {
                    N = (dTreeNode)E.end;
                    found = true;
                    continue block0;
                }
                found = false;
                ++i2;
            }
        }
        if (found && N.getType() == "LEAF") {
            return N.label[0];
        }
        return "No Prediction";
    }

    public String getGraphStatsLabel() {
        return "Number of Nodes: " + this.nodes.size() + "     Number of Splits: " + this.splitCount + "     Maximum Depth: " + this.maxDepth();
    }

    public int maxDepth() {
        int max = 0;
        int i = 0;
        while (i < this.nodes.size()) {
            if (((dTreeNode)this.nodes.get(i)).getDepth() > max) {
                max = ((dTreeNode)this.nodes.get(i)).getDepth();
            }
            ++i;
        }
        return max;
    }

    public void setAllNodesLeaves() {
        while (this.nodesToSplit != null && this.nodesToSplit.size() > 0) {
            dTreeNode node = this.nodesToSplit.get(0);
            node.setAsLeaf();
            this.nodesToSplit.remove(node);
        }
    }

    public void removeSplitNode(dTreeNode node) {
        this.nodesToSplit.remove(node);
    }

    public void mapAllTestExamples() {
        Iterator nodeItr = this.nodes.iterator();
        while (nodeItr.hasNext()) {
            ((dTreeNode)nodeItr.next()).clearTestMappings();
        }
        int i = 0;
        while (i < dTreeGraph.exampleList.testData.size()) {
            this.mapTestExample(i);
            ++i;
        }
    }

    private void mapTestExample(int testExampleIndex) {
        Hashtable<Integer, String> testExample = exampleList.getTestArrayList().get(testExampleIndex);
        dTreeNode N = (dTreeNode)this.nodes.get(0);
        boolean found = true;
        String[] values = new String[exampleList.getNumParameters() - 1];
        int i = 0;
        while (i < values.length) {
            values[i] = testExample.get(new Integer(i));
            ++i;
        }
        block1: while (N.getType() == "NON_LEAF" && found) {
            int ind = -1;
            int i2 = 0;
            while (i2 < dTreeGraph.exampleList.parameters.length) {
                if (dTreeGraph.exampleList.parameters[i2].equals(N.label[0])) {
                    ind = i2;
                    break;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.edges.size()) {
                dTreeEdge E = (dTreeEdge)this.edges.get(i3);
                if (E.start == N && E.label[0].equals(values[ind])) {
                    N = (dTreeNode)E.end;
                    found = true;
                    continue block1;
                }
                found = false;
                ++i3;
            }
        }
        if (found && N.getType() == "LEAF") {
            if (N.label[0].equals(testExample.get(new Integer(exampleList.getNumParameters() - 1)))) {
                N.correct_test_indices.add(new Integer(testExampleIndex));
            } else {
                N.incorrect_test_indices.add(new Integer(testExampleIndex));
            }
        } else {
            N.noPrediction_test_indices.add(new Integer(testExampleIndex));
        }
    }

    public void auto() {
        while (this.autoCreateContinue()) {
            this.step();
        }
    }

    public void split(dTreeNode node, int ind) {
        ++this.splitCount;
        boolean nodeState = node.isHistogramViewOn();
        node.showHistogramView(true);
        int height = node.height;
        node.showHistogramView(nodeState);
        if (node.getOutValues().size() == 1) {
            int j = node.getExampleIndices().get(0);
            String s = exampleList.outValue(j);
            node.setType("LEAF");
            node.setLabel(s);
            node.updateSize();
            this.nodesToSplit.remove(node);
        } else {
            node.setType("NON_LEAF");
            node.setLabel(dTreeGraph.exampleList.parameters[ind]);
            ArrayList<Integer> new_parameters = new ArrayList<Integer>(node.getInIndices());
            new_parameters.remove(new Integer(ind));
            node.updateSize();
            node.setInIndices(null);
            this.nodesToSplit.remove(node);
            ArrayList<Integer> new_examples = new ArrayList<Integer>(node.getExampleIndices());
            int n = node.numInValues(ind);
            int i = 0;
            while (i < n) {
                dTreeNode newNode = new dTreeNode(this);
                newNode.setScreenWidth(node.getScreenWidth() / 2);
                newNode.setDepth(node.getDepth() + 1);
                newNode.setOriginalOutValues(node.getOriginalOutValues());
                newNode.setOriginalProbs(node.getOriginalProbs());
                int j = new_examples.get(0);
                String v = exampleList.inValue(j, ind);
                int k = 0;
                while (k < new_examples.size()) {
                    j = new_examples.get(k);
                    String s = exampleList.inValue(j, ind);
                    if (v.equals(s)) {
                        newNode.addExample(j);
                        new_examples.remove(k--);
                    }
                    ++k;
                }
                newNode.setOutValues();
                if (newNode.getExampleIndices().size() > 0) {
                    if (newNode.getOutValues().size() == 1) {
                        newNode.setType("LEAF");
                        j = newNode.getExampleIndices().get(0);
                        String s = exampleList.outValue(j);
                        newNode.setLabel(s);
                    } else if (new_parameters.size() == 0) {
                        newNode.setType("INCONSISTENT");
                    } else if (new_parameters.size() > 0) {
                        newNode.setType("SPLIT");
                        newNode.setInIndices(new_parameters);
                        this.nodesToSplit.add(newNode);
                    }
                    newNode.updateSize();
                    int h = height + 50;
                    int a = (-(n - 1) + 2 * i) * newNode.getScreenWidth() / n;
                    newNode.pos = new Point(node.pos.x + (float)a, node.pos.y + (float)h);
                    this.addNode(newNode);
                    dTreeEdge newEdge = new dTreeEdge(this, node, newNode, v);
                    this.addEdge(newEdge);
                }
                node.addChild(newNode);
                node.refreshHistogram();
                newNode.refreshHistogram();
                node.updateBounds();
                if (this.canvas.inline) {
                    if (((InlineDTreeApplet)this.window).getShowHistograms()) {
                        newNode.toggleHistogramView();
                    }
                } else if (((dTreeWindow)this.window).getShowHistograms()) {
                    newNode.toggleHistogramView();
                }
                ++i;
            }
        }
        this.updatePlot();
        this.repaint();
    }

    public void updatePlot() {
        if (this.canvas.inline) {
            if (((InlineDTreeApplet)this.window).plotWindow != null) {
                this.leafErrorType = 201;
                this.addPointMode(this.splitCount, this.getProbabilisticErrorAbs(true), this.getProbabilisticErrorAbs(false));
                this.leafErrorType = 200;
                this.addPointAbs(this.splitCount, this.getProbabilisticErrorAbs(true), this.getProbabilisticErrorAbs(false));
                this.addPointDifference(this.splitCount, this.getProbabilisticErrorDifference(true), this.getProbabilisticErrorDifference(false));
                ((InlineDTreeApplet)this.window).plotWindow.repaint();
            }
        } else if (((dTreeWindow)this.window).plotWindow != null) {
            this.leafErrorType = 201;
            this.addPointMode(this.splitCount, this.getProbabilisticErrorAbs(true), this.getProbabilisticErrorAbs(false));
            this.leafErrorType = 200;
            this.addPointAbs(this.splitCount, this.getProbabilisticErrorAbs(true), this.getProbabilisticErrorAbs(false));
            this.addPointDifference(this.splitCount, this.getProbabilisticErrorDifference(true), this.getProbabilisticErrorDifference(false));
            ((dTreeWindow)this.window).plotWindow.repaint();
        }
    }

    public void showPlot() {
        if (((dTreeWindow)this.window).plotWindow == null) {
            ((dTreeWindow)this.window).plotWindow = new PlotFrame(this);
        }
        ((dTreeWindow)this.window).plotWindow.open();
    }

    public double getProbabilisticNodeErrorDifference(dTreeNode node, boolean useTrainingSet) {
        ArrayList<Hashtable<Integer, String>> exampleArrayList;
        ArrayList<Integer> exampleIndices;
        if (useTrainingSet && node.getTrainingSetError() != -1.0) {
            return node.getTrainingSetError();
        }
        if (!useTrainingSet && node.getTestSetError() != -1.0) {
            return node.getTestSetError();
        }
        double leafError = 0.0;
        this.mapAllTestExamples();
        if (useTrainingSet) {
            exampleIndices = node.getTrainingExampleIndices();
            exampleArrayList = exampleList.getTrainingArrayList();
        } else {
            exampleIndices = node.getTestExampleIndices();
            exampleArrayList = exampleList.getTestArrayList();
        }
        int i = 0;
        while (i < exampleIndices.size()) {
            Hashtable<Integer, String> oneExample = exampleArrayList.get(exampleIndices.get(i));
            double exampleError = 0.0;
            int j = 0;
            while (j < node.getOriginalOutValues().size()) {
                double predictedProb = node.getOriginalProbs()[j] / (double)node.getNumExamples();
                double observedProb = 0.0;
                String currOutputString = node.getOriginalOutValues().get(j);
                String actualResultString = oneExample.get(new Integer(exampleList.getNumParameters() - 1));
                observedProb = actualResultString.equals(currOutputString) ? 1.0 : 0.0;
                exampleError += Math.abs(predictedProb - observedProb);
                ++j;
            }
            leafError += Math.pow(exampleError / 2.0, 2.0);
            ++i;
        }
        if (node.getType() == "LEAF") {
            if (useTrainingSet) {
                node.setTrainingSetError(leafError);
            } else {
                node.setTestSetError(leafError);
            }
        }
        return leafError;
    }

    private int getProbabilisticErrorAbs(boolean useTrainingSet) {
        double totalError = 0.0;
        int numExamples = useTrainingSet ? exampleList.getTrainingArrayList().size() : exampleList.getTestArrayList().size();
        if (numExamples == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.nodes.size()) {
            dTreeNode node = (dTreeNode)this.nodes.get(i);
            if (node.getType() == "LEAF" || node.getType() == "SPLIT") {
                totalError += this.getProbabilisticNodeErrorAbs(node, useTrainingSet);
            }
            ++i;
        }
        return (int)(totalError * 100.0);
    }

    private int getProbabilisticErrorDifference(boolean useTrainingSet) {
        double totalError = 0.0;
        int numExamples = useTrainingSet ? exampleList.getTrainingArrayList().size() : exampleList.getTestArrayList().size();
        if (numExamples == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.nodes.size()) {
            dTreeNode node = (dTreeNode)this.nodes.get(i);
            if (node.getType() == "LEAF" || node.getType() == "SPLIT") {
                totalError += this.getProbabilisticNodeErrorDifference(node, useTrainingSet);
            }
            ++i;
        }
        return (int)(totalError * 100.0);
    }

    public double getProbabilisticNodeErrorAbs(dTreeNode node, boolean useTrainingSet) {
        ArrayList<Hashtable<Integer, String>> exampleArrayList;
        ArrayList<Integer> exampleIndices;
        if (useTrainingSet && node.getTrainingSetError() != -1.0) {
            return node.getTrainingSetError();
        }
        if (!useTrainingSet && node.getTestSetError() != -1.0) {
            return node.getTestSetError();
        }
        double leafError = 0.0;
        this.mapAllTestExamples();
        if (useTrainingSet) {
            exampleIndices = node.getTrainingExampleIndices();
            exampleArrayList = exampleList.getTrainingArrayList();
        } else {
            exampleIndices = node.getTestExampleIndices();
            exampleArrayList = exampleList.getTestArrayList();
        }
        int i = 0;
        while (i < exampleIndices.size()) {
            Hashtable<Integer, String> oneExample = exampleArrayList.get(exampleIndices.get(i));
            leafError += this.getExampleError(node, oneExample);
            ++i;
        }
        if (node.getType() == "LEAF") {
            if (useTrainingSet) {
                node.setTrainingSetError(leafError);
            } else {
                node.setTestSetError(leafError);
            }
        }
        return leafError;
    }

    protected double getExampleError(dTreeNode node, Hashtable exampleHash) {
        double exampleError = 0.0;
        int i = 0;
        while (i < node.getOriginalOutValues().size()) {
            double predictedProb = node.getOriginalProbs()[i] / (double)node.getNumExamples();
            double observedProb = 0.0;
            String currOutputString = node.getOriginalOutValues().get(i);
            String actualResultString = (String)exampleHash.get(new Integer(exampleList.getNumParameters() - 1));
            observedProb = actualResultString.equals(currOutputString) ? 1.0 : 0.0;
            if (this.leafErrorType == 201) {
                predictedProb = currOutputString.equals(node.getModeOutputValue()) ? 1.0 : 0.0;
            }
            exampleError += Math.abs(predictedProb - observedProb);
            ++i;
        }
        return exampleError / 2.0;
    }

    public ArrayList<Integer> getTestExampleIndices(int category) {
        ArrayList<Integer> resultIndices = new ArrayList<Integer>();
        ArrayList<Integer> currNodeIndices = null;
        int i = 0;
        while (i < this.nodes.size()) {
            if (category == 30) {
                currNodeIndices = ((dTreeNode)this.nodes.get((int)i)).correct_test_indices;
            } else if (category == 31) {
                currNodeIndices = ((dTreeNode)this.nodes.get((int)i)).noPrediction_test_indices;
            } else if (category == 32) {
                currNodeIndices = ((dTreeNode)this.nodes.get((int)i)).incorrect_test_indices;
            }
            int j = 0;
            while (j < currNodeIndices.size()) {
                resultIndices.add(currNodeIndices.get(j));
                ++j;
            }
            ++i;
        }
        return resultIndices;
    }

    public ArrayList getProbabilisticTestResults() {
        ArrayList<Hashtable<Integer, String>> resultData = new ArrayList<Hashtable<Integer, String>>();
        ArrayList<Hashtable<Integer, String>> examples = dTreeGraph.exampleList.testData;
        this.mapAllTestExamples();
        int i = 0;
        while (i < this.nodes.size()) {
            dTreeNode currNode = (dTreeNode)this.nodes.get(i);
            ArrayList<Integer> currNodeExamples = currNode.getTestExampleIndices();
            int j = 0;
            while (j < currNodeExamples.size()) {
                Hashtable<Integer, String> currExampleHash = examples.get(currNodeExamples.get(j));
                int k = 0;
                while (k < currNode.getOriginalOutValues().size()) {
                    String currOutValueKey = new String(currNode.getOriginalOutValues().get(k));
                    double currOutValueValue = currNode.getOriginalProbs()[k] / (double)currNode.getNumExamples();
                    currExampleHash.put((Integer)((Object)currOutValueKey), (String)((Object)new Double(currOutValueValue)));
                    ++k;
                }
                double error = this.getExampleError(currNode, currExampleHash);
                currExampleHash.put((Integer)((Object)"error"), (String)((Object)new Double(error)));
                currExampleHash.put((Integer)((Object)"squaredError"), (String)((Object)new Double(Math.pow(error, 2.0))));
                resultData.add(currExampleHash);
                ++j;
            }
            ++i;
        }
        return resultData;
    }

    public ArrayList<String> getOutputValues() {
        if (this.nodes.size() == 0) {
            return new ArrayList<String>();
        }
        dTreeNode node = (dTreeNode)this.nodes.get(0);
        return new ArrayList<String>(node.getOriginalOutValues());
    }

    private void addPointMode(int x, int yTraining, int yTest) {
        this.xValsMode.add(x);
        this.yValsTrainingMode.add(yTraining);
        this.yValsTestMode.add(yTest);
    }

    public IntList[] getPlotValsMode() {
        IntList[] plotVals = new IntList[]{this.xValsMode, this.yValsTrainingMode};
        return plotVals;
    }

    public IntList[] getTestPlotValsMode() {
        IntList[] plotVals = new IntList[]{this.xValsMode, this.yValsTestMode};
        return plotVals;
    }

    private void addPointAbs(int x, int yTraining, int yTest) {
        this.xValsAbs.add(x);
        this.yValsTrainingAbs.add(yTraining);
        this.yValsTestAbs.add(yTest);
    }

    public IntList[] getPlotValsAbs() {
        IntList[] plotVals = new IntList[]{this.xValsAbs, this.yValsTrainingAbs};
        return plotVals;
    }

    public IntList[] getTestPlotValsAbs() {
        IntList[] plotVals = new IntList[]{this.xValsAbs, this.yValsTestAbs};
        return plotVals;
    }

    private void addPointDifference(int x, int yTraining, int yTest) {
        this.xValsDifference.add(x);
        this.yValsTrainingDifference.add(yTraining);
        this.yValsTestDifference.add(yTest);
    }

    public IntList[] getPlotValsDifference() {
        IntList[] plotVals = new IntList[]{this.xValsDifference, this.yValsTrainingDifference};
        return plotVals;
    }

    public IntList[] getTestPlotValsDifference() {
        IntList[] plotVals = new IntList[]{this.xValsDifference, this.yValsTestDifference};
        return plotVals;
    }

    public void clearPlotPts() {
        this.xValsAbs = new IntList();
        this.yValsTrainingAbs = new IntList();
        this.yValsTestAbs = new IntList();
        this.xValsDifference = new IntList();
        this.yValsTrainingDifference = new IntList();
        this.yValsTestDifference = new IntList();
    }

    public boolean autoCreateContinue() {
        return this.nodesToSplit != null && this.nodesToSplit.size() > 0;
    }

    public boolean isMinInfoGainEnabled() {
        return this.minInfoGainEnabled;
    }

    public boolean isMinExampleCountEnabled() {
        return this.minExampleCountEnabled;
    }

    public void setMinInfoGainEnabled(boolean enable) {
        this.minInfoGainEnabled = enable;
    }

    public void setMinExampleCountEnabled(boolean enable) {
        this.minExampleCountEnabled = enable;
    }

    public void setMaxDepthEnabled(boolean enable) {
        this.maxDepthEnabled = enable;
    }

    public boolean isMaxDepthEnabled() {
        return this.maxDepthEnabled;
    }

    public void setMinInfoGain(double minInfoGain) {
        this.minInfoGain = minInfoGain;
    }

    public double getMinInfoGain() {
        return this.minInfoGain;
    }

    public void setMinExampleCount(int minExampleCount) {
        this.minExampleCount = minExampleCount;
    }

    public int getMinExampleCount() {
        return this.minExampleCount;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setSolveGraphMode(int newMode) {
        solveGraphMode = newMode;
    }

    public int getSolveGraphMode() {
        return solveGraphMode;
    }

    public void setLeafErrorType(int leafErrorType) {
        this.leafErrorType = leafErrorType;
        for (dTreeNode curNode : this.nodes) {
            curNode.setTestSetError(-1.0);
            curNode.setTrainingSetError(-1.0);
        }
    }

    public int getLeafErrorType() {
        return this.leafErrorType;
    }
}

