/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree.dialogs;

import CIspace.dTree.InlineDTreeApplet;
import CIspace.dTree.dTreeGraph;
import CIspace.dTree.dTreeWindow;
import CIspace.dTree.dialogs.ExampleDialog;
import CIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputExampleDialog
extends BasicDialog {
    public static final int TRAINING_ADD = 0;
    public static final int TEST_ADD = 1;
    public static final int TEST_CALCULATE = 2;
    public static final int TEST_VERIFY = 3;
    public static final int TRAINING_EDIT = 4;
    public static final int TEST_EDIT = 5;
    private JLabel[] labelInputs;
    private JTextField[] textInputs;
    private Integer[] indexInputs;
    private JLabel labelOutput;
    private JTextField textOutput;
    private Integer indexOutput;
    private JLabel labelError;
    private Container window;
    private ExampleDialog dialog;
    private int numInputs;
    private boolean inline;
    protected int mode;

    public InputExampleDialog(Container parent, ExampleDialog dialogParent, String title) {
        super((JFrame)(parent instanceof dTreeWindow ? (dTreeWindow)parent : null), title, true);
        if (title == "Input Training Examples") {
            this.mode = 0;
        } else if (title == "Input Test Examples") {
            this.mode = 1;
        } else if (title == "Calculate Test Value") {
            this.mode = 2;
        } else if (title == "Verify Test Value") {
            this.mode = 3;
        } else if (title == "Edit Training Example") {
            this.mode = 4;
        } else if (title == "Edit Test Example") {
            this.mode = 5;
        }
        this.window = parent;
        this.inline = !(this.window instanceof dTreeWindow);
        this.dialog = dialogParent;
        this.numInputs = this.inline ? ((InlineDTreeApplet)this.window).exampleList.getNumParameters() - 1 : ((dTreeWindow)this.window).exampleList.getNumParameters() - 1;
        if (this.numInputs > 0) {
            this.labelInputs = new JLabel[this.numInputs];
            this.textInputs = new JTextField[this.numInputs];
            this.indexInputs = new Integer[this.numInputs];
        }
        this.labelOutput = new JLabel();
        this.textOutput = new JTextField();
        int exampleIndex = -1;
        Hashtable<Integer, String> oneExample = null;
        if (this.mode == 4) {
            exampleIndex = this.dialog.getTrainingList().getSelectedIndices()[0];
            oneExample = this.inline ? ((InlineDTreeApplet)this.window).exampleList.getTrainingExampleValues(exampleIndex - 1) : ((dTreeWindow)this.window).exampleList.getTrainingExampleValues(exampleIndex - 1);
        } else if (this.mode == 5) {
            exampleIndex = this.dialog.getTestList().getSelectedIndices()[0];
            oneExample = this.inline ? ((InlineDTreeApplet)this.window).exampleList.getTestExampleValues(exampleIndex - 1) : ((dTreeWindow)this.window).exampleList.getTestExampleValues(exampleIndex - 1);
        }
        int i = 0;
        while (i < this.numInputs) {
            this.labelInputs[i] = this.inline ? new JLabel(((InlineDTreeApplet)this.window).exampleList.getParameters()[i]) : new JLabel(((dTreeWindow)this.window).exampleList.getParameters()[i]);
            this.textInputs[i] = exampleIndex != -1 ? new JTextField(oneExample.get(new Integer(i)), 20) : new JTextField("", 20);
            this.indexInputs[i] = new Integer(i);
            ++i;
        }
        String s = this.numInputs > 0 ? (this.inline ? ((InlineDTreeApplet)this.window).exampleList.getParameters()[this.numInputs] : ((dTreeWindow)this.window).exampleList.getParameters()[this.numInputs]) : "";
        this.labelOutput = this.mode != 3 ? new JLabel(s) : new JLabel(String.valueOf(s) + ": \t\t\tPredicted value");
        this.textOutput = exampleIndex != -1 ? new JTextField(oneExample.get(new Integer(this.numInputs)), 20) : new JTextField("", 20);
        this.indexOutput = new Integer(this.numInputs);
        JButton button2 = this.mode == 0 || this.mode == 1 ? new JButton("Add") : (this.mode == 4 || this.mode == 5 ? new JButton("Update") : new JButton("Calculate"));
        button2.addActionListener(this);
        JButton button1 = new JButton("Cancel");
        button1.addActionListener(this);
        this.labelError = new JLabel("");
        JPanel p = new JPanel();
        if (this.mode == 3) {
            p.setLayout(new GridLayout(this.numInputs + 5, 2));
        } else {
            p.setLayout(new GridLayout(this.numInputs + 4, 2));
        }
        p.add(new JLabel(" \tInput Values:"));
        p.add(new JLabel(""));
        int i2 = 0;
        while (i2 < this.numInputs) {
            p.add(this.labelInputs[i2]);
            p.add(this.textInputs[i2]);
            ++i2;
        }
        p.add(new JLabel(" \tOutput Value:"));
        p.add(new JLabel(""));
        p.add(this.labelOutput);
        p.add(this.textOutput);
        if (this.mode == 2) {
            this.textOutput.setText("");
            this.textOutput.setEditable(false);
        }
        if (this.mode != 3) {
            p.add(button2);
        }
        p.add(button1);
        this.getContentPane().add(p);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private boolean parseData(Integer[] indices, String[] values) {
        try {
            boolean valuesOk = true;
            int i = 0;
            while (i < this.numInputs) {
                indices[i] = this.indexInputs[i];
                values[i] = this.textInputs[i].getText().trim();
                if (values[i].equals("")) {
                    valuesOk = false;
                }
                ++i;
            }
            indices[this.numInputs] = this.indexOutput;
            values[this.numInputs] = this.textOutput.getText().trim();
            if (values[this.numInputs].equals("")) {
                valuesOk = false;
            }
            if (!valuesOk) {
                this.labelError.setText("Error: Please enter all parameters.");
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Parameters have invalid real number format!");
            return false;
        }
    }

    public boolean setExample() {
        Integer[] indices = new Integer[this.numInputs + 1];
        String[] values = new String[this.numInputs + 1];
        if (!this.parseData(indices, values)) {
            return false;
        }
        if (this.inline) {
            if (this.mode == 0) {
                ((InlineDTreeApplet)this.window).exampleList.addTrainingExample(indices, values);
            } else if (this.mode == 1) {
                ((InlineDTreeApplet)this.window).exampleList.addTestExample(indices, values);
            }
        } else if (this.mode == 0) {
            ((dTreeWindow)this.window).exampleList.addTrainingExample(indices, values);
        } else if (this.mode == 1) {
            ((dTreeWindow)this.window).exampleList.addTestExample(indices, values);
        }
        return true;
    }

    public boolean updateExample() {
        Integer[] indices = new Integer[this.numInputs + 1];
        String[] values = new String[this.numInputs + 1];
        if (!this.parseData(indices, values)) {
            return false;
        }
        if (this.inline) {
            if (this.mode == 4) {
                int index = this.dialog.getTrainingList().getSelectedIndices()[0];
                ((InlineDTreeApplet)this.window).exampleList.updateTrainingExample(index - 1, indices, values);
            } else if (this.mode == 5) {
                int index = this.dialog.getTestList().getSelectedIndices()[0];
                ((InlineDTreeApplet)this.window).exampleList.updateTestExample(index - 1, indices, values);
            }
        } else if (this.mode == 4) {
            int index = this.dialog.getTrainingList().getSelectedIndices()[0];
            ((dTreeWindow)this.window).exampleList.updateTrainingExample(index - 1, indices, values);
        } else if (this.mode == 5) {
            int index = this.dialog.getTestList().getSelectedIndices()[0];
            ((dTreeWindow)this.window).exampleList.updateTestExample(index - 1, indices, values);
        }
        return true;
    }

    public void calculateOutput() {
        Integer[] indices = new Integer[this.numInputs + 1];
        String[] values = new String[this.numInputs + 1];
        int i = 0;
        while (i < this.numInputs) {
            indices[i] = this.indexInputs[i];
            values[i] = this.textInputs[i].getText();
            ++i;
        }
        if (this.inline) {
            this.textOutput.setText(((dTreeGraph)((InlineDTreeApplet)this.window).returnCanvas().graph).search(values));
        } else {
            this.textOutput.setText(((dTreeGraph)((dTreeWindow)this.window).returnCanvas().graph).search(values));
        }
    }

    protected boolean actionOK() {
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand() == "Add") {
            if (this.setExample()) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (e.getActionCommand() == "Update") {
            if (this.updateExample()) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (e.getActionCommand() == "Calculate") {
            this.labelError.setText("");
            this.calculateOutput();
        }
    }
}

