/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree.dialogs;

import CIspace.dTree.dTreeWindow;
import CIspace.dTree.elements.dTreeNode;
import CIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NodeInformationDialog
extends BasicDialog {
    protected dTreeWindow window;

    public NodeInformationDialog(dTreeWindow parent, dTreeNode node) {
        super((JFrame)parent, "Node Information", true);
        super.setCancelString("Close");
        this.window = parent;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(closeButton);
        this.getContentPane().add("South", buttonPanel);
        this.getContentPane().add("Center", this.makeInfoPanel(node));
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private JPanel makeInfoPanel(dTreeNode node) {
        JPanel infoPanel = new JPanel();
        DecimalFormat numFormat = new DecimalFormat("0.00;0.00");
        JLabel nodeNameTitle = node.getType() == "LEAF" ? new JLabel("Leaf Node Value:       ") : (node.getType() == "NON_LEAF" ? new JLabel("Split Attribute:         ") : new JLabel(""));
        this.addComponent(nodeNameTitle, infoPanel, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(new JLabel(node.getLabel()), infoPanel, 0, 1, 1, 1, 0.0, 0.0);
        if (this.window != null && this.window.returnCanvas().getMode() == 2220) {
            this.addComponent(new JLabel("Num. Mapped Training Examples:    "), infoPanel, 1, 0, 1, 1, 0.0, 0.0);
            this.addComponent(new JLabel(new Integer(node.getNumExamples()).toString()), infoPanel, 1, 1, 1, 1, 0.0, 0.0);
        } else {
            int exampleCount = node.getCorrectTestIndices().size() + node.getIncorrectTestIndices().size() + node.getNoPredictionTestIndices().size();
            this.addComponent(new JLabel("Num. Mapped Test Examples:    "), infoPanel, 1, 0, 1, 1, 0.0, 0.0);
            this.addComponent(new JLabel(String.valueOf(exampleCount)), infoPanel, 1, 1, 1, 1, 0.0, 0.0);
        }
        this.addComponent(new JLabel("Entropy:"), infoPanel, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(new JLabel(numFormat.format(node.getEntropy())), infoPanel, 2, 1, 1, 1, 0.0, 0.0);
        this.addComponent(new JLabel("Gini Index:"), infoPanel, 3, 0, 1, 1, 0.0, 0.0);
        this.addComponent(new JLabel(numFormat.format(node.getGini())), infoPanel, 3, 1, 1, 1, 0.0, 0.0);
        this.addComponent(new JLabel(""), infoPanel, 4, 0, 1, 1, 0.0, 0.0);
        this.addComponent(new JLabel(""), infoPanel, 4, 1, 1, 1, 0.0, 0.0);
        int i = 0;
        while (i < node.getOriginalOutValues().size()) {
            this.addComponent(new JLabel("Output Value " + node.getOriginalOutValues().get(i) + " count: "), infoPanel, i + 5, 0, 1, 1, 0.0, 0.0);
            this.addComponent(new JLabel(String.valueOf((int)node.getOriginalProbs()[i])), infoPanel, i + 5, 1, 1, 1, 0.0, 0.0);
            ++i;
        }
        if (node.getType() == "LEAF") {
            i = 0;
            while (i < node.getOriginalOutValues().size()) {
                this.addComponent(new JLabel(" Probability:      " + numFormat.format(node.getOriginalProbs()[i] / (double)node.getNumExamples())), infoPanel, i + 5, 2, 1, 1, 0.0, 0.0);
                ++i;
            }
        }
        infoPanel.setLayout(this.gbl);
        return infoPanel;
    }

    protected boolean actionOK() {
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }
}

