/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree.dialogs;

import CIspace.dTree.ExampleList;
import CIspace.dTree.InlineDTreeApplet;
import CIspace.dTree.dTreeWindow;
import CIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParameterInputDialog
extends BasicDialog {
    private Container window;
    private ExampleList eList;
    private JTextField promptText;

    public ParameterInputDialog(Container parent, ExampleList eList) {
        super((JFrame)(parent instanceof dTreeWindow ? (dTreeWindow)parent : null), "Data Set Parameter Input", true);
        this.window = parent;
        this.eList = eList;
        this.getContentPane().add((Component)this.constructTopPanel(), "North");
        this.getContentPane().add((Component)this.constructCenterPanel(), "Center");
        this.getContentPane().add((Component)this.constructBottomPanel(), "South");
        this.pack();
        this.centerWindow();
        this.promptText.requestFocus();
        this.setVisible(true);
    }

    private JPanel constructTopPanel() {
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add("North", new JLabel("Please enter the parameters for the new dataset."));
        topPanel.add("South", new JLabel("Separate each parameter with a comma and specify the output parameter last."));
        return topPanel;
    }

    private JPanel constructCenterPanel() {
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add("West", new JLabel("Parameters: "));
        this.promptText = new JTextField(50);
        centerPanel.add("East", this.promptText);
        return centerPanel;
    }

    private JPanel constructBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout());
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        bottomPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        bottomPanel.add(cancelButton);
        return bottomPanel;
    }

    protected boolean actionOK() {
        boolean isParsed;
        if (this.window instanceof dTreeWindow) {
            ((dTreeWindow)this.window).clear();
            isParsed = this.parseInput();
            ((dTreeWindow)this.window).updateTextRep();
        } else {
            ((InlineDTreeApplet)this.window).clear();
            isParsed = this.parseInput();
        }
        return isParsed;
    }

    protected boolean actionCancel() {
        return true;
    }

    private boolean parseInput() {
        ArrayList<String> parameters = new ArrayList<String>(5);
        StringTokenizer tokenizer = new StringTokenizer(this.promptText.getText());
        try {
            while (tokenizer.hasMoreTokens()) {
                String nextToken = tokenizer.nextToken(",").trim();
                if (nextToken.equals("") || parameters.contains(nextToken)) continue;
                parameters.add(nextToken);
            }
            if (parameters.size() > 1) {
                this.eList.setParameters(parameters);
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (this.window instanceof dTreeWindow) {
            ((dTreeWindow)this.window).showMessage("Invalid Input", "You must enter at least two different parameters");
        } else {
            ((InlineDTreeApplet)this.window).showMessage("Invalid Input", "You must enter at least two different parameters");
        }
        return false;
    }
}

