/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree.dialogs;

import CIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SelectExamplesDialog
extends BasicDialog {
    private JComboBox selectionTypeComboBox;
    private JTextField percentageText;
    private JLabel labelError;
    private JList exampleList;

    public SelectExamplesDialog(JFrame parent, JList exampleList) {
        super(parent, "Select Data Examples", true);
        this.exampleList = exampleList;
        this.exampleList.setModel(exampleList.getModel());
        this.labelError = new JLabel("");
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.constructCenterPanel(), "Center");
        p1.add((Component)this.constructBottomPanel(), "South");
        this.getContentPane().add(p1);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private JPanel constructCenterPanel() {
        JPanel centerPanel = new JPanel();
        String[] choiceString = new String[]{"Random", "the First", "the Last"};
        this.selectionTypeComboBox = new JComboBox<String>(choiceString);
        this.percentageText = new JTextField("50", 3);
        centerPanel.add(new JLabel("Select"));
        centerPanel.add(this.selectionTypeComboBox);
        centerPanel.add(this.percentageText);
        centerPanel.add(new JLabel("% \tof the data"));
        return centerPanel;
    }

    private JPanel constructBottomPanel() {
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("OK");
        button.addActionListener(this);
        this.getRootPane().setDefaultButton(button);
        bottomPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(this);
        bottomPanel.add(button);
        return bottomPanel;
    }

    protected boolean actionOK() {
        return this.parsePercentage();
    }

    protected boolean actionCancel() {
        return true;
    }

    private void selectItems(int[] inds) {
        int i = 0;
        while (i < inds.length) {
            inds[i] = inds[i] + 1;
            ++i;
        }
        this.exampleList.setSelectedIndices(inds);
    }

    private boolean parsePercentage() {
        double percentage;
        try {
            percentage = Double.parseDouble(this.percentageText.getText());
            if (percentage < 0.0 || percentage > 100.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Parameter should have a real value between 0 and 100");
            this.pack();
            return false;
        }
        int numExamples = this.exampleList.getModel().getSize() - 1;
        int numToMove = (int)((double)numExamples * (percentage / 100.0));
        int[] inds = new int[numToMove];
        if (numToMove > 0) {
            if (this.selectionTypeComboBox.getSelectedItem() == "the First") {
                int i = 0;
                while (i < numToMove) {
                    inds[i] = i;
                    ++i;
                }
            } else if (this.selectionTypeComboBox.getSelectedItem() == "the Last") {
                int i = 0;
                while (i < numToMove) {
                    inds[i] = numExamples - numToMove + i;
                    ++i;
                }
            } else if (this.selectionTypeComboBox.getSelectedItem() == "Random") {
                int n;
                inds[0] = n = (int)((double)numExamples * Math.random());
                int i = 1;
                while (i < numToMove) {
                    boolean isUnique = false;
                    block5: while (!isUnique) {
                        n = (int)((double)numExamples * Math.random());
                        isUnique = true;
                        int j = 1;
                        while (j < i) {
                            if (inds[j] == n) {
                                isUnique = false;
                                continue block5;
                            }
                            ++j;
                        }
                    }
                    inds[i] = n;
                    ++i;
                }
            }
            this.selectItems(inds);
        }
        return true;
    }
}

