/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree.dialogs;

import CIspace.dTree.InlineDTreeApplet;
import CIspace.dTree.dTreeGraph;
import CIspace.dTree.dTreeWindow;
import CIspace.dTree.elements.dTreeNode;
import CIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SplitDialog
extends BasicDialog
implements ItemListener {
    protected Container window;
    protected dTreeNode node;
    protected dTreeGraph graph;
    protected ButtonGroup attributeGroup;
    protected JCheckBox[] attributeCheckbox;

    public SplitDialog(Container parent, dTreeNode node, String title) {
        super((JFrame)(parent instanceof dTreeWindow ? (dTreeWindow)parent : null), title, true);
        super.setOKString("Split");
        this.window = parent;
        this.node = node;
        this.graph = this.window instanceof dTreeWindow ? (dTreeGraph)((dTreeWindow)this.window).returnCanvas().graph : (dTreeGraph)((InlineDTreeApplet)this.window).returnCanvas().graph;
        this.getContentPane().add("North", new JLabel("Please select an attribute to split on:"));
        this.getContentPane().add("Center", this.makeChoicePanel());
        this.getContentPane().add("South", this.makeButtonPanel());
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private JPanel makeButtonPanel() {
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        JButton splitButton = new JButton("Split");
        splitButton.addActionListener(this);
        splitButton.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(splitButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    private JPanel makeChoicePanel() {
        GridLayout layout = new GridLayout();
        JPanel choicePanel = new JPanel();
        DecimalFormat numFormat = new DecimalFormat("0.00;0.00");
        this.attributeGroup = new ButtonGroup();
        this.attributeCheckbox = new JCheckBox[this.node.getInIndices().size()];
        choicePanel.add(new JLabel("Attribute Name", 0));
        choicePanel.add(new JLabel("Information Gain", 0));
        choicePanel.add(new JLabel("Gain Ratio", 0));
        choicePanel.add(new JLabel("Gini", 0));
        int i = 0;
        while (i < this.node.getInIndices().size()) {
            int paramIndex = this.node.getInIndices().get(i);
            this.attributeCheckbox[i] = this.window instanceof dTreeWindow ? new JCheckBox(((dTreeWindow)this.window).exampleList.getParameters()[paramIndex], false) : new JCheckBox(((InlineDTreeApplet)this.window).exampleList.getParameters()[paramIndex], false);
            this.attributeCheckbox[i].addItemListener(this);
            this.attributeGroup.add(this.attributeCheckbox[i]);
            choicePanel.add(this.attributeCheckbox[i]);
            double entropy = this.graph.getEntropy(this.node, paramIndex);
            choicePanel.add(new JLabel(numFormat.format(this.node.getEntropy() - entropy), 0));
            double entropyGainRatio = (this.node.getEntropy() - entropy) / (double)this.node.numInValues(paramIndex);
            choicePanel.add(new JLabel(numFormat.format(entropyGainRatio), 0));
            double giniGain = (this.node.getGini() - this.graph.getGini(this.node, paramIndex)) / (double)this.node.numInValues(paramIndex);
            choicePanel.add(new JLabel(numFormat.format(giniGain), 0));
            ++i;
        }
        layout.setColumns(4);
        layout.setRows(this.node.getInIndices().size() + 1);
        layout.setHgap(10);
        choicePanel.setLayout(layout);
        return choicePanel;
    }

    public void itemStateChanged(ItemEvent e) {
        ((JButton)((JPanel)this.getContentPane().getComponent(2)).getComponent(0)).setEnabled(true);
    }

    protected boolean actionOK() {
        int checkboxIndex = -1;
        int i = 0;
        while (i < this.attributeCheckbox.length) {
            if (this.attributeCheckbox[i].isSelected()) {
                checkboxIndex = i;
                break;
            }
            ++i;
        }
        this.graph.split(this.node, this.node.getInIndices().get(checkboxIndex));
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }
}

