/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree.dialogs;

import CIspace.dTree.ExampleList;
import CIspace.dTree.InlineDTreeApplet;
import CIspace.dTree.dTreeGraph;
import CIspace.dTree.dTreeWindow;
import CIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TestNewExampleDialog
extends BasicDialog {
    Container window;
    ExampleList exampleList;
    JComboBox[] valueChoice;
    JLabel outputLabel;

    public TestNewExampleDialog(Container parent, String title) {
        super((JFrame)(parent instanceof dTreeWindow ? (dTreeWindow)parent : null), title, false);
        super.setOKString("Test");
        super.setCancelString("Close");
        this.window = parent;
        this.exampleList = this.window instanceof dTreeWindow ? ((dTreeWindow)this.window).exampleList : ((InlineDTreeApplet)this.window).exampleList;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.makeCenterPanel());
        this.getContentPane().add("South", this.makeButtonPanel());
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton button = new JButton("Close");
        button.addActionListener(this);
        buttonPanel.add(button);
        button = new JButton("Test");
        button.addActionListener(this);
        buttonPanel.add(button);
        return buttonPanel;
    }

    private JPanel makeCenterPanel() {
        JPanel centerPanel = new JPanel();
        GridLayout layout = new GridLayout();
        int numInputs = this.window instanceof dTreeWindow ? ((dTreeWindow)this.window).exampleList.getNumParameters() - 1 : ((InlineDTreeApplet)this.window).exampleList.getNumParameters() - 1;
        centerPanel.add(new JLabel("Input Values:"));
        centerPanel.add(new JLabel(""));
        this.valueChoice = new JComboBox[numInputs];
        int i = 0;
        while (i < numInputs) {
            centerPanel.add(new JLabel(this.exampleList.getParameters()[i]));
            ArrayList<String> values = this.exampleList.getValueSet(i);
            this.valueChoice[i] = new JComboBox();
            int j = 0;
            while (j < values.size()) {
                this.valueChoice[i].addItem(values.get(j));
                ++j;
            }
            this.valueChoice[i].addItem("Other");
            centerPanel.add(this.valueChoice[i]);
            ++i;
        }
        centerPanel.add(new JLabel(""));
        centerPanel.add(new JLabel(""));
        centerPanel.add(new JLabel("Output Value: "));
        this.outputLabel = new JLabel("  None       ");
        centerPanel.add(this.outputLabel);
        layout.setColumns(2);
        layout.setRows(numInputs + 3);
        centerPanel.setLayout(layout);
        return centerPanel;
    }

    private void calculateOutput() {
        String[] values = new String[this.valueChoice.length + 1];
        int i = 0;
        while (i < this.valueChoice.length) {
            values[i] = (String)this.valueChoice[i].getSelectedItem();
            ++i;
        }
        dTreeGraph graph = this.window instanceof dTreeWindow ? (dTreeGraph)((dTreeWindow)this.window).returnCanvas().graph : (dTreeGraph)((InlineDTreeApplet)this.window).returnCanvas().graph;
        this.outputLabel.setForeground(Color.red);
        this.outputLabel.setText(graph.search(values));
    }

    protected boolean actionOK() {
        this.calculateOutput();
        return false;
    }

    protected boolean actionCancel() {
        return true;
    }
}

