/*
 * Decompiled with CFR 0.152.
 */
package CIspace.dTree.elements;

import CIspace.dTree.dTreeGraph;
import CIspace.graphToolKit.elements.HistogramNode;
import CIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;

public class dTreeHistogramNode
extends HistogramNode {
    protected ArrayList<Integer> count;
    protected int totalCount;
    protected final int HORIZ_PAD = 7;

    public dTreeHistogramNode(dTreeGraph graph) {
        super(graph);
    }

    public void draw(Graphics offscreen, boolean moving) {
        if (this.fontMetrics != this.graph.canvas.getFontMetrics()) {
            this.fontMetrics = this.graph.canvas.getFontMetrics();
            this.resetMaxLabelWidth();
        }
        if (this.showHistogram && this.values.size() > 0 && (double)this.totalValue > 0.1) {
            this.drawNode(offscreen, moving);
        } else {
            super.draw(offscreen, moving);
        }
    }

    public void clearHistogram() {
        this.totalValue = 0;
        this.labels = new ArrayList();
        this.values = new ArrayList();
        this.count = new ArrayList();
    }

    private void drawNode(Graphics offscreen, boolean moving) {
        this.lineHeight = this.fontMetrics.getHeight();
        this.height = this.lineHeight + (this.lineHeight + 3) * (this.labels.size() + 1) + 6;
        this.width = this.maxLabelWidth + 50 + this.fontMetrics.stringWidth("0.00") + this.fontMetrics.stringWidth("0.0") + 42;
        if (this.histogramNodeShape == 1113) {
            this.height += this.lineHeight / 2;
        }
        if (this.width < this.fontMetrics.stringWidth(this.caption)) {
            this.width = this.fontMetrics.stringWidth(this.caption) + 14;
            if (this.histogramNodeShape == 1113) {
                this.width += 70;
            }
        }
        this.nw = new Point(this.pos);
        this.nw.translate(-this.width / 2, -this.height / 2);
        this.drawOutline(offscreen);
        this.drawHistogramNode(offscreen);
    }

    public void addHistogramCount(Integer newCount) {
        this.count.add(newCount);
        this.totalCount += newCount.intValue();
    }

    private void drawHistogramNode(Graphics g) {
        this.drawOutline(g);
        this.drawCaption(g);
        this.drawRowLabels(g);
        this.drawRows(g);
    }

    protected void drawRows(Graphics g) {
        int currentRowY = (int)this.nw.y + 3 * this.lineHeight + 9;
        int valueX2 = (int)this.nw.x + this.width - 50 - 7 - this.fontMetrics.stringWidth("0.00");
        int barX = (int)this.nw.x + this.width - 50;
        int labelX = (int)(this.nw.x + 7.0f);
        g.drawLine(barX - 1, (int)this.nw.y + (this.lineHeight + 3) * 2, barX - 1, (int)this.nw.y + this.height + 3);
        this.drawDashedLines(g, barX, (int)this.nw.y + (this.lineHeight + 3) * 2, (int)this.nw.x + this.width, (int)this.nw.y + this.height + 3);
        int i = 0;
        while (i < this.labels.size()) {
            int currentValue = (Integer)this.values.get(i);
            int currentCount = this.count.get(i);
            g.setColor(Color.black);
            if (this.histogramNodeShape == 1113) {
                g.drawString((String)this.labels.get(i), labelX += 14, currentRowY);
            } else if (this.histogramNodeShape == 1111) {
                g.drawString((String)this.labels.get(i), labelX, currentRowY);
            }
            int valueX = valueX2 - this.fontMetrics.stringWidth("0.00") - 7;
            g.drawString(String.valueOf(currentCount), valueX, currentRowY);
            g.drawString(this.numFormat.format((double)currentValue / 100.0), valueX2, currentRowY);
            int barWidth = (int)(50.0 * ((double)currentValue / (double)this.totalValue));
            g.fillRect(barX, currentRowY - this.lineHeight + 5, barWidth, this.lineHeight - 3);
            currentRowY += this.lineHeight + 3;
            ++i;
        }
    }

    protected void drawDashedLines(Graphics g, int startX, int startY, int endX, int endY) {
        int currentX = startX;
        int increment = (endX - startX) / 3;
        currentX += increment;
        int i = 0;
        while (i < 2) {
            int currentY = startY;
            while (currentY < endY - 4) {
                g.drawLine(currentX, currentY, currentX, currentY + 4);
                currentY += 8;
            }
            if (currentY < endY) {
                g.drawLine(currentX, currentY, currentX, endY);
            }
            currentX += increment;
            ++i;
        }
    }

    private void drawCaption(Graphics g) {
        int captionWidth = this.fontMetrics.stringWidth(this.caption);
        int captionHeight = this.fontMetrics.getHeight();
        g.setColor(Color.black);
        g.drawString(this.caption, (int)this.pos.x - captionWidth / 2, (int)this.nw.y + captionHeight);
        g.setColor(this.color);
        g.drawLine((int)this.nw.x, (int)this.nw.y + captionHeight + 3, (int)this.nw.x + this.width, (int)this.nw.y + captionHeight + 3);
    }

    private void drawRowLabels(Graphics g) {
        int valueX2 = (int)this.nw.x + this.width - 7 - 50 - 7 - this.fontMetrics.stringWidth("0.00");
        int valueX = valueX2 - this.fontMetrics.stringWidth("00");
        int captionHeight = this.fontMetrics.getHeight() * 2;
        Font tempFont = g.getFont();
        if (tempFont.getSize() / 2 < 9) {
            g.setFont(new Font("sans serif", 0, 9));
        } else {
            g.setFont(new Font("sans serif", 0, tempFont.getSize() / 2));
        }
        g.setColor(Color.black);
        g.drawString("Value ", (int)(this.nw.x + 7.0f), (int)this.nw.y + captionHeight);
        g.drawString(" Count ", valueX - 14, (int)this.nw.y + captionHeight);
        g.drawString("   Probability  ", valueX2, (int)this.nw.y + captionHeight);
        g.setColor(this.color);
        g.drawLine((int)this.nw.x, (int)this.nw.y + captionHeight + 3, (int)this.nw.x + this.width, (int)this.nw.y + captionHeight + 3);
        g.setFont(tempFont);
    }

    private void drawOutline(Graphics offscreen) {
        float lineWidth = this.graph.getLineWidth() + this.xw;
        int histrogramHeight = this.height + 3;
        offscreen.setColor(this.color);
        if (lineWidth == 1.0f) {
            if (this.isBold) {
                offscreen.setColor(this.color);
            } else {
                offscreen.setColor(Color.white);
            }
            if (this.histogramNodeShape == 1113) {
                offscreen.fillRoundRect((int)this.nw.x, (int)this.nw.y, this.width, histrogramHeight, histrogramHeight / 2, histrogramHeight / 2);
                offscreen.setColor(this.color);
                offscreen.drawRoundRect((int)this.nw.x, (int)this.nw.y, this.width, histrogramHeight, histrogramHeight / 2, histrogramHeight / 2);
            } else if (this.histogramNodeShape == 1111) {
                offscreen.fillRect((int)this.nw.x, (int)this.nw.y, this.width, histrogramHeight);
                offscreen.setColor(this.color);
                offscreen.drawRect((int)this.nw.x, (int)this.nw.y, this.width, histrogramHeight);
            }
        } else {
            if (this.histogramNodeShape == 1113) {
                offscreen.fillRoundRect((int)(this.nw.x - lineWidth), (int)(this.nw.y - lineWidth), (int)((float)this.width + lineWidth * 2.0f), (int)((float)histrogramHeight + lineWidth * 2.0f), histrogramHeight / 2, histrogramHeight / 2);
            } else if (this.histogramNodeShape == 1111) {
                offscreen.fillRect((int)(this.nw.x - lineWidth), (int)(this.nw.y - lineWidth), (int)((float)this.width + lineWidth * 2.0f), (int)((float)histrogramHeight + lineWidth * 2.0f));
            }
            if (!this.isBold) {
                offscreen.setColor(Color.white);
            }
            if (this.histogramNodeShape == 1113) {
                offscreen.fillRoundRect((int)this.nw.x, (int)this.nw.y, this.width, histrogramHeight, histrogramHeight / 2, histrogramHeight / 2);
            } else if (this.histogramNodeShape == 1111) {
                offscreen.fillRect((int)this.nw.x, (int)this.nw.y, this.width, histrogramHeight);
            }
        }
    }

    public void setHistogramNodeShape(int newShape) {
        this.histogramNodeShape = newShape;
    }
}

