/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.LabelCanvas;
import CIspace.graphToolKit.dialogs.OpenLocationDialog;
import CIspace.graphToolKit.dialogs.ProblemDialog;
import CIspace.graphToolKit.elements.Edge;
import CIspace.graphToolKit.elements.Node;
import CIspace.graphToolKit.elements.Point;
import CIspace.graphToolKit.help.HelpMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphWindow
extends JFrame
implements WindowListener,
ActionListener,
ChangeListener {
    protected boolean undoBoolean;
    protected String fileName;
    protected static String appletTitle;
    protected static String appletName;
    protected static String aboutText;
    protected Font toolBarFont;
    protected int savedLineWidth;
    protected int savedFontSize;
    protected JRadioButtonMenuItem savedFontSizeMenuItem;
    protected JRadioButtonMenuItem savedLineWidthMenuItem;
    protected JRadioButtonMenuItem extraLargeFont;
    protected JRadioButtonMenuItem largeFont;
    protected JRadioButtonMenuItem mediumFont;
    protected JRadioButtonMenuItem smallFont;
    protected JRadioButtonMenuItem otherFont;
    protected JRadioButtonMenuItem wideLine;
    protected JRadioButtonMenuItem mediumLine;
    protected JRadioButtonMenuItem narrowLine;
    protected JRadioButtonMenuItem pan;
    protected JRadioButtonMenuItem zoom;
    protected boolean isMessagePanelShowing = true;
    protected boolean isAntiAliasingEnabled = true;
    protected boolean isButtonTextShowing = true;
    protected boolean isToolBarShowing = true;
    protected GridBagConstraints gbc;
    protected GridBagLayout gbl;
    protected JPanel canvasPanel;
    protected JPanel bottomPanel;
    protected JTabbedPane tabbedPane;
    public JScrollPane scrollPanel;
    protected JSplitPane tabandbottom;
    protected JTextArea algoText;
    protected JToggleButton[] createButModes;
    protected JToggleButton[] solveButModes;
    protected ButtonGroup createModeButGroup;
    protected ButtonGroup solveModeButGroup;
    protected JToolBar toolBar;
    protected int otherSavedButtonIndex = -1;
    protected ImageIcon createNodeIcon = GraphWindow.createImageIcon("images/newNode.png");
    protected ImageIcon createEdgeIcon = GraphWindow.createImageIcon("images/newEdge2.png");
    protected ImageIcon selectIcon = GraphWindow.createImageIcon("images/select.png");
    protected ImageIcon deleteIcon = GraphWindow.createImageIcon("images/delete.png");
    protected ImageIcon setPropsIcon = GraphWindow.createImageIcon("images/setProp.png");
    protected JPanel emptyPanel1;
    protected JPanel emptyPanel2;
    protected GraphCanvas canvas;
    protected LabelCanvas messageCanvas;
    protected JApplet applet;

    public GraphWindow(JApplet parent) {
        this.applet = parent;
        this.setBackground(GraphConsts.bg);
        this.setForeground(GraphConsts.fg);
        this.setSize(600, 700);
        this.toolBarFont = new Font("arial", 0, 10);
        this.initializeAppletInfo();
        this.setTitle(appletTitle);
        this.addWindowListener(this);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        UIManager.put("TabbedPane.selected", Color.white);
        this.tabbedPane = new JTabbedPane();
        this.emptyPanel1 = new JPanel();
        this.emptyPanel2 = new JPanel();
        this.canvasPanel = new JPanel();
        this.canvasPanel.setBackground(Color.white);
        this.messageCanvas = new LabelCanvas();
        this.getCanvas();
        this.canvasPanel.setLayout(this.gbl);
        this.scrollPanel.setPreferredSize(new Dimension(425, 300));
        this.addComponent(this.messageCanvas, this.canvasPanel, 0, 0, 1, 1, 1.0, 0.135);
        this.addComponent(this.scrollPanel, this.canvasPanel, 1, 0, 1, 1, 1.0, 0.865);
        this.tabbedPane.addTab("Create", null, this.canvasPanel, "Click to change to Create mode");
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addTab("Solve", null, this.emptyPanel2, "Click to change to Solve mode");
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.setBackground(Color.lightGray);
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)main, "Center");
        this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
        this.setJMenuBar(this.createMenuBar());
        this.algoText = new JTextArea();
        this.algoText.setBorder(BorderFactory.createRaisedBevelBorder());
        this.algoText.setBackground(Color.lightGray);
        this.algoText.setFont(new Font("arial", 1, 12));
        this.algoText.setEditable(false);
        this.algoText.setVisible(false);
        this.toolBar = new JToolBar();
        this.createToolBarWithText();
        this.bottomPanel = new JPanel(new BorderLayout());
        this.tabandbottom = new JSplitPane(0);
        this.tabandbottom.setOneTouchExpandable(true);
        this.bottomPanel.add((Component)this.algoText, "North");
        toolBarPanel.add((Component)this.toolBar, "West");
        this.tabandbottom.setTopComponent(this.tabbedPane);
        this.tabandbottom.setBottomComponent(this.bottomPanel);
        this.tabandbottom.setResizeWeight(0.85);
        this.tabandbottom.setDividerLocation(0.8);
        main.add((Component)toolBarPanel, "North");
        main.add((Component)this.tabandbottom, "Center");
        this.messageCanvas.setPreferredSize(new Dimension(525, 50));
        this.centerWindow();
        UIManager.getDefaults().put("Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ENTER", "pressed", "released ENTER", "released", "SPACE", "pressed", "released SPACE", "released"}));
    }

    private void initializeAppletInfo() {
        appletTitle = "Graph Drawing ToolKit Version 4.2.1";
        appletName = "graphToolKit";
        aboutText = "About this Applet\n\n" + appletTitle + "\n\n" + "Special Thanks to:\n" + "David Poole, Alan Mackworth, Holger Hoos,\n" + "Peter Gorniak, and Cristina Conati";
    }

    protected void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createViewMenu());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }

    protected JMenu createFileMenu() {
        JMenu m = new JMenu("File");
        m.setMnemonic(70);
        JMenuItem mItem = new JMenuItem("Create Random Graph");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(82);
        m.add(mItem);
        mItem = new JMenuItem("Create New Graph");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(78);
        m.add(mItem);
        mItem = new JMenuItem("Load Sample Graph");
        mItem.setActionCommand(mItem.getText());
        mItem.setMnemonic(71);
        mItem.addActionListener(this);
        m.add(mItem);
        boolean hasLocalAccess = this.hasLocalAccess();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Load From File");
            mItem.setActionCommand(mItem.getText());
            mItem.setMnemonic(70);
            mItem.setDisplayedMnemonicIndex(10);
            mItem.addActionListener(this);
            m.add(mItem);
        }
        mItem = new JMenuItem("Load From URL");
        mItem.setActionCommand(mItem.getText());
        mItem.setMnemonic(85);
        mItem.addActionListener(this);
        m.add(mItem);
        m.addSeparator();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Save Graph");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            mItem.setMnemonic(83);
            m.add(mItem);
        }
        mItem = new JMenuItem("Print");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(80);
        m.add(mItem);
        mItem = new JMenuItem("Quit");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(81);
        m.add(mItem);
        return m;
    }

    protected JMenu createViewMenu() {
        ButtonGroup group = new ButtonGroup();
        JMenu menu = new JMenu("View");
        menu.setMnemonic(86);
        JMenu fontMenu = new JMenu("Font Size");
        fontMenu.setMnemonic(70);
        this.extraLargeFont = new JRadioButtonMenuItem("Extra Large (30 pt)", false);
        this.extraLargeFont.addActionListener(this);
        fontMenu.add(this.extraLargeFont);
        group.add(this.extraLargeFont);
        this.largeFont = new JRadioButtonMenuItem("Large (20 pt)", false);
        this.largeFont.addActionListener(this);
        fontMenu.add(this.largeFont);
        group.add(this.largeFont);
        this.mediumFont = new JRadioButtonMenuItem("Medium (12 pt)", true);
        this.mediumFont.addActionListener(this);
        fontMenu.add(this.mediumFont);
        group.add(this.mediumFont);
        this.smallFont = new JRadioButtonMenuItem("Small (9 pt)", false);
        this.smallFont.addActionListener(this);
        fontMenu.add(this.smallFont);
        group.add(this.smallFont);
        this.otherFont = new JRadioButtonMenuItem("Other...", false);
        this.otherFont.addActionListener(this);
        fontMenu.add(this.otherFont);
        group.add(this.otherFont);
        menu.add(fontMenu);
        group = new ButtonGroup();
        JMenu line = new JMenu("Line Width");
        line.setMnemonic(76);
        this.wideLine = new JRadioButtonMenuItem("Wide (4 pixels)", false);
        this.wideLine.addActionListener(this);
        line.add(this.wideLine);
        group.add(this.wideLine);
        this.mediumLine = new JRadioButtonMenuItem("Medium (2 pixels)", false);
        this.mediumLine.addActionListener(this);
        line.add(this.mediumLine);
        group.add(this.mediumLine);
        this.narrowLine = new JRadioButtonMenuItem("Narrow (1 pixel)", true);
        this.narrowLine.addActionListener(this);
        line.add(this.narrowLine);
        group.add(this.narrowLine);
        menu.add(line);
        menu.addSeparator();
        JMenuItem mItem = new JMenuItem("Autoscale");
        mItem.setActionCommand(mItem.getText());
        mItem.setMnemonic(65);
        mItem.addActionListener(this);
        menu.add(mItem);
        group = new ButtonGroup();
        JMenu zp = new JMenu("Pan/Zoom");
        zp.setMnemonic(90);
        this.zoom = new JRadioButtonMenuItem("Zoom", true);
        this.zoom.addActionListener(this);
        group.add(this.zoom);
        zp.add(this.zoom);
        this.pan = new JRadioButtonMenuItem("Pan", false);
        this.pan.addActionListener(this);
        zp.add(this.pan);
        group.add(this.pan);
        menu.add(zp);
        mItem = new JMenuItem("Reset Labels");
        mItem.setActionCommand(mItem.getText());
        mItem.setMnemonic(82);
        mItem.addActionListener(this);
        menu.add(mItem);
        menu.addSeparator();
        JCheckBoxMenuItem checkItem = new JCheckBoxMenuItem("Enable Anti-Aliasing", true);
        checkItem.setMnemonic(65);
        checkItem.setDisplayedMnemonicIndex(7);
        checkItem.addActionListener(this);
        menu.add(checkItem);
        checkItem = new JCheckBoxMenuItem("Show Message Panel", true);
        checkItem.setMnemonic(77);
        checkItem.addActionListener(this);
        menu.add(checkItem);
        checkItem = new JCheckBoxMenuItem("Show Button Text", true);
        checkItem.setMnemonic(84);
        checkItem.setDisplayedMnemonicIndex(12);
        checkItem.addActionListener(this);
        menu.add(checkItem);
        checkItem = new JCheckBoxMenuItem("Show Buttons", true);
        checkItem.setMnemonic(66);
        checkItem.addActionListener(this);
        menu.add(checkItem);
        return menu;
    }

    protected JMenu createHelpMenu() {
        if (appletName.equals("graphToolKit") || appletName.equals("")) {
            JMenu menu = new JMenu("Help");
            menu.setMnemonic(72);
            JMenuItem mItem = new JMenuItem("About CIspace");
            mItem.setMnemonic(67);
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            menu.add(mItem);
            return menu;
        }
        return new HelpMenu(appletName, this);
    }

    public String getAboutText() {
        return aboutText;
    }

    public JApplet getApplet() {
        return this.applet;
    }

    public static ImageIcon createImageIcon(String path) {
        URL imgURL = GraphWindow.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    protected void createToolBar() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        this.createButModes = new JToggleButton[7];
        this.setCreateButtons(0, this.createNodeIcon, "Create Node");
        this.setCreateButtons(1, this.createEdgeIcon, "Create Edge");
        this.setCreateButtons(2, this.selectIcon, "   Select   ");
        this.setCreateButtons(3, this.deleteIcon, "   Delete   ");
        this.setCreateButtons(4, this.setPropsIcon, "Set Properties");
        this.createToolBarLayout();
    }

    protected void createToolBarWithText() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        this.createButModes = new JToggleButton[7];
        this.setCreateButtonsWithText(0, "Create Node", this.createNodeIcon, "Create Node");
        this.setCreateButtonsWithText(1, "Create Edge", this.createEdgeIcon, "Create Edge");
        this.setCreateButtonsWithText(2, "   Select   ", this.selectIcon, "Select");
        this.setCreateButtonsWithText(3, "   Delete   ", this.deleteIcon, "Delete");
        this.setCreateButtonsWithText(4, "Set Properties", this.setPropsIcon, "Set Properties");
        this.createToolBarLayout();
    }

    private void createToolBarLayout() {
        int i = 0;
        while (i <= 4) {
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.algoText.setText(" ");
    }

    protected void setCreateButtons(int num, ImageIcon icon, String toolTip) {
        this.createButModes[num] = new JToggleButton(icon);
        this.createButModes[num].setActionCommand(toolTip);
        this.createButModes[num].addActionListener(this);
        this.createButModes[num].setToolTipText(toolTip);
    }

    protected void setSolveButtons(int num, ImageIcon icon, String toolTip) {
        this.solveButModes[num] = new JToggleButton(icon);
        this.solveButModes[num].setActionCommand(toolTip);
        this.solveButModes[num].addActionListener(this);
        this.solveButModes[num].setToolTipText(toolTip);
    }

    protected void setCreateButtonsWithText(int num, String buttonName, ImageIcon icon, String toolTip) {
        this.createButModes[num] = new JToggleButton(buttonName, icon);
        this.createButModes[num].addActionListener(this);
        this.createButModes[num].setToolTipText(toolTip);
        this.createButModes[num].setVerticalTextPosition(3);
        this.createButModes[num].setHorizontalTextPosition(0);
    }

    protected void setSolveButtonsWithText(int num, String buttonName, ImageIcon icon, String toolTip) {
        this.solveButModes[num] = new JToggleButton(buttonName, icon);
        this.solveButModes[num].addActionListener(this);
        this.solveButModes[num].setToolTipText(toolTip);
        this.solveButModes[num].setVerticalTextPosition(3);
        this.solveButModes[num].setHorizontalTextPosition(0);
    }

    protected void solveToolBar() {
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        this.solveButModes = new JToggleButton[9];
    }

    protected void solveToolBarWithText() {
        this.solveToolBar();
    }

    private Graph randomGraph(int numNodes) {
        String label;
        Graph graph = new Graph(this.returnCanvas());
        int i = 0;
        while (i < numNodes) {
            label = Integer.toString((int)(200.0 * Math.random()));
            int x = 150 - (int)(300.0 * Math.random());
            int y = 150 - (int)(300.0 * Math.random());
            int shape = 1110;
            Point p = new Point(x, y);
            Color color = Color.black;
            if (i % 4 == 0) {
                color = Color.red;
                shape = 1111;
            } else if (i % 4 == 1) {
                color = Color.blue;
                shape = 1112;
            } else if (i % 4 == 2) {
                color = Color.green;
                shape = 1110;
            }
            if (i == numNodes - 1) {
                p = new Point(0.0f, 0.0f);
            }
            Node n = new Node(graph, label, p, color, shape);
            graph.addNode(n);
            ++i;
        }
        i = 0;
        while (i < numNodes - 1) {
            label = "Edge #" + i;
            Node start = graph.nodeAt(i);
            Node end = graph.nodeAt(numNodes - 1);
            Color color = Color.black;
            if (i % 4 == 0) {
                color = Color.red;
            } else if (i % 4 == 1) {
                color = Color.blue;
            } else if (i % 4 == 2) {
                color = Color.green;
            }
            Edge e = new Edge(graph, label, start, end, color, 5551);
            graph.addEdge(e);
            ++i;
        }
        return graph;
    }

    protected void getCanvas() {
        this.canvas = new GraphCanvas(this, false);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.scrollPanel = new JScrollPane(this.canvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7000);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    public final GraphCanvas returnCanvas() {
        return this.canvas;
    }

    public void setHorizontalBarPosition(int horzPosition) {
        this.scrollPanel.getHorizontalScrollBar().setValue(horzPosition);
    }

    public void setVerticalBarPosition(int vertPosition) {
        this.scrollPanel.getVerticalScrollBar().setValue(vertPosition);
    }

    public void switchTab(String str) {
        int tempSaveIndex = 0;
        if (str == "Create") {
            tempSaveIndex = this.getSelectedButtonIndex(this.solveButModes);
            this.setCreate();
            if (this.otherSavedButtonIndex != -1) {
                this.actionPerformed(new ActionEvent(this.createButModes[this.otherSavedButtonIndex], 0, this.createButModes[this.otherSavedButtonIndex].getActionCommand()));
                this.createButModes[this.otherSavedButtonIndex].setSelected(true);
            }
        } else if (str == "Solve") {
            tempSaveIndex = this.getSelectedButtonIndex(this.createButModes);
            this.setSolve();
            if (this.otherSavedButtonIndex != -1) {
                this.actionPerformed(new ActionEvent(this.solveButModes[this.otherSavedButtonIndex], 0, this.solveButModes[this.otherSavedButtonIndex].getActionCommand()));
                this.solveButModes[this.otherSavedButtonIndex].setSelected(true);
            }
        }
        this.otherSavedButtonIndex = tempSaveIndex;
        this.repaint();
    }

    public int getTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void setPanZoom(int num) {
        if (num == 0) {
            this.zoom.setSelected(true);
        } else {
            this.pan.setSelected(true);
        }
    }

    public void setCreate() {
        this.returnCanvas().setMode(2220);
        this.tabbedPane.setComponentAt(0, this.emptyPanel1);
        this.tabbedPane.setComponentAt(1, this.emptyPanel2);
        this.tabbedPane.setComponentAt(0, this.canvasPanel);
        this.tabbedPane.setSelectedIndex(0);
        if (this.isButtonTextShowing) {
            this.createToolBarWithText();
        } else {
            this.createToolBar();
        }
        this.createButModes[2].setSelected(true);
        this.actionPerformed(new ActionEvent(this.createButModes[2], 0, this.createButModes[2].getActionCommand()));
    }

    public void setSolve() {
        this.returnCanvas().setMode(2221);
        this.tabbedPane.setComponentAt(0, this.emptyPanel1);
        this.tabbedPane.setComponentAt(1, this.emptyPanel2);
        this.tabbedPane.setComponentAt(1, this.canvasPanel);
        this.tabbedPane.setSelectedIndex(1);
        if (this.isButtonTextShowing) {
            this.solveToolBarWithText();
        } else {
            this.solveToolBar();
        }
    }

    public void setPromptLabel(String str) {
        this.messageCanvas.setText(str);
    }

    public String getExactPromptLabel() {
        return this.messageCanvas.getExactText();
    }

    public void setPromptColor(Color col) {
        this.messageCanvas.setTextColor(col);
    }

    public String getPromptLabel() {
        return this.messageCanvas.getText();
    }

    protected void saveProperties() {
        this.savedFontSize = this.returnCanvas().getFont().getSize();
        if (this.extraLargeFont.isSelected()) {
            this.savedFontSizeMenuItem = this.extraLargeFont;
        } else if (this.largeFont.isSelected()) {
            this.savedFontSizeMenuItem = this.largeFont;
        } else if (this.mediumFont.isSelected()) {
            this.savedFontSizeMenuItem = this.mediumFont;
        } else if (this.smallFont.isSelected()) {
            this.savedFontSizeMenuItem = this.smallFont;
        } else if (this.otherFont.isSelected()) {
            this.savedFontSizeMenuItem = this.otherFont;
        }
        this.savedLineWidth = this.returnCanvas().graph.getLineWidth();
        if (this.wideLine.isSelected()) {
            this.savedLineWidthMenuItem = this.wideLine;
        } else if (this.mediumLine.isSelected()) {
            this.savedLineWidthMenuItem = this.mediumLine;
        } else if (this.narrowLine.isSelected()) {
            this.savedLineWidthMenuItem = this.narrowLine;
        }
    }

    protected void restoreProperties() {
        this.savedLineWidthMenuItem.setSelected(true);
        this.returnCanvas().graph.setLineWidth(this.savedLineWidth);
        this.returnCanvas().changeLineWidth();
        this.savedFontSizeMenuItem.setSelected(true);
        this.returnCanvas().changeFont(this.savedFontSize);
        if (this.returnCanvas().getMode() == 2220) {
            this.createButModes[0].setSelected(true);
            this.returnCanvas().setSubmode(3330);
            this.setPromptLabel("Click the canvas to create a node.");
        }
    }

    public boolean isAntiAliasingEnabled() {
        return this.isAntiAliasingEnabled;
    }

    public boolean isButtonTextShowing() {
        return this.isButtonTextShowing;
    }

    protected boolean hasLocalAccess() {
        SecurityManager secMan = System.getSecurityManager();
        try {
            if (secMan != null) {
                secMan.checkWrite("C:/temp");
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    protected void loadSampleGraph() {
        this.saveProperties();
        new ProblemDialog(this).open();
        this.restoreProperties();
    }

    protected void openGraph() {
        JFileChooser load = new JFileChooser();
        load.setFileSelectionMode(2);
        load.setLocation(0, 0);
        if (load.showOpenDialog(this) == 0) {
            File file = load.getSelectedFile();
            this.fileName = file.getName();
            this.saveProperties();
            this.load(file);
            this.restoreProperties();
        }
    }

    protected void createNewGraph() {
        this.saveProperties();
        this.tabbedPane.setSelectedIndex(0);
        this.returnCanvas().reset();
        this.returnCanvas().setSubmode(3330);
        this.createButModes[0].setSelected(true);
        this.setPromptLabel("Click the canvas to create a node.");
        this.restoreProperties();
        this.returnCanvas().repaint();
    }

    protected void openLocation() {
        OpenLocationDialog openDialog = new OpenLocationDialog(this);
        if (openDialog.url != null) {
            try {
                this.fileName = openDialog.url.substring(openDialog.url.lastIndexOf("/") + 1);
                this.load(new BufferedReader(new InputStreamReader(new URL(openDialog.url).openStream())));
            }
            catch (Exception exc) {
                this.showMessage("Error", exc.toString());
            }
        }
    }

    protected void saveGraph() {
        JFileChooser save = new JFileChooser();
        save.setFileSelectionMode(2);
        save.setLocation(0, 0);
        if (save.showSaveDialog(this) == 0) {
            this.save(save.getSelectedFile());
            if (this.fileName != null) {
                this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
            }
        }
    }

    protected void save(File file) {
        System.err.println("Override save(File file) method from GraphWindow");
    }

    public void load(String dir, String fileName) {
        try {
            this.fileName = fileName;
            if (this.applet != null) {
                this.load(new BufferedReader(new InputStreamReader(new URL(this.applet.getCodeBase() + dir + fileName).openStream())));
            } else {
                this.load(new BufferedReader(new FileReader(String.valueOf(dir) + fileName)));
            }
        }
        catch (Exception e) {
            this.fileName = null;
            this.showMessage("Error", e.toString());
        }
    }

    public void load(File file) {
        try {
            this.fileName = file.getName();
            this.load(new BufferedReader(new FileReader(file.getPath())));
        }
        catch (Exception e) {
            this.fileName = null;
            this.showMessage("Error", e.toString());
        }
    }

    public void load(BufferedReader in) {
        System.err.println("Override load(BufferedReader in) method from GraphWindow");
    }

    public void setMessageCanvasFontSize(int size) {
        this.messageCanvas.setFontSize(size);
        this.messageCanvas.repaint();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand().trim();
        if (arg.equals("Load Sample Graph") || arg.equals("Load From File") || arg.equals("Load From URL") || arg.equals("Create New Graph") || arg.equals("Create Random Graph")) {
            this.saveProperties();
            if (arg.equals("Load Sample Graph")) {
                this.loadSampleGraph();
            } else if (arg.equals("Load From File")) {
                this.openGraph();
            } else if (arg.equals("Load From URL")) {
                this.openLocation();
            } else if (arg.equals("Create New Graph")) {
                this.createNewGraph();
            } else if (arg.equals("Create Random Graph")) {
                this.returnCanvas().setGraph(this.randomGraph(10));
                this.returnCanvas().repaint();
            }
            this.restoreProperties();
        } else if (arg.equals("Save Graph")) {
            this.saveGraph();
        } else if (arg.equals("Create Node")) {
            this.returnCanvas().setSubmode(3330);
            this.setPromptLabel("Click the canvas to create a node.");
        } else if (arg.equals("Create Edge") || arg.equals("Create Arc")) {
            this.returnCanvas().setSubmode(3331);
            this.setPromptLabel("Click on a node to start creating an edge.\nClick on another node to finish.\nYou can cancel edge creation by clicking on the canvas.");
        } else if (arg.equals("Select")) {
            this.returnCanvas().setSubmode(3332);
            if (this.canvas.mode == 2221) {
                this.setPromptLabel("Click on an entity and drag the mouse to move it.");
            } else {
                this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
            }
        } else if (arg.equals("Delete")) {
            this.returnCanvas().setSubmode(3333);
            this.setPromptLabel("Click on an entity to delete.");
        } else if (arg.equals("Set Properties")) {
            this.returnCanvas().setSubmode(3334);
            this.setPromptLabel("Click on an entity to set its properties.");
        } else if (arg.equals("Extra Large (30 pt)")) {
            this.returnCanvas().changeFont(30);
            this.algoText.setFont(new Font("Arial", 1, 30));
        } else if (arg.equals("Large (20 pt)")) {
            this.returnCanvas().changeFont(20);
            this.algoText.setFont(new Font("Arial", 1, 20));
        } else if (arg.equals("Medium (12 pt)")) {
            this.returnCanvas().changeFont(12);
            this.algoText.setFont(new Font("Arial", 1, 15));
        } else if (arg.equals("Small (9 pt)")) {
            this.returnCanvas().changeFont(9);
            this.algoText.setFont(new Font("Arial", 1, 15));
        } else if (arg.equals("Other...")) {
            this.returnCanvas().changeFont(-1);
        } else if (arg.equals("Wide (4 pixels)")) {
            this.returnCanvas().graph.setLineWidth(4);
            this.returnCanvas().changeLineWidth();
        } else if (arg.equals("Medium (2 pixels)")) {
            this.returnCanvas().graph.setLineWidth(2);
            this.returnCanvas().changeLineWidth();
        } else if (arg.equals("Narrow (1 pixel)")) {
            this.returnCanvas().graph.setLineWidth(1);
            this.returnCanvas().changeLineWidth();
        } else if (arg.equals("Enable Anti-Aliasing")) {
            this.isAntiAliasingEnabled = !this.isAntiAliasingEnabled;
            this.canvas.repaint();
        } else if (arg.equals("Show Message Panel")) {
            this.isMessagePanelShowing = !this.isMessagePanelShowing;
            this.messageCanvas.setVisible(this.isMessagePanelShowing);
            this.validate();
            this.returnCanvas().autoscale();
        } else if (arg.equals("Show Button Text")) {
            boolean bl = this.isButtonTextShowing = !this.isButtonTextShowing;
            if (this.tabbedPane.getSelectedIndex() == 0) {
                int selectedIndex = this.getSelectedButtonIndex(this.createButModes);
                if (this.isButtonTextShowing) {
                    this.createToolBarWithText();
                } else {
                    this.createToolBar();
                }
                if (selectedIndex != -1) {
                    this.createButModes[selectedIndex].setSelected(true);
                }
            } else {
                int selectedIndex = this.getSelectedButtonIndex(this.solveButModes);
                if (this.isButtonTextShowing) {
                    this.solveToolBarWithText();
                } else {
                    this.solveToolBar();
                }
                if (selectedIndex != -1) {
                    this.solveButModes[selectedIndex].setSelected(true);
                }
            }
        } else if (arg.equals("Show Buttons")) {
            this.isToolBarShowing = !this.isToolBarShowing;
            this.toolBar.setVisible(this.isToolBarShowing);
        } else if (arg.equals("Autoscale")) {
            this.returnCanvas().autoscale();
        } else if (arg.equals("Reset Labels")) {
            this.returnCanvas().resetLabels();
        } else if (arg.equals("Pan")) {
            this.returnCanvas().setRMode(4440);
            this.setPromptLabel("Drag the right mouse button to pan the graph.");
        } else if (arg.equals("Zoom")) {
            this.returnCanvas().setRMode(4441);
            this.setPromptLabel("Drag the right mouse button up to zoom in and down to zoom out.");
        } else if (arg.equals("Print")) {
            this.returnCanvas().print();
            this.returnCanvas().autoscale();
        } else if (arg.equals("Quit")) {
            this.setVisible(false);
            this.dispose();
        }
    }

    protected int getSelectedButtonIndex(JToggleButton[] buttons) {
        int i = 0;
        while (buttons != null && i < buttons.length) {
            if (buttons[i] != null && buttons[i].isSelected()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final void showMessage(String title, String msg) {
        this.canvas.showMessage(title, msg);
    }

    protected final void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point centerPosition = new Point(screenSize.width / 2, screenSize.height / 2);
        Dimension windowSize = this.getSize();
        this.setLocation((int)centerPosition.x - windowSize.width / 2, (int)centerPosition.y - windowSize.height / 2);
    }

    public void stateChanged(ChangeEvent e) {
        this.switchTab(this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex()));
        this.canvas.autoscale();
    }

    public void windowClosed(WindowEvent e) {
        if (this.applet == null) {
            System.exit(0);
        }
    }

    public void windowClosing(WindowEvent e) {
        this.canvas.disposeWindows();
        this.setVisible(false);
        this.dispose();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        new GraphWindow(null);
    }
}

