/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit.dialogs;

import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FontDialog
extends BasicDialog {
    private JTextField tf;
    private GraphCanvas canvas;

    public FontDialog(GraphCanvas parent) {
        super((JFrame)parent.parent, "Choose Font Size", true);
        this.canvas = parent;
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        this.tf = new JTextField(String.valueOf(this.canvas.getFont().getSize()), 3);
        this.tf.addActionListener(this);
        JPanel center = new JPanel();
        center.add(new JLabel("Font Size:"));
        center.add(this.tf);
        JPanel south = new JPanel();
        south.add(ok);
        south.add(cancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)center, "Center");
        this.getContentPane().add((Component)south, "South");
        this.packCenterOpen();
    }

    protected boolean actionOK() {
        try {
            int fontSize = Integer.parseInt(this.tf.getText());
            if (fontSize < 1) {
                fontSize = 1;
            }
            this.canvas.changeFont(fontSize);
            return true;
        }
        catch (Exception err) {
            this.canvas.showMessage("Error", err.getLocalizedMessage());
            return false;
        }
    }

    protected boolean actionCancel() {
        return true;
    }
}

