/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit.dialogs;

import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.dialogs.BasicDialog;
import CIspace.graphToolKit.elements.Node;
import CIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NodeDialog
extends BasicDialog {
    private JComboBox colors;
    private JComboBox shapes;
    private GraphCanvas canvas;
    private Point pos;
    private JTextField label;
    private boolean creating;
    private Node node;

    public NodeDialog(GraphCanvas canvas) {
        super((JFrame)canvas.parent, "Node Options", true);
        this.canvas = canvas;
        this.creating = true;
        this.colors = new JComboBox();
        this.colors.addItem("Black");
        this.colors.addItem("Red");
        this.colors.addItem("Blue");
        this.colors.addItem("Green");
        this.shapes = new JComboBox();
        this.shapes.addItem("Oval");
        this.shapes.addItem("Rectangle");
        this.shapes.addItem("Diamond");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridLayout(3, 1));
        JPanel panel = new JPanel();
        panel.add(new JLabel("Label"));
        this.label = new JTextField("", 10);
        this.label.addActionListener(this);
        panel.add(this.label);
        contentPane.add(panel);
        panel = new JPanel();
        panel.add(this.colors);
        panel.add(this.shapes);
        contentPane.add(panel);
        panel = new JPanel();
        JButton button = new JButton("OK");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        panel.add(button);
        button = new JButton("Cancel");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        panel.add(button);
        contentPane.add(panel);
        this.pack();
        this.setSize(300, 300);
        this.setResizable(false);
    }

    public void open(Point pos) {
        this.creating = true;
        this.pos = pos;
        this.centerWindow();
        this.setVisible(true);
    }

    public void open(Node n) {
        this.creating = false;
        this.node = n;
        this.pos = n.pos;
        this.label.setText(n.label[0]);
        if (n.color == Color.black) {
            this.colors.setSelectedItem("Black");
        } else if (n.color == Color.red) {
            this.colors.setSelectedItem("Red");
        } else if (n.color == Color.blue) {
            this.colors.setSelectedItem("Blue");
        } else {
            this.colors.setSelectedItem("Green");
        }
        if (n.shape == 1110) {
            this.shapes.setSelectedItem("Oval");
        } else if (n.shape == 1111) {
            this.shapes.setSelectedItem("Rectangle");
        } else {
            this.shapes.setSelectedItem("Diamond");
        }
        this.centerWindow();
        this.setVisible(true);
    }

    protected boolean actionOK() {
        this.parseDialog();
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }

    private void parseDialog() {
        Color color = this.colors.getSelectedItem() == "Black" ? Color.black : (this.colors.getSelectedItem() == "Red" ? Color.red : (this.colors.getSelectedItem() == "Blue" ? Color.blue : Color.green));
        int shape = this.shapes.getSelectedItem() == "Oval" ? 1110 : (this.shapes.getSelectedItem() == "Rectangle" ? 1111 : 1112);
        if (this.creating) {
            Node n = new Node(this.canvas.graph, this.label.getText(), this.pos, color, shape);
            this.canvas.graph.addNode(n);
        } else {
            this.canvas.graph.modifyNode(this.node, this.label.getText(), this.pos, color, shape);
        }
    }
}

