/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit.dialogs;

import CIspace.graphToolKit.GraphWindow;
import CIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProblemDialog
extends BasicDialog {
    protected GraphWindow window;
    protected LinkedHashMap<String, String> problemNameToFileName;
    protected JComboBox sampleChoice;
    protected boolean errorOccurredOnLoad = false;

    public ProblemDialog(GraphWindow window) {
        super((JFrame)window, "Load Sample Problems", true);
        super.setOKString("Load");
        this.window = window;
        this.getContentPane().add((Component)this.constructTopPanel(), "North");
        this.getContentPane().add((Component)this.constructCenterPanel(), "Center");
        this.getContentPane().add((Component)this.constructBottomPanel(), "South");
        this.pack();
        this.centerWindow();
    }

    public void open() {
        if (!this.errorOccurredOnLoad) {
            this.setVisible(true);
        }
    }

    private JPanel constructTopPanel() {
        JPanel top = new JPanel();
        top.add((Component)new JLabel("Select an Example File:"), "Center");
        return top;
    }

    protected JPanel constructCenterPanel() {
        this.problemNameToFileName = new LinkedHashMap();
        this.sampleChoice = new JComboBox();
        this.populateList();
        JPanel middle = new JPanel();
        middle.add((Component)this.sampleChoice, "Center");
        return middle;
    }

    protected void populateList() {
        this.sampleChoice.removeAllItems();
        if (!this.getProblemList()) {
            this.errorOccurredOnLoad = true;
            return;
        }
        Iterator<String> itr = this.problemNameToFileName.keySet().iterator();
        while (itr.hasNext()) {
            this.sampleChoice.addItem(itr.next());
        }
        this.sampleChoice.setSelectedIndex(0);
    }

    private JPanel constructBottomPanel() {
        JPanel bottom = new JPanel();
        JButton button = new JButton("Load");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        bottom.add(button);
        button = new JButton("Cancel");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        bottom.add(button);
        return bottom;
    }

    protected boolean getProblemList() {
        try {
            String text;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/SampleProblems.txt")));
            while ((text = in.readLine()) != null) {
                if ((text = text.trim()).length() <= 0 || text.substring(0, 2).equals("//")) continue;
                int p1 = text.indexOf(",");
                this.problemNameToFileName.put(text.substring(0, p1), text.substring(p1 + 1, text.length()).trim());
            }
            in.close();
            return true;
        }
        catch (Exception e) {
            this.window.showMessage("Error", "Error loading problem list: " + e.getLocalizedMessage() + ".");
            return false;
        }
    }

    protected void loadProblem() {
        if (this.sampleChoice.getSelectedItem() != null && !this.sampleChoice.getSelectedItem().equals("<Error>")) {
            this.window.setFileName(this.problemNameToFileName.get(this.sampleChoice.getSelectedItem()));
            this.window.load(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/saves/" + this.problemNameToFileName.get(this.sampleChoice.getSelectedItem())))));
        } else {
            this.window.showMessage("Error", "Error loading file.");
        }
    }

    protected boolean actionOK() {
        this.loadProblem();
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }
}

