/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit.help;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JPanel;

public abstract class HelpCanvas
extends JPanel {
    protected final int LINE_SEPARATION = 35;
    protected final int GROUP_SEPARATION = 60;
    protected final int SUBGROUP_SEPARATION = 50;
    private int lineWidth = 2;
    private boolean isAntiAliasingEnabled;
    private float[] dashedPattern = new float[]{10.0f, 10.0f, 10.0f, 10.0f};

    public HelpCanvas(boolean isAntiAliasingEnabled) {
        this.isAntiAliasingEnabled = isAntiAliasingEnabled;
        this.setBackground(Color.white);
    }

    public void paint(Graphics graphics) {
        if (this.isAntiAliasingEnabled) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paint(graphics);
    }

    public void drawEdge(Graphics graphics, int x, int y, int length, Color color, boolean isDashed, boolean isLineBold, boolean isArrowHeadFilled) {
        Stroke oldStroke = null;
        graphics.setColor(color);
        int extraWidth = this.lineWidth;
        if (isLineBold) {
            extraWidth += 4;
        }
        if (isDashed) {
            oldStroke = ((Graphics2D)graphics).getStroke();
            ((Graphics2D)graphics).setStroke(new BasicStroke(extraWidth, 0, 0, 10.0f, this.dashedPattern, 0.0f));
        }
        graphics.drawLine(x - length / 2, y, x + length / 2 - 6, y);
        if (!isDashed) {
            int shiftDown = --extraWidth / 2;
            while (extraWidth > 0) {
                graphics.drawLine(x - length / 2, y + shiftDown - extraWidth, x + length / 2 - 6, y + shiftDown - extraWidth);
                --extraWidth;
            }
        }
        if (isDashed) {
            ((Graphics2D)graphics).setStroke(oldStroke);
        }
        if (!isArrowHeadFilled) {
            graphics.drawLine(x + length / 2 - 6, y - 6, x + length / 2 - 6, y + 6);
            graphics.drawLine(x + length / 2 - 6, y + 6, x + length / 2 + 8, y);
            graphics.drawLine(x + length / 2 - 6, y - 6, x + length / 2 + 8, y);
        } else {
            int[] xPoints = new int[]{x + length / 2 - 6, x + length / 2 + 8, x + length / 2 - 6};
            int[] yPoints = new int[]{y + 6, y, y - 6};
            graphics.fillPolygon(xPoints, yPoints, 3);
        }
        graphics.setColor(Color.BLACK);
    }

    public void drawEdge(Graphics graphics, int x, int y, int length, Color color, boolean isDashed, boolean isLineBold) {
        Stroke oldStroke = null;
        graphics.setColor(color);
        int extraWidth = this.lineWidth;
        if (isLineBold) {
            extraWidth += 4;
        }
        if (isDashed) {
            oldStroke = ((Graphics2D)graphics).getStroke();
            float[] dashedPattern = new float[]{10.0f, 10.0f, 10.0f, 10.0f};
            ((Graphics2D)graphics).setStroke(new BasicStroke(extraWidth, 0, 0, 10.0f, dashedPattern, 0.0f));
        }
        graphics.drawLine(x - length / 2, y, x + length / 2, y);
        if (!isDashed) {
            int shiftDown = --extraWidth / 2;
            while (extraWidth > 0) {
                graphics.drawLine(x - length / 2, y + shiftDown - extraWidth, x + length / 2, y + shiftDown - extraWidth);
                --extraWidth;
            }
        }
        if (isDashed) {
            ((Graphics2D)graphics).setStroke(oldStroke);
        }
        graphics.setColor(Color.BLACK);
    }

    public void drawRectangleNode(Graphics graphics, int x, int y, int width, int height, Color color, boolean isBold, boolean isFilled) {
        width = (int)((double)width * 1.2);
        height = (int)((double)height * 1.2);
        int extraWidth = this.lineWidth;
        if (isBold) {
            extraWidth += 2;
        }
        graphics.setColor(color);
        graphics.fillRect(x - width / 2, y - height / 2, width, height);
        if (!isFilled) {
            graphics.setColor(Color.white);
            graphics.fillRect(x - width / 2 + extraWidth, y - height / 2 + extraWidth, width - 2 * extraWidth, height - 2 * extraWidth);
        }
        graphics.setColor(Color.black);
    }

    public void drawOvalNode(Graphics graphics, int x, int y, int width, int height, Color color, boolean isBold, boolean isFilled) {
        height = (int)((double)height * 1.3);
        width = (int)((double)width * 1.3);
        int extraWidth = this.lineWidth;
        if (isBold) {
            extraWidth += 2;
        }
        graphics.setColor(color);
        graphics.fillOval(x - width / 2, y - height / 2, width, height);
        if (!isFilled) {
            graphics.setColor(Color.white);
            graphics.fillOval(x - width / 2 + extraWidth, y - height / 2 + extraWidth, width - 2 * extraWidth, height - 2 * extraWidth);
        }
        graphics.setColor(Color.black);
    }

    public void drawDiamondNode(Graphics graphics, int x, int y, int width, int height, Color color, boolean isBold, boolean isFilled) {
        int[] xVals = new int[]{x, (int)((double)x + (double)width / 1.5), x, (int)((double)x - (double)width / 1.5)};
        int[] yVals = new int[]{(int)((double)y - (double)height / 1.5), y, (int)((double)y + (double)height / 1.5), y};
        int extraWidth = this.lineWidth;
        if (isBold) {
            extraWidth += 2;
        }
        graphics.setColor(color);
        graphics.fillPolygon(xVals, yVals, 4);
        if (!isFilled) {
            graphics.setColor(Color.white);
            xVals[1] = xVals[1] - 2 * extraWidth;
            xVals[3] = xVals[3] + 2 * extraWidth;
            yVals[0] = yVals[0] + extraWidth;
            yVals[2] = yVals[2] - extraWidth;
            graphics.fillPolygon(xVals, yVals, 4);
        }
        graphics.setColor(Color.black);
    }
}

