/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit.help;

import CIspace.graphToolKit.GraphWindow;
import CIspace.graphToolKit.dialogs.AboutDialog;
import CIspace.graphToolKit.elements.Point;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpMenu
extends JMenu
implements ActionListener {
    private static final String aboutCIspaceURL = "http://www.cs.ubc.ca/labs/lci/CIspace/Version4/";
    private String appletName;
    private JFrame parent;
    protected JEditorPane htmlPane;

    public HelpMenu(String name, JFrame parent) {
        super("Help");
        this.appletName = name;
        this.parent = parent;
        this.setMnemonic(72);
        JMenuItem mi = new JMenuItem("Legend for Nodes/Edges");
        mi.setMnemonic(76);
        mi.setActionCommand(mi.getText());
        mi.addActionListener((GraphWindow)parent);
        this.add(mi);
        mi = new JMenuItem("Help");
        mi.setMnemonic(72);
        mi.addActionListener(this);
        this.add(mi);
        mi = new JMenuItem("Tutorials");
        mi.setMnemonic(84);
        mi.addActionListener(this);
        this.add(mi);
        this.addSeparator();
        mi = new JMenuItem("About CIspace");
        mi.setMnemonic(67);
        mi.addActionListener(this);
        this.add(mi);
        mi = new JMenuItem("About this Applet");
        mi.setMnemonic(65);
        mi.addActionListener(this);
        this.add(mi);
    }

    public void openBrowserHelp(String title, String helptype) {
        new MyEditor(title, aboutCIspaceURL + this.appletName + "/help/" + helptype);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Help") {
            if (((GraphWindow)this.parent).getTabIndex() == 0) {
                this.openBrowserHelp("Help", "general.html#create");
            } else {
                this.openBrowserHelp("Help", "general.html#solve");
            }
        } else if (e.getActionCommand() == "Tutorials") {
            this.openBrowserHelp("Tutorials", "tutorials.html");
        } else if (e.getActionCommand() == "About CIspace") {
            new AboutDialog(this.parent, true);
        } else if (e.getActionCommand() == "About this Applet") {
            new AboutDialog(this.parent, false);
        }
    }

    private class MyEditor
    extends JFrame
    implements HyperlinkListener {
        public MyEditor(String title, String urlString) {
            super(title);
            try {
                HelpMenu.this.htmlPane = new JEditorPane();
                HelpMenu.this.htmlPane.addHyperlinkListener(this);
                HelpMenu.this.htmlPane.setPage(urlString);
                HelpMenu.this.htmlPane.setEditable(false);
                JScrollPane htmlView = new JScrollPane(HelpMenu.this.htmlPane);
                htmlView.setMinimumSize(new Dimension(500, 500));
                this.getContentPane().add((Component)htmlView, "Center");
                this.setSize(600, 600);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Point bottomLeftCorner = new Point(screenSize.width, screenSize.height);
                Dimension windowSize = this.getSize();
                this.setLocation((int)(bottomLeftCorner.x - (float)windowSize.width), (int)(bottomLeftCorner.y - (float)windowSize.height));
                this.setVisible(true);
            }
            catch (IOException e) {
                ((GraphWindow)HelpMenu.this.parent).showMessage("Error", "Cannot access URL. You must be connected to the Internet in order to view help documentation.");
            }
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    HelpMenu.this.htmlPane.setPage(e.getURL());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

