/*
 * Decompiled with CFR 0.152.
 */
package AIspace.dTree;

import AIspace.XMLReader.Pair;
import AIspace.XMLReader.XMLBlock;
import AIspace.XMLReader.XMLParseException;
import AIspace.XMLReader.XMLTree;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleList
implements Cloneable {
    private DefaultListModel testModel;
    private DefaultListModel trainingModel;
    protected ArrayList<Hashtable<Integer, String>> trainingData = new ArrayList(5);
    protected ArrayList<Hashtable<Integer, String>> testData = new ArrayList(5);
    protected Integer[] indices = null;
    protected String[] parameters = null;
    protected boolean[] isInput = null;
    protected float probTest = 0.5f;
    private JList trainingList = new JList();
    private JList testList;
    protected String shortDescription = "";
    protected String detailedDescription = "";

    public ExampleList() {
        this.trainingList.setSelectionMode(2);
        this.trainingModel = new DefaultListModel();
        this.trainingList.setModel(this.trainingModel);
        this.testList = new JList();
        this.testList.setSelectionMode(2);
        this.testModel = new DefaultListModel();
        this.testList.setModel(this.testModel);
        Font font = new Font("courier", 0, 12);
        this.trainingList.setFont(font);
        this.testList.setFont(font);
        this.shortDescription = new String();
        this.detailedDescription = new String();
    }

    public void reset() {
        this.trainingData.clear();
        this.testData.clear();
        this.indices = null;
        this.parameters = null;
        this.isInput = null;
        this.probTest = 0.5f;
        this.trainingList.removeAll();
        this.testList.removeAll();
        this.trainingModel.clear();
        this.testModel.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String parse(String file) {
        String errorMessage = new String("");
        this.shortDescription = new String("");
        this.detailedDescription = new String("");
        boolean rawDataFound = false;
        int p1 = -1;
        int p2 = file.indexOf("\n");
        int lineCount = 0;
        try {
            while (p2 != -1) {
                String inString = file.substring(p1 + 1, p2).trim();
                if (inString.length() > 2) {
                    errorMessage = this.parseLine(inString.trim());
                    if (errorMessage.equals("RawDataFound")) {
                        rawDataFound = true;
                    } else {
                        if (errorMessage.equals("You must identify parameters before loading examples")) {
                            return "You must identify parameters before loading examples";
                        }
                        if (errorMessage.length() > 0) {
                            throw new Exception();
                        }
                    }
                }
                p1 = p2;
                p2 = file.indexOf("\n", p1 + 1);
                ++lineCount;
            }
            if (!rawDataFound) return "OK";
            int numToMove = (int)((float)this.trainingData.size() * this.probTest);
            int[] inds = new int[numToMove];
            if (numToMove > 0) {
                int n;
                inds[0] = n = (int)((double)this.trainingData.size() * Math.random());
                int i = 1;
                while (i < numToMove) {
                    boolean different = false;
                    block4: while (!different) {
                        n = (int)((double)this.trainingData.size() * Math.random());
                        different = true;
                        int j = 0;
                        while (j < i) {
                            if (inds[j] == n) {
                                different = false;
                                continue block4;
                            }
                            ++j;
                        }
                    }
                    inds[i] = n;
                    ++i;
                }
            }
            this.moveToTest(inds);
            return "OK";
        }
        catch (Exception e) {
            String message = "";
            if (errorMessage.length() <= 0) return "Error at line " + (lineCount + 1) + " -- " + e.toString();
            return "Error at line " + (lineCount + 1) + " -- " + errorMessage;
        }
    }

    public String parseLine(String inString) {
        String errorMessage = new String("");
        int numParameters = this.getNumParameters();
        if (inString.charAt(0) == 'T' && inString.charAt(1) == ':') {
            ArrayList<String> titles = new ArrayList<String>();
            String dataString = inString.substring(2);
            StringTokenizer tokenizer = new StringTokenizer(dataString);
            while (tokenizer.hasMoreTokens()) {
                titles.add(tokenizer.nextToken(",;").trim());
            }
            numParameters = titles.size();
            this.setParameters(titles);
        } else if ((inString.charAt(0) == 'A' || inString.charAt(0) == 'B' || inString.charAt(0) == 'X') && inString.charAt(1) == ':') {
            if (numParameters == 0) {
                return "You must identify parameters before loading examples";
            }
            String dataString = inString.substring(2);
            StringTokenizer tokenizer = new StringTokenizer(dataString);
            String[] values = new String[numParameters];
            int currTokenNum = 0;
            while (tokenizer.hasMoreTokens() && currTokenNum < numParameters) {
                values[currTokenNum] = tokenizer.nextToken(",;").trim();
                ++currTokenNum;
            }
            if (currTokenNum < numParameters - 1) {
                return "Not enough values found";
            }
            if (inString.charAt(0) == 'A' || inString.charAt(0) == 'X') {
                this.addTrainingExample(this.indices, values);
            } else {
                this.addTestExample(this.indices, values);
            }
        } else if (inString.charAt(0) != '%' && inString.charAt(0) != ' ' && inString.charAt(0) != 'N' && inString.charAt(0) != 'E' && inString.charAt(0) != '\n') {
            if (numParameters == 0) {
                return "You must identify parameters before loading examples";
            }
            StringTokenizer tokenizer = new StringTokenizer(inString);
            String[] values = new String[numParameters];
            int currTokenNum = 0;
            while (tokenizer.hasMoreTokens() && currTokenNum < numParameters) {
                values[currTokenNum] = tokenizer.nextToken(", ;");
                ++currTokenNum;
            }
            if (currTokenNum < numParameters - 1) {
                return "";
            }
            this.addTrainingExample(this.indices, values);
            return "RawDataFound";
        }
        return errorMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String parseXML(XMLTree tree) {
        String errString = "";
        try {
            Pair paraPair;
            ArrayList<Pair> paraList;
            int j;
            ArrayList<XMLBlock> values;
            XMLBlock oneExample;
            int i;
            XMLBlock exTree = tree.findNetworkTree("examples");
            XMLBlock desc = tree.findNetworkTree("description");
            ArrayList<Object> sdescs = new ArrayList();
            ArrayList<Object> ldescs = new ArrayList();
            if (desc == null) {
                this.shortDescription = "";
                this.detailedDescription = "";
            } else {
                sdescs = desc.searchChildTag("short");
                ldescs = desc.searchChildTag("detailed");
                this.shortDescription = sdescs == null || sdescs.size() == 0 ? "" : ((XMLBlock)sdescs.get(0)).getText();
                this.detailedDescription = ldescs == null || ldescs.size() == 0 ? "" : ((XMLBlock)ldescs.get(0)).getText();
            }
            ArrayList<XMLBlock> para = exTree.searchChildTag("parameter");
            if (para == null) {
                if (this.getNumParameters() == 0) {
                    return "You must identify parameters before loading examples";
                }
            } else {
                ArrayList<String> paras = null;
                ArrayList<String> in = new ArrayList<String>();
                ArrayList<String> out = new ArrayList<String>();
                i = 0;
                while (i < para.size()) {
                    XMLBlock onePara = para.get(i);
                    String name = onePara.getText();
                    if (name == "") {
                        errString = "A parameter name has an invalid name.";
                        throw new Exception();
                    }
                    ArrayList<Pair> typeVect = onePara.getProperties();
                    if (typeVect == null) {
                        in.add(name);
                    } else {
                        Pair type = typeVect.get(0);
                        if (type.name.equalsIgnoreCase("type")) {
                            if (type.value.equalsIgnoreCase("output")) {
                                out.add(name);
                            } else {
                                in.add(name);
                            }
                        } else {
                            in.add(name);
                        }
                    }
                    ++i;
                }
                int inputIndex = in.size() - 1;
                if (inputIndex < 0) {
                    errString = "No input parameters";
                    throw new Exception();
                }
                paras = in;
                int i2 = 0;
                while (i2 < out.size()) {
                    paras.add((String)out.get(i2));
                    ++i2;
                }
                this.setParameters(paras);
                i2 = 0;
                while (i2 < paras.size()) {
                    this.setInputParam(i2 <= inputIndex, i2);
                    ++i2;
                }
            }
            ArrayList<XMLBlock> exampleSet = exTree.searchChildTag("example");
            ArrayList<XMLBlock> trainSet = new ArrayList<XMLBlock>();
            ArrayList<XMLBlock> testSet = new ArrayList<XMLBlock>();
            if (exampleSet != null) {
                i = 0;
                while (i < exampleSet.size()) {
                    XMLBlock oneExample2 = exampleSet.get(i);
                    ArrayList<Pair> propVect = oneExample2.getProperties();
                    if (propVect == null || propVect.get((int)0).value.equalsIgnoreCase("training")) {
                        trainSet.add(oneExample2);
                    } else if (propVect.get((int)0).value.equalsIgnoreCase("test")) {
                        testSet.add(oneExample2);
                    } else {
                        trainSet.add(oneExample2);
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < trainSet.size()) {
                Integer[] trainIndices = new Integer[this.parameters.length];
                String[] trainItems = new String[this.parameters.length];
                oneExample = (XMLBlock)trainSet.get(i);
                values = oneExample.searchChildTag("value");
                if (values.size() != this.parameters.length) {
                    errString = "Training example " + i + "does not have the correct number of parameters";
                    throw new Exception();
                }
                j = 0;
                while (j < values.size()) {
                    paraList = values.get(j).getProperties();
                    if (paraList == null) {
                        errString = "Training example " + i + " has no associated parameter";
                        throw new Exception();
                    }
                    paraPair = paraList.get(0);
                    trainItems[j] = new String(values.get(j).getText());
                    trainIndices[j] = new Integer(this.indexOf(paraPair.value));
                    ++j;
                }
                this.addTrainingExample(trainIndices, trainItems);
                ++i;
            }
            i = 0;
            while (i < testSet.size()) {
                Integer[] testIndices = new Integer[this.parameters.length];
                String[] testItems = new String[this.parameters.length];
                oneExample = (XMLBlock)testSet.get(i);
                values = oneExample.searchChildTag("value");
                if (values.size() != this.parameters.length) {
                    errString = "Test example " + i + "does not have the correct number of parameters";
                    throw new Exception();
                }
                j = 0;
                while (j < values.size()) {
                    paraList = values.get(j).getProperties();
                    if (paraList == null) {
                        errString = "Test example " + i + " has no associated parameter";
                        throw new Exception();
                    }
                    paraPair = paraList.get(0);
                    testItems[j] = new String(paraPair.value);
                    testIndices[j] = new Integer(this.indexOf(testItems[j]));
                    ++j;
                }
                this.addTestExample(testIndices, testItems);
                ++i;
            }
            return "OK";
        }
        catch (Exception e) {
            if (errString.length() > 0) {
                return "Error: " + errString;
            }
            e.printStackTrace();
            return "Error: " + e.toString();
        }
    }

    public int indexOf(String name) {
        int i = 0;
        while (i < this.parameters.length) {
            if (this.parameters[i].equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String parseString(String all) {
        String s = all.trim();
        String errString = "";
        this.probTest = 0.5f;
        this.trainingList.removeAll();
        this.testList.removeAll();
        this.trainingModel.clear();
        this.testModel.clear();
        if (s.startsWith("<")) {
            XMLTree tree = new XMLTree();
            try {
                tree.readString(all);
            }
            catch (XMLParseException e) {
                return e.getLocalizedMessage();
            }
            errString = this.parseXML(tree);
        } else {
            errString = this.parse(all);
        }
        return errString;
    }

    public String generateTextRepCreate() {
        StringBuffer outBuffer = new StringBuffer("EXAMPLES\n");
        ArrayList<Object> examples = new ArrayList(5);
        if (this.indices == null) {
            outBuffer.append("\nNo dataset loaded.");
            return outBuffer.toString();
        }
        int k = 0;
        while (k < 2) {
            if (k == 1) {
                outBuffer.append("\n\nTest Examples: \n");
                examples = this.testData;
            } else {
                examples = this.trainingData;
                outBuffer.append("Parameters: ");
                int i = 0;
                while (i < this.indices.length) {
                    if (i > 0) {
                        outBuffer.append(", ");
                    }
                    outBuffer.append(this.parameters[i]);
                    ++i;
                }
                outBuffer.append(";\n\n");
                outBuffer.append("Training Examples: \n");
            }
            if (examples.size() > 0) {
                Integer[] indices = this.indices;
                int i = 0;
                while (i < examples.size()) {
                    outBuffer.append(i + 1).append(": ");
                    int j = 0;
                    while (j < indices.length) {
                        String v = (String)((Hashtable)examples.get(i)).get(indices[j]);
                        if (v == null) {
                            v = "Error";
                        }
                        if (j > 0) {
                            outBuffer.append(", ");
                        }
                        outBuffer.append(v);
                        ++j;
                    }
                    outBuffer.append(";\n");
                    ++i;
                }
            } else if (k == 0) {
                outBuffer.append("\n% NO TRAINING EXAMPLES\n");
            } else {
                outBuffer.append("\n% NO TEST EXAMPLES\n");
            }
            ++k;
        }
        return outBuffer.toString();
    }

    public String generateTextRep() {
        StringBuffer outBuffer = new StringBuffer("% Auto-generated on ");
        outBuffer.append(Calendar.getInstance().getTime().toString()).append("\n\n");
        outBuffer.append("%  'T:' Identifies the Attribute Title Line\n");
        outBuffer.append("%  'A:' Identifies Training Set Examples\n");
        outBuffer.append("%  'B:' Identifies Test Set Examples\n\n");
        ArrayList<Object> examples = new ArrayList(5);
        if (this.indices == null) {
            outBuffer.append("\nNO DATASET LOADED, NO GRAPH GENERATED");
            return outBuffer.toString();
        }
        int k = 0;
        while (k < 2) {
            if (k == 0) {
                outBuffer.append("T: ");
                int i = 0;
                while (i < this.indices.length) {
                    if (i > 0) {
                        outBuffer.append(", ");
                    }
                    outBuffer.append(this.parameters[i]);
                    ++i;
                }
                outBuffer.append(";\n");
                examples = this.trainingData;
            } else {
                examples = this.testData;
            }
            if (examples.size() > 0) {
                Integer[] indices = this.indices;
                int i = 0;
                while (i < examples.size()) {
                    if (k == 0) {
                        outBuffer.append("A: ");
                    } else {
                        outBuffer.append("B: ");
                    }
                    int j = 0;
                    while (j < indices.length) {
                        String v = (String)((Hashtable)examples.get(i)).get(indices[j]);
                        if (v == null) {
                            v = "Error";
                        }
                        if (j > 0) {
                            outBuffer.append(", ");
                        }
                        outBuffer.append(v);
                        ++j;
                    }
                    outBuffer.append(";\n");
                    ++i;
                }
            } else if (k == 0) {
                outBuffer.append("\n% NO TRAINING EXAMPLES\n");
            } else {
                outBuffer.append("\n% NO TEST EXAMPLES\n");
            }
            ++k;
        }
        return outBuffer.toString();
    }

    public String generateXMLTextRep() {
        StringBuffer xmlBuffer = new StringBuffer();
        if (this.indices == null) {
            xmlBuffer.append("<!-- No Examples Loaded -->\n\n");
            return xmlBuffer.toString();
        }
        xmlBuffer.append("<!-- Example Database -->\n<EXAMPLES>\n\n");
        xmlBuffer.append("\t<DESCRIPTION>\n\t\t<SHORT>").append(this.getShortDesc());
        xmlBuffer.append("</SHORT>\n\t\t<DETAILED>").append(this.getDetailedDesc());
        xmlBuffer.append("</DETAILED>\n\t</DESCRIPTION>\n\n");
        xmlBuffer.append("\t<!-- Parameter Definition -->\n");
        int i = 0;
        while (i < this.parameters.length) {
            xmlBuffer.append("\t<PARAMETER type=");
            if (this.isInput[i]) {
                xmlBuffer.append("input>");
            } else {
                xmlBuffer.append("output>");
            }
            xmlBuffer.append(this.parameters[i]).append("</PARAMETER>\n");
            ++i;
        }
        xmlBuffer.append("\n\t<!-- Examples -->\n");
        ArrayList<Object> examples = new ArrayList(5);
        int k = 0;
        while (k < 2) {
            examples = k == 0 ? this.trainingData : this.testData;
            if (examples.size() > 0) {
                Integer[] indices = this.indices;
                int i2 = 0;
                while (i2 < examples.size()) {
                    if (k == 0) {
                        xmlBuffer.append("\t<EXAMPLE type=training>\n");
                    } else {
                        xmlBuffer.append("\t<EXAMPLE type=test>\n");
                    }
                    int j = 0;
                    while (j < indices.length) {
                        String v = (String)((Hashtable)examples.get(i2)).get(indices[j]);
                        if (v == null) {
                            v = "Error";
                        }
                        xmlBuffer.append("\t\t<VALUE parameter=\"").append(this.parameters[j]).append("\">").append(v).append("</VALUE>\n");
                        ++j;
                    }
                    xmlBuffer.append("\t</EXAMPLE>\n");
                    ++i2;
                }
            }
            ++k;
        }
        xmlBuffer.append("</EXAMPLES>\n\n");
        return xmlBuffer.toString();
    }

    public String inValue(int i, int j) {
        return this.trainingData.get(i).get(this.indices[j]);
    }

    public String outValue(int i) {
        return this.trainingData.get(i).get(this.indices[this.indices.length - 1]);
    }

    public void addTestExample(Integer[] ind, String[] values) {
        this.indices = (Integer[])ind.clone();
        Hashtable<Integer, String> oneExample = new Hashtable<Integer, String>();
        int i = 0;
        while (i < this.indices.length) {
            oneExample.put(this.indices[i], values[i]);
            ++i;
        }
        this.testData.add(oneExample);
    }

    public void updateTestExample(int index, Integer[] ind, String[] values) {
        this.testData.remove(index);
        this.indices = (Integer[])ind.clone();
        Hashtable<Integer, String> oneExample = new Hashtable<Integer, String>();
        int i = 0;
        while (i < this.indices.length) {
            oneExample.put(this.indices[i], values[i]);
            ++i;
        }
        this.testData.add(index, oneExample);
        this.testList = this.getTestList();
    }

    public void updateTrainingExample(int index, Integer[] ind, String[] values) {
        this.trainingData.remove(index);
        this.indices = (Integer[])ind.clone();
        Hashtable<Integer, String> oneExample = new Hashtable<Integer, String>();
        int i = 0;
        while (i < this.indices.length) {
            oneExample.put(this.indices[i], values[i]);
            ++i;
        }
        this.trainingData.add(index, oneExample);
        this.trainingList = this.getTrainingList();
    }

    public void updateTrainingExample(int index, Hashtable<Integer, String> oneExample) {
        this.trainingData.remove(index);
        this.trainingData.add(index, oneExample);
        this.trainingList = this.getTrainingList();
    }

    public void updateTestExample(int index, Hashtable<Integer, String> oneExample) {
        this.testData.remove(index);
        this.testData.add(index, oneExample);
        this.testList = this.getTestList();
    }

    public Hashtable<Integer, String> getTestExampleValues(int index) {
        return this.testData.get(index);
    }

    public Hashtable<Integer, String> getTrainingExampleValues(int index) {
        return this.trainingData.get(index);
    }

    public void removeTestExamples(int[] inds) {
        int i = inds.length - 1;
        while (i >= 0) {
            this.testData.remove(inds[i]);
            --i;
        }
        this.testList = this.getTestList();
    }

    public void setParameters(String[] para) {
        ArrayList<String> parameters = new ArrayList<String>(para.length);
        int i = 0;
        while (i < para.length) {
            parameters.add(para[i]);
            ++i;
        }
        this.setParameters(parameters);
    }

    public int getTestSize() {
        return this.testModel.getSize();
    }

    public int getTrainingSize() {
        return this.trainingModel.getSize();
    }

    public void setParameters(ArrayList<String> newParams) {
        this.reset();
        this.parameters = new String[newParams.size()];
        this.indices = new Integer[newParams.size()];
        this.isInput = new boolean[newParams.size()];
        int i = 0;
        while (i < newParams.size()) {
            this.parameters[i] = newParams.get(i);
            this.indices[i] = new Integer(i);
            this.isInput[i] = true;
            ++i;
        }
        this.isInput[newParams.size() - 1] = false;
    }

    public void setInputParam(boolean boolInput, int index) {
        if (this.isInput == null || index >= this.isInput.length || index < 0) {
            return;
        }
        this.isInput[index] = boolInput;
    }

    public boolean isInputParam(int index) {
        if (this.isInput == null || index >= this.isInput.length || index < 0) {
            return false;
        }
        return this.isInput[index];
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void addTrainingExample(Integer[] ind, String[] values) {
        this.indices = (Integer[])ind.clone();
        Hashtable<Integer, String> oneExample = new Hashtable<Integer, String>();
        int i = 0;
        while (i < this.indices.length) {
            oneExample.put(this.indices[i], values[i]);
            ++i;
        }
        this.trainingData.add(oneExample);
    }

    public void removeTrainingExamples(int[] inds) {
        int i = inds.length - 1;
        while (i >= 0) {
            this.trainingData.remove(inds[i]);
            --i;
        }
        this.trainingList = this.getTrainingList();
    }

    public void moveToTest(int[] inds) {
        this.sortIntArray(inds);
        int i = 0;
        while (i < inds.length) {
            this.testData.add(this.trainingData.get(inds[i]));
            ++i;
        }
        i = inds.length - 1;
        while (i >= 0) {
            this.trainingData.remove(inds[i]);
            --i;
        }
        this.trainingList = this.getTrainingList();
        this.testList = this.getTestList();
    }

    public void moveToTraining(int[] inds) {
        this.sortIntArray(inds);
        int i = 0;
        while (i < inds.length) {
            this.trainingData.add(this.testData.get(inds[i]));
            ++i;
        }
        i = inds.length - 1;
        while (i >= 0) {
            this.testData.remove(inds[i]);
            --i;
        }
        this.trainingList = this.getTrainingList();
        this.testList = this.getTestList();
    }

    public JList getTestList() {
        int i;
        this.testModel.clear();
        StringBuffer buffer = new StringBuffer();
        if (this.indices == null) {
            buffer.append("NO DATA");
            this.testModel.addElement(buffer.toString());
            return this.testList;
        }
        if (this.parameters != null) {
            buffer = new StringBuffer();
            i = 0;
            while (i < this.indices.length) {
                buffer.append(this.parameters[i]);
                int j = this.parameters[i].length();
                while (j < 8) {
                    buffer.append(" ");
                    ++j;
                }
                ++i;
            }
        }
        this.testModel.addElement(buffer.toString());
        i = 0;
        while (i < this.testData.size()) {
            buffer = new StringBuffer();
            Hashtable<Integer, String> oneExample = this.testData.get(i);
            int j = 0;
            while (j < this.indices.length) {
                String value = oneExample.get(this.indices[j]);
                if (value != null) {
                    buffer.append(value);
                    int k = value.length();
                    while (k < 8) {
                        buffer.append("  ");
                        ++k;
                    }
                }
                ++j;
            }
            this.testModel.addElement(buffer.toString());
            ++i;
        }
        return this.testList;
    }

    public ArrayList<Hashtable<Integer, String>> getTestArrayList() {
        return this.testData;
    }

    public ArrayList<Hashtable<Integer, String>> getTrainingArrayList() {
        return this.trainingData;
    }

    public Integer[] getIndices() {
        return this.indices;
    }

    public JList getTrainingList() {
        int j;
        int i;
        this.trainingModel.clear();
        StringBuffer buffer = new StringBuffer();
        if (this.indices == null) {
            buffer.append("NO DATA");
            this.trainingModel.addElement(buffer.toString());
            return this.trainingList;
        }
        if (this.parameters != null) {
            buffer = new StringBuffer();
            i = 0;
            while (i < this.indices.length) {
                buffer.append(this.parameters[i]);
                j = this.parameters[i].length();
                while (j < 8) {
                    buffer.append(" ");
                    ++j;
                }
                ++i;
            }
        }
        this.trainingModel.addElement(buffer.toString());
        i = 0;
        while (i < this.trainingData.size()) {
            buffer = new StringBuffer();
            j = 0;
            while (j < this.indices.length) {
                String value = this.trainingData.get(i).get(this.indices[j]);
                if (value != null) {
                    buffer.append(value);
                    int k = value.length();
                    while (k < 8) {
                        buffer.append(" ");
                        ++k;
                    }
                }
                ++j;
            }
            this.trainingModel.addElement(buffer.toString());
            ++i;
        }
        return this.trainingList;
    }

    public int getNumParameters() {
        if (this.parameters != null) {
            return this.parameters.length;
        }
        return 0;
    }

    public ArrayList<String> getValueSet(int paramIndex) {
        ArrayList<String> outputList = new ArrayList<String>(5);
        boolean valueExists = false;
        int i = 0;
        while (i < this.trainingData.size()) {
            String value = this.trainingData.get(i).get(new Integer(paramIndex));
            valueExists = false;
            int j = 0;
            while (j < outputList.size()) {
                if (outputList.get(j).equals(value)) {
                    valueExists = true;
                    break;
                }
                ++j;
            }
            if (!valueExists) {
                outputList.add(value);
            }
            ++i;
        }
        this.sortStringList(outputList);
        return outputList;
    }

    public String getShortDesc() {
        return this.shortDescription;
    }

    public void setShortDesc(String description) {
        this.shortDescription = description;
        if (description.trim().equals("") || description == null) {
            this.shortDescription = "";
        }
    }

    public String getDetailedDesc() {
        return this.detailedDescription;
    }

    public void setDetailedDesc(String description) {
        this.detailedDescription = description;
        if (description.trim().equals("") || description == null) {
            this.detailedDescription = "";
        }
    }

    public void sortIntArray(int[] inputArray) {
        int i = 0;
        while (i < inputArray.length) {
            int j = i;
            while (j < inputArray.length) {
                if (inputArray[j] < inputArray[i]) {
                    int temp = inputArray[i];
                    inputArray[i] = inputArray[j];
                    inputArray[j] = temp;
                }
                ++j;
            }
            ++i;
        }
    }

    public void sortStringList(ArrayList<String> inputList) {
        int i = 0;
        while (i < inputList.size()) {
            int j = i;
            while (j < inputList.size()) {
                if (inputList.get(j).compareTo(inputList.get(i)) < 0) {
                    String temp = inputList.get(i);
                    inputList.set(i, inputList.get(j));
                    inputList.set(j, temp);
                }
                ++j;
            }
            ++i;
        }
    }

    public Object clone() {
        ExampleList copy = new ExampleList();
        copy.trainingData = new ArrayList<Hashtable<Integer, String>>(this.trainingData);
        copy.indices = new Integer[this.indices.length];
        copy.parameters = new String[this.indices.length];
        int i = 0;
        while (i < this.indices.length) {
            copy.indices[i] = new Integer(this.indices[i]);
            copy.parameters[i] = new String(this.parameters[i]);
            ++i;
        }
        return copy;
    }
}

