/*
 * Decompiled with CFR 0.152.
 */
package AIspace.dTree;

import AIspace.dTree.AutoCreate;
import AIspace.dTree.ExampleList;
import AIspace.dTree.InlineCanvas;
import AIspace.dTree.PlotFrame;
import AIspace.dTree.dTreeCanvas;
import AIspace.dTree.dTreeGraph;
import AIspace.dTree.dialogs.ExampleDialog;
import AIspace.dTree.dialogs.ParameterInputDialog;
import AIspace.dTree.dialogs.ProbTestResultsFrame;
import AIspace.dTree.dialogs.TestNewExampleDialog;
import AIspace.dTree.dialogs.dTreeTextFrame;
import AIspace.graphToolKit.GraphCanvas;
import AIspace.graphToolKit.InlineApplet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class InlineDTreeApplet
extends InlineApplet {
    private static final long serialVersionUID = 1L;
    public AutoCreate autoCreate;
    private int delayTime;
    public ExampleList exampleList;
    protected PlotFrame plotWindow;
    private boolean isInitialStep;
    private ExampleDialog exampleDialog;
    public JToggleButton fakeButton;
    public JToggleButton examplesButton;
    public JToggleButton stepButton;
    public JToggleButton autoCreateButton;
    public JToggleButton stopButton;
    public JToggleButton resetGraphButton;
    public JToggleButton showPlotButton;
    public JToggleButton viewNodeInfoButton;
    public JToggleButton viewMappedExamplesButton;
    public JToggleButton toggleHistogramButton;
    public JToggleButton splitNodeButton;
    public JToggleButton moveSubtreeButton;
    public JToggleButton testButton;
    public JToggleButton testNewExampleButton;
    private boolean examplesButtonOn = false;
    private boolean stepButtonOn = false;
    private boolean autoCreateButtonOn = false;
    private boolean stopButtonOn = false;
    private boolean resetGraphButtonOn = false;
    private boolean showPlotButtonOn = false;
    private boolean viewNodeInfoButtonOn = false;
    private boolean viewMappedExamplesButtonOn = false;
    private boolean toggleHistogramButtonOn = false;
    private boolean splitNodeButtonOn = false;
    private boolean moveSubtreeButtonOn = false;
    private boolean testButtonOn = false;
    private boolean testNewExampleButtonOn = false;
    public boolean examplesPopupOn = false;
    public boolean stepPopupOn = false;
    public boolean autoCreatePopupOn = false;
    public boolean stopPopupOn = false;
    public boolean resetGraphPopupOn = false;
    public boolean splitNodePopupOn = false;
    public boolean toggleHistogramPopupOn = false;
    public boolean viewMappedExamplesPopupOn = false;
    public boolean viewNodeInfoPopupOn = false;
    public boolean showPlotPopupOn = false;
    public boolean testPopupOn = false;
    public boolean testNewExamplePopupOn = false;

    public void init() {
        super.init();
        this.exampleList = new ExampleList();
        this.makeCanvas();
        this.plotWindow = new PlotFrame((dTreeGraph)this.canvas.graph);
        this.loadParams();
        if (this.incorrectParameter) {
            return;
        }
        ((InlineCanvas)this.canvas).initializePopup();
        this.createToolBar();
        this.addComponent(this.messageCanvas, this.canvasPanel, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.canvas, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        if (!this.showMessagePanel) {
            this.messageCanvas.setVisible(false);
        } else {
            this.messageCanvas.setMinimumSize(new Dimension(10, 50));
        }
        if (this.showButtons) {
            this.canvasPanel.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 75));
        } else {
            this.canvasPanel.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 10));
            this.toolBarPanel.setVisible(false);
        }
        if (this.showBorder) {
            this.canvas.setBorder(BorderFactory.createLineBorder(Color.black));
            this.canvasPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        } else {
            this.canvas.setBorder(null);
        }
        this.mainPanel.add((Component)this.canvasPanel, "Center");
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.setBorder(null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.setPromptLabel("Click the 'Create New Query' button to create a query.");
    }

    protected void makeCanvas() {
        this.canvas = new InlineCanvas(this);
        this.canvas.WIDTH = this.getSize().width;
        this.canvas.HEIGHT = this.getSize().height;
        this.canvas.setPreferredSize(new Dimension(this.canvas.WIDTH, this.canvas.HEIGHT));
        this.canvas.setMode(2221);
    }

    public void createToolBar() {
        this.toolBarPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttons = new JToggleButton[14];
        int index = 0;
        this.setSolveButtonsWithText(index, "View/Edit Ex.", InlineDTreeApplet.createImageIcon("images/dTree/Edit24.gif"), "View/Edit Ex.");
        this.examplesButton = this.buttons[index++];
        if (!this.examplesButtonOn) {
            this.examplesButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Step    ", InlineDTreeApplet.createImageIcon("images/dTree/step.png"), "Step");
        this.stepButton = this.buttons[index++];
        if (!this.stepButtonOn) {
            this.stepButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Auto Create", InlineDTreeApplet.createImageIcon("images/dTree/gear.png"), "Auto Create");
        this.autoCreateButton = this.buttons[index++];
        if (!this.autoCreateButtonOn) {
            this.autoCreateButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Stop    ", InlineDTreeApplet.createImageIcon("images/dTree/stop.gif"), "Stop");
        this.stopButton = this.buttons[index++];
        if (!this.stopButtonOn) {
            this.stopButton.setVisible(false);
        }
        this.stopButton.setEnabled(false);
        this.setSolveButtonsWithText(index, "Reset Graph", InlineDTreeApplet.createImageIcon("images/dTree/Reset.gif"), "Reset Graph");
        this.resetGraphButton = this.buttons[index++];
        if (!this.resetGraphButtonOn) {
            this.resetGraphButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Show Plot", InlineDTreeApplet.createImageIcon("images/dTree/showPlot.png"), "Show Plot");
        this.showPlotButton = this.buttons[index++];
        if (!this.showPlotButtonOn) {
            this.showPlotButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "View Node Info", InlineDTreeApplet.createImageIcon("images/dTree/viewNodeInfo.png"), "View Node Info");
        this.viewNodeInfoButton = this.buttons[index++];
        if (!this.viewNodeInfoButtonOn) {
            this.viewNodeInfoButton.setVisible(false);
        }
        this.viewNodeInfoButton.setSelected(true);
        this.setSolveButtonsWithText(index, "View Mapped Ex.", InlineDTreeApplet.createImageIcon("images/dTree/viewKBCheckBox.png"), "View Mapped Ex.");
        this.viewMappedExamplesButton = this.buttons[index++];
        if (!this.viewMappedExamplesButtonOn) {
            this.viewMappedExamplesButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Toggle Histogram", InlineDTreeApplet.createImageIcon("images/dTree/toggleMonitoring.png"), "Toggle Histogram");
        this.toggleHistogramButton = this.buttons[index++];
        if (!this.toggleHistogramButtonOn) {
            this.toggleHistogramButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Split Node", InlineDTreeApplet.createImageIcon("images/dTree/splitNode.png"), "Split Node");
        this.splitNodeButton = this.buttons[index++];
        if (!this.splitNodeButtonOn) {
            this.splitNodeButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Move Subtree", InlineDTreeApplet.createImageIcon("images/dTree/movesubtree.png"), "Move Subtree");
        this.moveSubtreeButton = this.buttons[index++];
        if (!this.moveSubtreeButtonOn) {
            this.moveSubtreeButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Test    ", InlineDTreeApplet.createImageIcon("images/dTree/quiz.gif"), "Test");
        this.testButton = this.buttons[index++];
        if (!this.testButtonOn) {
            this.testButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Test New Ex.", InlineDTreeApplet.createImageIcon("images/dTree/testNew.png"), "Test New Ex.");
        this.testNewExampleButton = this.buttons[index++];
        if (!this.testNewExampleButtonOn) {
            this.testNewExampleButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Fake", InlineDTreeApplet.createImageIcon("images/common/finestep.png"), "Fake");
        this.fakeButton = this.buttons[index++];
        ButtonGroup buttonGroup2 = new ButtonGroup();
        Font toolFont = new Font("arial", 0, 10);
        int i = 0;
        while (i < index) {
            if (this.buttons[i] != this.viewNodeInfoButton && this.buttons[i] != this.viewMappedExamplesButton && this.buttons[i] != this.toggleHistogramButton && this.buttons[i] != this.splitNodeButton && this.buttons[i] != this.moveSubtreeButton) {
                buttonGroup.add(this.buttons[i]);
                toolBar.add(this.buttons[i]);
                this.buttons[i].setFont(toolFont);
            } else {
                buttonGroup2.add(this.buttons[i]);
                toolBar.add(this.buttons[i]);
                this.buttons[i].setFont(toolFont);
            }
            ++i;
        }
        this.buttons[index - 1].setVisible(false);
        this.toolBarPanel.add((Component)toolBar, "Center");
        this.mainPanel.add((Component)this.toolBarPanel, "North");
    }

    public final GraphCanvas returnCanvas() {
        return this.canvas;
    }

    public boolean getShowHistograms() {
        return true;
    }

    public void clear() {
        this.exampleList.reset();
        this.returnCanvas().reset();
    }

    protected void loadParams() {
        super.loadParams();
        String param = this.getParameter("examplesButton");
        if (param != null) {
            if (param.equals("on")) {
                this.examplesButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("examplesButton", param);
            }
        }
        if ((param = this.getParameter("stepButton")) != null) {
            if (param.equals("on")) {
                this.stepButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepButton", param);
            }
        }
        if ((param = this.getParameter("autoCreateButton")) != null) {
            if (param.equals("on")) {
                this.autoCreateButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoCreateButton", param);
            }
        }
        if ((param = this.getParameter("stopButton")) != null) {
            if (param.equals("on")) {
                this.stopButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopButton", param);
            }
        }
        if ((param = this.getParameter("resetGraphButton")) != null) {
            if (param.equals("on")) {
                this.resetGraphButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("resetGraphButton", param);
            }
        }
        if ((param = this.getParameter("showPlotButton")) != null) {
            if (param.equals("on")) {
                this.showPlotButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showPlotButton", param);
            }
        }
        if ((param = this.getParameter("viewNodeInfoButton")) != null) {
            if (param.equals("on")) {
                this.viewNodeInfoButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("viewNodeInfoButton", param);
            }
        }
        if ((param = this.getParameter("viewMappedExamplesButton")) != null) {
            if (param.equals("on")) {
                this.viewMappedExamplesButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("viewMappedExamplesButton", param);
            }
        }
        if ((param = this.getParameter("toggleHistogramButton")) != null) {
            if (param.equals("on")) {
                this.toggleHistogramButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("toggleHistogramButton", param);
            }
        }
        if ((param = this.getParameter("splitNodeButton")) != null) {
            if (param.equals("on")) {
                this.splitNodeButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("splitNodeButton", param);
            }
        }
        if ((param = this.getParameter("moveSubtreeButton")) != null) {
            if (param.equals("on")) {
                this.moveSubtreeButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("moveSubtreeButton", param);
            }
        }
        if ((param = this.getParameter("testButton")) != null) {
            if (param.equals("on")) {
                this.testButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("testButton", param);
            }
        }
        if ((param = this.getParameter("testNewExampleButton")) != null) {
            if (param.equals("on")) {
                this.testNewExampleButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("testNewExampleButton", param);
            }
        }
        if ((param = this.getParameter("examplesPopup")) != null) {
            if (param.equals("on")) {
                this.examplesPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("examplesPopup", param);
            }
        }
        if ((param = this.getParameter("stepPopup")) != null) {
            if (param.equals("on")) {
                this.stepPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepPopup", param);
            }
        }
        if ((param = this.getParameter("autoCreatePopup")) != null) {
            if (param.equals("on")) {
                this.autoCreatePopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoCreatePopup", param);
            }
        }
        if ((param = this.getParameter("stopPopup")) != null) {
            if (param.equals("on")) {
                this.stopPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopPopup", param);
            }
        }
        if ((param = this.getParameter("resetGraphPopup")) != null) {
            if (param.equals("on")) {
                this.resetGraphPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("resetGraphPopup", param);
            }
        }
        if ((param = this.getParameter("showPlotPopup")) != null) {
            if (param.equals("on")) {
                this.showPlotPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showPlotPopup", param);
            }
        }
        if ((param = this.getParameter("testPopup")) != null) {
            if (param.equals("on")) {
                this.testPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("testPopup", param);
            }
        }
        if ((param = this.getParameter("testNewExamplePopup")) != null) {
            if (param.equals("on")) {
                this.testNewExamplePopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("testNewExamplePopup", param);
            }
        }
        if ((param = this.getParameter("splitNodePopup")) != null) {
            if (param.equals("on")) {
                this.splitNodePopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("splitNodePopup", param);
            }
        }
        if ((param = this.getParameter("toggleHistogramPopup")) != null) {
            if (param.equals("on")) {
                this.toggleHistogramPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("toggleHistogramPopup", param);
            }
        }
        if ((param = this.getParameter("viewMappedExamplesPopup")) != null) {
            if (param.equals("on")) {
                this.viewMappedExamplesPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("viewMappedExamplesPopup", param);
            }
        }
        if ((param = this.getParameter("viewNodeInfoPopup")) != null) {
            if (param.equals("on")) {
                this.viewNodeInfoPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("viewNodeInfoPopup", param);
            }
        }
        if ((param = this.getParameter("splittingFunction")) != null) {
            if (param.equals("gini")) {
                dTreeGraph.splitMode = 4;
            } else if (param.equals("informationGain")) {
                dTreeGraph.splitMode = 2;
            } else if (param.equals("gainRatio")) {
                dTreeGraph.splitMode = 3;
            } else if (param.equals("random")) {
                dTreeGraph.splitMode = 1;
            } else {
                this.incorrectParameter("splittingFunction", param);
            }
        }
        if ((param = this.getParameter("speed")) != null) {
            if (param.equals("veryFast")) {
                this.delayTime = 0;
                if (this.autoCreate != null) {
                    this.autoCreate.setDelayTime(this.delayTime);
                }
            } else if (param.equals("fast")) {
                this.delayTime = 100;
                if (this.autoCreate != null) {
                    this.autoCreate.setDelayTime(this.delayTime);
                }
            } else if (param.equals("medium")) {
                this.delayTime = 500;
                if (this.autoCreate != null) {
                    this.autoCreate.setDelayTime(this.delayTime);
                }
            } else if (param.equals("slow")) {
                this.delayTime = 1000;
                if (this.autoCreate != null) {
                    this.autoCreate.setDelayTime(this.delayTime);
                }
            } else {
                this.incorrectParameter("speed", param);
            }
        } else {
            this.delayTime = 500;
            if (this.autoCreate != null) {
                this.autoCreate.setDelayTime(this.delayTime);
            }
        }
    }

    public void load(String filename) {
        try {
            String line;
            String errMsg = "";
            StringBuffer allText = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL(filename).openStream()));
            while ((line = in.readLine()) != null) {
                allText.append(line).append("\n");
            }
            in.close();
            errMsg = this.exampleList.parseString(allText.toString());
            if (errMsg.length() > 20 && errMsg.substring(19).equals("You must identify parameters before loading examples")) {
                new ParameterInputDialog(null, this.exampleList);
                errMsg = this.exampleList.getNumParameters() > 1 ? this.exampleList.parseString(allText.toString()) : "Cannot load file without parameter names";
            }
            this.plotWindow.dispose();
            this.plotWindow = new PlotFrame((dTreeGraph)this.canvas.graph);
            this.isInitialStep = true;
            this.canvas.reset();
            this.canvas.moveToTopMiddle();
            this.setPromptLabel("");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public final void showMessage(String title, String msg) {
        this.canvas.showMessage(title, msg);
    }

    public void setPlotFramePromptLabel(String message) {
        if (this.plotWindow != null) {
            this.plotWindow.setPromptLabel(message);
        }
    }

    public void step() {
        if (!this.stepButton.isEnabled()) {
            return;
        }
        this.fakeButton.setSelected(true);
        if (this.exampleList.getNumParameters() < 2) {
            this.showMessage("No Examples", "Please select \"Create New Dataset\" from the file menu or load an existing data set before creating a tree.");
            return;
        }
        if (this.isInitialStep) {
            this.plotWindow.setMaxY();
            this.isInitialStep = false;
        }
        ((dTreeGraph)this.canvas.graph).step();
    }

    public void autoCreateInit() {
        this.fakeButton.setSelected(true);
        if (this.exampleList.getNumParameters() < 2) {
            this.showMessage("No Examples", "Please select \"Create New Dataset\" from the file menu or load an existing data set before creating a tree.");
            return;
        }
        if (this.isInitialStep) {
            this.plotWindow.setMaxY();
            this.isInitialStep = false;
        }
        if (((dTreeGraph)this.canvas.graph).autoCreateContinue()) {
            if (this.delayTime > 0) {
                this.autoCreateStart();
            } else {
                ((dTreeGraph)this.canvas.graph).auto();
            }
            this.setPromptLabel("");
        } else {
            this.showMessage("Auto-Create Finished", "There are no more nodes to expand.");
        }
    }

    public void autoCreateStart() {
        this.autoCreate = new AutoCreate(this, (dTreeGraph)this.canvas.graph, this.delayTime);
        if (this.plotWindow != null) {
            this.plotWindow.setAutoCreateOn(true);
        }
        this.autoCreate.start();
        this.stepButton.setEnabled(false);
        this.autoCreateButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.resetGraphButton.setEnabled(false);
    }

    public void autoCreateEnd() {
        this.autoCreate.quit();
        if (!((dTreeGraph)this.canvas.graph).autoCreateContinue()) {
            this.showMessage("Auto-Create Finished", "There are no more nodes to expand.");
        }
        if (this.plotWindow != null) {
            this.plotWindow.setAutoCreateOn(false);
        }
        this.stepButton.setEnabled(true);
        this.autoCreateButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.resetGraphButton.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand().trim();
        if (!this.moveSubtreeButton.isSelected()) {
            this.returnCanvas().setSubmode(3332);
        }
        if (arg.equals("View/Edit Examples") || e.getSource() == this.examplesButton) {
            this.fakeButton.setSelected(true);
            if (this.exampleList.getNumParameters() < 2) {
                this.showMessage("No Examples", "Please select \"Create New Dataset\" from the file menu or load an existing data set before manipulating examples.");
            } else {
                if (this.exampleDialog != null) {
                    this.exampleDialog.dispose();
                }
                this.exampleDialog = new ExampleDialog(this, this.exampleList);
            }
            return;
        }
        if (this.returnCanvas().getMode() == 2221) {
            if (arg.equals("Step") || e.getSource() == this.stepButton) {
                this.step();
            } else if (arg.equals("Auto Create") || e.getSource() == this.autoCreateButton) {
                this.autoCreateInit();
            } else if (arg.equals("Stop") || e.getSource() == this.stopButton) {
                this.fakeButton.setSelected(true);
                this.autoCreate.quit();
                this.stopButton.setEnabled(false);
                this.setPromptLabel("");
                this.setPlotFramePromptLabel("");
            } else if (arg.equals("Reset Graph") || e.getSource() == this.resetGraphButton) {
                this.fakeButton.setSelected(true);
                this.returnCanvas().reset();
                this.returnCanvas().moveToTopMiddle();
                this.setPromptLabel("");
                this.setPlotFramePromptLabel("");
                this.stopButton.setEnabled(false);
            } else if (arg.equals("Show Plot") || e.getSource() == this.showPlotButton) {
                this.fakeButton.setSelected(true);
                if (this.plotWindow == null) {
                    this.plotWindow = new PlotFrame((dTreeGraph)this.returnCanvas().graph);
                }
                this.plotWindow.open();
            } else if (arg.equals("View Node Information") || e.getSource() == this.viewNodeInfoButton) {
                ((dTreeGraph)this.canvas.graph).setSolveGraphMode(11);
                this.setPromptLabel("Click any node to get summary information about the examples mapped to it, its entropy, and its GINI index");
            } else if (arg.equals("View Mapped Examples") || e.getSource() == this.viewMappedExamplesButton) {
                ((dTreeGraph)this.canvas.graph).setSolveGraphMode(12);
                this.setPromptLabel("Click any node to get the examples that have been mapped to that node.");
            } else if (arg.equals("Toggle Histogram") || e.getSource() == this.toggleHistogramButton) {
                ((dTreeGraph)this.canvas.graph).setSolveGraphMode(15);
                this.setPromptLabel("Click on node to view a histogram for the node's count and probability distribution. \n Click the node again to turn histogram off.");
            } else if (arg.equals("Split Node") || e.getSource() == this.splitNodeButton) {
                ((dTreeGraph)this.canvas.graph).setSolveGraphMode(13);
                this.setPromptLabel("Click on any blue node to split.");
            } else if (arg.equals("Move Subtree") || e.getSource().equals(this.moveSubtreeButton)) {
                this.canvas.setSubmode(3338);
                this.setPromptLabel("Click on a node and drag it to move it and its descendents.");
            } else if (arg.equals("Test") || e.getSource() == this.testButton) {
                this.fakeButton.setSelected(true);
                if (this.exampleList.getTestArrayList().size() > 0) {
                    new ProbTestResultsFrame(this, this.exampleList, ((dTreeGraph)this.canvas.graph).getProbabilisticTestResults(), ((dTreeGraph)this.canvas.graph).getOutputValues());
                } else {
                    this.showMessage("No Test Results", "Please add one or more examples to the test set before testing results");
                }
            } else if (arg.equals("Test New Example") || e.getSource() == this.testNewExampleButton) {
                this.fakeButton.setSelected(true);
                if (this.exampleList.getNumParameters() < 2) {
                    this.showMessage("No Examples", "Please add one or more examples to the test set before testing results");
                } else {
                    new TestNewExampleDialog(this, "Test New Example");
                }
            }
        }
        if (arg.equals("View Text Representation")) {
            new dTreeTextFrame((dTreeCanvas)this.canvas, this.exampleList.generateTextRep(), "Text Representation of Graph", false);
        } else if (arg.equals("View XML Representation")) {
            new dTreeTextFrame((dTreeCanvas)this.canvas, this.exampleList.generateXMLTextRep(), "XML Text Representation of Graph", false);
        } else if (arg.equals("Probabilistic Error")) {
            ((dTreeGraph)this.canvas.graph).setLeafErrorType(200);
            if (this.plotWindow != null) {
                this.plotWindow.clear();
                ((dTreeGraph)this.returnCanvas().graph).clearPlotPts();
                this.plotWindow.setGraph((dTreeGraph)this.returnCanvas().graph);
                ((dTreeGraph)this.returnCanvas().graph).updatePlot();
                this.setPlotFramePromptLabel(this.plotWindow.getPlotErrorString());
            }
        } else if (arg.equals("Mode Value Error")) {
            ((dTreeGraph)this.canvas.graph).setLeafErrorType(201);
            if (this.plotWindow != null) {
                this.plotWindow.clear();
                ((dTreeGraph)this.returnCanvas().graph).clearPlotPts();
                this.plotWindow.setGraph((dTreeGraph)this.returnCanvas().graph);
                ((dTreeGraph)this.returnCanvas().graph).updatePlot();
                this.plotWindow.repaint();
                this.setPlotFramePromptLabel(this.plotWindow.getPlotErrorString());
            }
        }
    }

    public void viewEditExamples() {
        if (this.examplesButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.examplesButton, 0, "View/Edit Ex."));
        }
    }

    public void autoCreate() {
        if (this.autoCreateButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.autoCreateButton, 0, "Auto Create"));
        }
    }

    public void stop() {
        if (this.stopButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.stopButton, 0, "Stop"));
        }
    }

    public void resetGraph() {
        if (this.resetGraphButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.resetGraphButton, 0, "Reset Graph"));
        }
    }

    public void showPlot() {
        if (this.showPlotButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.showPlotButton, 0, "Show Plot"));
        }
    }

    public void test() {
        if (this.testButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.testButton, 0, "Test"));
        }
    }

    public void testNewExample() {
        if (this.testNewExampleButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.testNewExampleButton, 0, "Test New Ex."));
        }
    }

    public void autoscale() {
        this.canvas.actionPerformed(new ActionEvent(this.fakeButton, 0, "Autoscale"));
    }
}

