/*
 * Decompiled with CFR 0.152.
 */
package AIspace.dTree;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class PieCanvas
extends Canvas {
    protected int numCorrect;
    protected int numNoPrediction;
    protected int numIncorrect;
    protected double total;
    protected Color correctColour;
    protected Color noPredictionColour;
    protected Color incorrectColour;

    public PieCanvas(int correct, int noPrediction, int incorrect) {
        this.numCorrect = correct;
        this.numNoPrediction = noPrediction;
        this.numIncorrect = incorrect;
        this.total = correct + noPrediction + incorrect;
        this.correctColour = new Color(Color.green.getRGB()).darker();
        this.noPredictionColour = new Color(Color.blue.getRGB()).darker();
        this.incorrectColour = new Color(Color.red.getRGB()).darker();
        this.setSize(200, 125);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int xPos = 50;
        int yPos = 15;
        int width = 100;
        int height = 100;
        double angle1 = (double)this.numCorrect / this.total * 360.0;
        double angle2 = (double)this.numNoPrediction / this.total * 360.0;
        g.setColor(this.correctColour);
        g.fillArc(xPos, yPos, width, height, 0, (int)angle1);
        if (this.numNoPrediction > 0) {
            g.setColor(this.noPredictionColour);
            g.fillArc(xPos, yPos, width, height, (int)angle1, (int)angle2);
        }
        if (this.numIncorrect > 0) {
            int startAngle = (int)(angle2 + angle1);
            int sweepAngle = (int)(360.0 - angle1 - angle2);
            g.setColor(this.incorrectColour);
            g.fillArc(xPos, yPos, width, height, startAngle, sweepAngle);
        }
        g.setColor(Color.black);
        g.drawOval(xPos, yPos, width, height);
    }
}

