/*
 * Decompiled with CFR 0.152.
 */
package AIspace.dTree;

import AIspace.dTree.AutoCreate;
import AIspace.dTree.ExampleList;
import AIspace.dTree.PlotFrame;
import AIspace.dTree.dTreeCanvas;
import AIspace.dTree.dTreeGraph;
import AIspace.dTree.dialogs.ExampleDialog;
import AIspace.dTree.dialogs.ParameterInputDialog;
import AIspace.dTree.dialogs.ProbTestResultsFrame;
import AIspace.dTree.dialogs.StoppingConditionDialog;
import AIspace.dTree.dialogs.TestNewExampleDialog;
import AIspace.dTree.dialogs.dTreeDescriptionDialog;
import AIspace.dTree.dialogs.dTreeTextFrame;
import AIspace.dTree.elements.dTreeNode;
import AIspace.dTree.help.dTreeHelpCanvas;
import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.GraphWindow;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.help.HelpFrame;
import AIspace.graphToolKit.help.HelpMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

public class dTreeWindow
extends GraphWindow {
    private static final long serialVersionUID = 1L;
    private JButton fakeButton;
    private JScrollPane programScroll;
    private JTextArea program;
    private JCheckBoxMenuItem menuItemHistogramOn;
    private JMenuItem textRepresentationMenuItem;
    private JMenuItem xmlRepresentationMenuItem;
    private JMenuItem descriptionMenuItem;
    private String extension;
    private boolean isInitialStep = true;
    private ExampleDialog exampleDialog;
    public ExampleList exampleList;
    protected PlotFrame plotWindow;
    protected AutoCreate autoCreate;
    private int delayTime = 100;
    private ImageIcon stepIcon;
    private ImageIcon autoSearchIcon;
    private ImageIcon stopIcon;
    private ImageIcon resetIcon;
    private ImageIcon quizIcon;
    private ImageIcon showPlotIcon;
    private ImageIcon editIcon;
    private ImageIcon newTestIcon;
    private ImageIcon viewNodeInfoIcon;
    private ImageIcon viewMappedIcon;
    private ImageIcon toggleIcon;
    private ImageIcon splitNodeIcon;
    private ImageIcon moveSubtreeIcon;

    public dTreeWindow(JApplet parent) {
        super(parent);
        this.initializeAppletInfo();
        this.setSize(975, 700);
        Color bg = GraphConsts.bg;
        this.setBackground(bg);
        this.setForeground(GraphConsts.fg);
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.txt");
        this.initialize();
        this.construct();
        this.addWindowListener(this);
        this.centerWindow();
        this.solveButModes[6].setSelected(true);
        this.setVisible(true);
    }

    private void initializeAppletInfo() {
        appletTitle = "Decision Tree Learning Applet Version 4.3.7";
        appletName = "dTree";
        aboutText = String.valueOf(appletTitle) + "\n\n" + "Learning is the ability to improve one's behaviour based on experience and\n" + "represents an essential element of computational intelligence. Decision\n" + "trees are a simple yet successful technique for supervised classification\n" + "learning. This tool demonstrates how to build a decision tree using a \n" + "training data set and then use the tree to classify unseen examples in a \n" + "test data set.\n\n" + "This applet was written by Kevin O'Neill, Shinjiro Sueda, Wesley Coelho,\n" + "Oxana Chakoula, Nicole Arksey, Kyle Porter, Byron Knoll, and Andre Gagne with help\n" + "from David Poole, Alan Mackworth, Holger Hoos, Peter Gorniak, Giuseppe\n" + "Carenini, and Cristina Conati.";
    }

    private void construct() {
        this.bottomPanel.setVisible(false);
        this.program = new JTextArea("", 10, 10);
        this.program.setBackground(Color.white);
        this.program.setForeground(GraphConsts.fg);
        this.setFontSize(this.returnCanvas().getFontSize());
        this.setExampleText();
        this.program.setEditable(false);
        this.program.setMargin(new Insets(0, 7, 0, 7));
        this.programScroll = new JScrollPane(this.program);
        JPanel createPanel = new JPanel();
        createPanel.setLayout(this.gbl);
        this.canvasPanel.remove(this.scrollPanel);
        this.addComponent(this.programScroll, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
    }

    private void initialize() {
        this.stepIcon = dTreeWindow.createImageIcon("images/dTree/step.png");
        this.autoSearchIcon = dTreeWindow.createImageIcon("images/dTree/gear.png");
        this.stopIcon = dTreeWindow.createImageIcon("images/dTree/stop.gif");
        this.resetIcon = dTreeWindow.createImageIcon("images/dTree/Reset.gif");
        this.quizIcon = dTreeWindow.createImageIcon("images/dTree/quiz.gif");
        this.editIcon = dTreeWindow.createImageIcon("images/dTree/Edit24.gif");
        this.showPlotIcon = dTreeWindow.createImageIcon("images/dTree/showPlot.png");
        this.newTestIcon = dTreeWindow.createImageIcon("images/dTree/testNew.png");
        this.viewNodeInfoIcon = dTreeWindow.createImageIcon("images/dTree/viewNodeInfo.png");
        this.viewMappedIcon = dTreeWindow.createImageIcon("images/dTree/viewKBCheckBox.png");
        this.toggleIcon = dTreeWindow.createImageIcon("images/dTree/toggleMonitoring.png");
        this.splitNodeIcon = dTreeWindow.createImageIcon("images/dTree/splitNode.png");
        this.moveSubtreeIcon = dTreeWindow.createImageIcon("images/dTree/movesubtree.png");
        this.exampleDialog = null;
        this.exampleList = new ExampleList();
        this.plotWindow = new PlotFrame((dTreeGraph)this.returnCanvas().graph);
        this.solveToolBarWithText();
        this.toolBar.setVisible(true);
        this.enableSolveButtons(false);
        this.otherSavedButtonIndex = 6;
        this.setPromptLabel("Create new dataset or load dataset from File Menu");
        this.extension = ".txt";
    }

    public void switchTab(String str) {
        if (this.exampleList.getIndices() == null) {
            this.setPromptLabel("Create new dataset or load dataset from File Menu");
        }
        if (str.equals("Create")) {
            this.textRepresentationMenuItem.setText("View/Edit Text Representation");
            this.textRepresentationMenuItem.setActionCommand(this.textRepresentationMenuItem.getText());
            this.xmlRepresentationMenuItem.setText("View/Edit XML Representation");
            this.xmlRepresentationMenuItem.setActionCommand(this.xmlRepresentationMenuItem.getText());
            this.descriptionMenuItem.setText("View/Edit Dataset Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            this.setCreate();
            this.returnCanvas().setMode(2220);
            this.enableSolveButtons(false);
            this.program.setVisible(true);
            this.program.setCaretPosition(this.program.getText().length());
            if (this.exampleList.getIndices() != null) {
                this.setPromptLabel("");
            }
        } else if (str.equals("Solve")) {
            this.textRepresentationMenuItem.setText("View Text Representation");
            this.textRepresentationMenuItem.setActionCommand(this.textRepresentationMenuItem.getText());
            this.xmlRepresentationMenuItem.setText("View XML Representation");
            this.xmlRepresentationMenuItem.setActionCommand(this.xmlRepresentationMenuItem.getText());
            this.descriptionMenuItem.setText("View Dataset Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            this.setSolve();
            this.returnCanvas().setMode(2221);
            ((dTreeGraph)this.canvas.graph).setSolveGraphMode(11);
            this.enableSolveButtons(true);
            if (this.isInitialStep) {
                this.returnCanvas().reset();
                this.validate();
                this.returnCanvas().autoscale();
            }
            if (this.exampleList.getIndices() != null && this.getSelectedButtonIndex(this.solveButModes) != -1) {
                this.actionPerformed(new ActionEvent(this.solveButModes[this.getSelectedButtonIndex(this.solveButModes)], 0, this.solveButModes[this.getSelectedButtonIndex(this.solveButModes)].getActionCommand()));
            }
        }
        this.validate();
    }

    private void enableSolveButtons(boolean enable) {
        int i = 1;
        while (i < 13) {
            this.solveButModes[i].setEnabled(enable);
            ++i;
        }
        this.solveButModes[3].setEnabled(false);
    }

    public void setSolve() {
        this.tabbedPane.setComponentAt(0, this.emptyPanel1);
        this.tabbedPane.setComponentAt(1, this.emptyPanel2);
        this.tabbedPane.setComponentAt(1, this.canvasPanel);
        this.tabbedPane.setSelectedIndex(1);
        this.canvasPanel.remove(this.programScroll);
        this.addComponent(this.scrollPanel, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
    }

    public void setCreate() {
        this.tabbedPane.setComponentAt(0, this.emptyPanel1);
        this.tabbedPane.setComponentAt(1, this.emptyPanel2);
        this.tabbedPane.setComponentAt(0, this.canvasPanel);
        this.tabbedPane.setSelectedIndex(0);
        this.canvasPanel.remove(this.scrollPanel);
        this.addComponent(this.programScroll, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
    }

    protected void solveToolBar() {
        this.solveButModes = new JToggleButton[13];
        this.setSolveButtons(0, this.editIcon, "View or edit examples");
        this.setSolveButtons(1, this.stepIcon, "Step");
        this.setSolveButtons(2, this.autoSearchIcon, "Auto Create");
        this.setSolveButtons(3, this.stopIcon, "Stop");
        this.setSolveButtons(4, this.resetIcon, "Reset");
        this.setSolveButtons(5, this.showPlotIcon, "Show plot graph");
        this.setSolveButtons(6, this.viewNodeInfoIcon, "View Node's Information");
        this.setSolveButtons(7, this.viewMappedIcon, "View Node's Mapped Examples");
        this.setSolveButtons(8, this.toggleIcon, "Toggle Histogram");
        this.setSolveButtons(9, this.splitNodeIcon, "Split Node");
        this.setSolveButtons(10, this.moveSubtreeIcon, "Move Subtree");
        this.setSolveButtons(11, this.quizIcon, "Test");
        this.setSolveButtons(12, this.newTestIcon, "Test new example");
        this.solveToolBarLayout();
    }

    protected void solveToolBarWithText() {
        this.solveButModes = new JToggleButton[13];
        this.setSolveButtonsWithText(0, "View/Edit Ex.", this.editIcon, "View or edit examples");
        this.setSolveButtonsWithText(1, "   Step   ", this.stepIcon, "Step");
        this.setSolveButtonsWithText(2, "Auto Create", this.autoSearchIcon, "Auto Create");
        this.setSolveButtonsWithText(3, "   Stop   ", this.stopIcon, "Stop ");
        this.setSolveButtonsWithText(4, "Reset Graph", this.resetIcon, "Reset");
        this.setSolveButtonsWithText(5, "Show Plot", this.showPlotIcon, "Show plot graph");
        this.setSolveButtonsWithText(6, "View Node Info", this.viewNodeInfoIcon, "View Node's Information");
        this.setSolveButtonsWithText(7, "View Mapped Ex.", this.viewMappedIcon, "View Node's Mapped Examples");
        this.setSolveButtonsWithText(8, "Toggle Histogram", this.toggleIcon, "Toggle Histogram");
        this.setSolveButtonsWithText(9, "Split Node", this.splitNodeIcon, "Split Node");
        this.setSolveButtonsWithText(10, "Move Subtree", this.moveSubtreeIcon, "Move Subtree");
        this.setSolveButtonsWithText(11, "    Test    ", this.quizIcon, "Test");
        this.setSolveButtonsWithText(12, "Test New Ex.", this.newTestIcon, "Test new example");
        this.solveToolBarLayout();
    }

    private void solveToolBarLayout() {
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        this.fakeButton = new JButton();
        this.solveModeButGroup.add(this.fakeButton);
        this.solveModeButGroup.add(this.solveButModes[0]);
        this.toolBar.add(this.solveButModes[0]);
        this.solveButModes[0].setFont(this.toolBarFont);
        this.toolBar.addSeparator();
        int i = 1;
        while (i < 6) {
            this.solveModeButGroup.add(this.solveButModes[i]);
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.toolBar.addSeparator();
        ButtonGroup solveModesGroup = new ButtonGroup();
        int i2 = 6;
        while (i2 < 11) {
            solveModesGroup.add(this.solveButModes[i2]);
            this.toolBar.add(this.solveButModes[i2]);
            this.solveButModes[i2].setFont(this.toolBarFont);
            ++i2;
        }
        this.toolBar.addSeparator();
        i2 = 11;
        while (i2 < 13) {
            this.solveModeButGroup.add(this.solveButModes[i2]);
            this.toolBar.add(this.solveButModes[i2]);
            this.solveButModes[i2].setFont(this.toolBarFont);
            ++i2;
        }
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = super.createMenuBar();
        menuBar.add((Component)this.createEditMenu(), 1);
        menuBar.add((Component)this.createGraphOptionsMenu(), 3);
        return menuBar;
    }

    protected JMenu createViewMenu() {
        JMenu m = super.createViewMenu();
        m.remove(5);
        this.menuItemHistogramOn = new JCheckBoxMenuItem("Toggle Histograms", true);
        this.menuItemHistogramOn.setMnemonic(72);
        this.menuItemHistogramOn.addActionListener(this);
        m.add(this.menuItemHistogramOn);
        return m;
    }

    protected JMenu createFileMenu() {
        JMenu m = new JMenu("File");
        m.setMnemonic(70);
        JMenuItem mItem = new JMenuItem("Create New Dataset");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(78);
        m.add(mItem);
        mItem = new JMenuItem("Load Sample Dataset");
        mItem.addActionListener(this);
        mItem.setMnemonic(83);
        m.add(mItem);
        boolean hasLocalAccess = this.hasLocalAccess();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Load From File");
            mItem.setActionCommand(mItem.getText());
            mItem.setMnemonic(70);
            mItem.setDisplayedMnemonicIndex(10);
            mItem.addActionListener(this);
            m.add(mItem);
        }
        mItem = new JMenuItem("Load From URL");
        mItem.setMnemonic(85);
        mItem.addActionListener(this);
        m.add(mItem);
        m.addSeparator();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Save Problem");
            mItem.addActionListener(this);
            mItem.setMnemonic(83);
            m.add(mItem);
        }
        mItem = new JMenuItem("Print");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(80);
        m.add(mItem);
        mItem = new JMenuItem("Quit");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(81);
        m.add(mItem);
        return m;
    }

    protected JMenu createEditMenu() {
        JMenu m = new JMenu("Edit");
        m.setMnemonic(69);
        this.textRepresentationMenuItem = new JMenuItem("View/Edit Text Representation");
        this.textRepresentationMenuItem.setMnemonic(84);
        this.textRepresentationMenuItem.setDisplayedMnemonicIndex(10);
        this.textRepresentationMenuItem.addActionListener(this);
        m.add(this.textRepresentationMenuItem);
        this.xmlRepresentationMenuItem = new JMenuItem("View/Edit XML Representation");
        this.xmlRepresentationMenuItem.setMnemonic(88);
        this.xmlRepresentationMenuItem.addActionListener(this);
        m.add(this.xmlRepresentationMenuItem);
        this.descriptionMenuItem = new JMenuItem("View/Edit Dataset Description");
        this.descriptionMenuItem.setMnemonic(68);
        this.descriptionMenuItem.setDisplayedMnemonicIndex(10);
        this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
        this.descriptionMenuItem.addActionListener(this);
        m.add(this.descriptionMenuItem);
        return m;
    }

    protected JMenu createGraphOptionsMenu() {
        JMenu menu = new JMenu("Decision Tree Options");
        menu.setMnemonic(68);
        JMenu speed = new JMenu("Auto Create Speed");
        speed.setMnemonic(65);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem mCheckItem = new JRadioButtonMenuItem("Very Fast (0 s)", false);
        mCheckItem.addActionListener(this);
        speed.add(mCheckItem);
        group.add(mCheckItem);
        mCheckItem = new JRadioButtonMenuItem("Fast (0.1 s)", true);
        mCheckItem.addActionListener(this);
        speed.add(mCheckItem);
        group.add(mCheckItem);
        mCheckItem = new JRadioButtonMenuItem("Medium (0.5 s)", false);
        mCheckItem.addActionListener(this);
        speed.add(mCheckItem);
        group.add(mCheckItem);
        mCheckItem = new JRadioButtonMenuItem("Slow (1 s)", false);
        mCheckItem.addActionListener(this);
        speed.add(mCheckItem);
        group.add(mCheckItem);
        menu.add(speed);
        JMenuItem stopping = new JMenuItem("Stopping Conditions...");
        stopping.setMnemonic(67);
        stopping.addActionListener(this);
        menu.add(stopping);
        JMenu splitting = new JMenu("Splitting Functions");
        splitting.setMnemonic(70);
        group = new ButtonGroup();
        mCheckItem = new JRadioButtonMenuItem("Gini", true);
        mCheckItem.addActionListener(this);
        group.add(mCheckItem);
        splitting.add(mCheckItem);
        mCheckItem = new JRadioButtonMenuItem("Information Gain");
        mCheckItem.addActionListener(this);
        group.add(mCheckItem);
        splitting.add(mCheckItem);
        mCheckItem = new JRadioButtonMenuItem("Gain Ratio");
        mCheckItem.addActionListener(this);
        group.add(mCheckItem);
        splitting.add(mCheckItem);
        mCheckItem = new JRadioButtonMenuItem("Random");
        mCheckItem.addActionListener(this);
        group.add(mCheckItem);
        splitting.add(mCheckItem);
        menu.add(splitting);
        return menu;
    }

    protected JMenu createHelpMenu() {
        return new HelpMenu("dTree", this);
    }

    protected void getCanvas() {
        this.exampleDialog = null;
        this.exampleList = new ExampleList();
        this.canvas = new dTreeCanvas(this, false);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.scrollPanel = new JScrollPane(this.canvas, 20, 30);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7500);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    public void setExampleText() {
        this.program.setText(this.exampleList.generateTextRepCreate());
    }

    public void load(BufferedReader in) {
        this.exampleDialog = null;
        try {
            String line;
            StringBuffer allText = new StringBuffer();
            String errMsg = "";
            while ((line = in.readLine()) != null) {
                allText.append(line).append("\n");
            }
            in.close();
            errMsg = this.exampleList.parseString(allText.toString());
            if (errMsg.length() > 20 && errMsg.substring(19).equals("You must identify parameters before loading examples")) {
                new ParameterInputDialog((Container)this, this.exampleList);
                errMsg = this.exampleList.getNumParameters() > 1 ? this.exampleList.parseString(allText.toString()) : "Cannot load file without parameter names";
            }
            if (!errMsg.equals("OK")) {
                this.showMessage("Error", errMsg);
                return;
            }
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
            this.updateTextRep();
            this.plotWindow.dispose();
            this.plotWindow = new PlotFrame((dTreeGraph)this.returnCanvas().graph);
            this.isInitialStep = true;
            this.returnCanvas().reset();
            this.returnCanvas().moveGraphToMiddle();
            this.setPromptLabel("");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.showMessage("Error", e.toString());
            return;
        }
    }

    public void updateTextRep() {
        this.program.setText(this.exampleList.generateTextRepCreate());
        this.program.setCaretPosition(0);
    }

    public void setFontSize(int size) {
        this.program.setFont(new Font("monospaced", 0, size));
        if (this.exampleDialog != null) {
            this.exampleDialog.changeFont(new Font("monospaced", 0, size));
        }
    }

    protected void createNewGraph() {
        new ParameterInputDialog((Container)this, this.exampleList);
        this.setPromptLabel("");
    }

    public void clear() {
        super.createNewGraph();
        this.setPromptLabel("Create new dataset or load dataset from File Menu");
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.xml");
        this.exampleList.reset();
        this.exampleList.setShortDesc("");
        this.exampleList.setDetailedDesc("");
        this.returnCanvas().reset();
    }

    protected void restoreProperties() {
        super.restoreProperties();
        this.returnCanvas().setSubmode(3332);
        this.setPromptLabel("");
        ((dTreeGraph)this.canvas.graph).setSolveGraphMode(((dTreeGraph)this.canvas.graph).getSolveGraphMode());
    }

    public void setPlotFramePromptLabel(String message) {
        if (this.plotWindow != null) {
            this.plotWindow.setPromptLabel(message);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand().trim();
        if (!this.solveButModes[10].isSelected()) {
            this.returnCanvas().setSubmode(3332);
        }
        if (arg.equals("View/Edit Examples") || e.getSource() == this.solveButModes[0]) {
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
            if (this.exampleList.getNumParameters() < 2) {
                this.showMessage("No Examples", "Please select \"Create New Dataset\" from the file menu or load an existing data set before manipulating examples.");
            } else {
                if (this.exampleDialog != null) {
                    this.exampleDialog.dispose();
                }
                this.exampleDialog = new ExampleDialog((Container)this, this.exampleList);
            }
            return;
        }
        if (this.returnCanvas().getMode() == 2221) {
            if (arg.equals("Step") || e.getSource() == this.solveButModes[1]) {
                this.step();
            } else if (arg.equals("Auto Create") || e.getSource() == this.solveButModes[2]) {
                this.autoCreateInit();
            } else if (arg.equals("Stop") || e.getSource() == this.solveButModes[3]) {
                this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
                this.autoCreate.quit();
                this.solveButModes[3].setEnabled(false);
                this.setPromptLabel("");
                this.setPlotFramePromptLabel("");
            } else if (arg.equals("Reset Graph") || e.getSource() == this.solveButModes[4]) {
                this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
                this.returnCanvas().reset();
                this.returnCanvas().moveGraphToMiddle();
                this.setPromptLabel("");
                this.setPlotFramePromptLabel("");
                this.solveButModes[3].setEnabled(false);
            } else if (arg.equals("Show Plot") || e.getSource() == this.solveButModes[5]) {
                this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
                if (this.plotWindow == null) {
                    this.plotWindow = new PlotFrame((dTreeGraph)this.returnCanvas().graph);
                }
                this.plotWindow.open();
            } else if (arg.equals("View Node Information") || e.getSource() == this.solveButModes[6]) {
                ((dTreeGraph)this.canvas.graph).setSolveGraphMode(11);
                this.setPromptLabel("Click any node to get summary information about the examples mapped to it, its entropy, and its GINI index");
            } else if (arg.equals("View Mapped Examples") || e.getSource() == this.solveButModes[7]) {
                ((dTreeGraph)this.canvas.graph).setSolveGraphMode(12);
                this.setPromptLabel("Click any node to get the examples that have been mapped to that node.");
            } else if (arg.equals("Toggle Histogram") || e.getSource() == this.solveButModes[8]) {
                ((dTreeGraph)this.canvas.graph).setSolveGraphMode(15);
                this.setPromptLabel("Click on node to view a histogram for the node's count and probability distribution. \n Click the node again to turn histogram off.");
            } else if (arg.equals("Split Node") || e.getSource() == this.solveButModes[9]) {
                ((dTreeGraph)this.canvas.graph).setSolveGraphMode(13);
                this.setPromptLabel("Click on any blue node to split.");
            } else if (arg.equals("Move Subtree") || e.getSource().equals(this.solveButModes[10])) {
                this.canvas.setSubmode(3338);
                this.setPromptLabel("Click on a node and drag it to move it and its descendents.");
            } else if (arg.equals("Test") || e.getSource() == this.solveButModes[11]) {
                this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
                if (this.exampleList.getTestArrayList().size() > 0) {
                    new ProbTestResultsFrame(this, this.exampleList, ((dTreeGraph)this.canvas.graph).getProbabilisticTestResults(), ((dTreeGraph)this.canvas.graph).getOutputValues());
                } else {
                    this.showMessage("No Test Results", "Please add one or more examples to the test set before testing results");
                }
            } else if (arg.equals("Test New Example") || e.getSource() == this.solveButModes[12]) {
                this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
                if (this.exampleList.getNumParameters() < 2) {
                    this.showMessage("No Examples", "Please add one or more examples to the test set before testing results");
                } else {
                    new TestNewExampleDialog((Container)this, "Test New Example");
                }
            }
        }
        if (arg.equals("Create New Dataset")) {
            this.createNewGraph();
        } else if (arg.equals("Load Sample Dataset")) {
            this.loadSampleGraph();
        } else if (arg.equals("View/Edit Text Representation")) {
            new dTreeTextFrame((dTreeCanvas)this.canvas, this.exampleList.generateTextRep(), "Text Representation of Graph", true);
        } else if (arg.equals("View/Edit XML Representation")) {
            new dTreeTextFrame((dTreeCanvas)this.canvas, this.exampleList.generateXMLTextRep(), "XML Text Representation of Graph", true);
        } else if (arg.equals("View Text Representation")) {
            new dTreeTextFrame((dTreeCanvas)this.canvas, this.exampleList.generateTextRep(), "Text Representation of Graph", false);
        } else if (arg.equals("View XML Representation")) {
            new dTreeTextFrame((dTreeCanvas)this.canvas, this.exampleList.generateXMLTextRep(), "XML Text Representation of Graph", false);
        } else if (arg.equals("View/Edit Dataset Description")) {
            new dTreeDescriptionDialog((GraphWindow)this, this.exampleList, true).open();
        } else if (arg.equals("View Dataset Description")) {
            new dTreeDescriptionDialog((GraphWindow)this, this.exampleList, false).open();
        } else if (arg.equals("Very Fast (0 s)")) {
            this.delayTime = 0;
            if (this.autoCreate != null) {
                this.autoCreate.setDelayTime(this.delayTime);
            }
        } else if (arg.equals("Fast (0.1 s)")) {
            this.delayTime = 100;
            if (this.autoCreate != null) {
                this.autoCreate.setDelayTime(this.delayTime);
            }
        } else if (arg.equals("Medium (0.5 s)")) {
            this.delayTime = 500;
            if (this.autoCreate != null) {
                this.autoCreate.setDelayTime(this.delayTime);
            }
        } else if (arg.equals("Slow (1 s)")) {
            this.delayTime = 1000;
            if (this.autoCreate != null) {
                this.autoCreate.setDelayTime(this.delayTime);
            }
        } else if (arg.equals("Stopping Conditions...")) {
            new StoppingConditionDialog((Container)this);
        } else if (arg.equals("Random")) {
            dTreeGraph.splitMode = 1;
        } else if (arg.equals("Information Gain")) {
            dTreeGraph.splitMode = 2;
        } else if (arg.equals("Gain Ratio")) {
            dTreeGraph.splitMode = 3;
        } else if (arg.equals("Gini")) {
            dTreeGraph.splitMode = 4;
        } else if (arg.equals("Legend for Nodes/Edges")) {
            new HelpFrame("Legend", new dTreeHelpCanvas(this.isAntiAliasingEnabled()), 350, 275);
        } else if (arg.equals("Probabilistic Error")) {
            ((dTreeGraph)this.canvas.graph).setLeafErrorType(200);
            if (this.plotWindow != null) {
                this.plotWindow.clear();
                ((dTreeGraph)this.returnCanvas().graph).clearPlotPts();
                this.plotWindow.setGraph((dTreeGraph)this.returnCanvas().graph);
                ((dTreeGraph)this.returnCanvas().graph).updatePlot();
                this.setPlotFramePromptLabel(this.plotWindow.getPlotErrorString());
            }
        } else if (arg.equals("Mode Value Error")) {
            ((dTreeGraph)this.canvas.graph).setLeafErrorType(201);
            if (this.plotWindow != null) {
                this.plotWindow.clear();
                ((dTreeGraph)this.returnCanvas().graph).clearPlotPts();
                this.plotWindow.setGraph((dTreeGraph)this.returnCanvas().graph);
                ((dTreeGraph)this.returnCanvas().graph).updatePlot();
                this.plotWindow.repaint();
                this.setPlotFramePromptLabel(this.plotWindow.getPlotErrorString());
            }
        } else if (arg.equals("Extra Large (30 pt)")) {
            this.program.setFont(new Font("arial", 0, 30));
            super.actionPerformed(e);
        } else if (arg.equals("Large (20 pt)")) {
            this.program.setFont(new Font("arial", 0, 20));
            super.actionPerformed(e);
        } else if (arg.equals("Medium (12 pt)")) {
            this.program.setFont(new Font("arial", 0, 12));
            super.actionPerformed(e);
        } else if (arg.equals("Small (9 pt)")) {
            this.program.setFont(new Font("arial", 0, 9));
            super.actionPerformed(e);
        } else if (arg.equals("Other...")) {
            this.program.setFont(new Font("arial", 0, this.returnCanvas().getFontSize()));
            super.actionPerformed(e);
        } else if (arg.equals("Toggle Histograms")) {
            Iterator<Node> nodeIterator = ((dTreeGraph)this.canvas.graph).getNodes();
            while (nodeIterator.hasNext()) {
                ((dTreeNode)nodeIterator.next()).toggleHistogramView();
            }
        } else {
            super.actionPerformed(e);
        }
    }

    public void step() {
        this.fakeButton.setSelected(true);
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
        if (this.exampleList.getNumParameters() < 2) {
            this.showMessage("No Examples", "Please select \"Create New Dataset\" from the file menu or load an existing data set before creating a tree.");
            return;
        }
        if (this.isInitialStep) {
            this.plotWindow.setMaxY();
            this.isInitialStep = false;
        }
        ((dTreeGraph)this.canvas.graph).step();
    }

    public void autoCreateInit() {
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
        if (this.exampleList.getNumParameters() < 2) {
            this.showMessage("No Examples", "Please select \"Create New Dataset\" from the file menu or load an existing data set before creating a tree.");
            return;
        }
        if (this.isInitialStep) {
            this.plotWindow.setMaxY();
            this.isInitialStep = false;
        }
        if (((dTreeGraph)this.canvas.graph).autoCreateContinue()) {
            if (this.delayTime > 0) {
                this.autoCreateStart();
            } else {
                ((dTreeGraph)this.canvas.graph).auto();
            }
            this.setPromptLabel("");
        } else {
            this.showMessage("Auto-Create Finished", "There are no more nodes to expand.");
        }
    }

    public void autoCreateEnd() {
        this.autoCreate.quit();
        if (!((dTreeGraph)this.canvas.graph).autoCreateContinue()) {
            this.showMessage("Auto-Create Finished", "There are no more nodes to expand.");
        }
        if (this.plotWindow != null) {
            this.plotWindow.setAutoCreateOn(false);
        }
        this.solveButModes[1].setEnabled(true);
        this.solveButModes[2].setEnabled(true);
        this.solveButModes[3].setEnabled(false);
        this.solveButModes[4].setEnabled(true);
    }

    public void autoCreateStart() {
        this.autoCreate = new AutoCreate(this, (dTreeGraph)this.canvas.graph, this.delayTime);
        if (this.plotWindow != null) {
            this.plotWindow.setAutoCreateOn(true);
        }
        this.autoCreate.start();
        this.solveButModes[1].setEnabled(false);
        this.solveButModes[2].setEnabled(false);
        this.solveButModes[3].setEnabled(true);
        this.solveButModes[4].setEnabled(false);
    }

    public int getNumParameters() {
        return this.exampleList.getNumParameters();
    }

    public boolean getShowHistograms() {
        return this.menuItemHistogramOn.getState();
    }

    public void save(File file) {
        if (!file.getName().endsWith(this.extension)) {
            file = new File(String.valueOf(file.getAbsolutePath()) + this.extension);
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            out.println(this.exampleList.generateXMLTextRep());
            out.close();
            this.fileName = file.getName();
            if (!this.fileName.equals("undo.xml")) {
                // empty if block
            }
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.canvas.disposeWindows();
        if (this.plotWindow != null) {
            this.plotWindow.dispose();
        }
        if (this.exampleDialog != null) {
            this.exampleDialog.dispose();
        }
        this.dispose();
    }

    public static void main(String[] args) {
        new dTreeWindow(null);
    }
}

