/*
 * Decompiled with CFR 0.152.
 */
package AIspace.dTree.dialogs;

import AIspace.dTree.ExampleList;
import AIspace.dTree.InlineDTreeApplet;
import AIspace.dTree.dTreeGraph;
import AIspace.dTree.dTreeWindow;
import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleDisplayDialog
extends BasicDialog {
    private JPanel mappedPanel;
    protected Font font;
    protected dTreeGraph graph;
    protected ExampleList exampleList;
    protected JScrollPane examplePane;
    protected JPanel buttonPanel;
    protected JTextArea mappedExampleTextArea;
    protected JTextArea correctTextArea;
    protected JTextArea noPredictionTextArea;
    protected JTextArea incorrectTextArea;
    protected Color correctColour;
    protected Color noPredictionColour;
    protected Color incorrectColour;

    public ExampleDisplayDialog(Container parent, String title) {
        super((JFrame)(parent instanceof dTreeWindow ? (dTreeWindow)parent : null), title, true);
        super.setCancelString("Close");
        if (parent instanceof dTreeWindow) {
            this.exampleList = ((dTreeWindow)parent).exampleList;
            this.graph = (dTreeGraph)((dTreeWindow)parent).returnCanvas().graph;
            this.font = new Font("monospaced", 0, ((dTreeWindow)parent).returnCanvas().getFontSize());
        } else {
            this.exampleList = ((InlineDTreeApplet)parent).exampleList;
            this.graph = (dTreeGraph)((InlineDTreeApplet)parent).returnCanvas().graph;
            this.font = new Font("monospaced", 0, ((InlineDTreeApplet)parent).returnCanvas().getFontSize());
        }
        this.mappedExampleTextArea = null;
        this.correctTextArea = null;
        this.noPredictionTextArea = null;
        this.incorrectTextArea = null;
        this.correctColour = new Color(Color.green.getRGB()).darker();
        this.noPredictionColour = new Color(Color.blue.getRGB()).darker();
        this.incorrectColour = new Color(Color.red.getRGB()).darker();
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(closeButton);
    }

    public void open() {
        JPanel mainPanel = new JPanel();
        JScrollPane scrollpane = new JScrollPane(mainPanel, 20, 30);
        this.getContentPane().setLayout(new BorderLayout());
        this.mappedExampleTextArea.setRows(10);
        this.mappedExampleTextArea.setCaretPosition(0);
        mainPanel.add(this.mappedPanel);
        mainPanel.setLayout(new GridLayout(1, 1));
        if (this.correctTextArea.getText().length() >= 1 || this.noPredictionTextArea.getText().length() >= 1 || this.incorrectTextArea.getText().length() >= 1) {
            JPanel tPanel;
            JLabel testLabel = new JLabel("Test Examples:");
            int panelCount = 1;
            boolean addTestLabel = true;
            if (this.correctTextArea.getText().length() > 1) {
                JPanel correctPanel = new JPanel(new BorderLayout());
                JLabel correctLabel = new JLabel("Correctly Predicted Test Examples:");
                correctLabel.setOpaque(true);
                correctLabel.setBackground(Color.WHITE);
                correctLabel.setForeground(this.correctColour);
                tPanel = new JPanel(new BorderLayout());
                tPanel.add((Component)testLabel, "North");
                tPanel.add((Component)correctLabel, "South");
                addTestLabel = false;
                correctPanel.add("North", tPanel);
                this.correctTextArea.setRows(10);
                this.correctTextArea.setCaretPosition(0);
                this.correctTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                correctPanel.add("Center", this.correctTextArea);
                mainPanel.add(correctPanel);
                ++panelCount;
            }
            if (this.noPredictionTextArea.getText().length() > 1) {
                JPanel noPredictionPanel = new JPanel(new BorderLayout());
                JLabel noPredictionLabel = new JLabel("Test Examples With No Prediction:");
                noPredictionLabel.setOpaque(true);
                noPredictionLabel.setBackground(Color.white);
                noPredictionLabel.setForeground(this.noPredictionColour);
                if (addTestLabel) {
                    tPanel = new JPanel(new BorderLayout());
                    tPanel.add((Component)testLabel, "North");
                    tPanel.add((Component)noPredictionLabel, "South");
                    addTestLabel = false;
                    noPredictionPanel.add("North", tPanel);
                } else {
                    noPredictionPanel.add("North", noPredictionLabel);
                }
                this.noPredictionTextArea.setRows(10);
                this.noPredictionTextArea.setCaretPosition(0);
                this.noPredictionTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                noPredictionPanel.add("Center", this.noPredictionTextArea);
                mainPanel.add(noPredictionPanel);
                ++panelCount;
            }
            if (this.incorrectTextArea.getText().length() > 1) {
                JPanel incorrectPanel = new JPanel(new BorderLayout());
                JLabel incorrectLabel = new JLabel("Incorrectly Predicted Test Examples:");
                incorrectLabel.setOpaque(true);
                incorrectLabel.setBackground(Color.white);
                incorrectLabel.setForeground(this.incorrectColour);
                if (addTestLabel) {
                    tPanel = new JPanel(new BorderLayout());
                    tPanel.add((Component)testLabel, "North");
                    tPanel.add((Component)incorrectLabel, "South");
                    addTestLabel = false;
                    incorrectPanel.add("North", tPanel);
                } else {
                    incorrectPanel.add("North", incorrectLabel);
                }
                this.incorrectTextArea.setRows(10);
                this.incorrectTextArea.setCaretPosition(0);
                this.incorrectTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                incorrectPanel.add("Center", this.incorrectTextArea);
                mainPanel.add(incorrectPanel);
                ++panelCount;
            }
            mainPanel.setLayout(new GridLayout(panelCount, 1));
        }
        this.getContentPane().add("Center", scrollpane);
        this.getContentPane().add("South", this.buttonPanel);
        scrollpane.setPreferredSize(new Dimension(400, 300));
        scrollpane.getHorizontalScrollBar().setMaximum(400);
        scrollpane.getHorizontalScrollBar().setValue(0);
        scrollpane.getVerticalScrollBar().setMaximum(300);
        scrollpane.getVerticalScrollBar().setValue(0);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private void fillTextArea(JTextArea targetTextArea, ArrayList<Integer> selectedIndices, ArrayList<Hashtable<Integer, String>> allExamples, boolean showPrediction) {
        int i;
        targetTextArea.setText("");
        int maxColWidth = 0;
        String heading = new String("   ");
        if (selectedIndices.size() < 1 || this.exampleList.getNumParameters() < 2) {
            return;
        }
        int numParameters = this.exampleList.getNumParameters();
        if (showPrediction) {
            ++numParameters;
        }
        String[] parameters = this.exampleList.getParameters();
        if (showPrediction) {
            String[] newParameters = new String[parameters.length + 1];
            i = 0;
            while (i < parameters.length) {
                newParameters[i] = parameters[i];
                ++i;
            }
            newParameters[newParameters.length - 1] = "Predicted Value";
            parameters = newParameters;
        }
        int[] colPos = new int[parameters.length];
        i = 0;
        while (i < numParameters) {
            colPos[i] = heading.length();
            heading = String.valueOf(heading) + parameters[i];
            int j = 0;
            while (j < 5) {
                heading = String.valueOf(heading) + " ";
                ++j;
            }
            ++i;
        }
        targetTextArea.setText(String.valueOf(targetTextArea.getText()) + heading);
        i = 0;
        while (i < selectedIndices.size()) {
            StringBuffer display = new StringBuffer(String.valueOf(i + 1) + ": ");
            Hashtable<Integer, String> oneExample = allExamples.get(selectedIndices.get(i));
            int j = 0;
            while (j < numParameters) {
                String value = " ";
                if (showPrediction && j == numParameters - 1) {
                    String[] values = new String[oneExample.size()];
                    int k = 0;
                    while (k < oneExample.size()) {
                        values[k] = oneExample.get(new Integer(k));
                        ++k;
                    }
                    value = this.graph.search(values);
                } else {
                    value = oneExample.get(new Integer(j));
                }
                if (value != null) {
                    while (display.length() < colPos[j]) {
                        display.append(" ");
                    }
                    display.append(value);
                }
                ++j;
            }
            if (maxColWidth < display.length()) {
                maxColWidth = heading.length();
            }
            targetTextArea.setText(String.valueOf(targetTextArea.getText()) + "\n" + display.toString());
            ++i;
        }
        targetTextArea.setColumns(maxColWidth);
        targetTextArea.setRows(selectedIndices.size() + 1);
    }

    public void changeFontSize(int size) {
        this.font = new Font("monspaced", 0, size);
        this.mappedExampleTextArea.setFont(this.font);
        this.repaint();
    }

    public void loadMappedExamples(ArrayList<Integer> indices) {
        this.mappedPanel = new JPanel(new BorderLayout());
        JLabel mappedLabel = new JLabel("Training Examples:");
        this.mappedExampleTextArea = new JTextArea("", 10, 50);
        this.mappedExampleTextArea.setFont(this.font);
        this.mappedExampleTextArea.setEditable(false);
        this.mappedExampleTextArea.setRows(10);
        this.mappedPanel.add("North", mappedLabel);
        this.mappedPanel.add("Center", this.mappedExampleTextArea);
        this.fillTextArea(this.mappedExampleTextArea, indices, this.exampleList.getTrainingArrayList(), false);
    }

    public void loadCorrectExamples(ArrayList<Integer> indices) {
        this.correctTextArea = new JTextArea("", 10, 50);
        this.correctTextArea.setFont(this.font);
        this.correctTextArea.setEditable(false);
        this.correctTextArea.setRows(10);
        this.fillTextArea(this.correctTextArea, indices, this.exampleList.getTestArrayList(), false);
    }

    public void loadNoPredictionExamples(ArrayList<Integer> indices) {
        this.noPredictionTextArea = new JTextArea("", 10, 50);
        this.noPredictionTextArea.setFont(this.font);
        this.noPredictionTextArea.setEditable(false);
        this.noPredictionTextArea.setRows(10);
        this.fillTextArea(this.noPredictionTextArea, indices, this.exampleList.getTestArrayList(), false);
    }

    public void loadIncorrectExamples(ArrayList<Integer> indices) {
        this.incorrectTextArea = new JTextArea("", 5, 50);
        this.incorrectTextArea.setFont(this.font);
        this.incorrectTextArea.setEditable(false);
        this.incorrectTextArea.setRows(10);
        this.fillTextArea(this.incorrectTextArea, indices, this.exampleList.getTestArrayList(), true);
    }

    @Override
    protected boolean actionOK() {
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }
}

