/*
 * Decompiled with CFR 0.152.
 */
package AIspace.dTree.dialogs;

import AIspace.dTree.ExampleList;
import AIspace.dTree.dialogs.TestStatisticsPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbTestResultsFrame
extends JFrame
implements AdjustmentListener,
ActionListener {
    private JPanel mainPanel;
    private DefaultListModel correctModel;
    private DefaultListModel incorrectModel;
    protected ExampleList exampleList;
    protected double errorThreshold;
    protected ArrayList<Hashtable<String, Double>> correctExamples;
    protected ArrayList<Hashtable<String, Double>> incorrectExamples;
    protected ArrayList<String> outputValues;
    protected JList correctList;
    protected JList incorrectList;
    protected JLabel correctLabel;
    protected JLabel incorrectLabel;
    protected JLabel thresholdLabel;
    protected JLabel maxScrollLabel;
    protected ButtonGroup errorTypeGroup;
    protected JRadioButton absErrorRadio;
    protected JRadioButton absErrorSquaredRadio;
    protected JScrollBar thresholdBar;
    protected Font listFont;
    protected Font noteFont;
    protected DecimalFormat numFormat;
    protected double maxError;
    protected double maxSquaredError;
    protected boolean useSquaredError;
    protected Container parent;
    protected GridBagConstraints gbc;
    protected GridBagLayout gbl;

    public ProbTestResultsFrame(Container parent, ExampleList exampleList, ArrayList<Hashtable<String, Double>> testExamples, ArrayList<String> outputValues) {
        super("Test Results");
        this.parent = parent;
        this.errorThreshold = 0.2;
        TestStatisticsPanel tsd = new TestStatisticsPanel(parent, this);
        this.construct(exampleList, testExamples, outputValues);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)tsd, "Mode");
        tabbedPane.add((Component)this.mainPanel, "Probabilistic");
        this.getContentPane().add(tabbedPane);
        this.pack();
        this.setSize(700, 600);
        this.centerWindow();
        this.repaint();
        this.setVisible(true);
    }

    public ProbTestResultsFrame(Container parent, ArrayList<Hashtable<String, Double>> testExamples, ExampleList exampleList, ArrayList<String> outputValues, double errorThreshold) {
        super("Probabilistic Test Results");
        this.parent = parent;
        this.errorThreshold = errorThreshold;
        this.construct(exampleList, testExamples, outputValues);
    }

    protected void construct(ExampleList exampleList, ArrayList<Hashtable<String, Double>> testExamples, ArrayList<String> outputValues) {
        this.exampleList = exampleList;
        this.outputValues = outputValues;
        this.correctExamples = new ArrayList();
        this.incorrectExamples = new ArrayList();
        this.listFont = new Font("monospaced", 0, 12);
        this.noteFont = new Font("arial", 0, 11);
        this.numFormat = new DecimalFormat("0.00;0.00");
        this.maxSquaredError = 0.0;
        this.maxError = 0.0;
        this.useSquaredError = true;
        this.thresholdLabel = new JLabel();
        this.maxScrollLabel = new JLabel();
        if (testExamples.size() == 0) {
            this.dispose();
            return;
        }
        int i = 0;
        while (i < testExamples.size()) {
            Hashtable<String, Double> currExample = testExamples.get(i);
            double currError = currExample.get("error");
            double currSquaredError = currExample.get("squaredError");
            currError = Math.floor(currError * 100.0) / 100.0;
            currExample.put("error", new Double(currError));
            currSquaredError = Math.floor(currSquaredError * 100.0) / 100.0;
            currExample.put("squaredError", new Double(currSquaredError));
            if (currSquaredError < this.errorThreshold) {
                this.addSorted(this.correctExamples, currExample);
            } else {
                this.addSorted(this.incorrectExamples, currExample);
            }
            if (currSquaredError > this.maxSquaredError) {
                this.maxSquaredError = currSquaredError;
            }
            if (currError > this.maxError) {
                this.maxError = currError;
            }
            ++i;
        }
        this.maxSquaredError = Math.floor(this.maxSquaredError * 100.0) / 100.0;
        this.maxError = Math.floor(this.maxError * 100.0) / 100.0;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 10;
        this.gbc.fill = 1;
        this.makeMainPanel();
    }

    protected void addComponent(JComponent component, Container panel, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(component, this.gbc);
        panel.add(component);
    }

    protected JPanel makeMainPanel() {
        this.mainPanel = new JPanel();
        this.addComponent(this.makeExamplePanel(), this.mainPanel, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.makeErrorSelectPanel(), this.mainPanel, 1, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.makeSliderPanel(), this.mainPanel, 2, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.makeNoteTextPanel(), this.mainPanel, 3, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.makeButtonPanel(), this.mainPanel, 4, 0, 1, 1, 1.0, 0.1);
        this.mainPanel.setLayout(this.gbl);
        return this.mainPanel;
    }

    protected JPanel makeExamplePanel() {
        JPanel examplePanel = new JPanel(new GridLayout(2, 1));
        this.correctList = new JList();
        this.correctModel = new DefaultListModel();
        this.correctList.setSelectionMode(2);
        this.correctList.setModel(this.correctModel);
        this.correctList.setFont(this.listFont);
        this.incorrectList = new JList();
        this.incorrectModel = new DefaultListModel();
        this.incorrectList.setSelectionMode(2);
        this.incorrectList.setModel(this.incorrectModel);
        this.incorrectList.setFont(this.listFont);
        this.correctLabel = new JLabel("Correctly Predicted Examples (" + this.correctExamples.size() + "):");
        this.correctLabel.setForeground(Color.green.darker());
        this.incorrectLabel = new JLabel("Incorrectly Predicted Examples (" + this.incorrectExamples.size() + "):");
        this.incorrectLabel.setForeground(Color.red.darker());
        this.fillList(this.correctList, this.correctExamples);
        this.fillList(this.incorrectList, this.incorrectExamples);
        JPanel correctPanel = new JPanel(new BorderLayout());
        JPanel incorrectPanel = new JPanel(new BorderLayout());
        correctPanel.add("North", this.correctLabel);
        correctPanel.add("Center", this.correctList);
        incorrectPanel.add("North", this.incorrectLabel);
        incorrectPanel.add("Center", this.incorrectList);
        JScrollPane correctPane = new JScrollPane(correctPanel, 20, 30);
        JScrollPane incorrectPane = new JScrollPane(incorrectPanel, 20, 30);
        examplePanel.add(correctPane);
        examplePanel.add(incorrectPane);
        return examplePanel;
    }

    protected JPanel makeSliderPanel() {
        JPanel sliderPanel = new JPanel(new BorderLayout());
        this.thresholdBar = new JScrollBar(0, 50, 1, 0, 101);
        this.thresholdBar.addAdjustmentListener(this);
        this.thresholdBar.setValue((int)Math.round(this.errorThreshold * 100.0 / this.maxSquaredError));
        JLabel minScrollLabel = new JLabel("0.00 ");
        this.maxScrollLabel = new JLabel(" ");
        this.thresholdLabel = new JLabel("");
        this.updateThresholdLabel();
        sliderPanel.add("North", this.thresholdLabel);
        sliderPanel.add("Center", this.thresholdBar);
        sliderPanel.add("West", minScrollLabel);
        sliderPanel.add("East", this.maxScrollLabel);
        return sliderPanel;
    }

    protected JPanel makeErrorSelectPanel() {
        JPanel errorSelectPanel = new JPanel(new BorderLayout());
        this.errorTypeGroup = new ButtonGroup();
        this.absErrorRadio = new JRadioButton("Avg. sum of abs. values of differences", false);
        this.absErrorRadio.addActionListener(this);
        this.errorTypeGroup.add(this.absErrorRadio);
        this.absErrorSquaredRadio = new JRadioButton("Avg. sum of squares of abs. values of differences", true);
        this.absErrorSquaredRadio.addActionListener(this);
        this.errorTypeGroup.add(this.absErrorSquaredRadio);
        JPanel radioPanel = new JPanel();
        radioPanel.add(this.absErrorRadio);
        radioPanel.add(this.absErrorSquaredRadio);
        errorSelectPanel.add("North", new JLabel("Select error threshold value type:"));
        errorSelectPanel.add("West", radioPanel);
        errorSelectPanel.add("South", new JLabel(""));
        return errorSelectPanel;
    }

    protected JPanel makeNoteTextPanel() {
        GridLayout layout = new GridLayout(4, 1);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(layout);
        JLabel line1 = new JLabel("Move the slider above to adjust the maximum error value");
        line1.setFont(this.noteFont);
        textPanel.add(line1);
        JLabel blank = new JLabel(" ");
        textPanel.add(blank);
        JLabel line2 = new JLabel("* Average sum of absolute values of differences error");
        line2.setFont(this.noteFont);
        textPanel.add(line2);
        JLabel line3 = new JLabel("** Average sum of squares of absolute values of differences error");
        line3.setFont(this.noteFont);
        textPanel.add(line3);
        return textPanel;
    }

    protected JPanel makeButtonPanel() {
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    protected void fillList(JList targetList, ArrayList dataSource) {
        int j;
        DefaultListModel tempModel = (DefaultListModel)targetList.getModel();
        StringBuffer headingStr = new StringBuffer("");
        ArrayList<String> colHeadings = new ArrayList<String>();
        String[] parameters = this.exampleList.getParameters();
        int currCol = 0;
        int i = 0;
        while (i < parameters.length) {
            colHeadings.add(parameters[i]);
            ++i;
        }
        i = 0;
        while (i < this.outputValues.size()) {
            colHeadings.add(this.outputValues.get(0));
            ++i;
        }
        colHeadings.add("Error");
        colHeadings.add("Squared Error");
        int[] colPos = new int[colHeadings.size()];
        int i2 = 0;
        while (i2 < this.exampleList.getNumParameters()) {
            colPos[currCol++] = headingStr.length();
            headingStr.append(parameters[i2]);
            j = 0;
            while (j < 5) {
                headingStr.append(" ");
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.outputValues.size()) {
            colPos[currCol++] = headingStr.length();
            headingStr.append(this.outputValues.get(i2));
            j = 0;
            while (j < 5) {
                headingStr.append(" ");
                ++j;
            }
            ++i2;
        }
        colPos[currCol++] = headingStr.length();
        headingStr.append("Error*");
        int j2 = 0;
        while (j2 < 5) {
            headingStr.append(" ");
            ++j2;
        }
        colPos[currCol++] = headingStr.length();
        headingStr.append("S.Error**");
        j2 = 0;
        while (j2 < 5) {
            headingStr.append(" ");
            ++j2;
        }
        tempModel.addElement(headingStr);
        i2 = 0;
        while (i2 < dataSource.size()) {
            String value;
            StringBuffer displayLine = new StringBuffer("");
            Hashtable oneExample = (Hashtable)dataSource.get(i2);
            int j3 = 0;
            while (j3 < parameters.length) {
                value = (String)oneExample.get(new Integer(j3));
                if (value != null) {
                    while (displayLine.length() < colPos[j3]) {
                        displayLine.append(" ");
                    }
                    displayLine.append(value);
                }
                ++j3;
            }
            j3 = 0;
            while (j3 < this.outputValues.size()) {
                value = this.numFormat.format((Double)oneExample.get(this.outputValues.get(j3)));
                if (value != null) {
                    while (displayLine.length() < colPos[j3 + parameters.length]) {
                        displayLine.append(" ");
                    }
                    displayLine.append(value);
                }
                ++j3;
            }
            String value2 = this.numFormat.format((Double)oneExample.get("error"));
            if (value2 != null) {
                while (displayLine.length() < colPos[this.outputValues.size() + parameters.length]) {
                    displayLine.append(" ");
                }
                displayLine.append(value2);
            }
            if ((value2 = this.numFormat.format((Double)oneExample.get("squaredError"))) != null) {
                while (displayLine.length() < colPos[this.outputValues.size() + parameters.length + 1]) {
                    displayLine.append(" ");
                }
                displayLine.append(value2);
            }
            tempModel.addElement(displayLine.toString());
            ++i2;
        }
    }

    public void addSorted(ArrayList<Hashtable<String, Double>> examples, Hashtable<String, Double> newExample) {
        int currPos = 0;
        double newValue = newExample.get("squaredError");
        if (examples.size() == 0) {
            examples.add(newExample);
        } else {
            double currValue = examples.get(currPos).get("squaredError");
            while (newValue > currValue) {
                if (currPos++ == examples.size() - 1) {
                    examples.add(newExample);
                    return;
                }
                currValue = examples.get(currPos).get("squaredError");
            }
            examples.add(currPos, newExample);
        }
    }

    protected void shiftExamples(boolean higherError) {
        String errorTypeKey = this.useSquaredError ? "squaredError" : "error";
        if (!higherError) {
            if (this.correctExamples.size() == 0) {
                return;
            }
            double maxCorrectError = this.correctExamples.get(this.correctExamples.size() - 1).get(errorTypeKey);
            while (maxCorrectError > this.errorThreshold && this.correctExamples.size() > 0) {
                this.incorrectExamples.add(0, this.correctExamples.get(this.correctExamples.size() - 1));
                this.correctExamples.remove(this.correctExamples.size() - 1);
                this.incorrectModel.add(1, this.correctModel.get(this.correctModel.getSize() - 1));
                this.correctModel.remove(this.correctModel.getSize() - 1);
                if (this.correctExamples.size() <= 0) continue;
                maxCorrectError = this.correctExamples.get(this.correctExamples.size() - 1).get(errorTypeKey);
            }
        } else {
            if (this.incorrectExamples.size() == 0) {
                return;
            }
            double minIncorrectError = this.incorrectExamples.get(0).get(errorTypeKey);
            while (minIncorrectError <= this.errorThreshold && this.incorrectExamples.size() > 0) {
                this.correctExamples.add(this.incorrectExamples.get(0));
                this.incorrectExamples.remove(0);
                this.correctModel.addElement(this.incorrectModel.getElementAt(1));
                this.incorrectModel.remove(1);
                if (this.incorrectExamples.size() <= 0) continue;
                minIncorrectError = this.incorrectExamples.get(0).get(errorTypeKey);
            }
        }
        this.updateLabels();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        double originalErrorThreshold = this.errorThreshold;
        this.errorThreshold = this.useSquaredError ? (double)this.thresholdBar.getValue() / 100.0 * this.maxSquaredError : (double)this.thresholdBar.getValue() / 100.0 * this.maxError;
        this.errorThreshold = Math.floor(this.errorThreshold * 100.0) / 100.0;
        this.shiftExamples(this.errorThreshold > originalErrorThreshold);
        this.updateThresholdLabel();
    }

    protected void updateThresholdLabel() {
        if (this.useSquaredError) {
            this.thresholdLabel.setText("Maximum (Squared) Error Value: " + this.numFormat.format(this.errorThreshold));
            this.maxScrollLabel.setText(" " + this.numFormat.format(this.maxSquaredError));
            this.thresholdBar.setValue((int)Math.round(this.errorThreshold * 100.0 / this.maxSquaredError));
        } else {
            this.thresholdLabel.setText("Maximum Error Value: " + this.numFormat.format(this.errorThreshold));
            this.maxScrollLabel.setText(" " + this.numFormat.format(this.maxError));
            this.thresholdBar.setValue((int)Math.round(this.errorThreshold * 100.0 / this.maxError));
        }
    }

    protected void updateLabels() {
        this.correctLabel.setText("Correctly Predicted Examples (" + this.correctExamples.size() + "):");
        this.incorrectLabel.setText("Incorrectly Predicted Examples (" + this.incorrectExamples.size() + "):");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Close")) {
            this.dispose();
        } else if (e.getSource() == this.absErrorRadio || e.getSource() == this.absErrorSquaredRadio) {
            if (this.absErrorRadio.isSelected()) {
                this.useSquaredError = false;
                this.updateThresholdLabel();
            } else if (this.absErrorSquaredRadio.isSelected()) {
                this.useSquaredError = true;
                this.updateThresholdLabel();
            }
            this.shiftExamples(true);
            this.shiftExamples(false);
        }
    }

    protected void centerWindow() {
        Container parent = this.parent;
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        this.setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }
}

