/*
 * Decompiled with CFR 0.152.
 */
package AIspace.dTree.dialogs;

import AIspace.dTree.InlineDTreeApplet;
import AIspace.dTree.dTreeGraph;
import AIspace.dTree.dTreeWindow;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StoppingConditionDialog
extends BasicDialog
implements ItemListener {
    protected Container window;
    protected dTreeGraph graph;
    protected DecimalFormat numFormat;
    protected JCheckBox minInfoGainCheckbox;
    protected JCheckBox minExampleCountCheckbox;
    protected JCheckBox maxDepthCheckbox;
    protected JTextField minInfoGainText;
    protected JTextField minExampleCountText;
    protected JTextField maxDepthText;

    public StoppingConditionDialog(Container parent) {
        super((JFrame)(parent instanceof dTreeWindow ? (dTreeWindow)parent : null), "Stopping Condition Options", true);
        this.window = parent;
        this.graph = parent instanceof dTreeWindow ? (dTreeGraph)((dTreeWindow)this.window).returnCanvas().graph : (dTreeGraph)((InlineDTreeApplet)this.window).returnCanvas().graph;
        this.numFormat = new DecimalFormat("0.00;0.00");
        this.getContentPane().add("North", this.makeMainPanel());
        this.getContentPane().add("South", this.makeButtonPanel());
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private JPanel makeButtonPanel() {
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    private JPanel makeMainPanel() {
        JPanel mainPanel = new JPanel();
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.minInfoGainCheckbox = new JCheckBox("Minimum Information Gain:");
        this.minInfoGainCheckbox.addActionListener(this);
        this.minExampleCountCheckbox = new JCheckBox("Minimum Example Count:");
        this.minExampleCountCheckbox.addActionListener(this);
        this.maxDepthCheckbox = new JCheckBox("Maximum Depth:");
        this.maxDepthCheckbox.addActionListener(this);
        this.minInfoGainText = new JTextField("");
        this.minExampleCountText = new JTextField("");
        this.maxDepthText = new JTextField("");
        this.updateWidgets();
        this.addComponent(new JLabel("Creation will stop on one of:"), mainPanel, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.minInfoGainCheckbox, mainPanel, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.minInfoGainText, mainPanel, 1, 1, 1, 1, 0.0, 0.0);
        this.addComponent(this.minExampleCountCheckbox, mainPanel, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.minExampleCountText, mainPanel, 2, 1, 1, 1, 0.0, 0.0);
        this.addComponent(this.maxDepthCheckbox, mainPanel, 3, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.maxDepthText, mainPanel, 3, 1, 1, 1, 0.0, 0.0);
        mainPanel.setLayout(this.gbl);
        return mainPanel;
    }

    private void updateWidgets() {
        this.minInfoGainCheckbox.setSelected(this.graph.isMinInfoGainEnabled());
        this.minExampleCountCheckbox.setSelected(this.graph.isMinExampleCountEnabled());
        this.maxDepthCheckbox.setSelected(this.graph.isMaxDepthEnabled());
        this.minInfoGainText.setText(this.numFormat.format(this.graph.getMinInfoGain()));
        this.minExampleCountText.setText(new Integer(this.graph.getMinExampleCount()).toString());
        this.maxDepthText.setText(new Integer(this.graph.getMaxDepth()).toString());
        this.minInfoGainText.setEnabled(this.graph.isMinInfoGainEnabled());
        this.minExampleCountText.setEnabled(this.graph.isMinExampleCountEnabled());
        this.maxDepthText.setEnabled(this.graph.isMaxDepthEnabled());
    }

    public void itemStateChanged(ItemEvent e) {
        String arg = e.getItem().toString();
        if (arg.equals("Minimum Information Gain:")) {
            if (this.minInfoGainCheckbox.isSelected()) {
                this.minInfoGainText.setEnabled(true);
            } else {
                this.minInfoGainText.setEnabled(false);
                this.minInfoGainText.setText(this.numFormat.format(this.graph.getMinInfoGain()));
            }
        } else if (arg.equals("Minimum Example Count:")) {
            if (this.minExampleCountCheckbox.isSelected()) {
                this.minExampleCountText.setEnabled(true);
            } else {
                this.minExampleCountText.setEnabled(false);
                this.minExampleCountText.setText(String.valueOf(this.graph.getMinExampleCount()));
            }
        } else if (arg.equals("Maximum Depth:")) {
            if (this.maxDepthCheckbox.isSelected()) {
                this.maxDepthText.setEnabled(true);
            } else {
                this.maxDepthText.setEnabled(false);
                this.maxDepthText.setText(String.valueOf(this.graph.getMaxDepth()));
            }
        }
    }

    protected boolean actionOK() {
        if (this.updateGraph()) {
            return true;
        }
        this.updateWidgets();
        return false;
    }

    protected boolean actionCancel() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String arg = e.getActionCommand();
        if (arg.equals("Minimum Information Gain:")) {
            if (this.minInfoGainCheckbox.isSelected()) {
                this.minInfoGainText.setEnabled(true);
            } else {
                this.minInfoGainText.setEnabled(false);
                this.minInfoGainText.setText(this.numFormat.format(this.graph.getMinInfoGain()));
            }
        } else if (arg.equals("Minimum Example Count:")) {
            if (this.minExampleCountCheckbox.isSelected()) {
                this.minExampleCountText.setEnabled(true);
            } else {
                this.minExampleCountText.setEnabled(false);
                this.minExampleCountText.setText(new Integer(this.graph.getMinExampleCount()).toString());
            }
        } else if (arg.equals("Maximum Depth:")) {
            if (this.maxDepthCheckbox.isSelected()) {
                this.maxDepthText.setEnabled(true);
            } else {
                this.maxDepthText.setEnabled(false);
                this.maxDepthText.setText(new Integer(this.graph.getMaxDepth()).toString());
            }
        }
    }

    private boolean updateGraph() {
        this.graph.setMinInfoGainEnabled(this.minInfoGainCheckbox.isSelected());
        this.graph.setMinExampleCountEnabled(this.minExampleCountCheckbox.isSelected());
        this.graph.setMaxDepthEnabled(this.maxDepthCheckbox.isSelected());
        if (this.minInfoGainCheckbox.isSelected()) {
            if (this.validateInfoGain()) {
                this.graph.setMinInfoGain(Double.parseDouble(this.minInfoGainText.getText()));
            } else {
                return false;
            }
        }
        if (this.minExampleCountCheckbox.isSelected()) {
            if (this.validateExampleCount()) {
                this.graph.setMinExampleCount(Integer.parseInt(this.minExampleCountText.getText()));
            } else {
                return false;
            }
        }
        if (this.maxDepthCheckbox.isSelected()) {
            if (this.validateDepth()) {
                this.graph.setMaxDepth(Integer.parseInt(this.maxDepthText.getText()));
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean validateInfoGain() {
        try {
            double infoGain = Double.parseDouble(this.minInfoGainText.getText());
            if (infoGain < 0.0 || infoGain > 1.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.graph.canvas.showMessage("Invalid Input", "Please specify a numeric information gain value between 0 and 1 (inclusive).");
            return false;
        }
        return true;
    }

    private boolean validateExampleCount() {
        try {
            if (Integer.parseInt(this.minExampleCountText.getText()) < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.graph.canvas.showMessage("Invalid Input", "Please specify a numeric example count value greater than zero.");
            return false;
        }
        return true;
    }

    private boolean validateDepth() {
        try {
            if (Integer.parseInt(this.maxDepthText.getText()) < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.graph.canvas.showMessage("Invalid Input", "Please specify a numeric depth value greater than zero.");
            return false;
        }
        return true;
    }
}

