/*
 * Decompiled with CFR 0.152.
 */
package AIspace.dTree.dialogs;

import AIspace.dTree.ExampleList;
import AIspace.dTree.InlineDTreeApplet;
import AIspace.dTree.PieCanvas;
import AIspace.dTree.dTreeGraph;
import AIspace.dTree.dTreeWindow;
import AIspace.dTree.dialogs.ProbTestResultsFrame;
import AIspace.graphToolKit.GraphConsts;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestStatisticsPanel
extends JPanel {
    protected dTreeGraph graph;
    protected ExampleList exampleList;
    protected ArrayList<Integer> correctExamples = null;
    protected ArrayList<Integer> noPredictionExamples = null;
    protected ArrayList<Integer> incorrectExamples = null;
    protected JTextArea correctTextArea;
    protected JTextArea noPredictionTextArea;
    protected JTextArea incorrectTextArea;
    protected Color correctColour;
    protected Color noPredictionColour;
    protected Color incorrectColour;
    protected GridBagLayout gridBagLayout;
    protected GridBagConstraints gridBagConstraints;
    protected PieCanvas pieCanvas;

    public TestStatisticsPanel(Container parent, ProbTestResultsFrame probTestFrame) {
        if (parent instanceof dTreeWindow) {
            this.graph = (dTreeGraph)((dTreeWindow)parent).returnCanvas().graph;
            this.exampleList = ((dTreeWindow)parent).exampleList;
        } else {
            this.graph = (dTreeGraph)((InlineDTreeApplet)parent).returnCanvas().graph;
            this.exampleList = ((InlineDTreeApplet)parent).exampleList;
        }
        this.correctColour = new Color(Color.green.getRGB()).darker();
        this.noPredictionColour = new Color(Color.blue.getRGB()).darker();
        this.incorrectColour = new Color(Color.red.getRGB()).darker();
        this.gridBagLayout = new GridBagLayout();
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.anchor = 10;
        this.gridBagConstraints.fill = 1;
        this.getData();
        this.setLayout(this.gridBagLayout);
        this.addComponent(this.makeExamplePanel(), this, 0, 0, 2, 1, 1.0, 1.0);
        this.addComponent(this.makePiePanel(), this, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.makePercentagePanel(), this, 1, 1, 1, 1, 0.0, 0.0);
        this.addComponent(this.makeButtonPanel(probTestFrame), this, 2, 0, 2, 1, 0.0, 0.1);
    }

    protected JPanel makeExamplePanel() {
        Dimension size;
        Font font = new Font("monospaced", 0, 12);
        JPanel centerPanel = new JPanel();
        JScrollPane correctPane = new JScrollPane(20, 30);
        JScrollPane incorrectPane = new JScrollPane(20, 30);
        JScrollPane noPredPane = new JScrollPane(22, 32);
        int panelCount = 0;
        if (this.correctTextArea.getText().length() < 1 && this.noPredictionTextArea.getText().length() < 1 && this.incorrectTextArea.getText().length() < 1) {
            centerPanel.add(new JLabel("There are no test examples"));
        } else {
            if (this.correctTextArea.getText().length() > 1) {
                JPanel correctPanel = new JPanel(new BorderLayout());
                JLabel correctLabel = new JLabel("Correctly Predicted Examples (" + this.correctExamples.size() + "):");
                correctLabel.setForeground(this.correctColour);
                this.correctTextArea.setRows(10);
                this.correctTextArea.setFont(font);
                this.correctTextArea.setEditable(false);
                this.correctTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                correctPanel.add("North", correctLabel);
                correctPanel.add("Center", this.correctTextArea);
                this.correctTextArea.setCaretPosition(0);
                correctPane = new JScrollPane(correctPanel, 20, 30);
                centerPanel.add(correctPane);
                ++panelCount;
            }
            if (this.noPredictionTextArea.getText().length() > 1) {
                JPanel noPredictionPanel = new JPanel(new BorderLayout());
                JLabel noPredictionLabel = new JLabel("Examples With No Prediction (" + this.noPredictionExamples.size() + "):");
                noPredictionLabel.setForeground(this.noPredictionColour);
                this.noPredictionTextArea.setRows(10);
                this.noPredictionTextArea.setFont(font);
                this.noPredictionTextArea.setEditable(false);
                this.noPredictionTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                noPredictionPanel.add("North", noPredictionLabel);
                noPredictionPanel.add("Center", this.noPredictionTextArea);
                this.noPredictionTextArea.setCaretPosition(0);
                noPredPane = new JScrollPane(noPredictionPanel, 22, 32);
                centerPanel.add(noPredPane);
                ++panelCount;
            }
            if (this.incorrectTextArea.getText().length() > 1) {
                JPanel incorrectPanel = new JPanel(new BorderLayout());
                JLabel incorrectLabel = new JLabel("Incorrectly Predicted Examples (" + this.incorrectExamples.size() + "):");
                incorrectLabel.setForeground(this.incorrectColour);
                this.incorrectTextArea.setRows(10);
                this.incorrectTextArea.setFont(font);
                this.incorrectTextArea.setEditable(false);
                this.incorrectTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                incorrectPanel.add("North", incorrectLabel);
                incorrectPanel.add("Center", this.incorrectTextArea);
                this.incorrectTextArea.setCaretPosition(0);
                incorrectPane = new JScrollPane(incorrectPanel, 20, 30);
                centerPanel.add(incorrectPane);
                ++panelCount;
            }
        }
        centerPanel.setMaximumSize(new Dimension(200, 200));
        if (panelCount == 1) {
            size = new Dimension(675, 350);
            incorrectPane.setPreferredSize(size);
            noPredPane.setPreferredSize(size);
            correctPane.setPreferredSize(size);
        } else if (panelCount == 2) {
            size = new Dimension(675, 125);
            incorrectPane.setPreferredSize(size);
            noPredPane.setPreferredSize(size);
            correctPane.setPreferredSize(size);
        } else if (panelCount == 3) {
            size = new Dimension(675, 115);
            incorrectPane.setPreferredSize(size);
            noPredPane.setPreferredSize(size);
            correctPane.setPreferredSize(size);
        }
        centerPanel.setLayout(new GridLayout(panelCount, 1));
        return centerPanel;
    }

    private void fillTextArea(JTextArea targetTextArea, ArrayList<Integer> selectedIndices, ArrayList<Hashtable<Integer, String>> allExamples, boolean showPrediction) {
        int i;
        targetTextArea.setText("");
        int maxColWidth = 0;
        if (selectedIndices.size() < 1 || this.exampleList.getNumParameters() < 2) {
            return;
        }
        int numParameters = this.exampleList.getNumParameters();
        if (showPrediction) {
            ++numParameters;
        }
        String[] parameters = this.exampleList.getParameters();
        StringBuffer heading = new StringBuffer();
        if (showPrediction) {
            String[] newParameters = new String[parameters.length + 1];
            i = 0;
            while (i < parameters.length) {
                newParameters[i] = parameters[i];
                ++i;
            }
            newParameters[newParameters.length - 1] = "Predicted Value";
            parameters = newParameters;
        }
        int[] colPos = new int[parameters.length];
        i = 0;
        while (i < numParameters) {
            colPos[i] = heading.length();
            heading.append(parameters[i]);
            int j = 0;
            while (j < 5) {
                heading.append(" ");
                ++j;
            }
            ++i;
        }
        targetTextArea.setText(String.valueOf(targetTextArea.getText()) + heading.toString());
        int i2 = 0;
        while (i2 < selectedIndices.size()) {
            StringBuffer display = new StringBuffer();
            Hashtable<Integer, String> oneExample = allExamples.get(selectedIndices.get(i2));
            int j = 0;
            while (j < numParameters) {
                String value = "";
                if (showPrediction && j == numParameters - 1) {
                    String[] values = new String[oneExample.size()];
                    int k = 0;
                    while (k < oneExample.size()) {
                        values[k] = oneExample.get(new Integer(k));
                        ++k;
                    }
                    value = this.graph.search(values);
                } else {
                    value = oneExample.get(new Integer(j));
                }
                if (value != null) {
                    while (display.length() < colPos[j]) {
                        display.append(" ");
                    }
                    display.append(value);
                }
                ++j;
            }
            if (maxColWidth < display.length()) {
                maxColWidth = heading.length();
            }
            targetTextArea.setText(String.valueOf(targetTextArea.getText()) + "\n" + display);
            ++i2;
        }
        targetTextArea.setColumns(maxColWidth);
        targetTextArea.setRows(selectedIndices.size() + 1);
    }

    protected JPanel makePercentagePanel() {
        JPanel percentagePanel = new JPanel(new GridLayout(5, 2));
        int numCorrect = 0;
        int numNoPrediction = 0;
        if (this.correctExamples != null) {
            numCorrect = this.correctExamples.size();
        }
        if (this.noPredictionExamples != null) {
            numNoPrediction = this.noPredictionExamples.size();
        }
        numCorrect = Math.round((float)numCorrect * 100.0f / (float)this.exampleList.getTestArrayList().size());
        numNoPrediction = Math.round((float)numNoPrediction * 100.0f / (float)this.exampleList.getTestArrayList().size());
        int numIncorrect = 100 - numCorrect - numNoPrediction;
        JLabel correct = new JLabel("Predicted Correctly: " + numCorrect + "%");
        correct.setForeground(this.correctColour);
        JLabel noPrediction = new JLabel("No Prediction: " + numNoPrediction + "%");
        noPrediction.setForeground(this.noPredictionColour);
        JLabel incorrect = new JLabel("Predicted Incorrectly: " + numIncorrect + "%");
        incorrect.setForeground(this.incorrectColour);
        percentagePanel.add(new JLabel(""));
        percentagePanel.add(new JLabel(""));
        percentagePanel.add(correct);
        percentagePanel.add(new JLabel(""));
        percentagePanel.add(noPrediction);
        percentagePanel.add(new JLabel(""));
        percentagePanel.add(incorrect);
        percentagePanel.add(new JLabel(""));
        percentagePanel.add(new JLabel(""));
        return percentagePanel;
    }

    protected JPanel makeButtonPanel(ProbTestResultsFrame ptrf) {
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(ptrf);
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    protected JPanel makePiePanel() {
        JPanel piePanel = new JPanel(new BorderLayout());
        this.pieCanvas = new PieCanvas(this.correctExamples.size(), this.noPredictionExamples.size(), this.incorrectExamples.size());
        piePanel.add("Center", this.pieCanvas);
        return piePanel;
    }

    protected void getData() {
        this.graph.mapAllTestExamples();
        this.correctExamples = this.graph.getTestExampleIndices(30);
        this.noPredictionExamples = this.graph.getTestExampleIndices(31);
        this.incorrectExamples = this.graph.getTestExampleIndices(32);
        this.correctTextArea = new JTextArea("", 5, 5);
        this.noPredictionTextArea = new JTextArea("", 5, 5);
        this.incorrectTextArea = new JTextArea("", 5, 5);
        this.fillTextArea(this.correctTextArea, this.correctExamples, this.exampleList.getTestArrayList(), false);
        this.fillTextArea(this.noPredictionTextArea, this.noPredictionExamples, this.exampleList.getTestArrayList(), false);
        this.fillTextArea(this.incorrectTextArea, this.incorrectExamples, this.exampleList.getTestArrayList(), true);
    }

    private void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gridBagConstraints.gridx = column;
        this.gridBagConstraints.gridy = row;
        this.gridBagConstraints.gridwidth = width;
        this.gridBagConstraints.gridheight = height;
        this.gridBagConstraints.weightx = wx;
        this.gridBagConstraints.weighty = wy;
        this.gridBagLayout.setConstraints(c, this.gridBagConstraints);
        p.add(c);
    }
}

