/*
 * Decompiled with CFR 0.152.
 */
package AIspace.dTree.elements;

import AIspace.dTree.ExampleList;
import AIspace.dTree.dTreeGraph;
import AIspace.dTree.elements.dTreeHistogramNode;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dTreeNode
extends dTreeHistogramNode {
    protected String type;
    protected ArrayList<Integer> in_indices;
    protected ArrayList<Integer> example_indices;
    public ArrayList<Integer> correct_test_indices;
    public ArrayList<Integer> noPrediction_test_indices;
    public ArrayList<Integer> incorrect_test_indices;
    protected int screenWidth = 600;
    protected int numExamples = 0;
    protected ArrayList<String> outValues;
    private ArrayList<String> originalOutValues;
    protected double[] probs;
    private double[] originalProbs;
    protected double entropy;
    protected double gini;
    private int depth = 0;
    private double testSetError = -1.0;
    private double trainingSetError = -1.0;
    protected ArrayList<dTreeNode> children;

    public dTreeNode(dTreeGraph graph) {
        super(graph);
        this.initialize();
    }

    public dTreeNode(dTreeGraph graph, String type) {
        super(graph);
        this.setType(type);
        this.initialize();
    }

    private void initialize() {
        this.wPad = 10;
        this.hPad = 10;
        this.updateSize();
        this.in_indices = new ArrayList(5);
        this.example_indices = new ArrayList(5);
        this.outValues = new ArrayList(5);
        this.children = new ArrayList(5);
        this.clearTestMappings();
    }

    public void setType(String newType) {
        if (newType == "SPLIT") {
            this.shape = 1111;
            this.color = Color.blue;
            this.label[0] = "     ";
            this.label[1] = "     ";
        } else if (newType == "LEAF") {
            this.shape = 1111;
            this.color = Color.green;
        } else if (newType == "NON_LEAF") {
            this.shape = 1111;
            this.color = Color.red;
        } else if (newType == "INCONSISTENT") {
            this.shape = 1111;
            this.color = Color.red;
            this.label[0] = "  ?  ";
        } else {
            return;
        }
        this.type = newType;
    }

    public void clearTestMappings() {
        this.correct_test_indices = new ArrayList();
        this.noPrediction_test_indices = new ArrayList();
        this.incorrect_test_indices = new ArrayList();
    }

    public ArrayList<dTreeNode> getAllDescendents() {
        ArrayList<dTreeNode> descList = new ArrayList<dTreeNode>(5);
        int i = 0;
        while (i < this.children.size()) {
            descList.add(this.children.get(i));
            ArrayList<dTreeNode> childDescList = this.children.get(i).getAllDescendents();
            descList.addAll(childDescList);
            ++i;
        }
        return descList;
    }

    public void addChild(dTreeNode child) {
        this.children.add(child);
    }

    public void removeChild(dTreeNode child) {
        this.children.remove(child);
    }

    public void removeChildByIndex(int index) {
        this.children.remove(index);
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public int getChildIndex(dTreeNode child) {
        return this.children.indexOf(child);
    }

    public ArrayList<Integer> getCorrectTestIndices() {
        return this.correct_test_indices;
    }

    public ArrayList<Integer> getNoPredictionTestIndices() {
        return this.noPrediction_test_indices;
    }

    public ArrayList<Integer> getIncorrectTestIndices() {
        return this.incorrect_test_indices;
    }

    public ArrayList<Integer> getInIndices() {
        return this.in_indices;
    }

    public void setInIndices(ArrayList<Integer> indices) {
        this.in_indices = indices;
    }

    public ArrayList<Integer> getExampleIndices() {
        return this.example_indices;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public void setScreenWidth(int width) {
        this.screenWidth = width;
    }

    public String getType() {
        return this.type;
    }

    public void addExample(int index) {
        if (!this.example_indices.contains(new Integer(index))) {
            this.example_indices.add(new Integer(index));
        }
    }

    public int numInValues(int attributeIndex) {
        ExampleList eList = dTreeGraph.exampleList;
        ArrayList<Integer> indices = new ArrayList<Integer>(this.example_indices);
        int k = 0;
        while (indices.size() > 0) {
            int exampleIndex = indices.get(0);
            String v = eList.inValue(exampleIndex, attributeIndex);
            ++k;
            int i = 0;
            while (i < indices.size()) {
                exampleIndex = indices.get(i);
                if (eList.inValue(exampleIndex, attributeIndex).equals(v)) {
                    indices.remove(i--);
                }
                ++i;
            }
        }
        return k;
    }

    public String getModeOutputValue() {
        String modeOutputValue = "";
        double maxCount = 0.0;
        int i = 0;
        while (i < this.outValues.size()) {
            if (this.probs[i] > maxCount) {
                maxCount = this.probs[i];
                modeOutputValue = this.outValues.get(i);
            }
            ++i;
        }
        return modeOutputValue;
    }

    public void setAsLeaf() {
        String modeValue = this.getModeOutputValue();
        int i = 0;
        while (i < this.outValues.size()) {
            if (!this.outValues.get(i).equals(modeValue)) {
                this.outValues.remove(i);
            }
            ++i;
        }
        this.setLabel(modeValue);
        this.updateSize();
        this.setType("LEAF");
        this.refreshHistogram();
    }

    public void setAsLeaf(String outValue) {
        int i = 0;
        while (i < this.outValues.size()) {
            if (!this.outValues.get(i).equals(outValue)) {
                this.outValues.remove(i);
            }
            ++i;
        }
        this.setLabel(outValue);
        this.updateSize();
        this.setType("LEAF");
        this.refreshHistogram();
    }

    public void setOutValues() {
        ExampleList eList = dTreeGraph.exampleList;
        ArrayList<Integer> indices = new ArrayList<Integer>(this.example_indices);
        this.entropy = 0.0;
        this.gini = 1.0;
        ArrayList<Integer> Probs = new ArrayList<Integer>();
        while (indices.size() > 0) {
            int valueCount = 0;
            int j = indices.get(0);
            String v = eList.outValue(j);
            int i = 0;
            while (i < indices.size()) {
                j = indices.get(i);
                if (eList.outValue(j).equals(v)) {
                    ++valueCount;
                    indices.remove(i--);
                }
                ++i;
            }
            this.outValues.add(v);
            Probs.add(new Integer(valueCount));
        }
        this.probs = new double[Probs.size()];
        this.numExamples = this.example_indices.size();
        if (this.originalProbs == null) {
            this.originalProbs = new double[this.probs.length];
        }
        int i = 0;
        while (i < this.probs.length) {
            this.probs[i] = ((Integer)Probs.get(i)).doubleValue();
            this.entropy -= this.probs[i] / (double)this.numExamples * Math.log(this.probs[i] / (double)this.numExamples) / Math.log(2.0);
            this.gini -= this.probs[i] / (double)this.numExamples * (this.probs[i] / (double)this.numExamples);
            ++i;
        }
        if (this.originalOutValues == null) {
            this.originalOutValues = new ArrayList(this.outValues.size());
            i = 0;
            while (i < this.outValues.size()) {
                this.originalOutValues.add(this.outValues.get(i));
                ++i;
            }
        }
        this.updateOriginalProbs();
    }

    private void updateOriginalProbs() {
        int i = 0;
        while (i < this.originalProbs.length) {
            this.originalProbs[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.outValues.size()) {
            String currOutValue = this.outValues.get(i);
            int k = 0;
            while (k < this.originalOutValues.size()) {
                String currOriginalOutValue = this.originalOutValues.get(k);
                if (currOutValue.equals(currOriginalOutValue)) {
                    this.originalProbs[k] = this.probs[i];
                }
                ++k;
            }
            ++i;
        }
    }

    public ArrayList<Integer> getTestExampleIndices() {
        ArrayList<Integer> testExampleIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < this.correct_test_indices.size()) {
            testExampleIndices.add(this.correct_test_indices.get(i));
            ++i;
        }
        i = 0;
        while (i < this.incorrect_test_indices.size()) {
            testExampleIndices.add(this.incorrect_test_indices.get(i));
            ++i;
        }
        i = 0;
        while (i < this.noPrediction_test_indices.size()) {
            testExampleIndices.add(this.noPrediction_test_indices.get(i));
            ++i;
        }
        return testExampleIndices;
    }

    public void refreshHistogram() {
        this.clearHistogram();
        if (this.type != "LEAF" && this.type != "SPLIT" && this.label[0].length() > 1) {
            this.setHistogramCaption("Split: " + this.label[0]);
        } else {
            this.setHistogramCaption("     Leaf    ");
        }
        int i = 0;
        while (i < this.originalOutValues.size()) {
            this.addHistogramLabel(this.originalOutValues.get(i));
            this.addHistogramCount(new Integer((int)this.getOriginalProbs()[i]));
            this.addHistogramValue((int)Math.round(this.originalProbs[i] / (double)this.numExamples * 100.0));
            ++i;
        }
    }

    public void addInIndex(int index) {
        if (!this.in_indices.contains(new Integer(index))) {
            this.in_indices.add(new Integer(index));
        }
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public double getEntropy() {
        return this.entropy;
    }

    public double getGini() {
        return this.gini;
    }

    public int getNumExamples() {
        return this.numExamples;
    }

    public ArrayList<Integer> getTrainingExampleIndices() {
        return this.example_indices;
    }

    public ArrayList<String> getOutValues() {
        return this.outValues;
    }

    public void setOriginalOutValues(ArrayList<String> originalOutValues) {
        this.originalOutValues = new ArrayList<String>(originalOutValues);
    }

    public ArrayList<String> getOriginalOutValues() {
        return this.originalOutValues;
    }

    public void setOriginalProbs(double[] originalProbs) {
        this.originalProbs = new double[originalProbs.length];
        int i = 0;
        while (i < originalProbs.length) {
            this.originalProbs[i] = originalProbs[i];
            ++i;
        }
    }

    public double[] getOriginalProbs() {
        return this.originalProbs;
    }

    public void setOriginalOutsAndProbs() {
        this.originalOutValues = new ArrayList<String>(this.outValues);
        this.originalProbs = new double[this.probs.length];
        int i = 0;
        while (i < this.probs.length) {
            this.originalProbs[i] = this.probs[i];
            ++i;
        }
    }

    public void setTestSetError(double error) {
        this.testSetError = error;
    }

    public double getTestSetError() {
        return this.testSetError;
    }

    public void setTrainingSetError(double trainingSetError) {
        this.trainingSetError = trainingSetError;
    }

    public double getTrainingSetError() {
        return this.trainingSetError;
    }

    @Override
    public String toString() {
        return String.valueOf(this.index) + ": " + this.label[0];
    }
}

