/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction;

import AIspace.deduction.DeductionGraph;
import AIspace.deduction.DeductionWindow;
import AIspace.deduction.InlineCanvas;
import AIspace.deduction.InlineDeductionApplet;
import AIspace.deduction.dialogs.CreateQueryFrame;
import AIspace.deduction.dialogs.DeductionTextFrame;
import AIspace.deduction.dialogs.InspectNodeFrame;
import AIspace.deduction.dialogs.ProofCanvas;
import AIspace.deduction.dialogs.ProofFrame;
import AIspace.deduction.dialogs.UserSearchFrame;
import AIspace.deduction.elements.DeductionEdge;
import AIspace.deduction.elements.DeductionNode;
import AIspace.deduction.searchTypes.Search;
import AIspace.graphToolKit.GraphCanvas;
import AIspace.graphToolKit.dialogs.FontDialog;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Point;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class DeductionCanvas
extends GraphCanvas {
    public static final int C_QUERY_NODE = 3340;
    public static final int C_INSPECT_NODE = 3336;
    public static final int C_VIEW_PROOF = 3337;
    public static final int C_MOVE_SUBTREE = 3338;
    private JMenuItem reset;
    private JMenu zp;
    public JMenuItem autoscale;
    public JMenuItem resetSearch;
    public JMenuItem stopSearch;
    public JMenuItem autoSearch;
    public JMenuItem fineStep;
    public JMenuItem step;
    public JMenuItem createNewQuery;
    private int searchMethod;
    private int lastStepSize;
    private CreateQueryFrame cqFrame;
    private UserSearchFrame rsFrame;
    private ProofFrame pfFrame;
    private InspectNodeFrame inFrame;

    public DeductionCanvas(Container parent, boolean inline) {
        super(parent, inline);
        this.graph = new DeductionGraph(this);
        this.lastStepSize = 102;
        this.submode = 3340;
        this.searchMethod = 201;
        if (this instanceof ProofCanvas) {
            this.mode = 2221;
            this.submode = 3338;
        }
        this.solvePopUp();
    }

    public void solvePopUp() {
        JRadioButtonMenuItem pan;
        JRadioButtonMenuItem zoom;
        this.createNewQuery = new JMenuItem("Create New Query");
        this.createNewQuery.addActionListener(this);
        this.step = new JMenuItem("Step");
        this.step.addActionListener(this);
        this.fineStep = new JMenuItem("Fine Step");
        this.fineStep.addActionListener(this);
        this.autoSearch = new JMenuItem("Auto Search");
        this.autoSearch.addActionListener(this);
        this.stopSearch = new JMenuItem("Stop Search");
        this.stopSearch.addActionListener(this);
        this.stopSearch.setEnabled(false);
        this.resetSearch = new JMenuItem("Reset Search");
        this.resetSearch.addActionListener(this);
        this.autoscale = new JMenuItem("Autoscale");
        this.autoscale.addActionListener(this);
        this.reset = new JMenuItem("Reset Edge Labels");
        this.reset.addActionListener(this);
        this.zp = new JMenu("Pan/Zoom");
        ButtonGroup zpGroup = new ButtonGroup();
        if (this.getRMode() == 4441) {
            zoom = new JRadioButtonMenuItem("Zoom", true);
            pan = new JRadioButtonMenuItem("Pan", false);
        } else {
            zoom = new JRadioButtonMenuItem("Zoom", false);
            pan = new JRadioButtonMenuItem("Pan", true);
        }
        zoom.setToolTipText("Zoom into certain area of graph");
        zoom.addActionListener(this);
        zpGroup.add(zoom);
        this.zp.add(zoom);
        pan.setToolTipText("Pan the graph to a different area on the canvas");
        pan.addActionListener(this);
        this.zp.add(pan);
        zpGroup.add(pan);
    }

    @Override
    protected void popupCanvas(int x, int y) {
        this.pop.removeAll();
        if (!(this instanceof ProofCanvas)) {
            this.pop.setBorder(BorderFactory.createTitledBorder("Solve Options"));
            if (this.inline) {
                ((InlineCanvas)this.graph.canvas).addAlgorithmItems();
            }
            this.pop.add(this.createNewQuery);
            this.pop.add(this.fineStep);
            this.pop.add(this.step);
            this.pop.add(this.autoSearch);
            this.pop.add(this.stopSearch);
            this.pop.add(this.resetSearch);
            this.pop.addSeparator();
            this.pop.add(new JLabel("View Options"));
        } else {
            this.pop.setBorder(BorderFactory.createTitledBorder("View Options"));
        }
        this.pop.add(this.autoscale);
        this.pop.add(this.reset);
        this.pop.add(this.zp);
        if (this.inline && ((InlineDeductionApplet)this.parent).textRepresentationPopupOn) {
            this.pop.addSeparator();
            JMenuItem repItem = new JMenuItem("View CILog Code");
            repItem.setActionCommand(repItem.getText());
            repItem.addActionListener((InlineDeductionApplet)this.parent);
            this.pop.add(repItem);
            repItem = new JMenuItem("View Proof Tree Text Representation");
            repItem.setActionCommand(repItem.getText());
            repItem.addActionListener((InlineDeductionApplet)this.parent);
            this.pop.add(repItem);
            repItem = new JMenuItem("View XML Representation");
            repItem.setActionCommand(repItem.getText());
            repItem.addActionListener((InlineDeductionApplet)this.parent);
            this.pop.add(repItem);
        }
        this.pop.show(this, x, y);
    }

    @Override
    protected void popupNode(int x, int y) {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Node Options"));
        if (this.mode != 2220 && !(this instanceof ProofCanvas) && ((DeductionNode)this.entClicked).getType() != 1 && ((DeductionNode)this.entClicked).getType() != 7) {
            JMenuItem mItem = new JMenuItem("Inspect Node");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("View Proof Deduction");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.show(this, x, y);
        }
    }

    @Override
    protected void popupEdge(int x, int y) {
    }

    @Override
    public void reset() {
        super.reset();
        this.graph = new DeductionGraph(this);
        this.resetSearch();
    }

    public String parse(String str) {
        DeductionGraph old = (DeductionGraph)this.graph;
        this.graph = new DeductionGraph(this);
        String errMsg = ((DeductionGraph)this.graph).parse(str);
        if (errMsg.equals("OK")) {
            if (this.inline) {
                ((InlineDeductionApplet)this.parent).setKB(((DeductionGraph)this.graph).generateCilogText());
            } else {
                ((DeductionWindow)this.parent).setKB(((DeductionGraph)this.graph).generateCilogText());
            }
        } else {
            this.showMessage("Error", errMsg);
            this.graph = old;
        }
        return errMsg;
    }

    @Override
    public void pause() {
        super.pause();
        Search search = ((DeductionGraph)this.graph).getSearchObject();
        if (search != null) {
            search.pauseAuto(true);
        }
    }

    @Override
    public void unpause() {
        super.unpause();
        Search search = ((DeductionGraph)this.graph).getSearchObject();
        if (search != null) {
            search.pauseAuto(false);
        }
    }

    public void doSearch(int searchAlgorithm, int rate, boolean inline) {
        this.lastStepSize = rate;
        this.searchMethod = searchAlgorithm;
        ((DeductionGraph)this.graph).doSearch(searchAlgorithm, rate, inline);
        this.repaint();
    }

    public DeductionWindow returnWindow() {
        return (DeductionWindow)this.parent;
    }

    public void resetSearch() {
        DeductionNode node;
        Search sTemp = ((DeductionGraph)this.graph).getSearchObject();
        if (sTemp != null && (node = sTemp.getStartNode()) != null) {
            ((DeductionCanvas)this.graph.canvas).centerOverNode(node);
        }
        ((DeductionGraph)this.graph).resetSearch();
        this.repaint();
    }

    public void disableStopButton() {
        if (this instanceof InlineCanvas) {
            ((InlineDeductionApplet)this.parent).stopSearchButton.setEnabled(false);
        } else {
            ((DeductionWindow)this.parent).disableStopButton();
        }
        this.stopSearch.setEnabled(false);
    }

    @Override
    public void disposeWindows() {
        super.disposeWindows();
        if (this.nDialog != null) {
            this.nDialog.dispose();
        }
        if (this.eDialog != null) {
            this.eDialog.dispose();
        }
        if (this.cqFrame != null) {
            this.cqFrame.dispose();
        }
        if (this.rsFrame != null) {
            this.rsFrame.dispose();
        }
        if (this.pfFrame != null) {
            this.pfFrame.dispose();
        }
        if (this.inFrame != null) {
            this.inFrame.dispose();
        }
    }

    public void enableSearch() {
        if (this instanceof InlineCanvas) {
            return;
        }
        ((DeductionWindow)this.parent).enableSearch();
    }

    public int getSearchMethod() {
        return this.searchMethod;
    }

    public void setSearchMethod(int method) {
        this.searchMethod = method;
    }

    @Override
    public void changeFont(int size) {
        if (this instanceof ProofCanvas) {
            if (size == -1) {
                new FontDialog(this);
            } else {
                this.font = new Font("SansSerif", 0, size);
            }
            this.graph.updateNodeSize();
            this.graph.updateEdgeSize();
            this.repaint();
        } else {
            super.changeFont(size);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        if (e.getModifiers() == 4 || ent == null || ent.type != 7770) {
            return;
        }
        if (this.mode != 2220 && this.mode == 2221) {
            if (this.submode == 3340 && ((DeductionNode)ent).getType() != 2 && ((DeductionNode)ent).getType() != 7 && this.searchMethod == 209) {
                if (this.rsFrame != null) {
                    this.rsFrame.dispose();
                }
                this.rsFrame = new UserSearchFrame((DeductionGraph)this.graph, (DeductionNode)ent);
            } else if (this.submode == 3336 && ((DeductionNode)ent).getType() != 1 && ((DeductionNode)ent).getType() != 7) {
                if (this.inFrame != null) {
                    this.inFrame.dispose();
                }
                this.inFrame = new InspectNodeFrame((DeductionNode)ent, this.font.getSize());
            } else if (this.submode == 3337 && ((DeductionNode)ent).getType() != 7) {
                if (this.pfFrame != null) {
                    this.pfFrame.dispose();
                }
                this.pfFrame = new ProofFrame((DeductionGraph)this.graph, (DeductionNode)ent, this.font.getSize());
            } else if (this.submode == 3338) {
                this.graph.deselectAll();
                ArrayList<DeductionNode> descendents = ((DeductionNode)ent).getAllDescendents();
                int i = 0;
                while (i < descendents.size()) {
                    this.graph.select(descendents.get(i));
                    this.graph.select(descendents.get(i).getEdgeIn());
                    ++i;
                }
                this.isMoving = true;
            } else if (this.submode == 3335 && ent == this.tempEnt) {
                this.mPressedSelect(ent, false);
                this.submode = this.tempMode;
            } else if (this.submode == 3335 && ent != this.tempEnt) {
                this.submode = this.tempMode;
            } else if (this.submode == 3332) {
                this.mPressedSelect(ent, e.isControlDown() || e.isShiftDown());
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.pause) {
            return;
        }
        super.mouseMoved(e);
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        if (ent != null && ent.type == 7770 && !((DeductionNode)ent).isHidden()) {
            String label = ((DeductionNode)ent).getFullLabel();
            if (!(this instanceof ProofCanvas) && !this.getPromptLabel().equals(label)) {
                this.setPromptLabel(label);
                this.setPromptSticky(false);
            }
            ((DeductionNode)ent).setHovered(true);
            ((DeductionGraph)this.graph).setHighlighted(ent);
            ((DeductionNode)ent).setLabel(((DeductionGraph)this.graph).nodeDetail);
        } else if (ent != null && ent.type == 7771 && !(this instanceof ProofCanvas)) {
            String label = ((DeductionEdge)ent).getFullLabel();
            if (!this.getPromptLabel().equals(label)) {
                this.setPromptLabel(label);
                this.setPromptSticky(false);
            }
            this.repaint();
        } else if (!this.isPromptSticky()) {
            this.setPromptLabel("Move the mouse over a node/edge to see the unification step.");
        }
    }

    public void openTextRep() {
        new DeductionTextFrame(this, ((DeductionGraph)this.graph).generateTextRep(), "Text Representation of the Graph", false);
    }

    public void openXMLTextRep() {
        new DeductionTextFrame(this, ((DeductionGraph)this.graph).generateXMLRep(), "XML Text Representation of the Graph", false);
    }

    public void openCilogTextRep() {
        new DeductionTextFrame(this, ((DeductionGraph)this.graph).generateCilogText(), "CILog Code for the Graph", false);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        Point min = this.graph.getBound()[0];
        Point max = this.graph.getBound()[1];
        float midX = Math.abs(max.x - min.x) / 2.0f + min.x;
        float midY = Math.abs(max.y - min.y) / 2.0f + min.y;
        float graphScale = this.graph.getScale();
        this.zoomForPrinting();
        this.drawPrint((Graphics2D)g);
        this.graph.setScale(graphScale);
        this.moveGraphToPoint(new Point(midX, midY));
        return 0;
    }

    @Override
    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean updateProgram(String allText) {
        this.resetSearch();
        DeductionGraph old = (DeductionGraph)this.graph;
        this.graph = new DeductionGraph(this);
        String errMsg = ((DeductionGraph)this.graph).parse(allText);
        if (errMsg.equals("OK")) {
            this.repaint();
            return true;
        }
        this.showMessage("Error", errMsg);
        this.graph = old;
        return false;
    }

    public void openSelectFrame() {
        this.cqFrame = new CreateQueryFrame((DeductionGraph)this.graph, this);
    }

    public void setPromptSticky(boolean value) {
        if (this instanceof ProofCanvas || this instanceof InlineCanvas) {
            return;
        }
        ((DeductionWindow)this.parent).setPromptSticky(value);
    }

    public boolean isPromptSticky() {
        if (this instanceof ProofCanvas || this instanceof InlineCanvas) {
            return false;
        }
        return ((DeductionWindow)this.parent).isPromptSticky();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        int arg = e.getKeyCode();
        if (!(arg != 32 && arg != 10 && arg != 83 || this instanceof ProofCanvas)) {
            this.doSearch(this.searchMethod, this.lastStepSize, false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Step")) {
            ((DeductionWindow)this.parent).step();
        } else if (arg.equals("Fine Step")) {
            ((DeductionWindow)this.parent).fineStep();
        } else if (arg.equals("Auto Search")) {
            ((DeductionWindow)this.parent).autoSearchAction();
        } else if (arg.equals("Stop Search")) {
            ((DeductionWindow)this.parent).stopSearch();
        } else if (arg.equals("Select Node")) {
            this.tempEnt = this.entClicked;
            this.tempMode = this.submode;
            this.setSubmode(3335);
        } else if (arg.equals("View Prolog Code")) {
            this.openCilogTextRep();
        } else if (arg.equals("View Text Representation")) {
            this.openTextRep();
        } else if (arg.equals("Reset Edge Labels")) {
            this.resetLabels();
        } else if (arg.equals("Create New Query")) {
            this.openSelectFrame();
        } else {
            if (arg.equals("Autoscale")) {
                this.autoscale();
                return;
            }
            if (arg.equals("View Proof Deduction")) {
                if (this.pfFrame != null) {
                    this.pfFrame.dispose();
                }
                this.pfFrame = new ProofFrame((DeductionGraph)this.graph, (DeductionNode)this.entClicked, this.font.getSize());
            } else if (arg.equals("Inspect Node")) {
                if (this.inFrame != null) {
                    this.inFrame.dispose();
                }
                this.inFrame = new InspectNodeFrame((DeductionNode)this.entClicked, this.font.getSize());
            } else if (arg.equals("Reset Search")) {
                if (!(this instanceof InlineCanvas)) {
                    ((DeductionWindow)this.parent).resetSearch();
                } else {
                    this.resetSearch();
                }
            }
        }
        super.aPerformed(e);
    }

    public void stopSearch() {
        ((DeductionWindow)this.parent).stopSearch();
    }
}

