/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction;

import AIspace.XMLReader.XMLBlock;
import AIspace.XMLReader.XMLParseException;
import AIspace.XMLReader.XMLTree;
import AIspace.deduction.DeductionCanvas;
import AIspace.deduction.DeductionWindow;
import AIspace.deduction.InlineCanvas;
import AIspace.deduction.elements.DeductionEdge;
import AIspace.deduction.elements.DeductionNode;
import AIspace.deduction.searchTypes.BestFirst;
import AIspace.deduction.searchTypes.BreadthFirst;
import AIspace.deduction.searchTypes.DepthFirst;
import AIspace.deduction.searchTypes.HeuristicDepthFirst;
import AIspace.deduction.searchTypes.Search;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import AIspace.prolog.Goal;
import AIspace.prolog.Predicate;
import AIspace.prolog.Program;
import AIspace.prolog.Rule;
import AIspace.prolog.Substitution;
import AIspace.prolog.Term;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.StringTokenizer;

public class DeductionGraph
extends Graph {
    public static final int C_NO_DETAIL = 39;
    public static final int C_LOW_DETAIL = 40;
    public static final int C_HIGH_DETAIL = 41;
    public static final int C_MED_DETAIL = 42;
    public static final int C_SELECT_RANDOM = 550;
    public static final int C_SELECT_FIRST = 551;
    public static final int C_SELECT_SHORTEST = 552;
    public static final int C_SELECT_FEWEST_VARS = 553;
    protected DeductionNode startNode;
    protected ArrayList<Integer> goalNodeIndex;
    protected Entity highlightedEnt;
    private int searchRate = 102;
    private Search search;
    public boolean pruneRules = true;
    private boolean stopAtGoal = true;
    private int curDepth;
    public int nodeDetail = 42;
    public int edgeDetail = 41;
    public boolean showFullSubs;
    private int maxNumSteps = 50;
    private int maxDepth = 50;
    protected int goalSelect = 551;
    private boolean showNum = false;
    private Program pr = new Program();
    private ArrayList<String> kbConstants = new ArrayList();
    protected int[] nodesAtDepth;
    protected String shortDescription = "";
    protected String detailedDescription = "";

    public DeductionGraph(DeductionCanvas canvas) {
        super(canvas);
        this.goalNodeIndex = new ArrayList();
        this.nodesAtDepth = new int[this.maxDepth];
    }

    public Search getSearchObject() {
        return this.search;
    }

    public int getMaxNumSteps() {
        return this.maxNumSteps;
    }

    public void setMaxNumSteps(int num) {
        this.maxNumSteps = num;
    }

    public int getDepth() {
        return this.maxDepth;
    }

    public void setDepth(int num) {
        this.maxDepth = num;
    }

    public DeductionNode getStartNode() {
        return this.startNode;
    }

    public ArrayList<Integer> getGoalNodeIndex() {
        return this.goalNodeIndex;
    }

    public void setGoalSelectHeuristic(int gsh) {
        this.goalSelect = gsh;
    }

    public int getGoalSelectHeuristic() {
        return this.goalSelect;
    }

    public boolean getStopAtGoal() {
        return this.stopAtGoal;
    }

    public void setStopAtGoal(boolean bool) {
        this.stopAtGoal = bool;
    }

    public boolean getShowNum() {
        return this.showNum;
    }

    public void setShowNum(boolean bool) {
        this.showNum = bool;
    }

    public void setPromptSticky(boolean value) {
        ((DeductionCanvas)this.canvas).setPromptSticky(value);
    }

    public boolean promptSticky() {
        return ((DeductionCanvas)this.canvas).isPromptSticky();
    }

    @Override
    public void draw(Graphics offscreen, boolean moving) {
        if (this.nodeDetail == 39) {
            super.drawStructure(offscreen, moving);
            return;
        }
        super.draw(offscreen, moving);
        if (this.highlightedEnt != null && this.nodeDetail != 39) {
            this.highlightedEnt.draw(offscreen, moving);
        }
    }

    protected void setHighlighted(Entity n) {
        if (this.highlightedEnt != null && this.highlightedEnt != n) {
            try {
                ((DeductionNode)this.highlightedEnt).setHovered(false);
                ((DeductionNode)this.highlightedEnt).setLabel(this.nodeDetail);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.highlightedEnt = n;
    }

    public void setOccursCheck(boolean bool) {
        this.pr.setOccursCheck(bool);
    }

    public void setPruneRules(boolean bool) {
        this.pruneRules = bool;
    }

    public void setEdgeDetail(int detail) {
        this.edgeDetail = detail;
        int i = 0;
        while (i < this.numEdges()) {
            ((DeductionEdge)this.edgeAt(i)).setLabel(detail);
            ++i;
        }
        this.repaint();
    }

    public void setNodeDetail(int detail) {
        this.nodeDetail = detail;
        int i = 0;
        while (i < this.numNodes()) {
            ((DeductionNode)this.nodeAt(i)).setLabel(detail);
            this.updateNodeSize(this.nodeAt(i));
            ++i;
        }
        this.repaint();
    }

    public int getSearchRate() {
        return this.searchRate;
    }

    public void setSearchRate(int rate) {
        this.searchRate = rate;
    }

    public String getShortDesc() {
        return this.shortDescription;
    }

    public void setShortDesc(String description) {
        this.shortDescription = description;
        if (description.trim().equals("") || description == null) {
            this.shortDescription = "";
        }
    }

    public String getDetailedDesc() {
        return this.detailedDescription;
    }

    public void setDetailedDesc(String description) {
        this.detailedDescription = description;
        if (description.trim().equals("") || description == null) {
            this.detailedDescription = "";
        }
    }

    public void stopAutoSearch() {
        if (this.search != null) {
            this.search.stopAutoSearch();
        }
    }

    public void disableStopButton() {
        ((DeductionCanvas)this.canvas).disableStopButton();
    }

    public void setButtonsAfterSearchComplete() {
        ((DeductionWindow)this.canvas.parent).setAutoSearchStopButton();
    }

    public void doSearch(int searchAlgorithm, int rate, boolean isInline) {
        this.setSearchRate(rate);
        if (this.startNode != null) {
            if (this.search == null) {
                switch (searchAlgorithm) {
                    case 201: {
                        this.search = new DepthFirst(this);
                        break;
                    }
                    case 202: {
                        this.search = new BreadthFirst(this);
                        break;
                    }
                    case 204: {
                        this.search = new BestFirst(this);
                        break;
                    }
                    case 205: {
                        this.search = new HeuristicDepthFirst(this);
                        break;
                    }
                }
                if (this.search.getSearchRate() == 101) {
                    this.search.step();
                }
            } else {
                this.search.setSearchRate(rate);
                this.search.step();
            }
        } else if (!isInline) {
            ((DeductionCanvas)this.canvas).stopSearch();
            this.setPromptLabel("No Start Nodes.");
        }
    }

    public void resetSearch() {
        this.highlightedEnt = null;
        this.curDepth = 0;
        this.nodesAtDepth = new int[this.maxDepth];
        this.nodesAtDepth[0] = 1;
        Iterator<Node> nodeItr = this.getNodes();
        while (nodeItr.hasNext()) {
            Node tmpNode = nodeItr.next();
            if (tmpNode == this.startNode) continue;
            this.select(tmpNode);
            this.deleteSelected();
            nodeItr = this.getNodes();
        }
        if (this.startNode != null) {
            this.startNode.reset();
            this.startNode.color = Color.black;
            this.startNode.setNodeAppearance(1);
        }
        this.goalNodeIndex = new ArrayList();
        this.pr.reset();
        this.search = null;
    }

    public ArrayList<Predicate> getPredicates() {
        return this.pr.getPredicates();
    }

    public boolean repeatPredicateName(Predicate p) {
        return this.pr.repeatName(p);
    }

    public ArrayList<String> getConstants() {
        return new ArrayList<String>(this.kbConstants);
    }

    public String parse(String file) {
        String err = this.pr.parse(file);
        this.kbConstants = this.pr.getConstants();
        if (err.length() > 0) {
            return err;
        }
        return "OK";
    }

    public String generateXMLRep() {
        StringBuffer rep = new StringBuffer("<DEDUCTION VERSION=\".1\">\n\n");
        rep.append("<DESCRIPTION>\n\t<SHORT>").append(this.getShortDesc()).append("</SHORT>");
        rep.append("\n\t<DETAILED>").append(this.getDetailedDesc()).append("</DETAILED>\n</DESCRIPTION>\n\n");
        rep.append("<KNOWLEDGEBASE>\n\t<LogicProgram>\n\n");
        rep.append(this.generateCilogText());
        rep.append("\n\t</LogicProgram>\n</KNOWLEDGEBASE>\n\n</DEDUCTION>\n");
        return rep.toString();
    }

    public String parseXML(XMLTree tree) {
        String errString = "";
        try {
            XMLBlock desc = tree.findNetworkTree("description");
            ArrayList<Object> sdescs = new ArrayList();
            ArrayList<Object> ldescs = new ArrayList();
            if (desc == null) {
                this.setShortDesc("");
                this.setDetailedDesc("");
            } else {
                sdescs = desc.searchChildTag("short");
                ldescs = desc.searchChildTag("detailed");
                if (sdescs == null || sdescs.size() == 0) {
                    this.setShortDesc("");
                } else {
                    this.setShortDesc(((XMLBlock)sdescs.get(0)).getText());
                }
                if (ldescs == null || ldescs.size() == 0) {
                    this.setDetailedDesc("");
                } else {
                    this.setDetailedDesc(((XMLBlock)ldescs.get(0)).getText());
                }
            }
            XMLBlock kb = tree.findNetworkTree("knowledgebase");
            if (kb == null) {
                errString = "No knowledge base defined";
                throw new Exception();
            }
            ArrayList<XMLBlock> logic = kb.searchChildTag("logicprogram");
            if (logic == null) {
                errString = "No knowledge base defined";
                throw new Exception();
            }
            errString = this.parse(logic.get(0).getText());
            if (errString.length() > 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            if (errString.length() > 0) {
                return "Error:" + errString;
            }
            return "Error:" + e.toString();
        }
        return "OK";
    }

    public Goal parseGoal(String goal) {
        return this.pr.parseGoal(goal);
    }

    public String updateGraphFromXML(String allText) {
        this.clearGraph();
        this.setScale(1.0f);
        String errorMessage = new String("");
        XMLTree newDeduction = new XMLTree();
        try {
            newDeduction.readString(allText);
        }
        catch (XMLParseException e) {
            return e.getLocalizedMessage();
        }
        errorMessage = this.parseXML(newDeduction);
        if (errorMessage.length() > 0) {
            return errorMessage;
        }
        return "OK";
    }

    public void setGoals(ArrayList<Goal> newGoals) {
        if (newGoals.size() > 0) {
            this.resetSearch();
            this.removeAllNodes();
            this.pr.setGoals(newGoals);
            this.setStartGoals(newGoals);
        }
    }

    public boolean setGoals(String goalString) {
        if (goalString.trim().equals("")) {
            return true;
        }
        StringTokenizer tok = new StringTokenizer(goalString, "&");
        ArrayList<Goal> newGoals = new ArrayList<Goal>();
        while (tok.hasMoreTokens()) {
            Goal g = this.parseGoal(tok.nextToken().trim());
            if (g == null) {
                return false;
            }
            newGoals.add(g);
        }
        this.setGoals(newGoals);
        return true;
    }

    protected void setStartGoals(ArrayList<Goal> newGoals) {
        this.nodesAtDepth = new int[this.maxDepth];
        this.nodesAtDepth[0] = 1;
        Program p = new Program();
        ArrayList<Term> theVars = p.getUniqueVariables(newGoals);
        Term[] theTerms = new Term[theVars.size()];
        int i = 0;
        while (i < theVars.size()) {
            theTerms[i] = theVars.get(i);
            ++i;
        }
        this.startNode = new DeductionNode(this, newGoals, this.nodeDetail, new Goal("yes", theTerms));
        this.startNode.pos = new Point(0.0f, -200.0f);
        this.addNode(this.startNode);
        this.startNode.setNodeAppearance(1);
        this.startNode.setNodeType(1);
        this.startNode.setDepth(0);
        this.curDepth = 0;
        this.updateNodeSize(this.startNode);
        this.setNodeDetail(this.nodeDetail);
        this.repaint();
        ((DeductionCanvas)this.canvas).enableSearch();
    }

    protected void setProofGoals(ArrayList<Goal> newGoals) {
        this.nodesAtDepth = new int[this.maxDepth];
        this.nodesAtDepth[0] = 1;
        this.startNode = new DeductionNode(this, newGoals);
        this.startNode.pos = new Point(0.0f, -200.0f);
        this.addNode(this.startNode);
        this.startNode.setNodeAppearance(1);
        this.startNode.setNodeType(1);
        this.startNode.setDepth(0);
        this.curDepth = 0;
        this.updateNodeSize(this.startNode);
        this.setNodeDetail(42);
        this.repaint();
    }

    private void removeAllNodes() {
        this.curDepth = 0;
        this.nodesAtDepth = new int[this.maxDepth];
        this.highlightedEnt = null;
        this.clearGraph();
        this.repaint();
        this.pr.reset();
    }

    private void removeNodes(ArrayList<DeductionNode> toRemove) {
        this.highlightedEnt = null;
        int i = 0;
        while (i < toRemove.size()) {
            DeductionNode node = toRemove.get(i);
            int n = node.getDepth();
            this.nodesAtDepth[n] = this.nodesAtDepth[n] - 1;
            ArrayList<Edge> out = node.getEdgesOut();
            int j = 0;
            while (j < out.size()) {
                if (this.edges.contains(out.get(j))) {
                    this.edges.remove(out.get(j));
                }
                ++j;
            }
            this.removeNode(node);
            ++i;
        }
        this.repaint();
    }

    public ArrayList getRulesFor(Goal g) {
        return this.pr.getRules(g, !this.pruneRules);
    }

    public boolean predicateExists(Predicate p) {
        return p.builtIn() || this.pr.predContains(p.getName(), p.getArity()) != null;
    }

    public void expandNode(DeductionNode node, Goal g) {
        node.setIsHidden(false);
        if (node != this.startNode) {
            node.getEdgeIn().setHidden(false, this.edgeDetail);
        }
        if (node.getDepth() >= this.maxDepth) {
            return;
        }
        ArrayList rules = this.pr.getRules(g, true);
        if (g.getPredicate().builtIn() || g.neg) {
            this.applyRule(null, g, node);
        }
        int i = 0;
        while (i < rules.size()) {
            this.applyRule((Rule)rules.get(i), g, node);
            ++i;
        }
        if (node.neighbours.size() == 0) {
            this.createFailureNode(node);
        }
    }

    public void createFailureNode(DeductionNode node) {
        Point p1;
        if (node.neighbours.size() != 0) {
            return;
        }
        DeductionNode failed = new DeductionNode(this, new ArrayList<Goal>(), this.nodeDetail, node.getYesClause());
        failed.setNodeType(7);
        failed.setNodeAppearance(7);
        failed.setParent(node);
        this.addNode(failed);
        failed.setLabel(this.nodeDetail);
        failed.setDepth(node.getDepth() + 1);
        if (failed.getDepth() > this.curDepth) {
            this.curDepth = failed.getDepth();
        }
        Point p = node.pos;
        failed.pos = p1 = new Point(p.x, p.y + 70.0f);
        DeductionEdge newEdge = new DeductionEdge(this, (Node)node, (Node)failed);
        newEdge.setSubs(new ArrayList<Substitution>(), new ArrayList<Substitution>(), this.edgeDetail);
        this.addEdge(newEdge);
        this.repaint();
    }

    /*
     * Unable to fully structure code
     */
    public void applyRule(Rule r, Goal g, DeductionNode node) {
        this.setPromptLabel("");
        newGoals = new ArrayList<E>();
        if (node.getGoalChosen() != null && g != node.getGoalChosen()) {
            node.setGoalChosen(g);
            toRemove = node.getAllDescendents();
            this.removeNodes(toRemove);
            out = node.getEdgesOut();
            j = 0;
            while (j < out.size()) {
                if (this.edges.contains(out.get(j))) {
                    this.edges.remove(out.get(j));
                }
                ++j;
            }
            node.reset();
        } else {
            node.setGoalChosen(g);
        }
        if (!g.neg) ** GOTO lbl32
        v = new ArrayList<Goal>(1);
        v.add(g);
        if (this.pr.finiteFailure(g, v, this.maxDepth)) {
            newGoals = new ArrayList<Goal>(node.getGoals());
            newGoals.remove(g);
        } else {
            if (this.search == null) {
                this.setPromptSticky(true);
                this.setPromptLabel("Negation as failure failed.");
                this.createFailureNode(node);
            }
            return;
lbl32:
            // 1 sources

            newGoals = g.getPredicate().builtIn() != false ? this.pr.solveGoal(g, node.getGoals()) : this.pr.applyRule(r, g, node.getGoals());
        }
        if (newGoals == null) {
            if (this.search == null) {
                this.setPromptSticky(true);
                this.setPromptLabel("Unification failed.");
                if (g.getPredicate().builtIn() || this.pr.getRules(g, this.pruneRules == false).size() == 0) {
                    this.createFailureNode(node);
                }
            }
            return;
        }
        newNode = new DeductionNode(this, newGoals, this.nodeDetail, node.getYesClause().fixTerms2());
        newNode.setDepth(node.getDepth() + 1);
        if (newNode.getDepth() > this.curDepth) {
            this.curDepth = newNode.getDepth();
            if (newNode.getDepth() >= this.nodesAtDepth.length) {
                this.growNodesAtDepth();
            }
        }
        v0 = newNode.getDepth();
        this.nodesAtDepth[v0] = this.nodesAtDepth[v0] + 1;
        p = node.pos;
        newNode.pos = p1 = new Point(p.x, p.y + 70.0f);
        newNode.setDerivedFrom(g.derivedFrom);
        newNode.setDerivedFromGoal(g);
        if (newGoals.size() > 0) {
            newNode.setNodeAppearance(0);
            newNode.setNodeType(0);
        } else {
            newNode.setNodeAppearance(2);
            newNode.setNodeType(2);
            this.goalNodeIndex.add(new Integer(this.getNextIndex()));
            this.highlightedEnt = newNode;
        }
        newEdge = new DeductionEdge(this, (Node)node, (Node)newNode);
        newNode.setParent(node);
        if (this.canvas instanceof InlineCanvas) {
            node.adjustChildren(false);
        } else {
            node.adjustChildren();
        }
        this.addNode(newNode);
        this.addEdge(newEdge);
        newEdge.setSubs(g.substitutions, g.extraSubs, this.edgeDetail);
        newNode.setLabel(this.nodeDetail);
        this.updateNodeSize(newNode);
        this.repaint();
    }

    protected void applyProofRule(Rule r, Goal g, DeductionNode node, ArrayList frontier, ArrayList subs) {
        ArrayList newGoals = this.pr.applyRuleShort(r, g, subs);
        if (newGoals == null) {
            return;
        }
        int index = frontier.indexOf(node);
        frontier.remove(node);
        int i = 0;
        while (i < newGoals.size()) {
            Goal g1 = (Goal)newGoals.get(i);
            ArrayList<Goal> goalList = new ArrayList<Goal>(1);
            goalList.add(g1.applySubs2(subs));
            DeductionNode newNode = new DeductionNode(this, goalList);
            Point p = node.pos;
            Point p1 = new Point(p.x, p.y + 60.0f);
            newNode.setDepth(node.getDepth() + 1);
            if (newNode.getDepth() > this.curDepth) {
                this.curDepth = newNode.getDepth();
                if (newNode.getDepth() > this.nodesAtDepth.length) {
                    this.growNodesAtDepth();
                }
            }
            int n = newNode.getDepth();
            this.nodesAtDepth[n] = this.nodesAtDepth[n] + 1;
            newNode.pos = p1;
            newNode.setDerivedFrom(g.derivedFrom);
            newNode.setDerivedFromGoal(g);
            if (newNode.getLabel().equals(node.getLabel())) {
                newNode.setNodeAppearance(3);
            } else {
                newNode.setNodeAppearance(0);
            }
            newNode.setNodeType(0);
            DeductionEdge newEdge = new DeductionEdge(this, (Node)node, (Node)newNode);
            newNode.setParent(node);
            node.adjustChildren(false);
            this.addNode(newNode);
            this.addEdge(newEdge);
            this.updateNodeSize(newNode);
            ArrayList<DeductionNode> nodeList = new ArrayList<DeductionNode>(1);
            nodeList.add(newNode);
            Program prog = new Program();
            prog.insertAt(frontier, nodeList, index++);
            this.repaint();
            ++i;
        }
    }

    protected ArrayList getSubstitutions(DeductionNode endNode) {
        ArrayList subs = new ArrayList();
        DeductionEdge e = endNode.getEdgeIn();
        DeductionNode next = endNode;
        Program p = new Program();
        while (next != this.startNode) {
            p.append(subs, e.getSubstitutions());
            next = next.getParent();
            e = next.getEdgeIn();
        }
        return subs;
    }

    protected ArrayList<Rule> getRuleOrder(DeductionNode endNode, ArrayList<Integer> goals, ArrayList<Substitution> subs) {
        DeductionEdge e = endNode.getEdgeIn();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Integer> goals2 = new ArrayList<Integer>();
        DeductionNode next = endNode;
        Program p = new Program();
        while (next != this.startNode) {
            p.append(subs, e.getSubstitutions());
            rules.add(next.getDerivedFrom());
            goals2.add(new Integer(next.getParent().getGoals().indexOf(next.getDerivedFromGoal())));
            next = next.getParent();
            e = next.getEdgeIn();
        }
        ArrayList<Rule> rules2 = new ArrayList<Rule>(rules.size());
        int i = rules.size() - 1;
        while (i >= 0) {
            rules2.add((Rule)rules.get(i));
            goals.add((Integer)goals2.get(i));
            --i;
        }
        this.fixSubs(subs);
        return rules2;
    }

    protected void fixSubs(ArrayList<Substitution> subs) {
        int i = 0;
        while (i < subs.size()) {
            Substitution s = subs.get(i);
            if (s.second.getType() != 1) {
                Term t = s.second.applySubs(subs, true);
                subs.set(i, new Substitution(s.first, t));
            }
            ++i;
        }
    }

    public void buildProofDeduction(DeductionNode endNode, DeductionGraph oldGraph) {
        ArrayList<Substitution> subs = new ArrayList<Substitution>();
        ArrayList<Integer> goalOrder = new ArrayList<Integer>();
        ArrayList<Rule> ruleOrder = oldGraph.getRuleOrder(endNode, goalOrder, subs);
        ArrayList<Goal> oldGoals = oldGraph.startNode.getGoals();
        ArrayList<Goal> newGoals = new ArrayList<Goal>(oldGoals.size());
        Program prog = new Program();
        ArrayList<Term> allVars = prog.getUniqueVariables(oldGoals);
        int i = 0;
        while (i < allVars.size()) {
            Term t = allVars.get(i);
            Term t1 = t.applySubs(subs, false);
            if (t1 != t) {
                t.setUnifiedWith(t1);
            } else {
                t.clearUnified();
            }
            ++i;
        }
        i = 0;
        while (i < oldGoals.size()) {
            newGoals.add(oldGoals.get(i).fixTerms2());
            ++i;
        }
        this.setProofGoals(newGoals);
        ArrayList<DeductionNode> frontier = new ArrayList<DeductionNode>(newGoals.size());
        if (this.startNode.getGoals().size() > 1) {
            int i2 = 0;
            while (i2 < this.startNode.getGoals().size()) {
                Point p1;
                Goal g = this.startNode.getGoals().get(i2);
                ArrayList<Goal> v = new ArrayList<Goal>(1);
                v.add(g);
                DeductionNode newNode = new DeductionNode(this, v);
                Point p = this.startNode.pos;
                newNode.pos = p1 = new Point(p.x, p.y + 60.0f);
                newNode.setNodeAppearance(0);
                newNode.setNodeType(0);
                DeductionEdge newEdge = new DeductionEdge(this, (Node)this.startNode, (Node)newNode);
                newNode.setParent(this.startNode);
                this.startNode.adjustChildren(false);
                this.addNode(newNode);
                this.addEdge(newEdge);
                this.updateNodeSize(newNode);
                frontier.add(newNode);
                ++i2;
            }
        } else {
            frontier.add(this.startNode);
        }
        int i3 = 0;
        while (i3 < goalOrder.size()) {
            DeductionNode node = (DeductionNode)frontier.get(goalOrder.get(i3));
            Goal g = node.getGoals().get(0);
            if (!g.getPredicate().builtIn() && !g.neg) {
                this.applyProofRule(ruleOrder.get(i3), g, node, frontier, subs);
            } else {
                frontier.remove(node);
            }
            ++i3;
        }
    }

    public String generateTextRep() {
        Calendar now = Calendar.getInstance();
        StringBuffer outBuffer = new StringBuffer("% Auto-generated on ");
        outBuffer.append(now.getTime()).append("\n\n %Nodes\n");
        outBuffer.append("% N: index, node_name, x_position, y_position, node_type, node_heuristics;\n");
        int i = 0;
        while (i < this.numNodes()) {
            DeductionNode curNode = (DeductionNode)this.nodeAt(i);
            outBuffer.append("N: ").append(curNode.index);
            if (curNode.getNodeType() == 0) {
                outBuffer.append(", N").append(curNode.index);
                outBuffer.append(", ").append(curNode.pos.x).append(", ").append(curNode.pos.y).append(", REGULAR, 0.0;\n");
            } else if (curNode.getNodeType() == 1) {
                outBuffer.append(", S");
                outBuffer.append(", ").append(curNode.pos.x).append(", ").append(curNode.pos.y).append(", START, 0.0;\n");
            } else {
                outBuffer.append(", G");
                outBuffer.append(", ").append(curNode.pos.x).append(", ").append(curNode.pos.y).append(", GOAL, 0.0;\n");
            }
            ++i;
        }
        outBuffer.append("\n%Edges\n");
        outBuffer.append("% E: from_node_index, to_node_index, edge_cost;\n");
        int i2 = 0;
        while (i2 < this.numEdges()) {
            DeductionEdge curEdge = (DeductionEdge)this.edgeAt(i2);
            outBuffer.append("E: ").append(curEdge.start.index).append(", ").append(curEdge.end.index).append(", 0.0;\n");
            ++i2;
        }
        outBuffer.append("\n%Miscellaneous\n%M: predicate_name, value;\n");
        outBuffer.append("M: HEURISTICS, AUTOMATIC;\nM: COSTS, AUTOMATIC;\n");
        return outBuffer.toString();
    }

    public String generateCilogText() {
        return this.pr.textRep();
    }

    public void spreadDeduction() {
        if (this.startNode == null) {
            return;
        }
        this.startNode.adjustChildren();
    }

    private void growNodesAtDepth() {
        int[] newArray = new int[this.nodesAtDepth.length * 2];
        int i = 0;
        while (i < this.nodesAtDepth.length) {
            newArray[i] = this.nodesAtDepth[i];
            ++i;
        }
        newArray[this.nodesAtDepth.length] = 1;
        this.nodesAtDepth = newArray;
    }
}

