/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction;

import AIspace.deduction.DeductionCanvas;
import AIspace.deduction.DeductionGraph;
import AIspace.deduction.SolveUndo;
import AIspace.deduction.dialogs.DeductionDescriptionDialog;
import AIspace.deduction.dialogs.ShowResultDialog;
import AIspace.deduction.help.DeductionHelpCanvas;
import AIspace.deduction.searchTypes.Search;
import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.GraphWindow;
import AIspace.graphToolKit.help.HelpFrame;
import AIspace.graphToolKit.help.HelpMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

public class DeductionWindow
extends GraphWindow
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private JMenuItem print;
    private JMenuItem textRepItem;
    private JMenuItem searchOptions;
    private JMenu speed;
    private JButton fakeButton;
    private JCheckBoxMenuItem noNodeDetail;
    private SolveUndo programUndo;
    private JTextArea ta;
    private JScrollPane programScroll;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    private JMenuItem descriptionMenuItem;
    private String extension;
    private JTextArea program;
    private int searchAlgorithm;
    private JCheckBoxMenuItem viewKBCheckBox;
    private JCheckBoxMenuItem pruneRules;
    private JMenu algoMenu;
    private JMenu nodeDetailMenu;
    private JRadioButtonMenuItem lowNodeDetail;
    private JRadioButtonMenuItem medNodeDetail;
    private JRadioButtonMenuItem highNodeDetail;
    private JMenu edgeDetailMenu;
    private JRadioButtonMenuItem lowEdgeDetail;
    private JRadioButtonMenuItem medEdgeDetail;
    private JCheckBoxMenuItem occursCheck;
    private JRadioButtonMenuItem showFullSubs;
    private ShowResultDialog srd;
    private boolean modified;
    private final int NUMBUTTONS = 10;
    private boolean promptSticky;
    private ImageIcon stepIcon;
    private ImageIcon fineStepIcon;
    private ImageIcon autoSearchIcon;
    private ImageIcon stopIcon;
    private ImageIcon resetIcon;
    private ImageIcon moveSubtreeIcon;
    private ImageIcon inspectSubtreeIcon;
    private ImageIcon inspectNodeIcon;
    private ImageIcon createNewQueryIcon;

    public DeductionWindow(JApplet parent) {
        super(parent);
        this.initializeAppletInfo();
        this.setSize(850, 700);
        this.modified = true;
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.pl");
        this.stepIcon = DeductionWindow.createImageIcon("images/deduction/step.png");
        this.fineStepIcon = DeductionWindow.createImageIcon("images/common/finestep.png");
        this.autoSearchIcon = DeductionWindow.createImageIcon("images/deduction/gear.png");
        this.stopIcon = DeductionWindow.createImageIcon("images/deduction/stop.gif");
        this.resetIcon = DeductionWindow.createImageIcon("images/deduction/Reset.gif");
        this.createNewQueryIcon = DeductionWindow.createImageIcon("images/deduction/createNewQuery.png");
        this.inspectNodeIcon = DeductionWindow.createImageIcon("images/deduction/inspectNode.png");
        this.inspectSubtreeIcon = DeductionWindow.createImageIcon("images/deduction/inspectSubtree.png");
        this.moveSubtreeIcon = DeductionWindow.createImageIcon("images/deduction/movesubtree.png");
        this.program = new JTextArea("");
        this.program.setBackground(Color.white);
        this.program.setForeground(GraphConsts.fg);
        this.program.setText("% file: untitled.pl\n\n");
        this.program.setEditable(true);
        this.program.addKeyListener(this);
        this.programUndo = new SolveUndo(this, this.program);
        this.program.addKeyListener(this.programUndo);
        this.program.addMouseListener(this.programUndo);
        this.program.addCaretListener(this.programUndo);
        this.programScroll = new JScrollPane(this.program);
        this.programScroll.setPreferredSize(new Dimension(100, 100));
        this.canvasPanel.remove(this.scrollPanel);
        this.addComponent(this.programScroll, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        this.toolBar.setVisible(true);
        this.solveToolBarWithText();
        this.enableToolBarButtons(false);
        this.undoItem.setEnabled(false);
        this.redoItem.setEnabled(false);
        this.tabbedPane.setSelectedIndex(0);
        this.enableMenuItems(false);
        this.print.setEnabled(false);
        this.ta = new JTextArea("");
        this.ta.setBorder(BorderFactory.createTitledBorder("Knowledge Base"));
        this.ta.setLayout(new BorderLayout());
        this.ta.setEditable(false);
        this.ta.setVisible(false);
        this.ta.setBackground(Color.white);
        JScrollPane KBpane = new JScrollPane(this.ta);
        KBpane.setPreferredSize(new Dimension(this.getWidth(), 150));
        KBpane.setMinimumSize(new Dimension(this.getWidth(), 150));
        this.bottomPanel.add((Component)KBpane, "Center");
        this.extension = ".pl";
        this.searchAlgorithm = 201;
        ((DeductionCanvas)this.canvas).setSearchMethod(this.searchAlgorithm);
        this.setPromptSticky(true);
        this.setPromptLabel("Enter the program in the text area provided or load an existing one.");
        this.algoText.setText("");
        this.bottomPanel.setVisible(false);
        this.centerWindow();
        this.setVisible(true);
    }

    private void initializeAppletInfo() {
        appletTitle = "Definite Clause Deduction Tool Version 4.2.8";
        appletName = "deduction";
        aboutText = String.valueOf(appletTitle) + "\n\n" + "Every representation and reasoning system needs a proof procedure in\n" + "order to be complete. The purpose of this tool is to illustrate how the\n" + "process of answer extraction within a knowledge base can be cast as a\n" + "search problem. The deduction tool uses a language similar to Prolog\n" + "and demonstrates its goal solving procedures.\n\n" + "This tool was written by Kevin O'Neill, Shinjiro Sueda, Audrey Yap,\n" + "Nicole Arksey, Regan Yuen, Kyle Porter, Byron Knoll, Janine Li, and \n" + "Andre Gagne with help from Wesley Coelho, Joseph Roy Santos, \n" + "Holger Hoos, Peter Gorniak, Alan Mackworth, David Poole, Mike Pavlin, \n" + "and Cristina Conati.\n";
    }

    @Override
    public void solveToolBarWithText() {
        this.solveButModes = new JToggleButton[10];
        this.setSolveButtonsWithText(0, "Create New Query", this.createNewQueryIcon, "Create New Query");
        this.setSolveButtonsWithText(1, " Fine Step ", this.fineStepIcon, "Fine Step");
        this.setSolveButtonsWithText(2, "    Step    ", this.stepIcon, "Step");
        this.setSolveButtonsWithText(3, " Auto Search  ", this.autoSearchIcon, " Auto Search");
        this.setSolveButtonsWithText(4, " Stop Search ", this.stopIcon, "Stop Search");
        this.setSolveButtonsWithText(5, " Reset Query ", this.resetIcon, "Reset Query");
        this.setSolveButtonsWithText(6, " Select Node ", this.selectIcon, "Select Node");
        this.setSolveButtonsWithText(7, " Inspect Node ", this.inspectNodeIcon, "Inspect Node");
        this.setSolveButtonsWithText(8, " Move Subtree ", this.moveSubtreeIcon, "Move Subtree");
        this.setSolveButtonsWithText(9, "View Proof Deduction ", this.inspectSubtreeIcon, "View Proof Deduction");
        this.isButtonTextShowing = false;
        this.solveToolBarLayout();
    }

    @Override
    public void solveToolBar() {
        this.solveButModes = new JToggleButton[10];
        this.setSolveButtons(0, this.createNewQueryIcon, "Create New Query");
        this.setSolveButtons(1, this.stepIcon, "Step");
        this.setSolveButtons(2, this.fineStepIcon, "Fine Step");
        this.setSolveButtons(3, this.autoSearchIcon, "  Auto Search");
        this.setSolveButtons(4, this.stopIcon, "Stop Search");
        this.setSolveButtons(5, this.resetIcon, "Reset Query");
        this.setSolveButtons(6, this.selectIcon, "Select Node");
        this.setSolveButtons(7, this.inspectNodeIcon, "Inspect Node");
        this.setSolveButtons(8, this.moveSubtreeIcon, "Move Subtree");
        this.setSolveButtons(9, this.inspectSubtreeIcon, "View Proof Deduction");
        this.isButtonTextShowing = true;
        this.solveToolBarLayout();
    }

    private void solveToolBarLayout() {
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        this.fakeButton = new JButton();
        this.solveModeButGroup.add(this.fakeButton);
        this.fakeButton.setVisible(false);
        int i = 0;
        while (i < 10) {
            this.solveModeButGroup.add(this.solveButModes[i]);
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolBarFont);
            if (i == 6) {
                this.toolBar.addSeparator();
            }
            ++i;
        }
        this.toolBar.addSeparator();
        ButtonGroup solveModesGroup = new ButtonGroup();
        int i2 = 6;
        while (i2 < 10) {
            solveModesGroup.add(this.solveButModes[i2]);
            this.toolBar.add(this.solveButModes[i2]);
            this.solveButModes[i2].setFont(this.toolBarFont);
            ++i2;
        }
        this.algoText.setFont(new Font("arial", 1, 12));
        this.algoText.setText("Algorithm Selected: " + this.getAlgorithmName());
        this.algoText.setVisible(true);
        this.repaint();
    }

    @Override
    protected void getCanvas() {
        this.canvas = new DeductionCanvas(this, false);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.scrollPanel = new JScrollPane(this.canvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7500);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    public void centerCanvas() {
        this.scrollPanel.getHorizontalScrollBar().setValue(this.scrollPanel.getWidth() / 2);
        this.scrollPanel.getVerticalScrollBar().setValue(this.scrollPanel.getHeight() / 2);
    }

    @Override
    public void switchTab(String str) {
        if (str == "Create") {
            this.modified = false;
            this.setPromptLabel("Enter/edit the program in the text area below or load an existing one.");
            this.bottomPanel.setVisible(false);
            this.enableMenuItems(false);
            this.print.setEnabled(false);
            this.enableToolBarButtons(false);
            this.validate();
            this.canvas.setMode(2220);
            this.canvasPanel.remove(this.scrollPanel);
            this.addComponent(this.programScroll, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
            this.undoItem.setEnabled(this.programUndo.checkEnableUndo());
            this.redoItem.setEnabled(this.programUndo.checkEnableRedo());
            this.descriptionMenuItem.setText("View/Edit Knowledge Base Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            this.tabbedPane.setComponentAt(1, this.emptyPanel2);
            this.tabbedPane.setComponentAt(0, this.canvasPanel);
            this.tabbedPane.setSelectedIndex(0);
            this.program.setVisible(true);
            this.program.setCaretPosition(this.program.getText().length());
            this.bottomPanel.setVisible(false);
        } else if (str == "Solve") {
            this.setPromptLabel("");
            this.algoText.setText("Algorithm selected: " + this.getAlgorithmName());
            this.canvas.setSubmode(3332);
            this.solveButModes[6].setSelected(true);
            this.setPromptLabel("Click the 'Create New Query' button to create a query.");
            this.enableToolBarButtons(true);
            this.enableMenuItems(true);
            this.solveButModes[4].setEnabled(false);
            this.canvas.setMode(2221);
            this.undoItem.setEnabled(false);
            this.redoItem.setEnabled(false);
            this.descriptionMenuItem.setText("View Knowledge Base Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            this.canvasPanel.remove(this.programScroll);
            this.addComponent(this.scrollPanel, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
            this.tabbedPane.setComponentAt(0, this.emptyPanel1);
            this.tabbedPane.setComponentAt(1, this.canvasPanel);
            this.tabbedPane.setSelectedIndex(1);
            this.bottomPanel.setVisible(true);
            this.tabandbottom.setDividerLocation(0.8);
            this.validate();
            this.print.setEnabled(true);
            if (this.viewKBCheckBox.getState()) {
                this.tabandbottom.setDividerLocation(0.8);
                this.bottomPanel.setVisible(true);
                this.ta.setVisible(true);
            } else {
                this.bottomPanel.setVisible(false);
            }
            String err = "OK";
            if (this.modified) {
                err = ((DeductionCanvas)this.canvas).parse(this.program.getText());
            }
            if (err.equals("OK")) {
                this.invalidate();
                this.program.setVisible(false);
                this.canvas.setVisible(true);
            }
            this.ta.setCaretPosition(0);
        }
        this.validate();
        this.repaint();
    }

    public void enableMenuItems(boolean isEnabled) {
        this.textRepItem.setEnabled(isEnabled);
        this.viewKBCheckBox.setEnabled(isEnabled);
        this.noNodeDetail.setEnabled(isEnabled);
        this.speed.setEnabled(isEnabled);
        this.edgeDetailMenu.setEnabled(isEnabled);
        this.nodeDetailMenu.setEnabled(isEnabled);
        this.pruneRules.setEnabled(isEnabled);
        this.occursCheck.setEnabled(isEnabled);
        this.searchOptions.setEnabled(isEnabled);
        this.algoMenu.setEnabled(isEnabled);
    }

    public void enableToolBarButtons(boolean isEnabled) {
        int n = 0;
        while (n < 10) {
            this.solveButModes[n].setEnabled(isEnabled);
            ++n;
        }
    }

    public void disableStopButton() {
        this.solveButModes[4].setEnabled(false);
    }

    @Override
    protected JMenu createFileMenu() {
        JMenu m = new JMenu("File");
        m.setMnemonic(70);
        JMenuItem mItem = new JMenuItem("Create New Knowledge Base");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(78);
        m.add(mItem);
        mItem = new JMenuItem("Load Sample Knowledge Base");
        mItem.addActionListener(this);
        mItem.setMnemonic(83);
        m.add(mItem);
        boolean hasLocalAccess = this.hasLocalAccess();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Load From File");
            mItem.setActionCommand(mItem.getText());
            mItem.setMnemonic(70);
            mItem.setDisplayedMnemonicIndex(10);
            mItem.addActionListener(this);
            m.add(mItem);
        }
        mItem = new JMenuItem("Load From URL");
        mItem.setMnemonic(85);
        mItem.addActionListener(this);
        m.add(mItem);
        m.addSeparator();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Save Knowledge Base");
            mItem.addActionListener(this);
            mItem.setMnemonic(83);
            m.add(mItem);
        }
        this.print = new JMenuItem("Print");
        this.print.setActionCommand(this.print.getText());
        this.print.addActionListener(this);
        this.print.setMnemonic(80);
        m.add(this.print);
        mItem = new JMenuItem("Quit");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(81);
        m.add(mItem);
        return m;
    }

    protected JMenu createEditMenu() {
        JMenu m = new JMenu("Edit");
        m.setMnemonic(69);
        this.undoItem = new JMenuItem("Undo");
        this.undoItem.setMnemonic(85);
        this.undoItem.addActionListener(this);
        m.add(this.undoItem);
        this.redoItem = new JMenuItem("Redo");
        this.redoItem.setMnemonic(82);
        this.redoItem.addActionListener(this);
        m.add(this.redoItem);
        m.addSeparator();
        JMenuItem mItem = new JMenuItem("View CILog Code");
        mItem.setMnemonic(67);
        mItem.addActionListener(this);
        m.add(mItem);
        this.textRepItem = new JMenuItem("View Proof Tree Text Representation");
        this.textRepItem.setMnemonic(84);
        this.textRepItem.addActionListener(this);
        m.add(this.textRepItem);
        mItem = new JMenuItem("View XML Representation");
        mItem.setMnemonic(88);
        mItem.addActionListener(this);
        m.add(mItem);
        this.descriptionMenuItem = new JMenuItem("View/Edit Knowledge Base Description");
        this.descriptionMenuItem.setMnemonic(68);
        this.descriptionMenuItem.setDisplayedMnemonicIndex(10);
        this.descriptionMenuItem.addActionListener(this);
        m.add(this.descriptionMenuItem);
        return m;
    }

    @Override
    protected JMenu createViewMenu() {
        JMenu m = super.createViewMenu();
        m.addSeparator();
        this.viewKBCheckBox = new JCheckBoxMenuItem("Show Knowledge Base", true);
        this.viewKBCheckBox.setMnemonic(75);
        this.viewKBCheckBox.addActionListener(this);
        m.add(this.viewKBCheckBox);
        this.noNodeDetail = new JCheckBoxMenuItem("Show Only Deduction's Structure", false);
        this.noNodeDetail.setMnemonic(68);
        this.noNodeDetail.addActionListener(this);
        m.add(this.noNodeDetail);
        m.addSeparator();
        ButtonGroup group = new ButtonGroup();
        this.edgeDetailMenu = new JMenu("Edge Label Detail");
        this.edgeDetailMenu.setMnemonic(69);
        this.lowEdgeDetail = new JRadioButtonMenuItem("No Details", false);
        this.lowEdgeDetail.addActionListener(this);
        group.add(this.lowEdgeDetail);
        this.edgeDetailMenu.add(this.lowEdgeDetail);
        this.medEdgeDetail = new JRadioButtonMenuItem("Placeholders", false);
        this.medEdgeDetail.addActionListener(this);
        this.edgeDetailMenu.add(this.medEdgeDetail);
        group.add(this.medEdgeDetail);
        m.add(this.edgeDetailMenu);
        this.showFullSubs = new JRadioButtonMenuItem("Show All Unifiers", true);
        this.showFullSubs.addActionListener(this);
        group.add(this.showFullSubs);
        this.edgeDetailMenu.add(this.showFullSubs);
        group = new ButtonGroup();
        this.nodeDetailMenu = new JMenu("Node Label Detail");
        this.nodeDetailMenu.setMnemonic(78);
        this.lowNodeDetail = new JRadioButtonMenuItem("Numbers", false);
        this.lowNodeDetail.addActionListener(this);
        group.add(this.lowNodeDetail);
        this.nodeDetailMenu.add(this.lowNodeDetail);
        this.medNodeDetail = new JRadioButtonMenuItem("Atoms", true);
        this.medNodeDetail.addActionListener(this);
        this.nodeDetailMenu.add(this.medNodeDetail);
        group.add(this.medNodeDetail);
        this.highNodeDetail = new JRadioButtonMenuItem("Yes Clauses", false);
        this.highNodeDetail.addActionListener(this);
        group.add(this.highNodeDetail);
        this.nodeDetailMenu.add(this.highNodeDetail);
        m.add(this.nodeDetailMenu);
        return m;
    }

    protected JMenu createDeductionOptionsMenu() {
        JMenu m = new JMenu("Deduction Options");
        m.setMnemonic(68);
        this.speed = new JMenu("Auto Step Speed");
        this.speed.setMnemonic(65);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem mCheckItem = new JRadioButtonMenuItem("Very Fast (0 s)", false);
        mCheckItem.addActionListener(this);
        this.speed.add(mCheckItem);
        group.add(mCheckItem);
        mCheckItem = new JRadioButtonMenuItem("Fast (0.1 s)", true);
        mCheckItem.addActionListener(this);
        this.speed.add(mCheckItem);
        group.add(mCheckItem);
        mCheckItem = new JRadioButtonMenuItem("Medium (0.5 s)", false);
        mCheckItem.addActionListener(this);
        this.speed.add(mCheckItem);
        group.add(mCheckItem);
        mCheckItem = new JRadioButtonMenuItem("Slow (1 s)", false);
        mCheckItem.addActionListener(this);
        this.speed.add(mCheckItem);
        group.add(mCheckItem);
        m.add(this.speed);
        m.addSeparator();
        this.pruneRules = new JCheckBoxMenuItem("Prune Irrelevant Clauses", true);
        this.pruneRules.setMnemonic(80);
        this.pruneRules.addActionListener(this);
        m.add(this.pruneRules);
        this.occursCheck = new JCheckBoxMenuItem("Do Occurs Check", true);
        this.occursCheck.setMnemonic(79);
        this.occursCheck.setDisplayedMnemonicIndex(3);
        this.occursCheck.addActionListener(this);
        m.add(this.occursCheck);
        m.addSeparator();
        this.searchOptions = new JMenuItem("Search Options");
        this.searchOptions.setMnemonic(83);
        this.searchOptions.addActionListener(this);
        m.add(this.searchOptions);
        ButtonGroup algorithmGroup = new ButtonGroup();
        this.algoMenu = new JMenu("Deduction Algorithms");
        this.algoMenu.setMnemonic(68);
        JRadioButtonMenuItem depthFirst = new JRadioButtonMenuItem("Depth First", true);
        depthFirst.addActionListener(this);
        algorithmGroup.add(depthFirst);
        this.algoMenu.add(depthFirst);
        JRadioButtonMenuItem breadthFirst = new JRadioButtonMenuItem("Breadth First");
        breadthFirst.addActionListener(this);
        algorithmGroup.add(breadthFirst);
        this.algoMenu.add(breadthFirst);
        JRadioButtonMenuItem bestFirst = new JRadioButtonMenuItem("Best First");
        bestFirst.addActionListener(this);
        algorithmGroup.add(bestFirst);
        this.algoMenu.add(bestFirst);
        JRadioButtonMenuItem heuristicDepthFirst = new JRadioButtonMenuItem("Heuristic Depth First");
        heuristicDepthFirst.addActionListener(this);
        algorithmGroup.add(heuristicDepthFirst);
        this.algoMenu.add(heuristicDepthFirst);
        JRadioButtonMenuItem userDefined = new JRadioButtonMenuItem("User Defined");
        userDefined.addActionListener(this);
        algorithmGroup.add(userDefined);
        this.algoMenu.add(userDefined);
        m.add(this.algoMenu);
        return m;
    }

    @Override
    protected JMenu createHelpMenu() {
        return new HelpMenu("deduction", this);
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = super.createMenuBar();
        menuBar.add((Component)this.createEditMenu(), 1);
        menuBar.add((Component)this.createDeductionOptionsMenu(), 3);
        return menuBar;
    }

    @Override
    protected void loadSampleGraph() {
        super.loadSampleGraph();
        this.noNodeDetail.setState(false);
    }

    @Override
    protected void openGraph() {
        super.openGraph();
        this.setPromptLabel("");
    }

    @Override
    protected void createNewGraph() {
        this.setPromptLabel("Enter the program in the text area provided or load an existing one.");
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.pl");
        this.program.setText("% file: untitled.pl\n\n");
        this.canvas.reset();
        this.ta.setText("");
    }

    @Override
    protected void openLocation() {
        super.openLocation();
        this.setPromptLabel("");
    }

    @Override
    protected void restoreProperties() {
        super.restoreProperties();
        this.setPromptLabel("Enter/edit the program in the text area below or load an existing one.");
    }

    public void setAutoSearchStopButton() {
        int i = 0;
        while (i < 4) {
            this.solveButModes[i].setEnabled(true);
            ++i;
        }
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
        ((DeductionCanvas)this.returnCanvas()).step.setEnabled(true);
        ((DeductionCanvas)this.returnCanvas()).fineStep.setEnabled(true);
    }

    public void setKB(String p) {
        this.ta.setText(p);
    }

    public void enableSearch() {
        boolean isUserDefined;
        boolean bl = isUserDefined = this.searchAlgorithm == 209;
        if (isUserDefined) {
            this.canvas.setSubmode(3340);
            this.setPromptSticky(true);
            this.setPromptLabel("Click the start node to begin.");
        }
        this.solveButModes[1].setEnabled(!isUserDefined);
        this.solveButModes[2].setEnabled(!isUserDefined);
        this.solveButModes[3].setEnabled(!isUserDefined);
        ((DeductionCanvas)this.returnCanvas()).step.setEnabled(!isUserDefined);
        ((DeductionCanvas)this.returnCanvas()).fineStep.setEnabled(!isUserDefined);
        ((DeductionCanvas)this.returnCanvas()).autoSearch.setEnabled(!isUserDefined);
    }

    public void resetSearch() {
        this.solveButModes[1].setEnabled(true);
        this.solveButModes[2].setEnabled(true);
        ((DeductionCanvas)this.returnCanvas()).step.setEnabled(true);
        ((DeductionCanvas)this.returnCanvas()).fineStep.setEnabled(true);
        ((DeductionCanvas)this.canvas).resetSearch();
        this.setPromptLabel("");
        if (this.searchAlgorithm == 209) {
            this.solveButModes[1].setEnabled(false);
            this.solveButModes[3].setEnabled(false);
            ((DeductionCanvas)this.returnCanvas()).fineStep.setEnabled(false);
            ((DeductionCanvas)this.returnCanvas()).autoSearch.setEnabled(false);
        } else {
            this.solveButModes[3].setEnabled(true);
            ((DeductionCanvas)this.returnCanvas()).autoSearch.setEnabled(true);
        }
    }

    public void setRedoItem(boolean enabled) {
        this.redoItem.setEnabled(enabled);
    }

    public void setUndoItem(boolean enabled) {
        this.undoItem.setEnabled(enabled);
    }

    @Override
    public void load(String dir, String fileName) {
        super.load(dir, fileName);
        this.program.setCaretPosition(0);
    }

    @Override
    public void load(BufferedReader in) {
        try {
            String line;
            StringBuffer allText = new StringBuffer();
            while ((line = in.readLine()) != null) {
                allText.append(line).append("\n");
            }
            in.close();
            this.canvas.reset();
            String errMsg = ((DeductionCanvas)this.canvas).parse(allText.toString());
            if (!errMsg.equals("OK")) {
                return;
            }
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
            this.program.setText(allText.toString());
            this.ta.setText(((DeductionGraph)this.canvas.graph).generateCilogText());
            this.ta.setCaretPosition(0);
        }
        catch (Exception e) {
            this.showMessage("Error", e.toString());
        }
    }

    @Override
    public void save(File file) {
        if (!file.getName().endsWith(this.extension)) {
            file = new File(String.valueOf(file.getAbsolutePath()) + this.extension);
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            out.println(this.program.getText());
            out.close();
            this.fileName = file.getName();
            if (file.getName() != "undo.xml") {
                this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    private void chooseAlgorithm(String arg) {
        if (arg.equals("Depth First")) {
            this.algoText.setText("Algorithm Selected: Depth First     ");
            this.searchAlgorithm = 201;
        } else if (arg.equals("Breadth First")) {
            this.algoText.setText("Algorithm Selected: Breadth First    ");
            this.searchAlgorithm = 202;
        } else if (arg.equals("User Defined")) {
            this.algoText.setText("Algorithm Selected: User Defined  ");
            this.searchAlgorithm = 209;
        } else if (arg.equals("Best First")) {
            this.algoText.setText("Algorithm Selected: Best First ");
            this.searchAlgorithm = 204;
        } else if (arg.equals("Heuristic Depth First")) {
            this.algoText.setText("Algorithm Selected: Heuristic Depth First ");
            this.searchAlgorithm = 205;
        }
        this.setPromptLabel("");
        ((DeductionCanvas)this.canvas).resetSearch();
        ((DeductionCanvas)this.canvas).setSearchMethod(this.searchAlgorithm);
        this.enableSearch();
    }

    private String getAlgorithmName() {
        switch (this.searchAlgorithm) {
            case 201: {
                return "Depth First";
            }
            case 202: {
                return "Breadth First";
            }
            case 204: {
                return "Best First";
            }
            case 205: {
                return "Heuristic Depth First";
            }
            case 209: {
                return "User Defined";
            }
        }
        return "No Algorithm Selected";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.canvas.pause) {
            return;
        }
        String arg = e.getActionCommand();
        if (arg.equals("Create New Knowledge Base")) {
            this.createNewGraph();
        } else if (arg.equals("Load Sample Knowledge Base")) {
            this.loadSampleGraph();
        } else if (arg.equals("Save Knowledge Base")) {
            this.saveGraph();
        } else {
            if (arg.equals("Step") || e.getSource().equals(this.solveButModes[2])) {
                this.step();
                return;
            }
            if (arg.equals("Fine Step") || e.getSource() == this.solveButModes[1]) {
                this.fineStep();
                return;
            }
            if (arg.equals("Auto Search") || e.getSource().equals(this.solveButModes[3])) {
                this.autoSearchAction();
                return;
            }
            if (arg.equals("Stop Search") || e.getSource().equals(this.solveButModes[4])) {
                this.stopSearch();
                return;
            }
            if (arg.equals("Reset Query") || e.getSource().equals(this.solveButModes[5])) {
                this.resetQuery();
                return;
            }
            if (arg.equals("Autoscale")) {
                this.canvas.autoscale();
                return;
            }
            if (arg.equals("Reset Edge Labels")) {
                this.canvas.resetLabels();
                return;
            }
            if (arg.equals("Print")) {
                this.returnCanvas().print();
                return;
            }
            if (arg.equals("Quit")) {
                this.setVisible(false);
                this.dispose();
                return;
            }
            if (arg.equals("Extra Large (30 pt)")) {
                this.program.setFont(new Font("arial", 0, 30));
                this.ta.setFont(new Font("arial", 0, 30));
            } else if (arg.equals("Large (20 pt)")) {
                this.program.setFont(new Font("arial", 0, 20));
                this.ta.setFont(new Font("arial", 0, 20));
            } else if (arg.equals("Medium (12 pt)")) {
                this.program.setFont(new Font("arial", 0, 12));
                this.ta.setFont(new Font("arial", 0, 12));
            } else if (arg.equals("Small (9 pt)")) {
                this.program.setFont(new Font("arial", 0, 9));
                this.ta.setFont(new Font("arial", 0, 9));
            } else if (arg.equals("Other...")) {
                this.program.setFont(new Font("arial", 0, this.returnCanvas().getFontSize()));
                this.ta.setFont(new Font("arial", 0, this.returnCanvas().getFontSize()));
            } else {
                if (arg.equals("View Proof Tree Text Representation")) {
                    ((DeductionCanvas)this.canvas).openTextRep();
                    return;
                }
                if (arg.equals("View XML Representation")) {
                    ((DeductionCanvas)this.canvas).openXMLTextRep();
                    return;
                }
                if (arg.equals("View CILog Code")) {
                    ((DeductionCanvas)this.canvas).openCilogTextRep();
                    return;
                }
                if (arg.equals("View/Edit Knowledge Base Description")) {
                    new DeductionDescriptionDialog((GraphWindow)this, (DeductionGraph)this.canvas.graph, true).open();
                } else if (arg.equals("View Knowledge Base Description")) {
                    new DeductionDescriptionDialog((GraphWindow)this, (DeductionGraph)this.canvas.graph, false).open();
                } else {
                    if (arg.equals("Show Button Text")) {
                        if (this.isButtonTextShowing) {
                            this.solveToolBarWithText();
                        } else {
                            this.solveToolBar();
                        }
                        if (this.returnCanvas().getMode() == 2220) {
                            int i = 0;
                            while (i < 10) {
                                this.solveButModes[i].setEnabled(false);
                                ++i;
                            }
                        }
                        return;
                    }
                    if (arg.equals("Search Options")) {
                        if (this.srd == null) {
                            this.srd = new ShowResultDialog(this);
                        }
                        this.srd.open();
                        return;
                    }
                    if (arg.equals("Create New Query") || e.getSource().equals(this.solveButModes[0])) {
                        ((DeductionCanvas)this.canvas).openSelectFrame();
                        this.setPromptLabel("");
                        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
                        this.centerCanvas();
                        return;
                    }
                    if (e.getSource().equals(this.viewKBCheckBox)) {
                        if (this.viewKBCheckBox.getState()) {
                            this.ta.setVisible(true);
                            this.bottomPanel.setVisible(true);
                            this.tabandbottom.setDividerLocation(0.8);
                            this.validate();
                            this.repaint();
                        } else {
                            this.bottomPanel.setVisible(false);
                        }
                        return;
                    }
                    if (arg.equals("Depth First") || arg.equals("Breadth First") || arg.equals("User Defined") || arg.equals("Best First") || arg.equals("Heuristic Depth First")) {
                        this.chooseAlgorithm(arg);
                        return;
                    }
                    if (arg.equals("Very Fast (0 s)")) {
                        Search.dt = 0;
                        return;
                    }
                    if (arg.equals("Fast (0.1 s)")) {
                        Search.dt = 100;
                        return;
                    }
                    if (arg.equals("Medium (0.5 s)")) {
                        Search.dt = 500;
                        return;
                    }
                    if (arg.equals("Slow (1 s)")) {
                        Search.dt = 1000;
                        return;
                    }
                    if (e.getSource().equals(this.noNodeDetail)) {
                        if (this.noNodeDetail.getState()) {
                            ((DeductionGraph)this.canvas.graph).setEdgeDetail(39);
                            ((DeductionGraph)this.canvas.graph).setNodeDetail(39);
                        } else {
                            if (this.lowEdgeDetail.isSelected()) {
                                ((DeductionGraph)this.canvas.graph).setEdgeDetail(39);
                            } else if (this.medEdgeDetail.isSelected()) {
                                ((DeductionGraph)this.canvas.graph).setEdgeDetail(42);
                            } else {
                                ((DeductionGraph)this.canvas.graph).setEdgeDetail(41);
                            }
                            if (this.lowNodeDetail.isSelected()) {
                                ((DeductionGraph)this.canvas.graph).setNodeDetail(40);
                            } else if (this.medNodeDetail.isSelected()) {
                                ((DeductionGraph)this.canvas.graph).setNodeDetail(42);
                            } else {
                                ((DeductionGraph)this.canvas.graph).setNodeDetail(41);
                            }
                        }
                        this.repaint();
                        return;
                    }
                    if (arg.equals("No Details") && e.getSource() == this.lowEdgeDetail) {
                        ((DeductionGraph)this.canvas.graph).setEdgeDetail(39);
                        return;
                    }
                    if (arg.equals("Placeholders")) {
                        ((DeductionGraph)this.canvas.graph).setEdgeDetail(42);
                        return;
                    }
                    if (arg.equals("Show All Unifiers")) {
                        ((DeductionGraph)this.canvas.graph).setEdgeDetail(41);
                        return;
                    }
                    if (arg.equals("Numbers") && e.getSource() == this.lowNodeDetail) {
                        if (!this.noNodeDetail.getState()) {
                            ((DeductionGraph)this.canvas.graph).setNodeDetail(40);
                        }
                        return;
                    }
                    if (arg.equals("Atoms")) {
                        if (!this.noNodeDetail.getState()) {
                            ((DeductionGraph)this.canvas.graph).setNodeDetail(42);
                        }
                        return;
                    }
                    if (arg.equals("Yes Clauses")) {
                        if (!this.noNodeDetail.getState()) {
                            ((DeductionGraph)this.canvas.graph).setNodeDetail(41);
                        }
                        return;
                    }
                    if (arg.equals("Prune Irrelevant Clauses")) {
                        ((DeductionGraph)this.canvas.graph).setPruneRules(this.pruneRules.getState());
                        return;
                    }
                    if (arg.equals("Do Occurs Check")) {
                        ((DeductionGraph)this.canvas.graph).setOccursCheck(this.occursCheck.getState());
                        return;
                    }
                    if (arg.equals("Inspect Node") || e.getSource().equals(this.solveButModes[7])) {
                        this.canvas.setSubmode(3336);
                        this.setPromptSticky(true);
                        this.setPromptLabel("Click on a node to ask how its atoms were obtained.");
                        return;
                    }
                    if (arg.equals("Legend for Nodes/Edges")) {
                        new HelpFrame("Legend", new DeductionHelpCanvas(this.isAntiAliasingEnabled()), 375, 500);
                        return;
                    }
                    if (arg.equals("Move Node") || e.getSource().equals(this.solveButModes[6])) {
                        this.canvas.setSubmode(3332);
                        this.setPromptSticky(true);
                        this.setPromptLabel("Click on an entity and drag the mouse to move it.");
                        return;
                    }
                    if (arg.equals("Move Subtree") || e.getSource().equals(this.solveButModes[8])) {
                        this.canvas.setSubmode(3338);
                        this.setPromptSticky(true);
                        this.setPromptLabel("Click on a node and drag it to move it and its descendents.");
                        return;
                    }
                    if (arg.equals("View Proof Deduction") || e.getSource().equals(this.solveButModes[9])) {
                        this.canvas.setSubmode(3337);
                        this.setPromptSticky(true);
                        this.setPromptLabel("Click on a node to view its proof tree.");
                        return;
                    }
                    if (arg.equals("Undo")) {
                        this.programUndo.loadUndo();
                    } else if (arg.equals("Redo")) {
                        this.programUndo.loadRedo();
                    }
                }
            }
        }
        super.actionPerformed(e);
    }

    public void resetQuery() {
        this.centerCanvas();
        this.stopSearch();
        int i = 0;
        while (i < 4) {
            this.solveButModes[i].setEnabled(true);
            ++i;
        }
        this.resetSearch();
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
        ((DeductionCanvas)this.returnCanvas()).step.setEnabled(true);
        ((DeductionCanvas)this.returnCanvas()).fineStep.setEnabled(true);
        this.setPromptLabel("Query reset.");
    }

    public void stopSearch() {
        ((DeductionGraph)this.canvas.graph).stopAutoSearch();
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
        int i = 1;
        while (i < 3) {
            this.solveButModes[i].setEnabled(true);
            ++i;
        }
        this.solveButModes[4].setEnabled(false);
        ((DeductionCanvas)this.returnCanvas()).step.setEnabled(true);
        ((DeductionCanvas)this.returnCanvas()).fineStep.setEnabled(true);
        ((DeductionCanvas)this.returnCanvas()).stopSearch.setEnabled(false);
        this.setPromptLabel("Auto search stopped.");
    }

    public void autoSearchAction() {
        int i = 1;
        while (i < 3) {
            this.solveButModes[i].setEnabled(false);
            ++i;
        }
        this.solveButModes[4].setEnabled(true);
        this.fakeButton.setSelected(true);
        ((DeductionCanvas)this.returnCanvas()).step.setEnabled(false);
        ((DeductionCanvas)this.returnCanvas()).fineStep.setEnabled(false);
        ((DeductionCanvas)this.returnCanvas()).stopSearch.setEnabled(true);
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
        ((DeductionCanvas)this.canvas).doSearch(this.searchAlgorithm, 101, false);
    }

    public void fineStep() {
        ((DeductionCanvas)this.canvas).doSearch(this.searchAlgorithm, 103, false);
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
    }

    public void step() {
        if (this.searchAlgorithm == 209) {
            this.canvas.setSubmode(3340);
            this.setPromptSticky(true);
            this.setPromptLabel("Click on a node to get a list of atoms and clauses to resolve them with.");
        } else {
            ((DeductionCanvas)this.canvas).doSearch(this.searchAlgorithm, 102, false);
        }
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
    }

    public void setPromptSticky(boolean value) {
        this.promptSticky = value;
    }

    public boolean isPromptSticky() {
        return this.promptSticky;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.canvas.getMode() != 2220) {
            return;
        }
        this.modified = true;
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public static void main(String[] args) {
        DeductionWindow window = new DeductionWindow(null);
        if (args.length > 0) {
            String url = args[0];
            try {
                window.fileName = url.substring(url.lastIndexOf("/") + 1);
                window.load(new BufferedReader(new InputStreamReader(new URL(url).openStream())));
            }
            catch (Exception exc) {
                window.showMessage("Error", exc.toString());
            }
        }
    }
}

