/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction;

import AIspace.deduction.DeductionCanvas;
import AIspace.deduction.DeductionGraph;
import AIspace.deduction.InlineCanvas;
import AIspace.deduction.help.DeductionHelpCanvas;
import AIspace.deduction.searchTypes.Search;
import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.InlineApplet;
import AIspace.graphToolKit.help.HelpFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class InlineDeductionApplet
extends InlineApplet {
    private static final long serialVersionUID = 1L;
    public JTextPane algorithmPane;
    private int searchAlgorithm = 201;
    public JTextArea knowledgeBaseTA;
    public JToggleButton fakeButton;
    public JToggleButton createNewQueryButton;
    public JToggleButton fineStepButton;
    public JToggleButton stepButton;
    public JToggleButton autoSearchButton;
    public JToggleButton stopSearchButton;
    public JToggleButton resetQueryButton;
    public JToggleButton selectNodeButton;
    public JToggleButton inspectNodeButton;
    public JToggleButton moveSubtreeButton;
    public JToggleButton viewProofDeductionButton;
    private boolean showKB = false;
    private boolean showAlgorithm = false;
    private boolean createNewQueryButtonOn = false;
    private boolean fineStepButtonOn = false;
    private boolean stepButtonOn = false;
    private boolean autoSearchButtonOn = false;
    private boolean stopSearchButtonOn = false;
    private boolean resetQueryButtonOn = false;
    private boolean selectNodeButtonOn = false;
    private boolean inspectNodeButtonOn = false;
    private boolean moveSubtreeButtonOn = false;
    private boolean viewProofDeductionButtonOn = false;
    public boolean createNewQueryPopupOn = false;
    public boolean fineStepPopupOn = false;
    public boolean stepPopupOn = false;
    public boolean autoSearchPopupOn = false;
    public boolean stopSearchPopupOn = false;
    public boolean resetQueryPopupOn = false;
    public boolean algorithmPopupOn = false;

    @Override
    public void init() {
        super.init();
        this.makeCanvas();
        this.knowledgeBaseTA = new JTextArea();
        this.knowledgeBaseTA.setEditable(false);
        this.knowledgeBaseTA.setBorder(BorderFactory.createTitledBorder("Knowledge Base"));
        this.knowledgeBaseTA.setBackground(Color.white);
        this.knowledgeBaseTA.setForeground(GraphConsts.fg);
        this.knowledgeBaseTA.setRows(2);
        this.knowledgeBaseTA.setText("CURRENT PATH:\n");
        JScrollPane taPanel = new JScrollPane(this.knowledgeBaseTA, 20, 31);
        this.loadParams();
        if (this.incorrectParameter) {
            return;
        }
        ((InlineCanvas)this.canvas).initializePopup();
        this.createToolBar();
        this.addComponent(this.messageCanvas, this.canvasPanel, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.canvas, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        this.canvas.setMinimumSize(new Dimension(10, 100));
        if (!this.showMessagePanel) {
            this.messageCanvas.setVisible(false);
        } else {
            this.messageCanvas.setMinimumSize(new Dimension(10, 50));
        }
        this.algorithmPane = new JTextPane();
        this.algorithmPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.algorithmPane.setEditable(false);
        this.algorithmPane.setMinimumSize(new Dimension(100, 17));
        this.updateAlgorithm();
        if (this.incorrectParameter) {
            return;
        }
        StyledDocument doc = this.algorithmPane.getStyledDocument();
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 1);
        StyleConstants.setFontFamily(standard, "arial");
        StyleConstants.setBold(standard, true);
        doc.setParagraphAttributes(0, 0, standard, true);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)taPanel, "Center");
        bottomPanel.add((Component)this.algorithmPane, "South");
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(this.canvasPanel);
        this.canvasPanel.addComponentListener(this);
        splitPane.setBottomComponent(bottomPanel);
        if (!this.showKB) {
            taPanel.setVisible(false);
            splitPane.setDividerSize(0);
            splitPane.setResizeWeight(1.0);
            splitPane.setEnabled(false);
        } else {
            splitPane.setOneTouchExpandable(true);
            splitPane.setResizeWeight(0.8);
        }
        if (!this.showAlgorithm) {
            this.algorithmPane.setVisible(false);
        }
        if (this.showButtons) {
            splitPane.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 75));
        } else {
            splitPane.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 10));
            this.toolBarPanel.setVisible(false);
        }
        this.algorithmPane.setBorder(null);
        if (this.showBorder) {
            this.canvas.setBorder(BorderFactory.createLineBorder(Color.black));
            splitPane.setBorder(BorderFactory.createLineBorder(Color.black));
            taPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        } else {
            this.canvas.setBorder(null);
            splitPane.setBorder(null);
            taPanel.setBorder(null);
        }
        this.mainPanel.add((Component)splitPane, "Center");
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.setBorder(null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.setPromptLabel("Click the 'Create New Query' button to create a query.");
    }

    protected void makeCanvas() {
        this.canvas = new InlineCanvas(this);
        this.canvas.WIDTH = this.getSize().width;
        this.canvas.HEIGHT = this.getSize().height;
        this.canvas.setPreferredSize(new Dimension(this.canvas.WIDTH, this.canvas.HEIGHT));
        this.canvas.setMode(2221);
    }

    public void createToolBar() {
        this.toolBarPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttons = new JToggleButton[11];
        int index = 0;
        this.setSolveButtonsWithText(index, "Create New Query", InlineDeductionApplet.createImageIcon("images/deduction/createNewQuery.png"), "Create New Query");
        this.createNewQueryButton = this.buttons[index++];
        if (!this.createNewQueryButtonOn) {
            this.createNewQueryButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, " Fine Step ", InlineDeductionApplet.createImageIcon("images/common/finestep.png"), "Fine Step");
        this.fineStepButton = this.buttons[index++];
        if (!this.fineStepButtonOn) {
            this.fineStepButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Step    ", InlineDeductionApplet.createImageIcon("images/deduction/step.png"), "Step");
        this.stepButton = this.buttons[index++];
        if (!this.stepButtonOn) {
            this.stepButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Auto Search", InlineDeductionApplet.createImageIcon("images/deduction/gear.png"), "Auto Search");
        this.autoSearchButton = this.buttons[index++];
        if (!this.autoSearchButtonOn) {
            this.autoSearchButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Stop Search", InlineDeductionApplet.createImageIcon("images/deduction/stop.gif"), "Stop Search");
        this.stopSearchButton = this.buttons[index++];
        this.stopSearchButton.setEnabled(false);
        if (!this.stopSearchButtonOn) {
            this.stopSearchButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Reset Query", InlineDeductionApplet.createImageIcon("images/deduction/Reset.gif"), "Reset Query");
        this.resetQueryButton = this.buttons[index++];
        if (!this.resetQueryButtonOn) {
            this.resetQueryButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Select Node", InlineDeductionApplet.createImageIcon("images/deduction/select.png"), "Select Node");
        this.selectNodeButton = this.buttons[index++];
        this.selectNodeButton.setSelected(true);
        if (!this.selectNodeButtonOn) {
            this.selectNodeButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Inspect Node", InlineDeductionApplet.createImageIcon("images/deduction/inspectNode.png"), "Inspect Node");
        this.inspectNodeButton = this.buttons[index++];
        if (!this.inspectNodeButtonOn) {
            this.inspectNodeButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Move Subtree", InlineDeductionApplet.createImageIcon("images/deduction/movesubtree.png"), "Move Subtree");
        this.moveSubtreeButton = this.buttons[index++];
        if (!this.moveSubtreeButtonOn) {
            this.moveSubtreeButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "View Proof Deduction", InlineDeductionApplet.createImageIcon("images/deduction/inspectSubtree.png"), "View Proof Deduction");
        this.viewProofDeductionButton = this.buttons[index++];
        if (!this.viewProofDeductionButtonOn) {
            this.viewProofDeductionButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Fake", InlineDeductionApplet.createImageIcon("images/common/finestep.png"), "Fake");
        this.fakeButton = this.buttons[index++];
        ButtonGroup buttonGroup2 = new ButtonGroup();
        Font toolFont = new Font("arial", 0, 10);
        int i = 0;
        while (i < index) {
            if (this.buttons[i] != this.selectNodeButton && this.buttons[i] != this.inspectNodeButton && this.buttons[i] != this.moveSubtreeButton && this.buttons[i] != this.viewProofDeductionButton) {
                buttonGroup.add(this.buttons[i]);
                toolBar.add(this.buttons[i]);
                this.buttons[i].setFont(toolFont);
            } else {
                buttonGroup2.add(this.buttons[i]);
                toolBar.add(this.buttons[i]);
                this.buttons[i].setFont(toolFont);
            }
            ++i;
        }
        this.buttons[index - 1].setVisible(false);
        this.toolBarPanel.add((Component)toolBar, "Center");
        this.mainPanel.add((Component)this.toolBarPanel, "North");
    }

    @Override
    protected void loadParams() {
        super.loadParams();
        String param = this.getParameter("createNewQueryButton");
        if (param != null) {
            if (param.equals("on")) {
                this.createNewQueryButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("createNewQueryButton", param);
            }
        }
        if ((param = this.getParameter("fineStepButton")) != null) {
            if (param.equals("on")) {
                this.fineStepButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("fineStepButton", param);
            }
        }
        if ((param = this.getParameter("stepButton")) != null) {
            if (param.equals("on")) {
                this.stepButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepButton", param);
            }
        }
        if ((param = this.getParameter("autoSearchButton")) != null) {
            if (param.equals("on")) {
                this.autoSearchButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoSearchButton", param);
            }
        }
        if ((param = this.getParameter("stopSearchButton")) != null) {
            if (param.equals("on")) {
                this.stopSearchButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopSearchButton", param);
            }
        }
        if ((param = this.getParameter("resetQueryButton")) != null) {
            if (param.equals("on")) {
                this.resetQueryButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("resetQueryButton", param);
            }
        }
        if ((param = this.getParameter("selectNodeButton")) != null) {
            if (param.equals("on")) {
                this.selectNodeButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("selectNodeButton", param);
            }
        }
        if ((param = this.getParameter("inspectNodeButton")) != null) {
            if (param.equals("on")) {
                this.inspectNodeButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("inspectNodeButton", param);
            }
        }
        if ((param = this.getParameter("moveSubtreeButton")) != null) {
            if (param.equals("on")) {
                this.moveSubtreeButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("moveSubtreeButton", param);
            }
        }
        if ((param = this.getParameter("viewProofDeductionButton")) != null) {
            if (param.equals("on")) {
                this.viewProofDeductionButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("viewProofDeductionButton", param);
            }
        }
        if ((param = this.getParameter("showKnowledgeBase")) != null) {
            if (param.equals("on")) {
                this.showKB = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showKnowledgeBase", param);
            }
        }
        if ((param = this.getParameter("showAlgorithm")) != null) {
            if (param.equals("on")) {
                this.showAlgorithm = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showAlgorithm", param);
            }
        }
        if ((param = this.getParameter("createNewQueryPopup")) != null) {
            if (param.equals("on")) {
                this.createNewQueryPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("createNewQueryPopup", param);
            }
        }
        if ((param = this.getParameter("fineStepPopup")) != null) {
            if (param.equals("on")) {
                this.fineStepPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("fineStepPopup", param);
            }
        }
        if ((param = this.getParameter("stepPopup")) != null) {
            if (param.equals("on")) {
                this.stepPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepPopup", param);
            }
        }
        if ((param = this.getParameter("autoSearchPopup")) != null) {
            if (param.equals("on")) {
                this.autoSearchPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoSearchPopup", param);
            }
        }
        if ((param = this.getParameter("stopSearchPopup")) != null) {
            if (param.equals("on")) {
                this.stopSearchPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopSearchPopup", param);
            }
        }
        if ((param = this.getParameter("resetQueryPopup")) != null) {
            if (param.equals("on")) {
                this.resetQueryPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("resetQueryPopup", param);
            }
        }
        if ((param = this.getParameter("algorithmPopup")) != null) {
            if (param.equals("on")) {
                this.algorithmPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("algorithmPopup", param);
            }
        }
        if ((param = this.getParameter("query")) != null && !((DeductionGraph)this.canvas.graph).setGoals(param)) {
            this.incorrectParameter("query", param);
        }
        if ((param = this.getParameter("edgeDetail")) != null) {
            if (param.equals("noDetails")) {
                ((DeductionGraph)this.canvas.graph).setEdgeDetail(39);
            } else if (param.equals("placeholders")) {
                ((DeductionGraph)this.canvas.graph).setEdgeDetail(42);
            } else if (param.equals("showAllUnifiers")) {
                ((DeductionGraph)this.canvas.graph).setEdgeDetail(41);
            } else {
                this.incorrectParameter("edgeDetail", param);
            }
        }
        if ((param = this.getParameter("nodeDetail")) != null) {
            if (param.equals("numbers")) {
                ((DeductionGraph)this.canvas.graph).setNodeDetail(40);
            } else if (param.equals("atoms")) {
                ((DeductionGraph)this.canvas.graph).setNodeDetail(42);
            } else if (param.equals("yesClauses")) {
                ((DeductionGraph)this.canvas.graph).setNodeDetail(41);
            } else {
                this.incorrectParameter("nodeDetail", param);
            }
        }
        if ((param = this.getParameter("speed")) != null) {
            if (param.equals("veryFast")) {
                Search.dt = 0;
            } else if (param.equals("fast")) {
                Search.dt = 100;
            } else if (param.equals("medium")) {
                Search.dt = 500;
            } else if (param.equals("slow")) {
                Search.dt = 1000;
            } else {
                this.incorrectParameter("speed", param);
            }
        } else {
            Search.dt = 100;
        }
    }

    public int getAlgorithm() {
        return this.searchAlgorithm;
    }

    private void updateAlgorithm() {
        String param = this.getParameter("algorithm");
        if (param != null) {
            if (param.equals("depthFirst") || param.equals("breadthFirst") || param.equals("bestFirst") || param.equals("heuristicDepthFirst") || param.equals("userDefined")) {
                this.setAlgorithm(param);
            } else {
                this.incorrectParameter("algorithm", param);
            }
        } else {
            this.setAlgorithm("Depth First");
        }
    }

    public void setAlgorithm(String arg) {
        if (arg.equals("Depth First") || arg.equals("depthFirst")) {
            this.algorithmPane.setText("Algorithm Selected: Depth First     ");
            this.searchAlgorithm = 201;
        } else if (arg.equals("Breadth First") || arg.equals("breadthFirst")) {
            this.algorithmPane.setText("Algorithm Selected: Breadth First    ");
            this.searchAlgorithm = 202;
        } else if (arg.equals("User Defined") || arg.equals("userDefined")) {
            this.algorithmPane.setText("Algorithm Selected: User Defined  ");
            this.searchAlgorithm = 209;
        } else if (arg.equals("Best First") || arg.equals("bestFirst")) {
            this.algorithmPane.setText("Algorithm Selected: Best First ");
            this.searchAlgorithm = 204;
        } else if (arg.equals("Heuristic Depth First") || arg.equals("heuristicDepthFirst")) {
            this.algorithmPane.setText("Algorithm Selected: Heuristic Depth First ");
            this.searchAlgorithm = 205;
        }
        this.setPromptLabel("");
        ((InlineCanvas)this.canvas).resetSearch();
        ((InlineCanvas)this.canvas).setSearchMethod(this.searchAlgorithm);
        this.enableSearch();
    }

    public void enableSearch() {
        boolean isUserDefined;
        boolean bl = isUserDefined = this.searchAlgorithm == 209;
        if (isUserDefined) {
            this.canvas.setSubmode(3340);
            this.setPromptLabel("Click the start node to begin.");
        }
        this.fineStepButton.setEnabled(!isUserDefined);
        this.stepButton.setEnabled(!isUserDefined);
        this.autoSearchButton.setEnabled(!isUserDefined);
        ((InlineCanvas)this.canvas).step.setEnabled(!isUserDefined);
        ((InlineCanvas)this.canvas).fineStep.setEnabled(!isUserDefined);
        ((InlineCanvas)this.canvas).autoSearch.setEnabled(!isUserDefined);
    }

    public void setKB(String p) {
        this.knowledgeBaseTA.setText(p);
    }

    @Override
    public void load(String filename) {
        try {
            String line;
            StringBuffer allText = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL(filename).openStream()));
            while ((line = in.readLine()) != null) {
                allText.append(line).append("\n");
            }
            in.close();
            ((InlineCanvas)this.canvas).resetSearch();
            ((InlineCanvas)this.canvas).parse(allText.toString());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void autoSearch() {
        if (!this.autoSearchButton.isEnabled()) {
            return;
        }
        this.fineStepButton.setEnabled(false);
        this.stepButton.setEnabled(false);
        this.stopSearchButton.setEnabled(true);
        this.fakeButton.setSelected(true);
        ((InlineCanvas)this.canvas).step.setEnabled(false);
        ((InlineCanvas)this.canvas).fineStep.setEnabled(false);
        ((InlineCanvas)this.canvas).stopSearch.setEnabled(true);
        ((InlineCanvas)this.canvas).doSearch(this.getAlgorithm(), 101, true);
    }

    public void resetQuery() {
        if (!this.resetQueryButton.isEnabled()) {
            return;
        }
        this.stopSearch();
        this.createNewQueryButton.setEnabled(true);
        if (this.searchAlgorithm != 209) {
            this.fineStepButton.setEnabled(true);
            this.stepButton.setEnabled(true);
            this.autoSearchButton.setEnabled(true);
            ((InlineCanvas)this.canvas).step.setEnabled(true);
            ((InlineCanvas)this.canvas).fineStep.setEnabled(true);
            ((InlineCanvas)this.canvas).autoSearch.setEnabled(true);
        }
        ((InlineCanvas)this.canvas).resetSearch();
        this.fakeButton.setSelected(true);
        this.setPromptLabel("Query reset.");
    }

    public void stopSearch() {
        if (!this.stopSearchButton.isEnabled()) {
            return;
        }
        ((DeductionGraph)this.canvas.graph).stopAutoSearch();
        this.fakeButton.setSelected(true);
        if (this.searchAlgorithm != 209) {
            this.fineStepButton.setEnabled(true);
            this.stepButton.setEnabled(true);
            this.stopSearchButton.setEnabled(false);
            ((InlineCanvas)this.canvas).step.setEnabled(true);
            ((InlineCanvas)this.canvas).fineStep.setEnabled(true);
            ((InlineCanvas)this.canvas).stopSearch.setEnabled(false);
        }
        this.setPromptLabel("Auto search stopped.");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (this.canvas.pause) {
            return;
        }
        if (arg.equals("Step")) {
            ((InlineCanvas)this.canvas).doSearch(this.getAlgorithm(), 102, true);
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Fine Step")) {
            ((InlineCanvas)this.canvas).doSearch(this.getAlgorithm(), 103, true);
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Auto Search")) {
            this.autoSearch();
        } else if (arg.equals("Stop Search")) {
            this.stopSearch();
        } else if (arg.equals("Reset Query")) {
            this.resetQuery();
        } else if (arg.equals("Pruning on")) {
            ((DeductionGraph)this.canvas.graph).pruneRules = true;
        } else if (arg.equals("Pruning off")) {
            ((DeductionGraph)this.canvas.graph).pruneRules = false;
        } else if (arg.equals("Autoscale")) {
            this.canvas.autoscale();
        } else if (arg.equals("Reset Edge Labels")) {
            this.canvas.resetLabels();
        } else if (arg.equals("Create New Query")) {
            ((InlineCanvas)this.canvas).openSelectFrame();
            this.fakeButton.setSelected(true);
        } else if (arg.equals("View Text Representation")) {
            ((InlineCanvas)this.canvas).openTextRep();
        } else if (arg.equals("View/Edit Prolog Code")) {
            ((InlineCanvas)this.canvas).openCilogTextRep();
        } else {
            if (arg.equals("Inspect Node")) {
                this.canvas.setSubmode(3336);
                this.setPromptLabel("Click on a node to ask how its atoms were obtained.");
                return;
            }
            if (arg.equals("Legend for Nodes/Edges")) {
                new HelpFrame("Legend", new DeductionHelpCanvas(true), 375, 500);
                return;
            }
            if (arg.equals("Move Node")) {
                this.canvas.setSubmode(3332);
                this.setPromptLabel("Click on an entity and drag the mouse to move it.");
                return;
            }
            if (arg.equals("Move Subtree")) {
                this.canvas.setSubmode(3338);
                this.setPromptLabel("Click on a node and drag it to move it and its descendents.");
                return;
            }
            if (arg.equals("View Proof Deduction")) {
                this.canvas.setSubmode(3337);
                this.setPromptLabel("Click on a node to view its proof tree.");
                return;
            }
            if (arg.equals("Select Node")) {
                this.canvas.setSubmode(3332);
                this.setPromptLabel("Click on an entity and drag the mouse to move it.");
                return;
            }
            if (arg.equals("Depth First") || arg.equals("Breadth First") || arg.equals("Best First") || arg.equals("Heuristic Depth First") || arg.equals("User Defined")) {
                this.setAlgorithm(arg);
            } else if (arg.equals("View Proof Tree Text Representation")) {
                ((DeductionCanvas)this.canvas).openTextRep();
            } else if (arg.equals("View XML Representation")) {
                ((DeductionCanvas)this.canvas).openXMLTextRep();
            } else if (arg.equals("View CILog Code")) {
                ((DeductionCanvas)this.canvas).openCilogTextRep();
            }
        }
    }

    public void createNewQuery() {
        if (this.createNewQueryButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.createNewQueryButton, 0, "Create New Query"));
        }
    }

    public void fineStep() {
        if (this.fineStepButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.fineStepButton, 0, "Fine Step"));
        }
    }

    public void step() {
        if (this.stepButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.stepButton, 0, "Step"));
        }
    }

    public void autoscale() {
        this.actionPerformed(new ActionEvent(this.fakeButton, 0, "Autoscale"));
    }

    public void resetEdgeLabels() {
        this.actionPerformed(new ActionEvent(this.fakeButton, 0, "Reset Edge Labels"));
    }
}

