/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction;

import AIspace.deduction.DeductionWindow;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class SolveUndo
implements MouseListener,
KeyListener,
CaretListener {
    private String[] undoArray;
    private final int undoLimit = 5;
    private int undoIndex;
    private final int undoKeyCheckLimit = 50;
    private int undoStartCaretPos;
    private int undoKeyCheck;
    private String undoBackString;
    private String undoTextSelection;
    private int undoTextCaratStartPos;
    private JTextArea tArea;
    private DeductionWindow window;

    public SolveUndo(JTextArea textArea) {
        this.tArea = textArea;
        this.window = null;
        this.undoArray = new String[5];
        this.undoIndex = 0;
        this.undoKeyCheck = 0;
        this.undoStartCaretPos = this.tArea.getText().length();
        this.undoBackString = "";
        this.undoTextSelection = "";
        this.undoTextCaratStartPos = 0;
    }

    public SolveUndo(DeductionWindow textParent, JTextArea textArea) {
        this.tArea = textArea;
        this.window = textParent;
        this.undoArray = new String[5];
        this.undoIndex = 0;
        this.undoKeyCheck = 0;
        this.undoStartCaretPos = this.tArea.getText().length();
        this.undoBackString = "";
        this.undoTextSelection = "";
        this.undoTextCaratStartPos = 0;
    }

    public boolean checkEnableUndo() {
        return this.undoIndex > 0;
    }

    public boolean checkEnableRedo() {
        return this.undoIndex != 5 && this.undoArray[this.undoIndex] != null;
    }

    private void saveUndo() {
        int i;
        boolean stored = false;
        if (this.undoArray[this.undoIndex] != null) {
            int i2 = this.undoIndex;
            while (i2 < 5) {
                this.undoArray[i2] = null;
                ++i2;
            }
            this.window.setRedoItem(false);
        }
        int storeIndex = this.undoIndex++;
        if (this.undoIndex >= 5) {
            i = 0;
            while (i < 4) {
                this.undoArray[i] = this.undoArray[i + 1];
                ++i;
            }
            --this.undoIndex;
            --storeIndex;
        }
        if (this.undoTextSelection.length() != 0) {
            this.undoArray[storeIndex] = "d" + this.undoTextCaratStartPos + "," + this.undoTextSelection;
            this.undoTextSelection = "";
            stored = true;
        } else if (this.undoBackString.length() != 0) {
            if (this.undoArray[storeIndex] != null) {
                this.undoArray[storeIndex + 1] = this.undoArray[storeIndex];
                ++this.undoIndex;
            }
            this.undoArray[storeIndex] = "d" + this.undoStartCaretPos + "," + this.undoBackString;
            stored = true;
        }
        if (stored) {
            storeIndex = this.undoIndex++;
            if (this.undoIndex >= 5) {
                i = 0;
                while (i < 4) {
                    this.undoArray[i] = this.undoArray[i + 1];
                    ++i;
                }
                --this.undoIndex;
                --storeIndex;
            }
        }
        if (this.undoKeyCheck > 0) {
            String undoSave = this.tArea.getText().substring(this.undoStartCaretPos, this.undoStartCaretPos + this.undoKeyCheck);
            this.undoArray[storeIndex] = "i" + this.undoStartCaretPos + "," + undoSave;
        }
        this.undoBackString = "";
        this.window.setUndoItem(true);
        this.undoStartCaretPos = this.tArea.getCaretPosition();
        this.undoKeyCheck = 0;
    }

    public void loadUndo() {
        if (this.undoKeyCheck > 0 || this.undoBackString.length() != 0) {
            this.saveUndo();
        }
        String undoString = this.undoArray[--this.undoIndex];
        char type = undoString.charAt(0);
        int startPos = Integer.parseInt(undoString.substring(1, undoString.indexOf(44)));
        undoString = undoString.substring(undoString.indexOf(44) + 1);
        if (type == 'i') {
            this.tArea.setText(String.valueOf(this.tArea.getText().substring(0, startPos)) + this.tArea.getText().substring(startPos + undoString.length()));
        } else if (type == 'd') {
            this.tArea.insert(undoString, startPos);
        }
        this.undoStartCaretPos = this.tArea.getCaretPosition();
        this.window.setRedoItem(true);
        if (this.undoIndex == 0) {
            this.window.setUndoItem(false);
        }
    }

    public void loadRedo() {
        if (this.undoIndex >= 5 || this.undoArray[this.undoIndex] == null) {
            return;
        }
        String undoString = this.undoArray[this.undoIndex++];
        char type = undoString.charAt(0);
        int startPos = Integer.parseInt(undoString.substring(1, undoString.indexOf(44)));
        undoString = undoString.substring(undoString.indexOf(44) + 1);
        if (type == 'i') {
            this.tArea.insert(undoString, startPos);
        } else if (type == 'd') {
            this.tArea.setText(String.valueOf(this.tArea.getText().substring(0, startPos)) + this.tArea.getText().substring(startPos + undoString.length()));
        }
        this.window.setUndoItem(true);
        this.undoStartCaretPos = this.tArea.getCaretPosition();
        if (this.undoIndex == 5 || this.undoArray[this.undoIndex] == null) {
            this.window.setRedoItem(false);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 127: {
                if (this.undoArray[this.undoIndex] != null) {
                    this.window.setRedoItem(false);
                }
                if (this.tArea.getCaretPosition() < this.tArea.getText().length()) {
                    this.undoBackString = String.valueOf(this.undoBackString) + this.tArea.getText().substring(this.tArea.getCaretPosition(), this.tArea.getCaretPosition() + 1);
                }
                if (this.undoKeyCheck <= 0) break;
                this.saveUndo();
                break;
            }
            case 8: {
                if (this.undoArray[this.undoIndex] != null) {
                    this.window.setRedoItem(false);
                }
                if (this.undoKeyCheck > 0) {
                    this.saveUndo();
                }
                if (this.undoKeyCheck <= 0 && this.tArea.getCaretPosition() > 0) {
                    this.undoBackString = String.valueOf(this.tArea.getText().substring(this.tArea.getCaretPosition() - 1, this.tArea.getCaretPosition())) + this.undoBackString;
                }
                --this.undoStartCaretPos;
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (e.isShiftDown()) {
                    return;
                }
                if (this.undoKeyCheck > 0) {
                    this.saveUndo();
                }
                this.undoStartCaretPos = this.tArea.getCaretPosition();
                break;
            }
            case 10: 
            case 32: {
                if (this.undoArray[this.undoIndex] != null) {
                    this.window.setRedoItem(false);
                }
                if (this.undoKeyCheck >= 50 || this.undoTextSelection.length() != 0) {
                    this.saveUndo();
                }
                ++this.undoKeyCheck;
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                if (this.undoKeyCheck <= 0) break;
                this.saveUndo();
                break;
            }
            case 19: 
            case 20: 
            case 27: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 145: 
            case 154: 
            case 155: 
            case 524: {
                return;
            }
            default: {
                if (e.isAltDown() || e.isControlDown() || e.isShiftDown()) {
                    return;
                }
                if (this.undoTextSelection.length() != 0) {
                    this.saveUndo();
                }
                if (this.undoArray[this.undoIndex] != null) {
                    this.window.setRedoItem(false);
                }
                this.window.setUndoItem(true);
                ++this.undoKeyCheck;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                this.undoStartCaretPos = this.tArea.getCaretPosition();
                break;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int mark;
        int dot = e.getDot();
        if (dot < (mark = e.getMark())) {
            this.undoTextSelection = this.tArea.getText().substring(dot, mark);
            this.undoTextCaratStartPos = dot;
        } else if (dot > mark) {
            this.undoTextCaratStartPos = mark;
            this.undoTextSelection = this.tArea.getText().substring(mark, dot);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.undoKeyCheck > 0) {
            this.saveUndo();
        }
        this.undoStartCaretPos = this.tArea.getCaretPosition();
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }
}

