/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction.dialogs;

import AIspace.deduction.DeductionCanvas;
import AIspace.deduction.DeductionGraph;
import AIspace.deduction.dialogs.EditQueryDialog;
import AIspace.graphToolKit.dialogs.BasicFrame;
import AIspace.graphToolKit.dialogs.MessageDialog;
import AIspace.prolog.Goal;
import AIspace.prolog.Predicate;
import AIspace.prolog.Program;
import AIspace.prolog.Term;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CreateQueryFrame
extends BasicFrame
implements ListSelectionListener,
WindowListener {
    private DeductionGraph graph;
    private DeductionCanvas canvas;
    private ArrayList<Goal> newGoals = new ArrayList();
    private ArrayList<Predicate> predicates;
    private DefaultListModel predModel;
    private JList predList;
    private JPanel cardPanel;
    private JPanel[] cards;
    private ArrayList<ArrayList<JComboBox>> comboFields;
    private JTextField typeQuery;
    private JLabel errorLabel;
    private JLabel queryLabel;
    private JPanel qePanel;
    private JButton addQueryButton;
    private JButton editButton;
    private JButton cancelButton;
    private JButton okButton;
    private JButton clearGoals;
    private EditQueryDialog eqDialog;

    public CreateQueryFrame(DeductionGraph graph, DeductionCanvas canvas) {
        super("Create a Query");
        this.predicates = graph.getPredicates();
        this.graph = graph;
        this.canvas = canvas;
        this.eqDialog = null;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new BoxLayout(selectPanel, 1));
        selectPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Select a Predicate and Choose Terms..."));
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 1));
        typePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "...OR Type a Query"));
        this.predModel = new DefaultListModel();
        this.predList = new JList();
        this.predList.setSelectionMode(0);
        this.predList.setModel(this.predModel);
        int i = 0;
        while (i < this.predicates.size()) {
            Predicate p = this.predicates.get(i);
            if (!graph.repeatPredicateName(p)) {
                this.predModel.addElement(p.getName());
            } else {
                this.predModel.addElement(String.valueOf(p.getName()) + "/" + p.getArity());
            }
            ++i;
        }
        this.predList.setSelectedIndex(0);
        this.predList.addListSelectionListener(this);
        JScrollPane listScroll = new JScrollPane(this.predList);
        this.cardPanel = new JPanel(new CardLayout());
        this.cards = new JPanel[this.predModel.size()];
        this.comboFields = new ArrayList(this.predModel.size());
        int i2 = 0;
        while (i2 < this.predModel.size()) {
            JLabel between;
            JComboBox<String> cb;
            DefaultComboBoxModel<String> cm;
            Predicate p = this.predicates.get(i2);
            this.cards[i2] = new JPanel();
            this.comboFields.add(new ArrayList(p.getArity()));
            JLabel name = new JLabel(p.getName());
            this.cards[i2].add(name);
            if (p.getArity() > 0) {
                name.setText(String.valueOf(p.getName()) + "(");
                cm = new DefaultComboBoxModel<String>(graph.getConstants().toArray(new String[0]));
                cm.insertElementAt("", 0);
                cb = new JComboBox<String>();
                cb.setModel(cm);
                cb.setSelectedIndex(0);
                cb.setEditable(true);
                this.comboFields.get(i2).add(cb);
                this.cards[i2].add(cb);
            }
            int j = 1;
            while (j < p.getArity()) {
                between = new JLabel(", ");
                this.cards[i2].add(between);
                cm = new DefaultComboBoxModel<String>(graph.getConstants().toArray(new String[0]));
                cm.insertElementAt("", 0);
                cb = new JComboBox();
                cb.setModel(cm);
                cb.setSelectedIndex(0);
                cb.setEditable(true);
                this.comboFields.get(i2).add(cb);
                this.cards[i2].add(cb);
                ++j;
            }
            if (p.getArity() > 0) {
                between = new JLabel(")");
                this.cards[i2].add(between);
            }
            this.cardPanel.add((Component)this.cards[i2], this.predModel.get(i2));
            ++i2;
        }
        listScroll.setAlignmentX(0.5f);
        this.cardPanel.setAlignmentX(0.5f);
        selectPanel.add(listScroll);
        selectPanel.add(this.cardPanel);
        this.typeQuery = new JTextField();
        typePanel.add(this.typeQuery);
        this.qePanel = new JPanel();
        this.qePanel.setLayout(new BorderLayout());
        this.queryLabel = new JLabel("... then click 'Add Query'");
        this.errorLabel = new JLabel("");
        this.qePanel.add((Component)this.queryLabel, "North");
        this.qePanel.add((Component)this.errorLabel, "South");
        JPanel buttonPanel = new JPanel();
        this.addQueryButton = new JButton("Add Query");
        this.addQueryButton.addActionListener(this);
        this.editButton = new JButton("Edit Query");
        this.editButton.addActionListener(this);
        this.editButton.setEnabled(false);
        this.clearGoals = new JButton("Clear Query");
        this.clearGoals.addActionListener(this);
        this.clearGoals.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        buttonPanel.add(this.addQueryButton);
        buttonPanel.add(this.editButton);
        buttonPanel.add(this.clearGoals);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.okButton);
        this.getContentPane().add(selectPanel);
        this.getContentPane().add(typePanel);
        this.getContentPane().add(this.qePanel);
        this.getContentPane().add(buttonPanel);
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    public void showQueryLabel() {
        this.invalidate();
        this.qePanel.invalidate();
        if (this.newGoals.size() > 0) {
            this.queryLabel.setForeground(Color.blue);
            this.queryLabel.setText("Query: " + this.newGoals.toString());
            this.errorLabel.setText("");
        } else {
            this.queryLabel.setText("");
            this.errorLabel.setText("");
            this.editButton.setEnabled(false);
            this.clearGoals.setEnabled(false);
        }
        this.qePanel.validate();
        this.validate();
    }

    private void addAtom(String atom) {
        Goal g = this.graph.parseGoal(this.preParse(atom));
        if (g != null) {
            if (!this.checkPredicate(g)) {
                return;
            }
            this.invalidate();
            this.newGoals.add(g);
            this.qePanel.invalidate();
            this.queryLabel.setForeground(Color.blue);
            this.queryLabel.setText("Query: " + this.newGoals.toString());
            this.errorLabel.setText("");
            this.clearGoals.setForeground(Color.black);
            this.clearGoals.setEnabled(true);
            this.editButton.setForeground(Color.black);
            this.editButton.setEnabled(true);
            int i = 0;
            while (i < this.comboFields.size()) {
                int j = 0;
                while (j < this.comboFields.get(i).size()) {
                    this.comboFields.get(i).get(j).setSelectedIndex(0);
                    ++j;
                }
                ++i;
            }
        } else {
            this.invalidate();
            this.qePanel.invalidate();
            this.errorLabel.setForeground(Color.red);
            this.errorLabel.setText("Error parsing atom");
        }
        this.qePanel.validate();
        this.validate();
        this.pack();
    }

    private boolean checkPredicate(Goal g) {
        if (this.graph.predicateExists(g.getPredicate())) {
            return true;
        }
        this.invalidate();
        this.qePanel.invalidate();
        this.errorLabel.setForeground(Color.red);
        this.errorLabel.setText("Predicate " + g.getPredicate().getName() + "/" + g.getPredicate().getArity() + " does not exist");
        this.qePanel.validate();
        this.validate();
        this.pack();
        return false;
    }

    private String preParse(String str) {
        int parenCount = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '(') {
                ++parenCount;
            } else if (c == ')' && --parenCount == 0) {
                return str.substring(0, i + 1);
            }
            ++i;
        }
        return str;
    }

    private void addQueryAction(boolean blank) {
        int index = this.predList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        Term[] terms = new Term[this.comboFields.get(index).size()];
        Program prog = new Program();
        int i = 0;
        while (i < this.comboFields.get(index).size()) {
            JComboBox cb = this.comboFields.get(index).get(i);
            String str = (String)cb.getSelectedItem();
            if (str.trim().equals("")) {
                if (blank) {
                    new MessageDialog(this).open("Textfield Error", "Textfield " + (i + 1) + " is blank.");
                }
                return;
            }
            if (!prog.matchBrackets(str)) {
                new MessageDialog(this).open("Textfield Error", "Textfield " + (i + 1) + " has mismatched parentheses ");
                return;
            }
            terms[i] = new Term(str);
            ++i;
        }
        Goal g = new Goal(this.predicates.get(index), terms);
        this.addAtom(g.toString());
    }

    @Override
    protected boolean actionOK() {
        if (this.newGoals.isEmpty()) {
            this.addQueryAction(false);
        }
        this.graph.setGoals(this.newGoals);
        this.canvas.moveToTopMiddle();
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand().equals("Edit Query")) {
            this.eqDialog = new EditQueryDialog(this, this.graph, this.newGoals);
        } else {
            if (e.getActionCommand().equals("Clear Query")) {
                this.clearGoals.setEnabled(false);
                this.editButton.setEnabled(false);
                this.invalidate();
                this.newGoals = new ArrayList();
                int i = 0;
                while (i < this.comboFields.size()) {
                    int j = 0;
                    while (j < this.comboFields.get(i).size()) {
                        this.comboFields.get(i).get(j).setSelectedIndex(0);
                        ++j;
                    }
                    ++i;
                }
                this.typeQuery.setText("");
                this.queryLabel.setForeground(Color.black);
                this.queryLabel.setText("Query: ");
                this.errorLabel.setText("");
                this.validate();
                this.pack();
                return;
            }
            if (e.getSource() == this.addQueryButton) {
                boolean typed = true;
                if (!this.typeQuery.getText().trim().equals("")) {
                    this.addAtom(this.typeQuery.getText());
                    typed = false;
                }
                this.addQueryAction(typed);
            } else if (this.queryLabel.getText().equals("Query: ")) {
                this.setVisible(false);
                return;
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, (String)this.predModel.getElementAt(this.predList.getSelectedIndex()));
        this.validate();
        this.pack();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.eqDialog != null) {
            this.eqDialog.dispose();
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

