/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction.dialogs;

import AIspace.deduction.DeductionGraph;
import AIspace.deduction.dialogs.CreateQueryFrame;
import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.prolog.Goal;
import AIspace.prolog.Program;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class EditQueryDialog
extends BasicDialog {
    private CreateQueryFrame cqf;
    private DeductionGraph graph;
    private DefaultListModel atomModel;
    private JList atomList;
    private ArrayList<Goal> atoms;
    private JPanel editPanel;
    private JTextField editField;
    private JButton saveButton;
    private int editIndex;

    public EditQueryDialog(CreateQueryFrame parent, DeductionGraph g, ArrayList<Goal> goals) {
        super((JFrame)parent, "Edit Query", true);
        this.cqf = parent;
        this.atoms = goals;
        this.graph = g;
        this.editIndex = 0;
        if (this.atoms == null) {
            return;
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.atomModel = new DefaultListModel();
        this.atomList = new JList();
        this.atomList.setSelectionMode(0);
        this.atomList.setModel(this.atomModel);
        int i = 0;
        while (i < this.atoms.size()) {
            this.atomModel.addElement(this.atoms.get(i).toString());
            ++i;
        }
        this.atomList.setSelectedIndex(0);
        JScrollPane listScroll = new JScrollPane(this.atomList);
        JPanel dePanel = new JPanel();
        JButton delButton = new JButton("Delete");
        delButton.addActionListener(this);
        JButton editButton = new JButton("Edit");
        editButton.addActionListener(this);
        dePanel.add(delButton);
        dePanel.add(editButton);
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new FlowLayout());
        this.editField = new JTextField("", 20);
        this.editField.setEditable(false);
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(this);
        this.saveButton.setEnabled(false);
        this.editPanel.add(this.editField);
        this.editPanel.add(this.saveButton);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(this);
        okButton.setAlignmentX(0.5f);
        this.getContentPane().add(listScroll);
        this.getContentPane().add(dePanel);
        this.getContentPane().add(this.editPanel);
        this.getContentPane().add(okButton);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    @Override
    protected boolean actionOK() {
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String arg = e.getActionCommand().trim();
        if (arg.equals("Delete")) {
            this.editIndex = this.atomList.getSelectedIndex();
            if (this.editIndex >= 0) {
                this.atomModel.remove(this.editIndex);
                this.atoms.remove(this.editIndex);
                this.editIndex = -1;
            }
        } else if (arg.equals("Edit")) {
            this.editIndex = this.atomList.getSelectedIndex();
            if (this.editIndex >= 0) {
                this.invalidate();
                this.editPanel.invalidate();
                this.editField.setEditable(true);
                this.saveButton.setEnabled(true);
                this.editField.setText((String)this.atomList.getSelectedValue());
                this.editPanel.validate();
                this.validate();
            }
        } else if (e.getSource() == this.saveButton && this.saveButton.isEnabled()) {
            Program prog = new Program();
            String str = this.editField.getText().trim();
            if (str.equals("")) {
                JOptionPane.showMessageDialog(null, "Textfield is blank.", "Error", 0);
                return;
            }
            if (!prog.matchBrackets(str)) {
                JOptionPane.showMessageDialog(null, "Textfield has mismatched parentheses.", "Error", 0);
                return;
            }
            Goal g = this.graph.parseGoal(str);
            if (g != null) {
                this.atomModel.remove(this.editIndex);
                this.atoms.remove(this.editIndex);
                this.atoms.add(this.editIndex, g);
                this.atomModel.add(this.editIndex, str);
                this.editField.setText("");
                this.editField.setEditable(false);
                this.saveButton.setEnabled(false);
                this.validate();
            }
        }
        this.cqf.showQueryLabel();
    }
}

