/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction.dialogs;

import AIspace.deduction.elements.DeductionNode;
import AIspace.graphToolKit.dialogs.BasicFrame;
import AIspace.prolog.Goal;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InspectNodeFrame
extends BasicFrame
implements ItemListener {
    private JComboBox goalChoice;
    private ArrayList<Goal> theGoals;
    private JLabel goalDeriv1;
    private JLabel goalDeriv2;

    public InspectNodeFrame(DeductionNode node, int fontSize) {
        super("Inspecting Node");
        super.setOKString("Close");
        Font font = new Font("SansSerif", 0, fontSize);
        this.theGoals = node.getGoals();
        JLabel title = new JLabel(node.getFullLabel(), 0);
        title.setFont(font);
        title.setForeground(Color.red);
        String subs = node.getEdgeIn().getFullLabel();
        JLabel howDerived = new JLabel("This node was derived by applying ", 0);
        howDerived.setFont(font);
        JLabel howDerived2 = new JLabel(node.getDerivedFrom().toString(), 0);
        howDerived2.setFont(font);
        JLabel howDerived3 = new JLabel("to " + node.getDerivedFromGoal().toString(), 0);
        howDerived3.setFont(font);
        JLabel howDerived4 = new JLabel("with the unification", 0);
        JLabel howDerived5 = new JLabel(subs, 0);
        if (subs.trim().equals("")) {
            howDerived4 = new JLabel("with no unification", 0);
            howDerived5 = new JLabel("");
        }
        howDerived4.setFont(font);
        howDerived5.setFont(font);
        JPanel deriv = new JPanel();
        deriv.setLayout(new GridLayout(6, 1));
        deriv.add(title);
        deriv.add(howDerived);
        deriv.add(howDerived2);
        deriv.add(howDerived3);
        deriv.add(howDerived4);
        deriv.add(howDerived5);
        JPanel display = new JPanel();
        display.setBackground(Color.white);
        if (this.theGoals.size() != 0) {
            display.setLayout(new GridLayout(2, 1));
            JPanel top = new JPanel();
            this.theGoals = node.getGoals();
            JLabel instruct = new JLabel("Select a goal");
            instruct.setFont(font);
            this.goalChoice = new JComboBox();
            int i = 0;
            while (i < this.theGoals.size()) {
                this.goalChoice.addItem(this.theGoals.get(i).toString());
                ++i;
            }
            this.goalChoice.setFont(font);
            this.goalChoice.addItemListener(this);
            Goal g = this.theGoals.get(0);
            top.add(instruct);
            top.add(this.goalChoice);
            display.add(top);
            JPanel goalDeriv = new JPanel();
            goalDeriv.setLayout(new GridLayout(2, 1));
            if (g.derivedFrom != null) {
                this.goalDeriv1 = new JLabel("This goal was part of the body of the clause ", 0);
                this.goalDeriv2 = new JLabel(g.derivedFrom.toString(), 0);
            } else {
                this.goalDeriv1 = new JLabel("This goal was part of the original query.", 0);
                this.goalDeriv2 = new JLabel("");
            }
            this.goalDeriv1.setFont(font);
            this.goalDeriv2.setFont(font);
            goalDeriv.add(this.goalDeriv1);
            goalDeriv.add(this.goalDeriv2);
            display.add(goalDeriv);
        }
        JPanel p = new JPanel();
        JButton okButton = new JButton("Close");
        okButton.addActionListener(this);
        p.add(okButton);
        this.getContentPane().add((Component)deriv, "North");
        this.getContentPane().add((Component)p, "South");
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    @Override
    protected boolean actionOK() {
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Goal g = this.theGoals.get(this.goalChoice.getSelectedIndex());
        if (g.derivedFrom != null) {
            this.goalDeriv2.setText(g.derivedFrom.toString());
        } else {
            this.goalDeriv1.setText("This goal was part of the original query.");
            this.goalDeriv2.setText("");
        }
        this.pack();
    }
}

